/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.env;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SeedNode {
    public static final Set<SeedNode> LOCALHOST = Collections.singleton(SeedNode.create("127.0.0.1"));
    private final String address;
    private final Optional<Integer> kvPort;
    private final Optional<Integer> clusterManagerPort;
    private static final int DEFAULT_KV_PORT = 11210;
    private static final int DEFAULT_MANAGER_PORT = 8091;
    private static final int DEFAULT_KV_TLS_PORT = 11207;
    private static final int DEFAULT_MANAGER_TLS_PORT = 18091;

    public static SeedNode create(String address) {
        return SeedNode.create(address, Optional.empty(), Optional.empty());
    }

    public static SeedNode create(String address, Optional<Integer> kvPort, Optional<Integer> clusterManagerPort) {
        return new SeedNode(address, kvPort, clusterManagerPort);
    }

    private SeedNode(String address, Optional<Integer> kvPort, Optional<Integer> clusterManagerPort) {
        this.address = Objects.requireNonNull(address, "Address");
        this.kvPort = Objects.requireNonNull(kvPort, "KvPort");
        this.clusterManagerPort = Objects.requireNonNull(clusterManagerPort, "ClusterManagerPort");
    }

    public String address() {
        return this.address;
    }

    public Optional<Integer> kvPort() {
        return this.kvPort;
    }

    public SeedNode withKvPort(int port) {
        return new SeedNode(this.address, port == 0 ? Optional.empty() : Optional.of(port), this.clusterManagerPort);
    }

    public SeedNode withManagerPort(int port) {
        return new SeedNode(this.address, this.kvPort, port == 0 ? Optional.empty() : Optional.of(port));
    }

    public SeedNode withDefaultPortsIfNoneSpecified(boolean tls) {
        if (this.clusterManagerPort.isPresent() || this.kvPort.isPresent()) {
            return this;
        }
        return this.withManagerPort(tls ? 18091 : 8091).withKvPort(tls ? 11207 : 11210);
    }

    public Optional<Integer> clusterManagerPort() {
        return this.clusterManagerPort;
    }

    public String toString() {
        return "SeedNode{address='" + this.address + '\'' + ", kvPort=" + this.kvPort + ", mgmtPort=" + this.clusterManagerPort + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeedNode seedNode = (SeedNode)o;
        return Objects.equals(this.address, seedNode.address) && Objects.equals(this.kvPort, seedNode.kvPort) && Objects.equals(this.clusterManagerPort, seedNode.clusterManagerPort);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.kvPort, this.clusterManagerPort);
    }
}

