/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.utils.CbCollections;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class PartitionInfo {
    static final PartitionInfo ABSENT = new PartitionInfo(null, Collections.emptyList(), Collections.emptyList());
    private final Optional<NodeInfo> active;
    private final List<NodeInfo> availableReplicas;
    private final List<Integer> rawNodeIndexes;

    public PartitionInfo(@Nullable NodeInfo active, List<NodeInfo> availableReplicas, List<Integer> rawNodeIndexes) {
        this.active = Optional.ofNullable(active);
        this.availableReplicas = CbCollections.copyToUnmodifiableList(availableReplicas);
        this.rawNodeIndexes = CbCollections.copyToUnmodifiableList(rawNodeIndexes);
    }

    public static PartitionInfo parse(List<NodeInfo> allNodes, List<Integer> partitionNodeIndexes) {
        int activeNodeIndex = partitionNodeIndexes.isEmpty() ? -2 : partitionNodeIndexes.get(0);
        NodeInfo activeNode = activeNodeIndex < 0 ? null : allNodes.get(activeNodeIndex);
        return new PartitionInfo(activeNode, PartitionInfo.findAvailableReplicas(allNodes, partitionNodeIndexes), partitionNodeIndexes);
    }

    private static List<NodeInfo> findAvailableReplicas(List<NodeInfo> allNodes, List<Integer> nodeIndexes) {
        return nodeIndexes.stream().skip(1L).filter(nodeIndex -> nodeIndex >= 0).map(allNodes::get).collect(Collectors.toList());
    }

    public Optional<NodeInfo> active() {
        return this.active;
    }

    public List<NodeInfo> availableReplicas() {
        return this.availableReplicas;
    }

    public OptionalInt nodeIndexForActive() {
        return this.nodeIndex(0);
    }

    public OptionalInt nodeIndexForReplica(int replicaIndex) {
        return this.nodeIndex(replicaIndex + 1);
    }

    private OptionalInt nodeIndex(int activeOrReplica) {
        if (activeOrReplica < 0) {
            throw new IllegalArgumentException("activeOrReplica must be non-negative, but got " + activeOrReplica);
        }
        if (activeOrReplica >= this.rawNodeIndexes.size()) {
            return OptionalInt.empty();
        }
        int index = this.rawNodeIndexes.get(activeOrReplica);
        return index < 0 ? OptionalInt.empty() : OptionalInt.of(index);
    }

    public String toString() {
        return this.rawNodeIndexes.toString();
    }
}

