/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.core.config;

import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.DeserializationFeature;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.ObjectReader;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.dcp.core.config.BucketCapability;
import com.couchbase.client.dcp.core.config.ClusterConfig;
import com.couchbase.client.dcp.core.config.ClusterConfigParser;
import com.couchbase.client.dcp.core.config.ConfigException;
import com.couchbase.client.dcp.core.config.CouchbaseBucketConfig;
import com.couchbase.client.dcp.core.config.NetworkSelector;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.config.PartitionInfo;
import com.couchbase.client.dcp.core.config.PartitionMap;
import com.couchbase.client.dcp.core.config.PortSelector;
import com.couchbase.client.dcp.core.utils.CbCollections;
import com.couchbase.client.dcp.core.utils.JacksonHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public class CouchbaseBucketConfigParser {
    private static final TypeReference<List<List<Integer>>> LIST_OF_LIST_OF_INTEGER_TYPE = new TypeReference<List<List<Integer>>>(){};
    private static final ObjectReader bucketCapabilitiesReader = JacksonHelper.reader().withFeatures(new DeserializationFeature[]{DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL}).forType((TypeReference)new TypeReference<Set<BucketCapability>>(){});

    public static CouchbaseBucketConfig parse(byte[] json, String originHost, PortSelector portSelector, NetworkSelector networkSelector) {
        ObjectNode configNode = JacksonHelper.readObject(json);
        ClusterConfig clusterConfig = ClusterConfigParser.parse(configNode, originHost, portSelector, networkSelector);
        List<NodeInfo> nodes = clusterConfig.nodes();
        ObjectNode vBucketServerMap = (ObjectNode)configNode.get("vBucketServerMap");
        PartitionMap partitionMap = CouchbaseBucketConfigParser.parsePartitionMap(nodes, vBucketServerMap.get("vBucketMap")).orElse(PartitionMap.ABSENT);
        Optional<PartitionMap> partitionMapForward = CouchbaseBucketConfigParser.parsePartitionMap(nodes, vBucketServerMap.get("vBucketMapForward"));
        Set<BucketCapability> bucketCapabilities = CouchbaseBucketConfigParser.parseBucketCapabilities(configNode);
        boolean ephemeral = CouchbaseBucketConfigParser.parseEphemeral(configNode, bucketCapabilities);
        return new CouchbaseBucketConfig(clusterConfig, configNode.path("name").asText(), configNode.path("uuid").asText(), bucketCapabilities, ephemeral, vBucketServerMap.path("numReplicas").asInt(0), partitionMap, partitionMapForward.orElse(null));
    }

    private static boolean parseEphemeral(ObjectNode configNode, Set<BucketCapability> bucketCapabilities) {
        String bucketType = configNode.path("bucketType").textValue();
        return bucketType != null ? "ephemeral".equals(bucketType) : !bucketCapabilities.contains((Object)BucketCapability.COUCHAPI);
    }

    private static Optional<PartitionMap> parsePartitionMap(List<NodeInfo> allNodes, @Nullable JsonNode vBucketMapNode) {
        if (vBucketMapNode == null) {
            return Optional.empty();
        }
        List<List<Integer>> vBucketMap = JacksonHelper.convertValue(vBucketMapNode, LIST_OF_LIST_OF_INTEGER_TYPE);
        List<PartitionInfo> entries = CbCollections.transform(vBucketMap, activeAndReplicaNodeIndexes -> PartitionInfo.parse(allNodes, activeAndReplicaNodeIndexes));
        return Optional.of(new PartitionMap(entries));
    }

    private static Set<BucketCapability> parseBucketCapabilities(ObjectNode configNode) {
        JsonNode capabilitiesNode = configNode.get("bucketCapabilities");
        if (capabilitiesNode == null) {
            return Collections.emptySet();
        }
        try {
            Set result = (Set)bucketCapabilitiesReader.readValue(capabilitiesNode);
            return result.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new ConfigException("Failed to parse bucketCapabilities node: " + capabilitiesNode);
        }
    }
}

