/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.conductor;

import com.couchbase.client.core.deps.io.netty.bootstrap.Bootstrap;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.PooledByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.buffer.UnpooledByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.channel.Channel;
import com.couchbase.client.core.deps.io.netty.channel.ChannelFuture;
import com.couchbase.client.core.deps.io.netty.channel.ChannelFutureListener;
import com.couchbase.client.core.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.core.deps.io.netty.channel.ChannelOption;
import com.couchbase.client.core.deps.io.netty.util.AttributeKey;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.core.deps.io.netty.util.concurrent.GenericFutureListener;
import com.couchbase.client.core.deps.io.netty.util.concurrent.ImmediateEventExecutor;
import com.couchbase.client.dcp.Client;
import com.couchbase.client.dcp.buffer.DcpOps;
import com.couchbase.client.dcp.conductor.Conductor;
import com.couchbase.client.dcp.conductor.DcpChannelControlHandler;
import com.couchbase.client.dcp.conductor.NotMyVbucketException;
import com.couchbase.client.dcp.config.HostAndPort;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import com.couchbase.client.dcp.core.state.AbstractStateMachine;
import com.couchbase.client.dcp.core.state.LifecycleState;
import com.couchbase.client.dcp.core.state.NotConnectedException;
import com.couchbase.client.dcp.core.time.Delay;
import com.couchbase.client.dcp.core.utils.DefaultObjectMapper;
import com.couchbase.client.dcp.error.RollbackException;
import com.couchbase.client.dcp.highlevel.StreamOffset;
import com.couchbase.client.dcp.highlevel.internal.CollectionsManifest;
import com.couchbase.client.dcp.message.DcpCloseStreamRequest;
import com.couchbase.client.dcp.message.DcpFailoverLogRequest;
import com.couchbase.client.dcp.message.DcpFailoverLogResponse;
import com.couchbase.client.dcp.message.DcpGetPartitionSeqnosRequest;
import com.couchbase.client.dcp.message.DcpGetPartitionSeqnosResponse;
import com.couchbase.client.dcp.message.DcpOpenStreamRequest;
import com.couchbase.client.dcp.message.DcpOpenStreamResponse;
import com.couchbase.client.dcp.message.HelloFeature;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.PartitionAndSeqno;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.message.RollbackMessage;
import com.couchbase.client.dcp.message.StreamFlag;
import com.couchbase.client.dcp.message.VbucketState;
import com.couchbase.client.dcp.metrics.DcpChannelMetrics;
import com.couchbase.client.dcp.metrics.DcpClientMetrics;
import com.couchbase.client.dcp.transport.netty.ChannelFlowController;
import com.couchbase.client.dcp.transport.netty.ChannelUtils;
import com.couchbase.client.dcp.transport.netty.DcpMessageHandler;
import com.couchbase.client.dcp.transport.netty.DcpPipeline;
import com.couchbase.client.dcp.transport.netty.DcpResponse;
import com.couchbase.client.dcp.transport.netty.DcpResponseListener;
import com.couchbase.client.dcp.util.AdaptiveDelay;
import com.couchbase.client.dcp.util.AtomicBooleanArray;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.util.retry.Retry;

public class DcpChannel
extends AbstractStateMachine<LifecycleState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DcpChannel.class);
    private final DcpChannelControlHandler controlHandler;
    private volatile boolean isShutdown;
    private volatile Channel channel;
    private volatile ChannelFuture connectFuture;
    private final DcpChannelMetrics metrics;
    private final DcpClientMetrics clientMetrics;
    private static final AttributeKey<HostAndPort> HOST_AND_PORT = AttributeKey.valueOf((String)"hostAndPort");
    private final AdaptiveDelay reconnectDelay = new AdaptiveDelay(Delay.exponential(TimeUnit.MILLISECONDS, 4096L, 32L), Duration.ofSeconds(10L));
    final Client.Environment env;
    final HostAndPort address;
    final AtomicBooleanArray streamIsOpen = new AtomicBooleanArray(1024);
    final Conductor conductor;

    public DcpChannel(HostAndPort address, Client.Environment env, Conductor conductor, DcpClientMetrics clientMetrics) {
        super(LifecycleState.DISCONNECTED);
        this.address = address;
        this.env = env;
        this.conductor = conductor;
        this.controlHandler = new DcpChannelControlHandler(this);
        this.isShutdown = false;
        this.clientMetrics = Objects.requireNonNull(clientMetrics);
        this.metrics = clientMetrics.channelMetrics(address);
    }

    public static HostAndPort getHostAndPort(Channel channel) {
        return (HostAndPort)channel.attr(HOST_AND_PORT).get();
    }

    public Future<DcpResponse> sendRequest(ByteBuf message) {
        if (this.channel == null) {
            ReferenceCountUtil.safeRelease((Object)message);
            return ImmediateEventExecutor.INSTANCE.newFailedFuture((Throwable)new NotConnectedException("Failed to issue request; channel is not active."));
        }
        return ((DcpMessageHandler)this.channel.pipeline().get(DcpMessageHandler.class)).sendRequest(message);
    }

    private Bootstrap newBootstrap() {
        PooledByteBufAllocator allocator = this.env.poolBuffers() ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT;
        return (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().option(ChannelOption.ALLOCATOR, (Object)allocator)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)this.env.socketConnectTimeout()))).remoteAddress(this.address.host(), this.address.port()).attr(HOST_AND_PORT, (Object)this.address)).channel(ChannelUtils.channelForEventLoopGroup(this.env.eventLoopGroup()))).handler((ChannelHandler)new DcpPipeline(this.env, this.controlHandler, this.conductor.bucketConfigArbiter(), this.metrics, this.clientMetrics))).group(this.env.eventLoopGroup());
    }

    public Mono<Void> connect() {
        return Mono.create(sink -> {
            if (this.isShutdown || this.state() != LifecycleState.DISCONNECTED) {
                sink.success();
                return;
            }
            Bootstrap bootstrap = this.newBootstrap();
            this.transitionState(LifecycleState.CONNECTING);
            this.connectFuture = this.metrics.trackConnect(bootstrap.connect());
            this.connectFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        LOGGER.info("Connect attempt to {} failed.", (Object)RedactableArgument.system(DcpChannel.this.address), (Object)future.cause());
                        DcpChannel.this.transitionState(LifecycleState.DISCONNECTED);
                        sink.error(future.cause());
                        return;
                    }
                    DcpChannel.this.channel = future.channel();
                    DcpChannel.this.metrics.trackDisconnect(DcpChannel.this.channel.closeFuture());
                    if (DcpChannel.this.isShutdown) {
                        LOGGER.info("Connected Node {}, but got instructed to disconnect in the meantime.", (Object)RedactableArgument.system(DcpChannel.this.address));
                        DcpChannel.this.disconnect().doOnSuccess(v -> sink.success()).onErrorResume(e -> {
                            LOGGER.warn("Got error during disconnect.", e);
                            sink.error(e);
                            return Mono.empty();
                        }).subscribe();
                        return;
                    }
                    DcpChannel.this.transitionState(LifecycleState.CONNECTED);
                    LOGGER.info("Connected to Node {}", (Object)RedactableArgument.system(DcpChannel.this.channel.remoteAddress()));
                    DcpChannel.this.channel.closeFuture().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            LOGGER.debug("Got notified of channel close on Node {}", (Object)DcpChannel.this.address);
                            if (DcpChannel.this.env.persistencePollingEnabled()) {
                                for (int vbid = 0; vbid < DcpChannel.this.streamIsOpen.length(); ++vbid) {
                                    if (!DcpChannel.this.streamIsOpen.get(vbid)) continue;
                                    DcpChannel.this.env.streamEventBuffer().clear(vbid);
                                }
                            }
                            DcpChannel.this.transitionState(LifecycleState.DISCONNECTED);
                            if (!DcpChannel.this.isShutdown) {
                                DcpChannel.this.dispatchReconnect();
                            }
                            DcpChannel.this.channel = null;
                        }
                    });
                    sink.success();
                }
            });
        });
    }

    private void dispatchReconnect() {
        if (this.isShutdown) {
            LOGGER.debug("Ignoring reconnect on {} because already shutdown.", (Object)this.address);
            return;
        }
        LOGGER.info("Node {} socket closed, initiating reconnect.", (Object)RedactableArgument.system(this.address));
        Duration delay = this.reconnectDelay.calculate();
        if (delay.compareTo(Duration.ZERO) > 0) {
            LOGGER.info("Delaying reconnection attempt by {}ms", (Object)delay.toMillis());
        }
        Mono.delay((Duration)delay).then(this.connect().retryWhen((Retry)Retry.backoff((long)Long.MAX_VALUE, (Duration)Duration.ofMillis(32L)).maxBackoff(Duration.ofSeconds(4L)).doAfterRetry(retrySignal -> LOGGER.debug("Rescheduling Node reconnect for DCP channel {}", (Object)this.address)))).doOnError(e -> LOGGER.warn("Got error during connect (maybe retried) for node {}", (Object)RedactableArgument.system(this.address), e)).doOnSuccess(ignored -> {
            LOGGER.debug("Completed Node connect for DCP channel {}", (Object)this.address);
            for (int vbid = 0; vbid < this.streamIsOpen.length(); ++vbid) {
                if (!this.streamIsOpen.get(vbid)) continue;
                this.conductor.maybeMovePartition(vbid);
            }
        }).subscribe();
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public Mono<Void> disconnect() {
        return Mono.create(sink -> {
            this.isShutdown = true;
            if (this.channel != null) {
                this.transitionState(LifecycleState.DISCONNECTING);
                ChannelFuture closeFuture = this.metrics.trackDisconnect(this.channel.close());
                closeFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        DcpChannel.this.transitionState(LifecycleState.DISCONNECTED);
                        LOGGER.info("Disconnected from Node {}", (Object)RedactableArgument.system(DcpChannel.this.address()));
                        if (future.isSuccess()) {
                            sink.success();
                        } else {
                            LOGGER.debug("Error during channel close.", future.cause());
                            sink.error(future.cause());
                        }
                    }
                });
            } else if (this.connectFuture != null) {
                this.connectFuture.addListener((GenericFutureListener)new ChannelFutureListener(){
                    final /* synthetic */ MonoSink val$sink;
                    {
                        this.val$sink = monoSink;
                    }

                    public void operationComplete(ChannelFuture channelFuture) throws Exception {
                        if (channelFuture.isSuccess()) {
                            channelFuture.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture closeFuture) throws Exception {
                                    if (closeFuture.isSuccess()) {
                                        val$sink.success();
                                    } else {
                                        val$sink.error(closeFuture.cause());
                                    }
                                }
                            });
                        } else {
                            this.val$sink.success();
                        }
                    }
                });
            } else {
                sink.success();
            }
        });
    }

    public HostAndPort address() {
        return this.address;
    }

    public Mono<Optional<CollectionsManifest>> getCollectionsManifest() {
        return Mono.create(sink -> {
            if (this.state() != LifecycleState.CONNECTED) {
                sink.error((Throwable)new NotConnectedException());
                return;
            }
            if (!HelloFeature.COLLECTIONS.isEnabled(this.channel)) {
                sink.success(Optional.empty());
                return;
            }
            ByteBuf buffer = Unpooled.buffer();
            MessageUtil.initRequest((byte)-70, buffer);
            this.sendRequest(buffer).addListener((GenericFutureListener)new DcpResponseListener(){
                final /* synthetic */ MonoSink val$sink;
                {
                    this.val$sink = monoSink;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(Future<DcpResponse> future) throws Exception {
                    if (!future.isSuccess()) {
                        if (future.cause() instanceof NotConnectedException) {
                            LOGGER.debug("Failed to get collections manifest from {}; {}", (Object)DcpChannel.this.address, (Object)future.cause().toString());
                        } else {
                            LOGGER.warn("Failed to get collections manifest from {}; {}", (Object)DcpChannel.this.address, (Object)future.cause().toString());
                        }
                        this.val$sink.error(future.cause());
                        return;
                    }
                    DcpResponse dcpResponse = (DcpResponse)future.getNow();
                    ByteBuf buf = dcpResponse.buffer();
                    try {
                        ResponseStatus status = dcpResponse.status();
                        if (!status.isSuccess()) {
                            LOGGER.warn("Failed to get collections manifest from {}, response status: {}", (Object)DcpChannel.this.address, (Object)status);
                            this.val$sink.error((Throwable)new DcpOps.BadResponseStatusException(status));
                            return;
                        }
                        byte[] manifestJsonBytes = MessageUtil.getContentAsByteArray(buf);
                        LOGGER.debug("Got collections manifest from {} ; {}", (Object)DcpChannel.this.address, (Object)new String(manifestJsonBytes, StandardCharsets.UTF_8));
                        try {
                            CollectionsManifest manifest = CollectionsManifest.fromJson(manifestJsonBytes);
                            this.val$sink.success(Optional.of(manifest));
                        }
                        catch (Exception e) {
                            LOGGER.error("Unparsable collections manifest from {} ; {}", new Object[]{RedactableArgument.system(DcpChannel.this.address), RedactableArgument.user(new String(manifestJsonBytes, StandardCharsets.UTF_8)), e});
                            this.val$sink.error((Throwable)new RuntimeException("Failed to parse collections manifest", e));
                        }
                    }
                    finally {
                        buf.release();
                    }
                }
            });
        });
    }

    public Mono<Void> openStream(final int vbid, StreamOffset startOffset, long endSeqno, CollectionsManifest manifest, Set<StreamFlag> flags) {
        return Mono.create(sink -> {
            long snapshotEndSeqno;
            long snapshotStartSeqno;
            if (this.state() != LifecycleState.CONNECTED) {
                sink.error((Throwable)new NotConnectedException());
                return;
            }
            long startSeqno = startOffset.getSeqno();
            long origSnapshotStartSeqno = startOffset.getSnapshot().getStartSeqno();
            long origSnapshotEndSeqno = startOffset.getSnapshot().getEndSeqno();
            long vbuuid = startOffset.getVbuuid();
            long collectionsManifestuid = startOffset.getCollectionsManifestUid();
            if (origSnapshotStartSeqno == startSeqno + 1L) {
                LOGGER.debug("Disregarding snapshot marker from the future.");
                snapshotStartSeqno = startSeqno;
                snapshotEndSeqno = startSeqno;
            } else {
                snapshotEndSeqno = origSnapshotEndSeqno;
                snapshotStartSeqno = origSnapshotStartSeqno;
            }
            LOGGER.debug("Opening Stream against {} with vbid: {}, vbuuid: {}, startSeqno: {}, endSeqno: {},  snapshotStartSeqno: {}, snapshotEndSeqno: {}, manifest: {}", new Object[]{this.address, vbid, vbuuid, startSeqno, endSeqno, snapshotStartSeqno, snapshotEndSeqno, manifest});
            ByteBuf buffer = Unpooled.buffer();
            DcpOpenStreamRequest.init(buffer, flags, vbid);
            DcpOpenStreamRequest.vbuuid(buffer, vbuuid);
            DcpOpenStreamRequest.startSeqno(buffer, startSeqno);
            DcpOpenStreamRequest.endSeqno(buffer, endSeqno);
            DcpOpenStreamRequest.snapshotStartSeqno(buffer, snapshotStartSeqno);
            DcpOpenStreamRequest.snapshotEndSeqno(buffer, snapshotEndSeqno);
            HashMap<String, Object> value = new HashMap<String, Object>();
            if (HelloFeature.COLLECTIONS.isEnabled(this.channel)) {
                OptionalLong scopeId;
                HashSet<Long> collectionIds = new HashSet<Long>(this.env.collectionIds());
                this.env.collectionNames().forEach(name -> {
                    CollectionsManifest.CollectionInfo c = manifest.getCollection((String)name);
                    if (c == null) {
                        sink.error((Throwable)new RuntimeException("Can't stream from collection '" + name + "' because it does not exist (not present in the collections manifest)."));
                        return;
                    }
                    LOGGER.debug("resolved collection name '{}' to UID {}", name, (Object)c.id());
                    collectionIds.add(c.id());
                });
                if (this.env.scopeName().isPresent()) {
                    String scopeName = this.env.scopeName().get();
                    CollectionsManifest.ScopeInfo s = manifest.getScope(scopeName);
                    if (s == null) {
                        sink.error((Throwable)new RuntimeException("Can't stream from scope '" + scopeName + "' because it does not exist (not present in the collections manifest)."));
                        return;
                    }
                    LOGGER.debug("resolved scope name '{}' to UID {}", (Object)scopeName, (Object)s.id());
                    scopeId = OptionalLong.of(s.id());
                } else {
                    scopeId = this.env.scopeId();
                }
                value.put("uid", DcpChannel.formatUid(collectionsManifestuid));
                if (!collectionIds.isEmpty()) {
                    value.put("collections", DcpChannel.formatUids(collectionIds));
                } else if (scopeId.isPresent()) {
                    value.put("scope", DcpChannel.formatUid(scopeId.getAsLong()));
                }
                try {
                    byte[] bytes = DefaultObjectMapper.writeValueAsBytes(value);
                    LOGGER.debug("opening stream for partition {} with value: {}", (Object)vbid, (Object)new String(bytes, StandardCharsets.UTF_8));
                    MessageUtil.setContent(bytes, buffer);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.env.tracer().onStreamStart(this.address, vbid, vbuuid, startSeqno, endSeqno, snapshotStartSeqno, snapshotEndSeqno, value);
            this.sendRequest(buffer).addListener((GenericFutureListener)new DcpResponseListener(){
                final /* synthetic */ MonoSink val$sink;
                {
                    this.val$sink = monoSink;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(Future<DcpResponse> future) throws Exception {
                    if (!future.isSuccess()) {
                        DcpChannel.this.env.tracer().onStreamStartFailed(DcpChannel.this.address, vbid, future.cause().toString());
                        LOGGER.debug("Failed open Stream against {} with vbid: {}", (Object)DcpChannel.this.address, (Object)vbid);
                        DcpChannel.this.streamIsOpen.set(vbid, false);
                        this.val$sink.error(future.cause());
                        return;
                    }
                    DcpResponse dcpResponse = (DcpResponse)future.getNow();
                    ByteBuf buf = dcpResponse.buffer();
                    try {
                        ResponseStatus status = dcpResponse.status();
                        if (!status.isSuccess()) {
                            DcpChannel.this.env.tracer().onStreamStartFailed(DcpChannel.this.address, vbid, status.formatted());
                        }
                        if (status == ResponseStatus.KEY_EXISTS) {
                            LOGGER.debug("Stream already open against {} with vbid: {}", (Object)DcpChannel.this.address, (Object)vbid);
                            this.val$sink.success();
                            return;
                        }
                        if (!status.isSuccess()) {
                            LOGGER.debug("Failed open Stream against {} with vbid: {}", (Object)DcpChannel.this.address, (Object)vbid);
                            DcpChannel.this.streamIsOpen.set(vbid, false);
                        }
                        if (status.isSuccess()) {
                            LOGGER.debug("Opened Stream against {} with vbid: {}", (Object)DcpChannel.this.address, (Object)vbid);
                            DcpChannel.this.streamIsOpen.set(vbid, true);
                            this.val$sink.success();
                            ByteBuf flog = Unpooled.buffer();
                            DcpFailoverLogResponse.init(flog);
                            DcpFailoverLogResponse.vbucket(flog, DcpOpenStreamResponse.vbucket(buf));
                            ByteBuf content = MessageUtil.getContent(buf).copy().writeShort(vbid);
                            MessageUtil.setContent(content, flog);
                            content.release();
                            DcpChannel.this.env.controlEventHandler().onEvent(ChannelFlowController.dummy, flog);
                        } else if (status == ResponseStatus.ROLLBACK_REQUIRED) {
                            this.val$sink.error((Throwable)new RollbackException());
                            ByteBuf rb = Unpooled.buffer();
                            RollbackMessage.init(rb, vbid, DcpOpenStreamResponse.rollbackSeqno(buf));
                            DcpChannel.this.env.controlEventHandler().onEvent(ChannelFlowController.dummy, rb);
                        } else if (status == ResponseStatus.NOT_MY_VBUCKET) {
                            this.val$sink.error((Throwable)new NotMyVbucketException());
                        } else {
                            this.val$sink.error((Throwable)new DcpOps.BadResponseStatusException(status));
                        }
                    }
                    finally {
                        buf.release();
                    }
                }
            });
        });
    }

    private static String formatUid(long uid) {
        return Long.toHexString(uid);
    }

    private static List<String> formatUids(Collection<Long> uids) {
        return uids.stream().map(DcpChannel::formatUid).collect(Collectors.toList());
    }

    public Mono<Void> closeStream(final int vbid) {
        return Mono.create(sink -> {
            if (this.state() != LifecycleState.CONNECTED) {
                sink.error((Throwable)new NotConnectedException());
                return;
            }
            LOGGER.debug("Closing Stream against {} with vbid: {}", (Object)this.address, (Object)vbid);
            ByteBuf buffer = Unpooled.buffer();
            DcpCloseStreamRequest.init(buffer);
            DcpCloseStreamRequest.vbucket(buffer, vbid);
            this.sendRequest(buffer).addListener((GenericFutureListener)new DcpResponseListener(){
                final /* synthetic */ MonoSink val$sink;
                {
                    this.val$sink = monoSink;
                }

                public void operationComplete(Future<DcpResponse> future) throws Exception {
                    DcpChannel.this.streamIsOpen.set(vbid, false);
                    if (future.isSuccess()) {
                        ((DcpResponse)future.getNow()).buffer().release();
                        LOGGER.debug("Closed Stream against {} with vbid: {}", (Object)DcpChannel.this.address, (Object)vbid);
                        this.val$sink.success();
                    } else {
                        LOGGER.debug("Failed close Stream against {} with vbid: {}", (Object)DcpChannel.this.address, (Object)vbid);
                        this.val$sink.error(future.cause());
                    }
                }
            });
        });
    }

    public Mono<List<PartitionAndSeqno>> getSeqnos() {
        return Mono.create(sink -> {
            if (this.state() != LifecycleState.CONNECTED) {
                sink.error((Throwable)new NotConnectedException());
                return;
            }
            ByteBuf buffer = Unpooled.buffer();
            DcpGetPartitionSeqnosRequest.init(buffer);
            DcpGetPartitionSeqnosRequest.vbucketState(buffer, VbucketState.ACTIVE);
            this.sendRequest(buffer).addListener((GenericFutureListener)new DcpResponseListener(){
                final /* synthetic */ MonoSink val$sink;
                {
                    this.val$sink = monoSink;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(Future<DcpResponse> future) throws Exception {
                    if (!future.isSuccess()) {
                        this.val$sink.error(future.cause());
                        return;
                    }
                    DcpResponse response = (DcpResponse)future.getNow();
                    ByteBuf buf = response.buffer();
                    try {
                        if (!response.status().isSuccess()) {
                            String content = MessageUtil.getContentAsString(response.buffer());
                            String msg = "Failed to get seqnos. Details: " + content;
                            this.val$sink.error((Throwable)new DcpOps.BadResponseStatusException(response.status(), msg));
                            return;
                        }
                        this.val$sink.success(DcpGetPartitionSeqnosResponse.parse(buf));
                    }
                    finally {
                        buf.release();
                    }
                }
            });
        });
    }

    public Mono<ByteBuf> getFailoverLog(final int vbid) {
        return Mono.create(sink -> {
            if (this.state() != LifecycleState.CONNECTED) {
                sink.error((Throwable)new NotConnectedException());
                return;
            }
            ByteBuf buffer = Unpooled.buffer();
            DcpFailoverLogRequest.init(buffer);
            DcpFailoverLogRequest.vbucket(buffer, vbid);
            LOGGER.debug("Asked for failover log on {} for vbid: {}", (Object)this.address, (Object)vbid);
            this.sendRequest(buffer).addListener((GenericFutureListener)new DcpResponseListener(){
                final /* synthetic */ MonoSink val$sink;
                {
                    this.val$sink = monoSink;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void operationComplete(Future<DcpResponse> future) throws Exception {
                    if (!future.isSuccess()) {
                        LOGGER.debug("Failed to ask for failover log on {} for vbid: {}", (Object)DcpChannel.this.address, (Object)vbid);
                        this.val$sink.error(future.cause());
                        return;
                    }
                    ByteBuf buf = ((DcpResponse)future.getNow()).buffer();
                    try {
                        ByteBuf flog = Unpooled.buffer();
                        DcpFailoverLogResponse.init(flog);
                        DcpFailoverLogResponse.vbucket(flog, DcpFailoverLogResponse.vbucket(buf));
                        ByteBuf copiedBuf = MessageUtil.getContent(buf).copy().writeShort(vbid);
                        MessageUtil.setContent(copiedBuf, flog);
                        copiedBuf.release();
                        LOGGER.debug("Failover log for vbid {} is {}", (Object)vbid, (Object)DcpFailoverLogResponse.toString(flog));
                        this.val$sink.success((Object)flog);
                    }
                    finally {
                        buf.release();
                    }
                }
            });
        });
    }

    public boolean streamIsOpen(int vbid) {
        return this.streamIsOpen.get(vbid);
    }

    public boolean equals(Object o) {
        if (o instanceof HostAndPort) {
            return this.address.equals(o);
        }
        if (o instanceof DcpChannel) {
            return this.address.equals(((DcpChannel)o).address);
        }
        return false;
    }

    public int hashCode() {
        return this.address.hashCode();
    }

    public String toString() {
        return "DcpChannel{address=" + this.address + '}';
    }
}

