/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.buffer;

import com.couchbase.client.dcp.buffer.NodeToPartitionMultimap;
import com.couchbase.client.dcp.buffer.PartitionInstance;
import com.couchbase.client.dcp.config.HostAndPort;
import com.couchbase.client.dcp.core.config.ConfigRevision;
import com.couchbase.client.dcp.core.config.CouchbaseBucketConfig;
import com.couchbase.client.dcp.core.config.NodeInfo;
import com.couchbase.client.dcp.core.logging.RedactableArgument;
import com.couchbase.client.dcp.core.service.ServiceType;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;

public class DcpBucketConfig {
    private final CouchbaseBucketConfig config;
    private final NodeToPartitionMultimap map;
    private final List<NodeInfo> allKvNodes;

    public DcpBucketConfig(CouchbaseBucketConfig config) {
        this.config = Objects.requireNonNull(config);
        this.map = new NodeToPartitionMultimap(config);
        this.allKvNodes = Collections.unmodifiableList(config.nodes().stream().filter(node -> node.has(ServiceType.KV)).collect(Collectors.toList()));
    }

    public ConfigRevision rev() {
        return this.config.revision();
    }

    public int numberOfPartitions() {
        return this.config.partitions().size();
    }

    public List<NodeInfo> nodes() {
        return this.allKvNodes;
    }

    public List<PartitionInstance> getHostedPartitions(HostAndPort nodeAddress) throws NoSuchElementException {
        int nodeIndex = this.getNodeIndex(nodeAddress);
        return this.map.get(nodeIndex);
    }

    public List<NodeInfo> getKvNodes() {
        return this.allKvNodes;
    }

    public int getNodeIndex(HostAndPort nodeAddress) throws NoSuchElementException {
        int nodeIndex = 0;
        for (NodeInfo node : this.nodes()) {
            if (nodeAddress.equals(this.getAddress(node))) {
                return nodeIndex;
            }
            ++nodeIndex;
        }
        throw new NoSuchElementException("Failed to locate " + RedactableArgument.redactSystem(nodeAddress) + " in bucket config.");
    }

    public HostAndPort getActiveNodeKvAddress(int partition) {
        NodeInfo node = this.config.partitions().active(partition).orElseThrow(() -> new IllegalStateException("No active node for partition " + partition));
        return this.getAddress(node);
    }

    public List<PartitionInstance> getAbsentPartitionInstances() {
        return this.map.getAbsent();
    }

    public HostAndPort getAddress(NodeInfo node) {
        return new HostAndPort(node.host(), node.port(ServiceType.KV).orElseThrow(() -> new IllegalArgumentException("Node not running KV service: " + node)));
    }

    public int numberOfReplicas() {
        return this.config.numberOfReplicas();
    }
}

