/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.util;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.NanoTimestamp;
import java.time.Duration;
import java.util.Objects;

@Stability.Internal
public class Deadline {
    private final NanoTimestamp start = NanoTimestamp.now();
    private final Duration duration;

    private Deadline(Duration duration) {
        this.duration = Objects.requireNonNull(duration);
    }

    public static Deadline of(Duration duration) {
        return new Deadline(duration);
    }

    public boolean exceeded() {
        return this.start.hasElapsed(this.duration);
    }
}

