/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.Event;
import com.couchbase.client.core.cnc.events.request.RequestNotRetriedEvent;
import com.couchbase.client.core.cnc.events.request.RequestRetryScheduledEvent;
import com.couchbase.client.core.error.AmbiguousTimeoutException;
import com.couchbase.client.core.error.TimeoutException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.error.context.CancellationErrorContext;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.protostellar.ProtostellarBaseRequest;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.retry.BestEffortRetryStrategy;
import com.couchbase.client.core.retry.ProtostellarRequestBehaviour;
import com.couchbase.client.core.retry.RetryAction;
import com.couchbase.client.core.retry.RetryOrchestrator;
import com.couchbase.client.core.retry.RetryReason;
import java.time.Duration;
import java.util.Optional;

@Stability.Internal
public class RetryOrchestratorProtostellar {
    public static ProtostellarRequestBehaviour shouldRetry(Core core, ProtostellarRequest<?> request, RetryReason reason) {
        CoreContext ctx = core.context();
        if (request.timeoutElapsed()) {
            CancellationErrorContext cancelContext = new CancellationErrorContext(request.context());
            TimeoutException exception = request.idempotent() ? new UnambiguousTimeoutException("Request timed out", cancelContext) : new AmbiguousTimeoutException("Request timed out", cancelContext);
            return ProtostellarRequestBehaviour.fail(exception);
        }
        if (reason.alwaysRetry()) {
            return RetryOrchestratorProtostellar.retryWithDuration(ctx, request, RetryOrchestrator.controlledBackoff(request.retryAttempts()), reason);
        }
        try {
            RetryAction retryAction;
            if (request.retryStrategy() == BestEffortRetryStrategy.INSTANCE) {
                retryAction = RetryAction.withDuration(Duration.ofMillis(50L));
            } else {
                ProtostellarBaseRequest wrapper = new ProtostellarBaseRequest(core, request);
                retryAction = request.retryStrategy().shouldRetry(wrapper, reason).get();
            }
            Optional<Duration> duration = retryAction.duration();
            if (duration.isPresent()) {
                Duration cappedDuration = RetryOrchestratorProtostellar.capDuration(duration.get(), request);
                return RetryOrchestratorProtostellar.retryWithDuration(ctx, request, cappedDuration, reason);
            }
            ctx.environment().eventBus().publish(new RequestNotRetriedEvent(Event.Severity.DEBUG, request.getClass(), request.context(), reason, null));
            return request.cancel(CancellationReason.noMoreRetries(reason));
        }
        catch (Throwable throwable) {
            ctx.environment().eventBus().publish(new RequestNotRetriedEvent(Event.Severity.INFO, request.getClass(), request.context(), reason, throwable));
            throw new IllegalStateException("Internal bug - should not reach here");
        }
    }

    private static ProtostellarRequestBehaviour retryWithDuration(CoreContext ctx, ProtostellarRequest<?> request, Duration duration, RetryReason reason) {
        Duration cappedDuration = RetryOrchestratorProtostellar.capDuration(duration, request);
        ctx.environment().eventBus().publish(new RequestRetryScheduledEvent(cappedDuration, request.context(), request.getClass(), reason));
        request.incrementRetryAttempts(cappedDuration, reason);
        return ProtostellarRequestBehaviour.retry(cappedDuration);
    }

    @Stability.Internal
    public static Duration capDuration(Duration uncappedDuration, ProtostellarRequest<?> request) {
        long absoluteTimeout;
        long theoreticalTimeout = System.nanoTime() + uncappedDuration.toNanos();
        long timeoutDelta = theoreticalTimeout - (absoluteTimeout = request.absoluteTimeout());
        if (timeoutDelta > 0L) {
            Duration cappedDuration = uncappedDuration.minus(Duration.ofNanos(timeoutDelta));
            if (cappedDuration.isNegative()) {
                return uncappedDuration;
            }
            return cappedDuration;
        }
        return uncappedDuration;
    }
}

