/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.retry;

import com.couchbase.client.core.annotation.Stability;
import java.time.Duration;
import java.util.Objects;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ProtostellarRequestBehaviour {
    @Nullable
    private final Duration retryDuration;
    @Nullable
    private final RuntimeException exception;

    public ProtostellarRequestBehaviour(@Nullable Duration retryDuration, @Nullable RuntimeException exception) {
        if (retryDuration == null) {
            Objects.requireNonNull(exception, "Internal error - exception must not be null if retryDuration is");
        }
        this.retryDuration = retryDuration;
        this.exception = exception;
    }

    public static ProtostellarRequestBehaviour retry(Duration retryDuration) {
        return new ProtostellarRequestBehaviour(retryDuration, null);
    }

    public static ProtostellarRequestBehaviour fail(RuntimeException err) {
        return new ProtostellarRequestBehaviour(null, err);
    }

    @Nullable
    public Duration retryDuration() {
        return this.retryDuration;
    }

    @Nullable
    public RuntimeException exception() {
        return this.exception;
    }
}

