/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryMetaData;
import com.couchbase.client.core.api.query.CoreQueryMetrics;
import com.couchbase.client.core.api.query.CoreQueryStatus;
import com.couchbase.client.core.api.query.CoreQueryWarning;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.protostellar.query.ProtostellarCoreQueryMetrics;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.protostellar.query.v1.QueryResponse;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Stability.Internal
public class ProtostellarCoreQueryMetaData
extends CoreQueryMetaData {
    private final QueryResponse.MetaData metaData;

    public ProtostellarCoreQueryMetaData(QueryResponse.MetaData metaData) {
        this.metaData = Validators.notNull(metaData, "metaData");
    }

    @Override
    public String requestId() {
        return this.metaData.getRequestId();
    }

    @Override
    public String clientContextId() {
        return this.metaData.getClientContextId();
    }

    @Override
    public CoreQueryStatus status() {
        switch (this.metaData.getStatus()) {
            case RUNNING: {
                return CoreQueryStatus.RUNNING;
            }
            case SUCCESS: {
                return CoreQueryStatus.SUCCESS;
            }
            case ERRORS: {
                return CoreQueryStatus.ERRORS;
            }
            case COMPLETED: {
                return CoreQueryStatus.COMPLETED;
            }
            case STOPPED: {
                return CoreQueryStatus.STOPPED;
            }
            case TIMEOUT: {
                return CoreQueryStatus.TIMEOUT;
            }
            case CLOSED: {
                return CoreQueryStatus.CLOSED;
            }
            case FATAL: {
                return CoreQueryStatus.FATAL;
            }
            case ABORTED: {
                return CoreQueryStatus.ABORTED;
            }
        }
        return CoreQueryStatus.UNKNOWN;
    }

    @Override
    public Optional<byte[]> signature() {
        return Optional.of(this.metaData.getSignature().toByteArray());
    }

    @Override
    public Optional<byte[]> profile() {
        if (this.metaData.hasProfile()) {
            return Optional.of(this.metaData.getProfile().toByteArray());
        }
        return Optional.empty();
    }

    @Override
    public Optional<CoreQueryMetrics> metrics() {
        if (this.metaData.hasMetrics()) {
            return Optional.of(new ProtostellarCoreQueryMetrics(this.metaData.getMetrics()));
        }
        return Optional.empty();
    }

    @Override
    public List<CoreQueryWarning> warnings() {
        return this.metaData.getWarningsList().stream().map(warning -> new CoreQueryWarning(new ErrorCodeAndMessage(warning.getCode(), warning.getMessage(), false, null))).collect(Collectors.toList());
    }
}

