/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreEncodedContent;
import com.couchbase.client.core.api.kv.CoreKvParamValidators;
import com.couchbase.client.core.api.kv.CoreStoreSemantics;
import com.couchbase.client.core.api.kv.CoreSubdocMutateCommand;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.google.protobuf.ByteString;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarKeyValueRequest;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.protostellar.kv.v1.ExistsRequest;
import com.couchbase.client.protostellar.kv.v1.GetAndLockRequest;
import com.couchbase.client.protostellar.kv.v1.GetAndTouchRequest;
import com.couchbase.client.protostellar.kv.v1.GetRequest;
import com.couchbase.client.protostellar.kv.v1.InsertRequest;
import com.couchbase.client.protostellar.kv.v1.MutateInRequest;
import com.couchbase.client.protostellar.kv.v1.RemoveRequest;
import com.couchbase.client.protostellar.kv.v1.ReplaceRequest;
import com.couchbase.client.protostellar.kv.v1.TouchRequest;
import com.couchbase.client.protostellar.kv.v1.UnlockRequest;
import com.couchbase.client.protostellar.kv.v1.UpsertRequest;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Stability.Internal
public class CoreProtostellarKeyValueRequests {
    private CoreProtostellarKeyValueRequests() {
    }

    public static ProtostellarRequest<GetRequest> getRequest(Core core, CoreCommonOptions opts, CoreKeyspace keyspace, String key, List<String> projections, boolean withExpiry) {
        CoreKvParamValidators.validateGetParams(opts, key, projections, withExpiry);
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        ProtostellarKeyValueRequest<GetRequest> out = new ProtostellarKeyValueRequest<GetRequest>(core, keyspace, key, CoreDurability.NONE, "get", CoreProtostellarUtil.createSpan(core, "get", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, true, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        out.request(GetRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).build());
        if (!projections.isEmpty() || withExpiry) {
            throw new UnsupportedOperationException("Projections and withExpiry are not yet supported with Protostellar, but will be");
        }
        return out;
    }

    public static ProtostellarRequest<GetAndLockRequest> getAndLockRequest(Core core, CoreCommonOptions opts, CoreKeyspace keyspace, String key, Duration lockTime) {
        CoreKvParamValidators.validateGetAndLockParams(opts, key, lockTime);
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        ProtostellarKeyValueRequest<GetAndLockRequest> out = new ProtostellarKeyValueRequest<GetAndLockRequest>(core, keyspace, key, CoreDurability.NONE, "get_and_lock", CoreProtostellarUtil.createSpan(core, "get_and_lock", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, true, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        out.request(GetAndLockRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setLockTime((int)lockTime.toMillis()).build());
        return out;
    }

    public static ProtostellarRequest<GetAndTouchRequest> getAndTouchRequest(Core core, CoreCommonOptions opts, CoreKeyspace keyspace, String key, long expiration) {
        CoreKvParamValidators.validateGetAndTouchParams(opts, key, expiration);
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        ProtostellarKeyValueRequest<GetAndTouchRequest> out = new ProtostellarKeyValueRequest<GetAndTouchRequest>(core, keyspace, key, CoreDurability.NONE, "get_and_touch", CoreProtostellarUtil.createSpan(core, "get_and_touch", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, true, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        out.request(GetAndTouchRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setExpiry(CoreProtostellarUtil.convertExpiry(expiration)).build());
        return out;
    }

    public static ProtostellarRequest<InsertRequest> insertRequest(Core core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, long expiry) {
        CoreKvParamValidators.validateInsertParams(opts, key, content, durability, expiry);
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        ProtostellarKeyValueRequest<InsertRequest> out = new ProtostellarKeyValueRequest<InsertRequest>(core, keyspace, key, durability, "insert", CoreProtostellarUtil.createSpan(core, "insert", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        CoreEncodedContent encoded = CoreProtostellarKeyValueRequests.encodedContent(core, content, out);
        InsertRequest.Builder request = InsertRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setContent(ByteString.copyFrom(encoded.encoded())).setContentType(CoreProtostellarUtil.convertFromFlags(encoded.flags()));
        if (expiry != 0L) {
            request.setExpiry(CoreProtostellarUtil.convertExpiry(expiry));
        }
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        out.request(request.build());
        return out;
    }

    public static ProtostellarRequest<ReplaceRequest> replaceRequest(Core core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, Supplier<CoreEncodedContent> content, long cas, CoreDurability durability, long expiry, boolean preserveExpiry) {
        CoreKvParamValidators.validateReplaceParams(opts, key, content, cas, durability, expiry, preserveExpiry);
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        ProtostellarKeyValueRequest<ReplaceRequest> out = new ProtostellarKeyValueRequest<ReplaceRequest>(core, keyspace, key, durability, "replace", CoreProtostellarUtil.createSpan(core, "replace", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        CoreEncodedContent encoded = CoreProtostellarKeyValueRequests.encodedContent(core, content, out);
        ReplaceRequest.Builder request = ReplaceRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setCas(cas).setContent(ByteString.copyFrom(encoded.encoded())).setContentType(CoreProtostellarUtil.convertFromFlags(encoded.flags()));
        if (!preserveExpiry) {
            request.setExpiry(CoreProtostellarUtil.convertExpiry(expiry));
        }
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        out.request(request.build());
        return out;
    }

    public static ProtostellarRequest<UpsertRequest> upsertRequest(Core core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, long expiry, boolean preserveExpiry) {
        CoreKvParamValidators.validateUpsertParams(opts, key, content, durability, expiry, preserveExpiry);
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        ProtostellarKeyValueRequest<UpsertRequest> out = new ProtostellarKeyValueRequest<UpsertRequest>(core, keyspace, key, durability, "upsert", CoreProtostellarUtil.createSpan(core, "upsert", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        CoreEncodedContent encoded = CoreProtostellarKeyValueRequests.encodedContent(core, content, out);
        UpsertRequest.Builder request = UpsertRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setContent(ByteString.copyFrom(encoded.encoded())).setContentType(CoreProtostellarUtil.convertFromFlags(encoded.flags()));
        if (!preserveExpiry) {
            request.setExpiry(CoreProtostellarUtil.convertExpiry(expiry));
        }
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        out.request(request.build());
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CoreEncodedContent encodedContent(Core core, Supplier<CoreEncodedContent> content, ProtostellarRequest<?> out) {
        CoreEncodedContent encoded;
        RequestSpan encodeSpan = CbTracing.newSpan(core.context(), "request_encoding", out.span());
        long start = System.nanoTime();
        try {
            encoded = content.get();
        }
        finally {
            encodeSpan.end();
        }
        out.encodeLatency(System.nanoTime() - start);
        return encoded;
    }

    public static ProtostellarRequest<RemoveRequest> removeRequest(Core core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, long cas, CoreDurability durability) {
        CoreKvParamValidators.validateRemoveParams(opts, key, cas, durability);
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        ProtostellarKeyValueRequest<RemoveRequest> out = new ProtostellarKeyValueRequest<RemoveRequest>(core, keyspace, key, durability, "remove", CoreProtostellarUtil.createSpan(core, "remove", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        RemoveRequest.Builder request = RemoveRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setCas(cas);
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        out.request(request.build());
        return out;
    }

    public static ProtostellarRequest<ExistsRequest> existsRequest(Core core, CoreKeyspace keyspace, CoreCommonOptions opts, String key) {
        CoreKvParamValidators.validateExistsParams(opts, key);
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        ProtostellarKeyValueRequest<ExistsRequest> out = new ProtostellarKeyValueRequest<ExistsRequest>(core, keyspace, key, CoreDurability.NONE, "exists", CoreProtostellarUtil.createSpan(core, "exists", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, true, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        ExistsRequest.Builder request = ExistsRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key);
        out.request(request.build());
        return out;
    }

    public static ProtostellarRequest<TouchRequest> touchRequest(Core core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, long expiry) {
        CoreKvParamValidators.validateTouchParams(opts, key, expiry);
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        ProtostellarKeyValueRequest<TouchRequest> out = new ProtostellarKeyValueRequest<TouchRequest>(core, keyspace, key, CoreDurability.NONE, "touch", CoreProtostellarUtil.createSpan(core, "touch", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        TouchRequest.Builder request = TouchRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setExpiry(CoreProtostellarUtil.convertExpiry(expiry)).setKey(key);
        out.request(request.build());
        return out;
    }

    public static ProtostellarRequest<UnlockRequest> unlockRequest(Core core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, long cas) {
        CoreKvParamValidators.validateUnlockParams(opts, key, cas, keyspace.toCollectionIdentifier());
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        ProtostellarKeyValueRequest<UnlockRequest> out = new ProtostellarKeyValueRequest<UnlockRequest>(core, keyspace, key, CoreDurability.NONE, "unlock", CoreProtostellarUtil.createSpan(core, "unlock", CoreDurability.NONE, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        UnlockRequest.Builder request = UnlockRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setCas(cas).setKey(key);
        out.request(request.build());
        return out;
    }

    public static ProtostellarRequest<MutateInRequest> mutateInRequest(Core core, CoreKeyspace keyspace, CoreCommonOptions opts, String key, List<CoreSubdocMutateCommand> commands, CoreStoreSemantics storeSemantics, long cas, CoreDurability durability, long expiry, boolean preserveExpiry, boolean accessDeleted, boolean createAsDeleted) {
        CoreKvParamValidators.validateSubdocMutateParams(opts, key, storeSemantics, cas);
        Duration timeout = CoreProtostellarUtil.kvTimeout(opts.timeout(), core);
        ProtostellarKeyValueRequest<MutateInRequest> out = new ProtostellarKeyValueRequest<MutateInRequest>(core, keyspace, key, CoreDurability.NONE, "mutate_in", CoreProtostellarUtil.createSpan(core, "mutate_in", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        MutateInRequest.Builder request = MutateInRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setCas(cas).setKey(key).addAllSpecs(commands.stream().map(command -> {
            MutateInRequest.Spec.Operation operation;
            switch (command.type()) {
                case COUNTER: {
                    operation = MutateInRequest.Spec.Operation.COUNTER;
                    break;
                }
                case REPLACE: {
                    operation = MutateInRequest.Spec.Operation.REPLACE;
                    break;
                }
                case DICT_ADD: {
                    operation = MutateInRequest.Spec.Operation.INSERT;
                    break;
                }
                case DICT_UPSERT: {
                    operation = MutateInRequest.Spec.Operation.UPSERT;
                    break;
                }
                case ARRAY_PUSH_FIRST: {
                    operation = MutateInRequest.Spec.Operation.ARRAY_PREPEND;
                    break;
                }
                case ARRAY_PUSH_LAST: {
                    operation = MutateInRequest.Spec.Operation.ARRAY_APPEND;
                    break;
                }
                case ARRAY_ADD_UNIQUE: {
                    operation = MutateInRequest.Spec.Operation.ARRAY_ADD_UNIQUE;
                    break;
                }
                case ARRAY_INSERT: {
                    operation = MutateInRequest.Spec.Operation.ARRAY_INSERT;
                    break;
                }
                case DELETE: {
                    operation = MutateInRequest.Spec.Operation.REMOVE;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Sub-Document mutateIn command " + (Object)((Object)command.type()) + " is not supported in Protostellar");
                }
            }
            MutateInRequest.Spec.Builder builder = MutateInRequest.Spec.newBuilder().setOperation(operation).setPath(command.path()).setContent(ByteString.copyFrom(command.fragment()));
            if (command.xattr() || command.expandMacro() || command.createParent()) {
                MutateInRequest.Spec.Flags.Builder flagsBuilder = MutateInRequest.Spec.Flags.newBuilder();
                if (command.xattr()) {
                    flagsBuilder.setXattr(command.xattr());
                }
                if (command.createParent()) {
                    flagsBuilder.setCreatePath(command.createParent());
                }
                if (command.expandMacro()) {
                    throw new IllegalArgumentException("expandMacro is not supported in Protostellar");
                }
                builder.setFlags(flagsBuilder);
            }
            return builder.build();
        }).collect(Collectors.toList()));
        switch (storeSemantics) {
            case REPLACE: {
                request.setStoreSemantic(MutateInRequest.StoreSemantic.REPLACE);
                break;
            }
            case UPSERT: {
                request.setStoreSemantic(MutateInRequest.StoreSemantic.UPSERT);
                break;
            }
            case INSERT: {
                request.setStoreSemantic(MutateInRequest.StoreSemantic.INSERT);
                break;
            }
            default: {
                throw new IllegalArgumentException("Sub-Document store semantic " + (Object)((Object)storeSemantics) + " is not supported in Protostellar");
            }
        }
        if (accessDeleted) {
            request.setFlags(MutateInRequest.Flags.newBuilder().setAccessDeleted(accessDeleted));
        }
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        if (createAsDeleted) {
            throw new IllegalArgumentException("createAsDeleted is not supported in mutateIn in Protostellar");
        }
        if (expiry != 0L) {
            throw new IllegalArgumentException("Setting expiry is not supported in mutateIn in Protostellar");
        }
        if (preserveExpiry) {
            throw new IllegalArgumentException("preserveExpiry is not supported in mutateIn in Protostellar");
        }
        out.request(request.build());
        return out;
    }
}

