/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreKvBinaryParamValidators;
import com.couchbase.client.core.deps.com.google.protobuf.ByteString;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.protostellar.ProtostellarKeyValueRequest;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.protostellar.kv.v1.AppendRequest;
import com.couchbase.client.protostellar.kv.v1.DecrementRequest;
import com.couchbase.client.protostellar.kv.v1.IncrementRequest;
import com.couchbase.client.protostellar.kv.v1.PrependRequest;
import java.time.Duration;
import java.util.Optional;

@Stability.Internal
public class CoreProtoStellarKvBinaryRequests {
    public static ProtostellarRequest<AppendRequest> appendRequest(Core core, String key, CoreKeyspace keyspace, CoreCommonOptions opts, byte[] content, long cas, CoreDurability durability) {
        CoreKvBinaryParamValidators.validateAppendPrependArgs(core, key, keyspace, opts, content, cas, durability);
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        ProtostellarKeyValueRequest<AppendRequest> out = new ProtostellarKeyValueRequest<AppendRequest>(core, keyspace, key, durability, "append", CoreProtostellarUtil.createSpan(core, "append", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        AppendRequest.Builder request = AppendRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setContent(ByteString.copyFrom(content)).setCas(cas);
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        return out.request(request.build());
    }

    public static ProtostellarRequest<PrependRequest> prependRequest(Core core, String key, CoreKeyspace keyspace, CoreCommonOptions opts, byte[] content, long cas, CoreDurability durability) {
        CoreKvBinaryParamValidators.validateAppendPrependArgs(core, key, keyspace, opts, content, cas, durability);
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        ProtostellarKeyValueRequest<PrependRequest> out = new ProtostellarKeyValueRequest<PrependRequest>(core, keyspace, key, durability, "prepend", CoreProtostellarUtil.createSpan(core, "prepend", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        PrependRequest.Builder request = PrependRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setContent(ByteString.copyFrom(content)).setCas(cas);
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        return out.request(request.build());
    }

    public static ProtostellarRequest<IncrementRequest> incrementRequest(Core core, String key, CoreKeyspace keyspace, CoreCommonOptions opts, long expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        CoreKvBinaryParamValidators.validateIncrementDecrementArgs(core, key, keyspace, opts, expiry, delta, initial, durability);
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        ProtostellarKeyValueRequest<IncrementRequest> out = new ProtostellarKeyValueRequest<IncrementRequest>(core, keyspace, key, durability, "increment", CoreProtostellarUtil.createSpan(core, "increment", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        IncrementRequest.Builder request = IncrementRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setDelta(delta).setInitial(initial.orElse(0L));
        if (expiry != 0L) {
            request.setExpiry(CoreProtostellarUtil.convertExpiry(expiry));
        }
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        return out.request(request.build());
    }

    public static ProtostellarRequest<DecrementRequest> decrementRequest(Core core, String key, CoreKeyspace keyspace, CoreCommonOptions opts, long expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        CoreKvBinaryParamValidators.validateIncrementDecrementArgs(core, key, keyspace, opts, expiry, delta, initial, durability);
        Duration timeout = CoreProtostellarUtil.kvDurableTimeout(opts.timeout(), durability, core);
        ProtostellarKeyValueRequest<DecrementRequest> out = new ProtostellarKeyValueRequest<DecrementRequest>(core, keyspace, key, durability, "decrement", CoreProtostellarUtil.createSpan(core, "decrement", durability, opts.parentSpan().orElse(null)), timeout, false, opts.retryStrategy().orElse(core.context().environment().retryStrategy()), opts.clientContext());
        DecrementRequest.Builder request = DecrementRequest.newBuilder().setBucketName(keyspace.bucket()).setScopeName(keyspace.scope()).setCollectionName(keyspace.collection()).setKey(key).setDelta(delta).setInitial(initial.orElse(0L));
        if (expiry != 0L) {
            request.setExpiry(CoreProtostellarUtil.convertExpiry(expiry));
        }
        if (!durability.isNone()) {
            request.setDurabilityLevel(CoreProtostellarUtil.convert(durability));
        }
        return out.request(request.build());
    }
}

