/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.metrics.NoopMeter;
import com.couchbase.client.core.deps.io.grpc.Deadline;
import com.couchbase.client.core.error.AmbiguousTimeoutException;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.error.TimeoutException;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.error.context.CancellationErrorContext;
import com.couchbase.client.core.error.context.ProtostellarErrorContext;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.protostellar.CoreProtostellarUtil;
import com.couchbase.client.core.retry.ProtostellarRequestBehaviour;
import com.couchbase.client.core.retry.RetryReason;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class ProtostellarRequest<TGrpcRequest> {
    private final Core core;
    @Nullable
    private final RequestSpan span;
    private final long absoluteTimeout;
    private long encodeLatency;
    private final RetryStrategy retryStrategy;
    private final long createdAt = System.nanoTime();
    protected final ServiceType serviceType;
    private final String requestName;
    private final boolean idempotent;
    private final Duration timeout;
    private final Deadline deadline;
    private final Map<String, Object> clientContext;
    private TGrpcRequest request;
    private long logicallyCompletedAt;
    private long lastDispatchDuration;
    private long totalDispatchDuration;
    private int retryAttempts;
    private Set<RetryReason> retryReasons;
    private CancellationReason cancellationReason;
    private volatile State state = State.INCOMPLETE;

    public ProtostellarRequest(Core core, ServiceType serviceType, String requestName, RequestSpan span, Duration timeout, boolean idempotent, RetryStrategy retryStrategy, Map<String, Object> clientContext) {
        this.core = core;
        this.serviceType = serviceType;
        this.requestName = requestName;
        this.span = span;
        this.absoluteTimeout = System.nanoTime() + timeout.toNanos();
        this.idempotent = idempotent;
        this.retryStrategy = retryStrategy;
        this.timeout = timeout;
        this.deadline = CoreProtostellarUtil.convertTimeout(timeout);
        this.clientContext = clientContext;
    }

    public ProtostellarRequest<TGrpcRequest> request(TGrpcRequest request) {
        this.request = request;
        return this;
    }

    public TGrpcRequest request() {
        return this.request;
    }

    public long encodeLatency() {
        return this.encodeLatency;
    }

    public ProtostellarRequest<TGrpcRequest> encodeLatency(long encodeLatency) {
        this.encodeLatency = encodeLatency;
        return this;
    }

    public RequestSpan span() {
        return this.span;
    }

    public void raisedResponseToUser(@Nullable Throwable err) {
        long latency;
        if (this.state != State.INCOMPLETE) {
            throw new IllegalStateException("Trying to raise a response multiple times on the same request - internal bug");
        }
        State state = this.state = err == null ? State.SUCCEEDED : State.FAILED;
        if (this.span != null) {
            if (!CbTracing.isInternalSpan(this.span)) {
                this.span.attribute("db.couchbase.retries", this.retryAttempts());
                if (err != null) {
                    this.span.recordException(err);
                    this.span.status(RequestSpan.StatusCode.ERROR);
                }
            }
            this.span.end();
        }
        if (!(this.core.context().environment().meter() instanceof NoopMeter) && (latency = this.logicalRequestLatency()) > 0L) {
            Core.ResponseMetricIdentifier rmi = new Core.ResponseMetricIdentifier(this.serviceType.ident(), this.requestName);
            this.core.responseMetric(rmi).recordValue(latency);
        }
    }

    public Duration timeout() {
        return this.timeout;
    }

    public Deadline deadline() {
        return this.deadline;
    }

    public long absoluteTimeout() {
        return this.absoluteTimeout;
    }

    public RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public boolean timeoutElapsed() {
        return this.absoluteTimeout - System.nanoTime() <= 0L;
    }

    public ProtostellarRequestBehaviour cancel(CancellationReason reason) {
        this.cancellationReason = reason;
        String msg = this.getClass().getSimpleName() + ", Reason: " + reason;
        CancellationErrorContext ctx = new CancellationErrorContext(this.context());
        RequestCanceledException exception = new RequestCanceledException(msg, reason, ctx);
        return ProtostellarRequestBehaviour.fail(exception);
    }

    public ProtostellarRequestBehaviour cancelDueToTimeout() {
        CancellationReason reason;
        this.cancellationReason = reason = CancellationReason.TIMEOUT;
        String msg = this.getClass().getSimpleName() + ", Reason: " + reason;
        CancellationErrorContext ctx = new CancellationErrorContext(this.context());
        TimeoutException exception = this.idempotent() ? new UnambiguousTimeoutException(msg, ctx) : new AmbiguousTimeoutException(msg, ctx);
        return ProtostellarRequestBehaviour.fail(exception);
    }

    public boolean idempotent() {
        return this.idempotent;
    }

    public long logicalRequestLatency() {
        if (this.logicallyCompletedAt == 0L || this.logicallyCompletedAt <= this.createdAt) {
            return 0L;
        }
        return this.logicallyCompletedAt - this.createdAt;
    }

    public void incrementRetryAttempts(Duration duration, RetryReason reason) {
        ++this.retryAttempts;
        if (this.retryReasons == null) {
            this.retryReasons = new HashSet<RetryReason>();
        }
        this.retryReasons.add(reason);
    }

    protected Map<String, Object> serviceContext() {
        return null;
    }

    public ProtostellarErrorContext context() {
        Map<String, Object> serviceContext;
        HashMap<String, Object> input = new HashMap<String, Object>();
        input.put("idempotent", this.idempotent);
        input.put("requestName", this.requestName);
        input.put("retried", this.retryAttempts);
        input.put("completed", this.completed());
        input.put("timeoutMs", this.timeout.toMillis());
        if (this.cancellationReason != null) {
            input.put("cancelled", true);
            input.put("reason", this.cancellationReason);
        }
        if (this.clientContext != null) {
            input.put("clientContext", this.clientContext);
        }
        if ((serviceContext = this.serviceContext()) != null) {
            input.put("service", serviceContext);
        }
        if (this.retryReasons != null) {
            input.put("retryReasons", this.retryReasons);
        }
        long logicalLatency = this.logicalRequestLatency();
        if (this.lastDispatchDuration != 0L || logicalLatency != 0L || this.encodeLatency != 0L) {
            HashMap<String, Long> timings = new HashMap<String, Long>();
            if (this.lastDispatchDuration != 0L) {
                timings.put("lastDispatchMicros", TimeUnit.NANOSECONDS.toMicros(this.lastDispatchDuration));
            }
            if (this.totalDispatchDuration != 0L) {
                timings.put("totalDispatchMicros", TimeUnit.NANOSECONDS.toMicros(this.totalDispatchDuration));
            }
            if (logicalLatency != 0L) {
                timings.put("totalMicros", TimeUnit.NANOSECONDS.toMicros(logicalLatency));
            }
            if (this.encodeLatency != 0L) {
                timings.put("encodingMicros", TimeUnit.NANOSECONDS.toMicros(this.encodeLatency));
            }
            input.put("timings", timings);
        }
        return new ProtostellarErrorContext(input, null);
    }

    public int retryAttempts() {
        return this.retryAttempts;
    }

    public void dispatchDuration(long duration) {
        this.lastDispatchDuration = duration;
        this.totalDispatchDuration += duration;
    }

    public boolean completed() {
        return this.state != State.INCOMPLETE;
    }

    public long createdAt() {
        return this.createdAt;
    }

    public ServiceType serviceType() {
        return this.serviceType;
    }

    @Nullable
    public CancellationReason cancellationReason() {
        return this.cancellationReason;
    }

    public boolean failed() {
        return this.state == State.FAILED;
    }

    public boolean succeeded() {
        return this.state == State.SUCCEEDED;
    }

    private static enum State {
        INCOMPLETE,
        SUCCEEDED,
        FAILED;

    }
}

