/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;

@Stability.Internal
public class ProtostellarKeyValueRequest<TGrpcRequest>
extends ProtostellarRequest<TGrpcRequest> {
    private final CoreKeyspace keyspace;
    private final String key;
    private final CoreDurability durability;

    public ProtostellarKeyValueRequest(Core core, CoreKeyspace keyspace, String key, CoreDurability durability, String requestName, RequestSpan span, Duration timeout, boolean idempotent, RetryStrategy retryStrategy, Map<String, Object> clientContext) {
        super(core, ServiceType.KV, requestName, span, timeout, idempotent, retryStrategy, clientContext);
        this.keyspace = keyspace;
        this.key = key;
        this.durability = durability;
    }

    @Override
    protected Map<String, Object> serviceContext() {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("type", this.serviceType.ident());
        if (this.keyspace != null) {
            ctx.put("bucket", RedactableArgument.redactMeta(this.keyspace.bucket()));
            ctx.put("scope", RedactableArgument.redactMeta(this.keyspace.scope()));
            ctx.put("collection", RedactableArgument.redactMeta(this.keyspace.collection()));
        }
        if (this.key != null) {
            ctx.put("documentId", RedactableArgument.redactUser(this.key));
        }
        if (!this.durability.isLegacy() && !this.durability.isNone()) {
            ctx.put("syncDurability", this.durability.levelIfSynchronous().orElse(DurabilityLevel.NONE).encodeForManagementApi());
        }
        return ctx;
    }
}

