/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.protostellar;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.google.protobuf.Timestamp;
import com.couchbase.client.core.deps.io.grpc.Deadline;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.protostellar.CoreProtostellarErrorHandlingUtil;
import com.couchbase.client.core.protostellar.ProtostellarRequest;
import com.couchbase.client.core.retry.ProtostellarRequestBehaviour;
import com.couchbase.client.protostellar.kv.v1.DocumentContentType;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.util.annotation.Nullable;

@Stability.Internal
public class CoreProtostellarUtil {
    private CoreProtostellarUtil() {
    }

    public static Duration kvTimeout(Optional<Duration> customTimeout, Core core) {
        return customTimeout.orElse(core.context().environment().timeoutConfig().kvTimeout());
    }

    public static Duration kvDurableTimeout(Optional<Duration> customTimeout, CoreDurability dl, Core core) {
        if (customTimeout.isPresent()) {
            return customTimeout.get();
        }
        if (dl.isLegacy()) {
            throw new FeatureNotAvailableException("Legacy durability is not supported with Protostellar; please use Durability instead");
        }
        if (!dl.isNone()) {
            return core.context().environment().timeoutConfig().kvDurableTimeout();
        }
        return core.context().environment().timeoutConfig().kvTimeout();
    }

    public static Duration kvDurableTimeout(Optional<Duration> customTimeout, Optional<DurabilityLevel> dl, Core core) {
        if (customTimeout.isPresent()) {
            return customTimeout.get();
        }
        if (dl.isPresent()) {
            return core.context().environment().timeoutConfig().kvDurableTimeout();
        }
        return core.context().environment().timeoutConfig().kvTimeout();
    }

    public static Deadline convertTimeout(Optional<Duration> customTimeout, Duration defaultTimeout) {
        if (customTimeout.isPresent()) {
            return Deadline.after(customTimeout.get().toMillis(), TimeUnit.MILLISECONDS);
        }
        return Deadline.after(defaultTimeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static Deadline convertTimeout(Duration timeout) {
        return Deadline.after(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    public static Duration managementTimeout(Optional<Duration> customTimeout, Core core) {
        return customTimeout.orElse(core.context().environment().timeoutConfig().managementTimeout());
    }

    public static int convertToFlags(DocumentContentType contentType) {
        int flags = 0;
        switch (contentType) {
            case JSON: {
                flags = CodecFlags.JSON_COMPAT_FLAGS;
                break;
            }
            case BINARY: {
                flags = CodecFlags.BINARY_COMPAT_FLAGS;
            }
        }
        return flags;
    }

    public static DocumentContentType convertFromFlags(int flags) {
        if ((flags & CodecFlags.JSON_COMPAT_FLAGS) != 0) {
            return DocumentContentType.JSON;
        }
        if ((flags & CodecFlags.BINARY_COMPAT_FLAGS) != 0) {
            return DocumentContentType.BINARY;
        }
        return DocumentContentType.UNKNOWN;
    }

    public static void handleShutdownBlocking(Core core, ProtostellarRequest<?> request) {
        if (core.protostellar().endpoint().isShutdown()) {
            throw RequestCanceledException.shuttingDown(request.context());
        }
    }

    public static <T> boolean handleShutdownAsync(Core core, CompletableFuture<T> ret, ProtostellarRequest<?> request) {
        if (core.protostellar().endpoint().isShutdown()) {
            ret.completeExceptionally(RequestCanceledException.shuttingDown(request.context()));
            return true;
        }
        return false;
    }

    public static <TSdkResult> boolean handleShutdownReactive(Sinks.One<TSdkResult> ret, Core core, ProtostellarRequest<?> request) {
        if (core.protostellar().endpoint().isShutdown()) {
            ret.tryEmitError((Throwable)RequestCanceledException.shuttingDown(request.context())).orThrow();
            return true;
        }
        return false;
    }

    @Nullable
    public static <T> Mono<T> handleShutdownReactive(Core core, ProtostellarRequest<?> request) {
        if (core.protostellar().endpoint().isShutdown()) {
            return Mono.error((Throwable)RequestCanceledException.shuttingDown(request.context()));
        }
        return null;
    }

    public static com.couchbase.client.protostellar.kv.v1.DurabilityLevel convert(DurabilityLevel dl) {
        switch (dl) {
            case MAJORITY: {
                return com.couchbase.client.protostellar.kv.v1.DurabilityLevel.MAJORITY;
            }
            case MAJORITY_AND_PERSIST_TO_ACTIVE: {
                return com.couchbase.client.protostellar.kv.v1.DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE;
            }
            case PERSIST_TO_MAJORITY: {
                return com.couchbase.client.protostellar.kv.v1.DurabilityLevel.PERSIST_TO_MAJORITY;
            }
        }
        throw new IllegalArgumentException("Unknown durability level " + (Object)((Object)dl));
    }

    public static com.couchbase.client.protostellar.kv.v1.DurabilityLevel convert(CoreDurability dl) {
        if (dl.isNone()) {
            throw new IllegalStateException("Should not have no durability here");
        }
        switch (dl.levelIfSynchronous().get()) {
            case MAJORITY: {
                return com.couchbase.client.protostellar.kv.v1.DurabilityLevel.MAJORITY;
            }
            case MAJORITY_AND_PERSIST_TO_ACTIVE: {
                return com.couchbase.client.protostellar.kv.v1.DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE;
            }
            case PERSIST_TO_MAJORITY: {
                return com.couchbase.client.protostellar.kv.v1.DurabilityLevel.PERSIST_TO_MAJORITY;
            }
        }
        throw new IllegalArgumentException("Unknown durability level " + dl);
    }

    @Nullable
    public static Instant convertExpiry(boolean hasExpiry, Timestamp expiry) {
        if (hasExpiry) {
            return Instant.ofEpochSecond(expiry.getSeconds());
        }
        return null;
    }

    public static Timestamp convertExpiry(long expiry) {
        if (expiry == 0L) {
            return Timestamp.getDefaultInstance();
        }
        return Timestamp.newBuilder().setSeconds(expiry).build();
    }

    public static <TResponse> ProtostellarRequestBehaviour convertKeyValueException(Core core, ProtostellarRequest<TResponse> request, Throwable t) {
        return CoreProtostellarErrorHandlingUtil.convertKeyValueException(core, request, t);
    }

    public static RequestSpan createSpan(Core core, String spanName, CoreDurability durability, @Nullable RequestSpan parent) {
        RequestSpan span = CbTracing.newSpan(core.context().environment().requestTracer(), spanName, parent);
        if (!durability.isNone() && !durability.isLegacy()) {
            switch (durability.levelIfSynchronous().get()) {
                case MAJORITY: {
                    span.attribute("db.couchbase.durability", "majority");
                    break;
                }
                case MAJORITY_AND_PERSIST_TO_ACTIVE: {
                    span.attribute("db.couchbase.durability", "majority_and_persist_active");
                    break;
                }
                case PERSIST_TO_MAJORITY: {
                    span.attribute("db.couchbase.durability", "persist_majority");
                }
            }
        }
        return span;
    }

    public static RuntimeException unsupportedInProtostellar(String feature) {
        return new FeatureNotAvailableException("Feature '" + feature + "' is not supported when using protostellar:// to connect");
    }

    public static RuntimeException unsupportedCurrentlyInProtostellar() {
        return new FeatureNotAvailableException("Feature is not supported when using protostellar:// to connect (but will be before GA)");
    }
}

