/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.query;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.DefaultFullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.FullHttpRequest;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderValues;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpMethod;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpVersion;
import com.couchbase.client.core.env.Authenticator;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.BaseRequest;
import com.couchbase.client.core.msg.HttpRequest;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.query.QueryChunkHeader;
import com.couchbase.client.core.msg.query.QueryChunkRow;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import com.couchbase.client.core.msg.query.QueryResponse;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.ServiceType;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class QueryRequest
extends BaseRequest<QueryResponse>
implements HttpRequest<QueryChunkHeader, QueryChunkRow, QueryChunkTrailer, QueryResponse> {
    private static final String URI = "/query/service";
    private final byte[] query;
    private final String statement;
    private final boolean idempotent;
    private final Authenticator authenticator;
    private final String contextId;
    private final String bucket;
    private final String scope;
    private final NodeIdentifier target;

    public QueryRequest(Duration timeout, CoreContext ctx, RetryStrategy retryStrategy, Authenticator authenticator, String statement, byte[] query, boolean idempotent, String contextId, RequestSpan span, String bucket, String scope, NodeIdentifier target) {
        super(timeout, ctx, retryStrategy, span);
        this.query = query;
        this.statement = statement;
        this.authenticator = authenticator;
        this.idempotent = idempotent;
        this.contextId = contextId;
        this.bucket = bucket;
        this.scope = scope;
        this.target = target;
        if (span != null && !CbTracing.isInternalSpan(span)) {
            span.attribute("db.couchbase.service", "query");
            span.attribute("db.statement", statement);
            if (bucket != null) {
                span.attribute("db.name", bucket);
            }
            if (scope != null) {
                span.attribute("db.couchbase.scope", scope);
            }
        }
    }

    public static String queryContext(String bucket, String scope) {
        return "`default`:`" + bucket + "`.`" + scope + "`";
    }

    @Override
    public FullHttpRequest encode() {
        ByteBuf content = Unpooled.wrappedBuffer(this.query);
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, URI, content);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.APPLICATION_JSON);
        request.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
        request.headers().set((CharSequence)HttpHeaderNames.USER_AGENT, (Object)this.context().environment().userAgent().formattedLong());
        this.authenticator.authHttpRequest(this.serviceType(), request);
        return request;
    }

    @Override
    public QueryResponse decode(ResponseStatus status, QueryChunkHeader header, Flux<QueryChunkRow> rows, Mono<QueryChunkTrailer> trailer) {
        return new QueryResponse(status, header, rows, trailer);
    }

    @Override
    public ServiceType serviceType() {
        return ServiceType.QUERY;
    }

    @Override
    public NodeIdentifier target() {
        return this.target;
    }

    public String statement() {
        return this.statement;
    }

    public Authenticator credentials() {
        return this.authenticator;
    }

    @Override
    public String operationId() {
        return this.contextId;
    }

    @Override
    public boolean idempotent() {
        return this.idempotent;
    }

    @Override
    public String bucket() {
        return this.bucket;
    }

    public String scope() {
        return this.scope;
    }

    @Override
    public Map<String, Object> serviceContext() {
        TreeMap<String, Object> ctx = new TreeMap<String, Object>();
        ctx.put("type", this.serviceType().ident());
        ctx.put("operationId", RedactableArgument.redactMeta(this.operationId()));
        ctx.put("statement", RedactableArgument.redactUser(this.statement()));
        if (this.bucket != null) {
            ctx.put("bucket", RedactableArgument.redactMeta(this.bucket));
        }
        if (this.scope != null) {
            ctx.put("scope", RedactableArgument.redactMeta(this.scope));
        }
        if (this.target != null) {
            ctx.put("target", RedactableArgument.redactSystem(this.target));
        }
        return ctx;
    }

    @Stability.Internal
    public QueryRequest toPrepareRequest(boolean autoExecute, RequestTracer requestTracer) {
        String newStatement = "PREPARE " + this.statement();
        byte[] newQuery = this.transformQuery(query -> {
            query.put("statement", newStatement);
            if (autoExecute) {
                query.put("auto_execute", true);
            } else {
                query.retain("statement", "timeout", "client_context_id", "query_context");
            }
        });
        RequestSpan newSpan = requestTracer.requestSpan("prepare", this.requestSpan());
        boolean newIdempotent = !autoExecute || this.idempotent();
        return this.copy(newStatement, newQuery, newIdempotent, newSpan);
    }

    @Stability.Internal
    public QueryRequest toExecuteRequest(String preparedStatementName, String encodedPlan, RequestTracer requestTracer) {
        byte[] newQuery = this.transformQuery(query -> {
            query.remove("statement");
            query.put("prepared", preparedStatementName);
            if (encodedPlan != null) {
                query.put("encoded_plan", encodedPlan);
            }
        });
        RequestSpan newSpan = requestTracer.requestSpan("execute", this.requestSpan());
        return this.copy(this.statement(), newQuery, this.idempotent(), newSpan);
    }

    private QueryRequest copy(String newStatement, byte[] newQuery, boolean newIdempotent, RequestSpan newSpan) {
        return new QueryRequest(this.timeout(), this.context(), this.retryStrategy(), this.credentials(), newStatement, newQuery, newIdempotent, this.operationId(), newSpan, this.bucket(), this.scope(), this.target());
    }

    private byte[] transformQuery(Consumer<ObjectNode> editor) {
        return QueryRequest.editObject(this.query, editor);
    }

    private static byte[] editObject(byte[] jsonObject, Consumer<ObjectNode> editor) {
        ObjectNode node = (ObjectNode)Mapper.decodeIntoTree(jsonObject);
        editor.accept(node);
        return Mapper.encodeAsBytes(node);
    }

    public String toString() {
        return "QueryRequest{query=" + RedactableArgument.redactUser(new String(this.query, StandardCharsets.UTF_8)) + ", statement='" + RedactableArgument.redactUser(this.statement) + '\'' + ", idempotent=" + this.idempotent + ", contextId='" + this.contextId + '\'' + ", bucket='" + RedactableArgument.redactMeta(this.bucket) + '\'' + ", scope='" + RedactableArgument.redactMeta(this.scope) + '\'' + '}';
    }

    @Override
    public String name() {
        return "query";
    }
}

