/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.api.kv.CoreStoreSemantics;
import com.couchbase.client.core.api.kv.CoreSubdocMutateCommand;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.config.BucketCapabilities;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.deps.io.netty.buffer.ByteBufAllocator;
import com.couchbase.client.core.deps.io.netty.buffer.CompositeByteBuf;
import com.couchbase.client.core.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.context.ErrorContext;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.error.context.SubDocumentErrorContext;
import com.couchbase.client.core.error.subdoc.DocumentAlreadyAliveException;
import com.couchbase.client.core.error.subdoc.DocumentNotJsonException;
import com.couchbase.client.core.error.subdoc.DocumentTooDeepException;
import com.couchbase.client.core.error.subdoc.XattrInvalidKeyComboException;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.io.netty.kv.KeyValueChannelContext;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.BaseKeyValueRequest;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubDocumentOpResponseStatus;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.msg.kv.SubdocMutateResponse;
import com.couchbase.client.core.msg.kv.SyncDurabilityRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.util.Bytes;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class SubdocMutateRequest
extends BaseKeyValueRequest<SubdocMutateResponse>
implements SyncDurabilityRequest {
    private static final byte SUBDOC_FLAG_XATTR_PATH = 4;
    private static final byte SUBDOC_FLAG_CREATE_PATH = 1;
    private static final byte SUBDOC_FLAG_EXPAND_MACRO = 16;
    private static final byte SUBDOC_DOC_FLAG_MKDOC = 1;
    private static final byte SUBDOC_DOC_FLAG_ADD = 2;
    public static final byte SUBDOC_DOC_FLAG_ACCESS_DELETED = 4;
    public static final byte SUBDOC_DOC_FLAG_CREATE_AS_DELETED = 8;
    private static final byte SUBDOC_DOC_FLAG_REVIVE = 16;
    public static final int SUBDOC_MAX_FIELDS = 16;
    private static final Comparator<Command> xattrsFirst = Comparator.comparing(it -> !it.xattr());
    private final byte flags;
    private final long expiration;
    private final boolean preserveExpiry;
    private final long cas;
    private final List<Command> commands;
    private final String origKey;
    private final Optional<DurabilityLevel> syncReplicationType;
    private final boolean createAsDeleted;
    private final boolean insertDocument;

    public SubdocMutateRequest(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, @Nullable BucketConfig bucketConfig, RetryStrategy retryStrategy, String key, CoreStoreSemantics storeSemantics, boolean accessDeleted, boolean createAsDeleted, List<CoreSubdocMutateCommand> commands, long expiration, boolean preserveExpiry, long cas, Optional<DurabilityLevel> syncReplicationType, RequestSpan span) {
        this(timeout, ctx, collectionIdentifier, bucketConfig, retryStrategy, key, storeSemantics == CoreStoreSemantics.INSERT, storeSemantics == CoreStoreSemantics.UPSERT, storeSemantics == CoreStoreSemantics.REVIVE, accessDeleted, createAsDeleted, SubdocMutateRequest.convertCommands(commands), expiration, preserveExpiry, cas, syncReplicationType, span);
    }

    private static List<Command> convertCommands(List<CoreSubdocMutateCommand> commands) {
        ArrayList<Command> result = new ArrayList<Command>(commands.size());
        int len = commands.size();
        for (int i = 0; i < len; ++i) {
            CoreSubdocMutateCommand core = commands.get(i);
            result.add(new Command(core.type(), core.path(), core.fragment(), core.createParent(), core.xattr(), core.expandMacro(), i));
        }
        result.sort(xattrsFirst);
        return result;
    }

    @Deprecated
    public SubdocMutateRequest(Duration timeout, CoreContext ctx, CollectionIdentifier collectionIdentifier, @Nullable BucketConfig bucketConfig, RetryStrategy retryStrategy, String key, boolean insertDocument, boolean upsertDocument, boolean reviveDocument, boolean accessDeleted, boolean createAsDeleted, List<Command> commands, long expiration, boolean preserveExpiry, long cas, Optional<DurabilityLevel> syncReplicationType, RequestSpan span) {
        super(timeout, ctx, retryStrategy, key, collectionIdentifier, span);
        this.insertDocument = insertDocument;
        byte flags = 0;
        if (bucketConfig != null) {
            if (createAsDeleted && !bucketConfig.bucketCapabilities().contains((Object)BucketCapabilities.CREATE_AS_DELETED)) {
                throw new FeatureNotAvailableException("Cannot use createAsDeleted Sub-Document flag, as it is not supported by this version of the cluster");
            }
            if (reviveDocument && !bucketConfig.bucketCapabilities().contains((Object)BucketCapabilities.SUBDOC_REVIVE_DOCUMENT)) {
                throw new FeatureNotAvailableException("Cannot use ReviveDocument Sub-Document flag, as it is not supported by this version of the cluster");
            }
        }
        if (insertDocument && upsertDocument) {
            throw InvalidArgumentException.fromMessage("Cannot both insert and upsert full document");
        }
        if (cas != 0L && (insertDocument || upsertDocument)) {
            throw InvalidArgumentException.fromMessage("A cas value can only be applied to \"replace\" store semantics.");
        }
        if (preserveExpiry) {
            if (insertDocument) {
                throw InvalidArgumentException.fromMessage("When using 'insert' store semantics, must not specify `preserveExpiry`.");
            }
            if (!upsertDocument && expiration != 0L) {
                throw InvalidArgumentException.fromMessage("When using 'replace' store semantics (the default), must not specify both `expiry` and `preserveExpiry`.");
            }
        }
        if (upsertDocument) {
            flags = (byte)(flags | 1);
        }
        if (insertDocument) {
            flags = (byte)(flags | 2);
        }
        if (reviveDocument) {
            flags = (byte)(flags | 0x10);
        }
        if (accessDeleted) {
            flags = (byte)(flags | 4);
        }
        if (createAsDeleted) {
            flags = (byte)(flags | 8);
        }
        this.flags = flags;
        this.commands = commands;
        this.expiration = expiration;
        this.preserveExpiry = preserveExpiry;
        this.cas = cas;
        this.origKey = key;
        this.syncReplicationType = syncReplicationType;
        this.createAsDeleted = createAsDeleted;
        if (span != null) {
            span.attribute("db.operation", "mutate_in");
            this.applyLevelOnSpan(syncReplicationType, span);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf encode(ByteBufAllocator alloc, int opaque, KeyValueChannelContext ctx) {
        ByteBuf byteBuf;
        ByteBuf key = null;
        ByteBuf extras = null;
        ByteBuf content = null;
        ByteBuf flexibleExtras = MemcacheProtocol.mutationFlexibleExtras(this, ctx, alloc, this.syncReplicationType, this.preserveExpiry);
        try {
            if (this.createAsDeleted && !ctx.createAsDeleted()) {
                throw new FeatureNotAvailableException("Cannot use createAsDeleted Sub-Document flag, as it is not supported by this version of the cluster");
            }
            key = this.encodedKeyWithCollection(alloc, ctx);
            extras = alloc.buffer();
            if (this.expiration != 0L) {
                extras.writeInt((int)this.expiration);
            }
            if (this.flags != 0) {
                extras.writeByte(this.flags);
            }
            if (this.commands.size() == 1) {
                content = this.commands.get(0).encode(alloc);
            } else {
                content = alloc.compositeBuffer(this.commands.size());
                for (Command command : this.commands) {
                    ByteBuf commandBuffer = command.encode(alloc);
                    try {
                        ((CompositeByteBuf)content).addComponent(commandBuffer);
                        content.writerIndex(content.writerIndex() + commandBuffer.readableBytes());
                    }
                    catch (Exception ex) {
                        ReferenceCountUtil.release(commandBuffer);
                        throw ex;
                    }
                }
            }
            byteBuf = MemcacheProtocol.flexibleRequest(alloc, MemcacheProtocol.Opcode.SUBDOC_MULTI_MUTATE, MemcacheProtocol.noDatatype(), this.partition(), opaque, this.cas, flexibleExtras, extras, key, content);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(key);
            ReferenceCountUtil.release(extras);
            ReferenceCountUtil.release(flexibleExtras);
            ReferenceCountUtil.release(content);
            throw throwable;
        }
        ReferenceCountUtil.release(key);
        ReferenceCountUtil.release(extras);
        ReferenceCountUtil.release(flexibleExtras);
        ReferenceCountUtil.release(content);
        return byteBuf;
    }

    @Override
    public SubdocMutateResponse decode(ByteBuf response, KeyValueChannelContext ctx) {
        SubDocumentErrorContext e;
        Optional<ByteBuf> maybeBody = MemcacheProtocol.body(response);
        short rawOverallStatus = MemcacheProtocol.status(response);
        ResponseStatus overallStatus = MemcacheProtocol.decodeStatus(response);
        Optional<Object> error = Optional.empty();
        MemcacheProtocol.FlexibleExtras flexibleExtras = MemcacheProtocol.flexibleExtras(response);
        SubDocumentField[] values = null;
        if (maybeBody.isPresent()) {
            ByteBuf body = maybeBody.get();
            if (rawOverallStatus == MemcacheProtocol.Status.SUBDOC_MULTI_PATH_FAILURE.status() || rawOverallStatus == MemcacheProtocol.Status.SUBDOC_MULTI_PATH_FAILURE_DELETED.status()) {
                byte index = body.readByte();
                short opStatusRaw = body.readShort();
                SubDocumentOpResponseStatus opStatus = MemcacheProtocol.decodeSubDocumentStatus(opStatusRaw);
                Command c = this.commands.get(index);
                error = Optional.of(MemcacheProtocol.mapSubDocumentError(this, opStatus, c.path, c.originalIndex, flexibleExtras));
                values = new SubDocumentField[]{};
            } else if (overallStatus.success()) {
                values = new SubDocumentField[this.commands.size()];
                int INDEX_PLUS_STATUS_FIELDS_BYTES = 3;
                while (body.isReadable(INDEX_PLUS_STATUS_FIELDS_BYTES)) {
                    SubDocumentField op;
                    byte index = body.readByte();
                    Command command = this.commands.get(index);
                    short statusRaw = body.readShort();
                    SubDocumentOpResponseStatus status = MemcacheProtocol.decodeSubDocumentStatus(statusRaw);
                    if (status != SubDocumentOpResponseStatus.SUCCESS) {
                        SubDocumentField op2;
                        CouchbaseException err = MemcacheProtocol.mapSubDocumentError(this, status, command.path, command.originalIndex, flexibleExtras);
                        values[((Command)command).originalIndex] = op2 = new SubDocumentField(status, Optional.of(err), Bytes.EMPTY_BYTE_ARRAY, command.path, command.type);
                        continue;
                    }
                    int valueLength = body.readInt();
                    byte[] value = new byte[valueLength];
                    body.readBytes(value, 0, valueLength);
                    values[((Command)command).originalIndex] = op = new SubDocumentField(status, Optional.empty(), value, command.path, command.type);
                }
            }
        }
        if (values == null) {
            values = new SubDocumentField[]{};
        }
        if (rawOverallStatus == MemcacheProtocol.Status.SUBDOC_DOC_NOT_JSON.status()) {
            e = this.createSubDocumentExceptionContext(SubDocumentOpResponseStatus.DOC_NOT_JSON, flexibleExtras);
            error = Optional.of(new DocumentNotJsonException(e));
        } else if (rawOverallStatus == MemcacheProtocol.Status.SUBDOC_DOC_TOO_DEEP.status()) {
            e = this.createSubDocumentExceptionContext(SubDocumentOpResponseStatus.DOC_TOO_DEEP, flexibleExtras);
            error = Optional.of(new DocumentTooDeepException(e));
        } else if (rawOverallStatus == MemcacheProtocol.Status.SUBDOC_XATTR_INVALID_KEY_COMBO.status()) {
            e = this.createSubDocumentExceptionContext(SubDocumentOpResponseStatus.XATTR_INVALID_KEY_COMBO, flexibleExtras);
            error = Optional.of(new XattrInvalidKeyComboException(e));
        } else if (rawOverallStatus == MemcacheProtocol.Status.SUBDOC_CAN_ONLY_REVIVE_DELETED_DOCUMENTS.status()) {
            e = this.createSubDocumentExceptionContext(SubDocumentOpResponseStatus.CAN_ONLY_REVIVE_DELETED_DOCUMENTS, flexibleExtras);
            error = Optional.of(new DocumentAlreadyAliveException(e));
        }
        return new SubdocMutateResponse(overallStatus, error, values, MemcacheProtocol.cas(response), MemcacheProtocol.extractToken(ctx.mutationTokensEnabled(), this.partition(), response, ctx.bucket().get()), flexibleExtras);
    }

    private SubDocumentErrorContext createSubDocumentExceptionContext(SubDocumentOpResponseStatus status, @Nullable MemcacheProtocol.FlexibleExtras flexibleExtras) {
        return new SubDocumentErrorContext(KeyValueErrorContext.completedRequest(this, ResponseStatus.SUBDOC_FAILURE, flexibleExtras), 0, null, status);
    }

    public static InvalidArgumentException errIfNoCommands(ErrorContext errorContext) {
        return new InvalidArgumentException("At least one sub-document operation must be provided.", null, errorContext);
    }

    public static InvalidArgumentException errIfTooManyCommands(ErrorContext errorContext) {
        return new InvalidArgumentException("A maximum of 16 sub-document operations can be provided.", null, errorContext);
    }

    public boolean insertDocument() {
        return this.insertDocument;
    }

    @Override
    public Optional<DurabilityLevel> durabilityLevel() {
        return this.syncReplicationType;
    }

    @Override
    public String name() {
        return "mutate_in";
    }

    public static class Command {
        private static final byte[] EMPTY_ARRAY = new byte[0];
        private final SubdocCommandType type;
        private final String path;
        @Nullable
        private final byte[] fragment;
        private final boolean createParent;
        private final boolean xattr;
        private final boolean expandMacro;
        private final int originalIndex;

        public Command(SubdocCommandType type, String path, @Nullable byte[] fragment, boolean createParent, boolean xattr, boolean expandMacro, int originalIndex) {
            this.type = type;
            this.path = path;
            this.xattr = xattr;
            this.fragment = fragment == null ? EMPTY_ARRAY : fragment;
            this.createParent = createParent;
            this.expandMacro = expandMacro;
            this.originalIndex = originalIndex;
        }

        public ByteBuf encode(ByteBufAllocator alloc) {
            byte[] path = this.path.getBytes(StandardCharsets.UTF_8);
            int pathLength = path.length;
            ByteBuf buffer = alloc.buffer(8 + pathLength + this.fragment.length);
            buffer.writeByte(this.type.opcode());
            int flags = 0;
            if (this.xattr) {
                flags = (byte)(flags | 4);
            }
            if (this.createParent) {
                flags = (byte)(flags | 1);
            }
            if (this.expandMacro) {
                flags = (byte)(flags | 0x10);
            }
            buffer.writeByte(flags);
            buffer.writeShort(pathLength);
            buffer.writeInt(this.fragment.length);
            buffer.writeBytes(path);
            buffer.writeBytes(this.fragment);
            return buffer;
        }

        public int originalIndex() {
            return this.originalIndex;
        }

        public boolean xattr() {
            return this.xattr;
        }
    }
}

