/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.http;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.netty.HttpChannelContext;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.BaseResponse;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.msg.ResponseStatus;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

@Stability.Internal
public class CoreHttpResponse
extends BaseResponse {
    private final int httpStatus;
    private final byte[] content;
    private final HttpChannelContext channelContext;
    private final RequestContext requestContext;

    public CoreHttpResponse(ResponseStatus status, byte[] content, int httpStatus, HttpChannelContext channelContext, RequestContext requestContext) {
        super(Objects.requireNonNull(status));
        this.httpStatus = httpStatus;
        this.content = Objects.requireNonNull(content);
        this.channelContext = Objects.requireNonNull(channelContext);
        this.requestContext = Objects.requireNonNull(requestContext);
    }

    public int httpStatus() {
        return this.httpStatus;
    }

    public byte[] content() {
        return this.content;
    }

    public HttpChannelContext channelContext() {
        return this.channelContext;
    }

    public String channelId() {
        return this.channelContext.channelId().asShortText();
    }

    public RequestContext requestContext() {
        return this.requestContext;
    }

    @Override
    public String toString() {
        return "CoreHttpResponse{status=" + (Object)((Object)this.status()) + ", httpStatus=" + this.httpStatus + ", content=" + RedactableArgument.redactUser(new String(this.content, StandardCharsets.UTF_8)) + '}';
    }
}

