/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.endpoint.ProtostellarEndpoint;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stability.Internal
public class ProtostellarPool {
    private final Logger logger = LoggerFactory.getLogger(ProtostellarPool.class);
    private final List<ProtostellarEndpoint> endpoints;
    private final AtomicLong lastUsed = new AtomicLong(0L);

    public ProtostellarPool(Core core, String hostname, int port) {
        int numEndpoints = Integer.parseInt(System.getProperty("com.couchbase.protostellar.numEndpoints", "3"));
        this.logger.info("creating with endpoints {}", (Object)numEndpoints);
        this.endpoints = new ArrayList<ProtostellarEndpoint>(numEndpoints);
        for (int i = 0; i < numEndpoints; ++i) {
            this.endpoints.add(new ProtostellarEndpoint(core, hostname, port));
        }
    }

    public void shutdown(Duration timeout) {
        this.endpoints.forEach(endpoint -> endpoint.shutdown(timeout));
    }

    public ProtostellarEndpoint endpoint() {
        int index = (int)((this.lastUsed.getAndIncrement() & Long.MAX_VALUE) % (long)this.endpoints.size());
        return this.endpoints.get(index);
    }

    public List<ProtostellarEndpoint> endpoints() {
        return Collections.unmodifiableList(this.endpoints);
    }
}

