/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.events.endpoint.EndpointStateChangedEvent;
import com.couchbase.client.core.deps.io.grpc.Attributes;
import com.couchbase.client.core.deps.io.grpc.CallCredentials;
import com.couchbase.client.core.deps.io.grpc.CallOptions;
import com.couchbase.client.core.deps.io.grpc.Channel;
import com.couchbase.client.core.deps.io.grpc.ClientCall;
import com.couchbase.client.core.deps.io.grpc.ClientInterceptor;
import com.couchbase.client.core.deps.io.grpc.ClientStreamTracer;
import com.couchbase.client.core.deps.io.grpc.ConnectivityState;
import com.couchbase.client.core.deps.io.grpc.EquivalentAddressGroup;
import com.couchbase.client.core.deps.io.grpc.InsecureChannelCredentials;
import com.couchbase.client.core.deps.io.grpc.ManagedChannel;
import com.couchbase.client.core.deps.io.grpc.ManagedChannelBuilder;
import com.couchbase.client.core.deps.io.grpc.Metadata;
import com.couchbase.client.core.deps.io.grpc.MethodDescriptor;
import com.couchbase.client.core.deps.io.grpc.Status;
import com.couchbase.client.core.deps.io.grpc.netty.NettyChannelBuilder;
import com.couchbase.client.core.deps.io.netty.channel.ChannelOption;
import com.couchbase.client.core.diagnostics.EndpointDiagnostics;
import com.couchbase.client.core.endpoint.CircuitBreaker;
import com.couchbase.client.core.endpoint.EndpointContext;
import com.couchbase.client.core.endpoint.EndpointState;
import com.couchbase.client.core.endpoint.MultiAddressNameResolverFactory;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.error.context.CancellationErrorContext;
import com.couchbase.client.core.protostellar.ProtostellarStatsCollector;
import com.couchbase.client.core.util.Deadline;
import com.couchbase.client.core.util.HostAndPort;
import com.couchbase.client.protostellar.admin.collection.v1.CollectionAdminGrpc;
import com.couchbase.client.protostellar.analytics.v1.AnalyticsGrpc;
import com.couchbase.client.protostellar.internal.hooks.v1.HooksGrpc;
import com.couchbase.client.protostellar.kv.v1.KvGrpc;
import com.couchbase.client.protostellar.query.v1.QueryGrpc;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtostellarEndpoint {
    private final Logger logger = LoggerFactory.getLogger(ProtostellarEndpoint.class);
    public static ProtostellarStatsCollector collector;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private final ManagedChannel managedChannel;
    private final KvGrpc.KvFutureStub kvStub;
    private final KvGrpc.KvBlockingStub kvBlockingStub;
    private final AnalyticsGrpc.AnalyticsStub analyticsStub;
    private final QueryGrpc.QueryStub queryStub;
    private final HooksGrpc.HooksBlockingStub hooksBlockingStub;
    private final CollectionAdminGrpc.CollectionAdminFutureStub collectionAdminStub;
    private final String hostname;
    private final int port;
    private final Core core;

    public ProtostellarEndpoint(final Core core, String hostname, int port) {
        String override = System.getProperty("com.couchbase.protostellar.overrideHostname");
        this.logger.info("creating {} {}, override={}", new Object[]{hostname, port, override});
        if (override != null) {
            hostname = override;
        }
        this.hostname = hostname;
        this.port = port;
        this.core = core;
        this.managedChannel = this.channel();
        ConnectivityState now = this.managedChannel.getState(false);
        this.logger.info("channel starts in state {}/{}", (Object)now, (Object)ProtostellarEndpoint.convert(now));
        this.notifyOnChannelStateChange(now);
        CallCredentials creds = new CallCredentials(){

            @Override
            public void applyRequestMetadata(CallCredentials.RequestInfo requestInfo, Executor executor, CallCredentials.MetadataApplier applier) {
                executor.execute(() -> {
                    try {
                        Metadata headers = new Metadata();
                        core.context().authenticator().authProtostellarRequest(headers);
                        applier.apply(headers);
                    }
                    catch (Throwable e) {
                        applier.fail(Status.UNAUTHENTICATED.withCause(e));
                    }
                });
            }

            @Override
            public void thisUsesUnstableApi() {
            }
        };
        final ClientStreamTracer.Factory factory = new ClientStreamTracer.Factory(){

            @Override
            public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
                return new ClientStreamTracer(){

                    @Override
                    public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
                        super.outboundMessageSent(seqNo, optionalWireSize, optionalUncompressedSize);
                        if (collector != null) {
                            collector.outboundMessageSent();
                        }
                    }

                    @Override
                    public void outboundMessage(int seqNo) {
                        super.outboundMessage(seqNo);
                        if (collector != null) {
                            collector.outboundMessage();
                        }
                    }

                    @Override
                    public void inboundMessage(int seqNo) {
                        super.inboundMessage(seqNo);
                        if (collector != null) {
                            collector.inboundMessage();
                        }
                    }

                    @Override
                    public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
                        super.inboundMessageRead(seqNo, optionalWireSize, optionalUncompressedSize);
                        if (collector != null) {
                            collector.inboundMessageRead();
                        }
                    }

                    @Override
                    public void streamCreated(Attributes transportAttrs, Metadata headers) {
                        super.streamCreated(transportAttrs, headers);
                    }

                    @Override
                    public void streamClosed(Status status) {
                        super.streamClosed(status);
                    }
                };
            }
        };
        ClientInterceptor ci = new ClientInterceptor(){

            @Override
            public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
                return next.newCall(method, callOptions.withStreamTracerFactory(factory));
            }
        };
        this.kvStub = (KvGrpc.KvFutureStub)KvGrpc.newFutureStub(this.managedChannel).withInterceptors(ci);
        this.kvBlockingStub = (KvGrpc.KvBlockingStub)KvGrpc.newBlockingStub(this.managedChannel).withInterceptors(ci);
        this.analyticsStub = (AnalyticsGrpc.AnalyticsStub)AnalyticsGrpc.newStub(this.managedChannel).withCallCredentials(creds);
        this.queryStub = (QueryGrpc.QueryStub)QueryGrpc.newStub(this.managedChannel).withCallCredentials(creds);
        this.hooksBlockingStub = (HooksGrpc.HooksBlockingStub)HooksGrpc.newBlockingStub(this.managedChannel).withCallCredentials(creds);
        this.collectionAdminStub = (CollectionAdminGrpc.CollectionAdminFutureStub)CollectionAdminGrpc.newFutureStub(this.managedChannel).withCallCredentials(creds);
    }

    private ManagedChannel channel() {
        this.logger.info("making channel {} {}", (Object)this.hostname, (Object)this.port);
        ManagedChannelBuilder builder = ((NettyChannelBuilder)NettyChannelBuilder.forAddress(this.hostname, this.port, InsecureChannelCredentials.create()).maxInboundMessageSize(0x1500000).executor(this.core.context().environment().executor())).withOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, (int)this.core.context().environment().timeoutConfig().connectTimeout().toMillis()).disableRetry();
        String loadBalancingCount = System.getProperty("com.couchbase.protostellar.loadBalancing");
        String loadBalancingStrategy = System.getProperty("com.couchbase.protostellar.loadBalancingStrategy", "round_robin");
        String loadBalancingSingle = System.getProperty("com.couchbase.protostellar.loadBalancingSingle", "true");
        this.logger.info("loadBalancing={} loadBalancingStrategy={} loadBalancingSingle={}", new Object[]{loadBalancingCount, loadBalancingStrategy, loadBalancingSingle});
        if (loadBalancingCount != null) {
            ArrayList<EquivalentAddressGroup> addresses = new ArrayList<EquivalentAddressGroup>();
            int count = Integer.parseInt(loadBalancingCount);
            boolean single = Boolean.parseBoolean(loadBalancingSingle);
            if (single) {
                ArrayList<SocketAddress> adds = new ArrayList<SocketAddress>();
                for (int i = 0; i < count; ++i) {
                    adds.add(new InetSocketAddress(this.hostname, this.port));
                }
                addresses.add(new EquivalentAddressGroup(adds));
            } else {
                for (int i = 0; i < count; ++i) {
                    addresses.add(new EquivalentAddressGroup(new InetSocketAddress(this.hostname, this.port)));
                }
            }
            MultiAddressNameResolverFactory nameResolverFactory = new MultiAddressNameResolverFactory(addresses);
            ((ManagedChannelBuilder)builder.nameResolverFactory(nameResolverFactory)).defaultLoadBalancingPolicy(loadBalancingStrategy);
        }
        return builder.build();
    }

    private void notifyOnChannelStateChange(ConnectivityState current) {
        this.managedChannel.notifyWhenStateChanged(current, () -> {
            ConnectivityState now = this.managedChannel.getState(false);
            this.logger.info("channel has changed state from {}/{} to {}/{}", new Object[]{current, ProtostellarEndpoint.convert(current), now, ProtostellarEndpoint.convert(now)});
            EndpointContext ec = new EndpointContext(this.core.context(), new HostAndPort(this.hostname, this.port), null, null, Optional.empty(), Optional.empty(), Optional.empty());
            this.core.context().environment().eventBus().publish(new EndpointStateChangedEvent(ec, ProtostellarEndpoint.convert(current), ProtostellarEndpoint.convert(now)));
            this.notifyOnChannelStateChange(now);
        });
    }

    private static EndpointState convert(ConnectivityState state) {
        switch (state) {
            case IDLE: {
                return EndpointState.DISCONNECTED;
            }
            case READY: {
                return EndpointState.CONNECTED;
            }
            case SHUTDOWN: {
                return EndpointState.DISCONNECTING;
            }
            case TRANSIENT_FAILURE: 
            case CONNECTING: {
                return EndpointState.CONNECTING;
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)state));
    }

    public EndpointDiagnostics diagnostics() {
        return new EndpointDiagnostics(null, ProtostellarEndpoint.convert(this.managedChannel.getState(false)), CircuitBreaker.State.CLOSED, null, this.hostname, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public synchronized void shutdown(Duration timeout) {
        if (this.shutdown.compareAndSet(false, true)) {
            this.logger.info("waiting for channel to shutdown");
            this.managedChannel.shutdown();
            try {
                this.managedChannel.awaitTermination(timeout.toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.logger.info("channel has shutdown");
        }
    }

    public KvGrpc.KvFutureStub kvStub() {
        return this.kvStub;
    }

    public KvGrpc.KvBlockingStub kvBlockingStub() {
        return this.kvBlockingStub;
    }

    public AnalyticsGrpc.AnalyticsStub analyticsStub() {
        return this.analyticsStub;
    }

    public QueryGrpc.QueryStub queryStub() {
        return this.queryStub;
    }

    public HooksGrpc.HooksBlockingStub hooksBlockingStub() {
        return this.hooksBlockingStub;
    }

    public CollectionAdminGrpc.CollectionAdminFutureStub collectionAdminStub() {
        return this.collectionAdminStub;
    }

    public synchronized boolean isShutdown() {
        return this.shutdown.get();
    }

    public String hostname() {
        return this.hostname;
    }

    public int port() {
        return this.port;
    }

    @Stability.Internal
    public CompletableFuture<Void> waitUntilReady(Deadline deadline, boolean waitingForReady) {
        CompletableFuture<Void> onDone = new CompletableFuture<Void>();
        ConnectivityState current = this.managedChannel.getState(true);
        this.logger.debug("WaitUntilReady: Endpoint {}:{} starts in state {}", new Object[]{this.hostname, this.port, current});
        this.notify(current, onDone, deadline, waitingForReady);
        return onDone;
    }

    private void notify(ConnectivityState current, CompletableFuture<Void> onDone, Deadline deadline, boolean waitingForReady) {
        if (this.inDesiredState(current, waitingForReady)) {
            onDone.complete(null);
        } else {
            this.managedChannel.notifyWhenStateChanged(current, () -> {
                ConnectivityState now = this.managedChannel.getState(true);
                this.logger.debug("WaitUntilReady: Endpoint {}:{} is now in state {}", new Object[]{this.hostname, this.port, now});
                if (this.inDesiredState(current, waitingForReady)) {
                    onDone.complete(null);
                } else if (deadline.exceeded()) {
                    onDone.completeExceptionally(new UnambiguousTimeoutException("Timed out while waiting for Protostellar endpoint " + this.hostname + ":" + this.port, new CancellationErrorContext(null)));
                } else {
                    this.notify(now, onDone, deadline, waitingForReady);
                }
            });
        }
    }

    private boolean inDesiredState(ConnectivityState current, boolean waitingForReady) {
        return waitingForReady && current == ConnectivityState.READY || !waitingForReady && current != ConnectivityState.READY;
    }
}

