/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.com.google.common.io;

import com.couchbase.client.core.deps.com.google.common.annotations.Beta;
import com.couchbase.client.core.deps.com.google.common.annotations.GwtIncompatible;
import com.couchbase.client.core.deps.com.google.common.base.Preconditions;
import com.couchbase.client.core.deps.com.google.common.io.ElementTypesAreNonnullByDefault;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    @Override
    public boolean accept(File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

