/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.com.google.common.collect;

import com.couchbase.client.core.deps.com.google.common.annotations.GwtCompatible;
import com.couchbase.client.core.deps.com.google.common.annotations.GwtIncompatible;
import com.couchbase.client.core.deps.com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.couchbase.client.core.deps.com.google.common.collect.ImmutableMap;
import com.couchbase.client.core.deps.com.google.common.collect.ImmutableSet;
import com.couchbase.client.core.deps.com.google.common.collect.IndexedImmutableSet;
import com.couchbase.client.core.deps.com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class ImmutableMapKeySet<K, V>
extends IndexedImmutableSet<K> {
    private final ImmutableMap<K, V> map;

    ImmutableMapKeySet(ImmutableMap<K, V> map) {
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public UnmodifiableIterator<K> iterator() {
        return this.map.keyIterator();
    }

    @Override
    public boolean contains(@CheckForNull Object object) {
        return this.map.containsKey(object);
    }

    @Override
    K get(int index) {
        return ((Map.Entry)((ImmutableSet)this.map.entrySet()).asList().get(index)).getKey();
    }

    @Override
    boolean isPartialView() {
        return true;
    }

    @Override
    @GwtIncompatible
    Object writeReplace() {
        return new KeySetSerializedForm<K>(this.map);
    }

    @GwtIncompatible
    private static class KeySetSerializedForm<K>
    implements Serializable {
        final ImmutableMap<K, ?> map;
        private static final long serialVersionUID = 0L;

        KeySetSerializedForm(ImmutableMap<K, ?> map) {
            this.map = map;
        }

        Object readResolve() {
            return this.map.keySet();
        }
    }
}

