/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.classic.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.query.CoreQueryMetaData;
import com.couchbase.client.core.api.query.CoreQueryMetrics;
import com.couchbase.client.core.api.query.CoreQueryStatus;
import com.couchbase.client.core.api.query.CoreQueryWarning;
import com.couchbase.client.core.classic.query.ClassicCoreQueryMetrics;
import com.couchbase.client.core.error.ErrorCodeAndMessage;
import com.couchbase.client.core.msg.query.QueryChunkHeader;
import com.couchbase.client.core.msg.query.QueryChunkTrailer;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Stability.Internal
public class ClassicCoreQueryMetaData
extends CoreQueryMetaData {
    private final QueryChunkHeader header;
    private final QueryChunkTrailer trailer;

    @Stability.Internal
    private ClassicCoreQueryMetaData(QueryChunkHeader header, QueryChunkTrailer trailer) {
        this.header = header;
        this.trailer = trailer;
    }

    @Stability.Internal
    public static ClassicCoreQueryMetaData from(QueryChunkHeader header, QueryChunkTrailer trailer) {
        return new ClassicCoreQueryMetaData(header, trailer);
    }

    @Override
    public String requestId() {
        return this.header.requestId();
    }

    @Override
    public String clientContextId() {
        return this.header.clientContextId().orElse("");
    }

    @Override
    public CoreQueryStatus status() {
        return CoreQueryStatus.from(this.trailer.status());
    }

    @Override
    public Optional<byte[]> signature() {
        return this.header.signature();
    }

    @Override
    public Optional<byte[]> profile() {
        return this.trailer.profile();
    }

    @Override
    public Optional<CoreQueryMetrics> metrics() {
        return this.trailer.metrics().map(ClassicCoreQueryMetrics::new);
    }

    @Override
    public List<CoreQueryWarning> warnings() {
        return this.trailer.warnings().map(warnings -> ErrorCodeAndMessage.fromJsonArray(warnings).stream().map(CoreQueryWarning::new).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public String toString() {
        return "CoreQueryMetaDataClassic{header=" + this.header + ", trailer=" + this.trailer + '}';
    }
}

