/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import java.util.OptionalInt;
import java.util.OptionalLong;
import reactor.util.annotation.Nullable;

@Stability.Internal
public final class CoreKvResponseMetadata {
    private final OptionalInt readUnits;
    private final OptionalInt writeUnits;
    private final OptionalLong serverDuration;
    public static final CoreKvResponseMetadata NONE = new CoreKvResponseMetadata(-1, -1, -1L);

    public static CoreKvResponseMetadata from(@Nullable MemcacheProtocol.FlexibleExtras flexibleExtras) {
        return flexibleExtras == null ? NONE : new CoreKvResponseMetadata(flexibleExtras.readUnits, flexibleExtras.writeUnits, flexibleExtras.serverDuration);
    }

    public static CoreKvResponseMetadata of(int readUnits, int writeUnits, long serverDuration) {
        return serverDuration < 0L && readUnits < 0 && writeUnits < 0 ? NONE : new CoreKvResponseMetadata(readUnits, writeUnits, serverDuration);
    }

    private CoreKvResponseMetadata(int readUnits, int writeUnits, long serverDuration) {
        this.readUnits = readUnits < 0 ? OptionalInt.empty() : OptionalInt.of(readUnits);
        this.writeUnits = writeUnits < 0 ? OptionalInt.empty() : OptionalInt.of(writeUnits);
        this.serverDuration = serverDuration < 0L ? OptionalLong.empty() : OptionalLong.of(serverDuration);
    }

    public OptionalInt readUnits() {
        return this.readUnits;
    }

    public OptionalInt writeUnits() {
        return this.writeUnits;
    }

    public OptionalLong serverDuration() {
        return this.serverDuration;
    }

    public String toString() {
        return "CoreKvOpMetadata{readUnits=" + this.readUnits + ", writeUnits=" + this.writeUnits + ", serverDuration=" + this.serverDuration + '}';
    }
}

