/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.api.kv.CoreAsyncResponse;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.api.kv.CoreEncodedContent;
import com.couchbase.client.core.api.kv.CoreExistsResult;
import com.couchbase.client.core.api.kv.CoreGetResult;
import com.couchbase.client.core.api.kv.CoreMutationResult;
import com.couchbase.client.core.api.kv.CoreStoreSemantics;
import com.couchbase.client.core.api.kv.CoreSubdocMutateCommand;
import com.couchbase.client.core.api.kv.CoreSubdocMutateResult;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.kv.CoreRangeScanItem;
import com.couchbase.client.core.kv.CoreScanOptions;
import com.couchbase.client.core.kv.CoreScanType;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Stream;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Stability.Internal
public interface CoreKvOps {
    public CoreAsyncResponse<CoreGetResult> getAsync(CoreCommonOptions var1, String var2, List<String> var3, boolean var4);

    default public CoreGetResult getBlocking(CoreCommonOptions common, String key, List<String> projections, boolean withExpiry) {
        return this.getAsync(common, key, projections, withExpiry).toBlocking();
    }

    default public Mono<CoreGetResult> getReactive(CoreCommonOptions common, String key, List<String> projections, boolean withExpiry) {
        return Mono.defer(() -> this.getAsync(common, key, projections, withExpiry).toMono());
    }

    default public void checkProjectionLimits(List<String> projections, boolean withExpiry) {
        if (withExpiry) {
            if (projections.size() > 15) {
                throw InvalidArgumentException.fromMessage("Only a maximum of 16 fields can be projected per request due to a server limitation (includes the expiration macro as one field).");
            }
        } else if (projections.size() > 16) {
            throw InvalidArgumentException.fromMessage("Only a maximum of 16 fields can be projected per request due to a server limitation.");
        }
    }

    public CoreAsyncResponse<CoreGetResult> getAndLockAsync(CoreCommonOptions var1, String var2, Duration var3);

    default public CoreGetResult getAndLockBlocking(CoreCommonOptions common, String key, Duration lockTime) {
        return this.getAndLockAsync(common, key, lockTime).toBlocking();
    }

    default public Mono<CoreGetResult> getAndLockReactive(CoreCommonOptions common, String key, Duration lockTime) {
        return Mono.defer(() -> this.getAndLockAsync(common, key, lockTime).toMono());
    }

    public CoreAsyncResponse<CoreGetResult> getAndTouchAsync(CoreCommonOptions var1, String var2, long var3);

    default public CoreGetResult getAndTouchBlocking(CoreCommonOptions common, String key, long expiration) {
        return this.getAndTouchAsync(common, key, expiration).toBlocking();
    }

    default public Mono<CoreGetResult> getAndTouchReactive(CoreCommonOptions common, String key, long expiration) {
        return Mono.defer(() -> this.getAndTouchAsync(common, key, expiration).toMono());
    }

    public CoreAsyncResponse<CoreMutationResult> insertAsync(CoreCommonOptions var1, String var2, Supplier<CoreEncodedContent> var3, CoreDurability var4, long var5);

    default public CoreMutationResult insertBlocking(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, long expiry) {
        return this.insertAsync(common, key, content, durability, expiry).toBlocking();
    }

    default public Mono<CoreMutationResult> insertReactive(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, long expiry) {
        return Mono.defer(() -> this.insertAsync(common, key, content, durability, expiry).toMono());
    }

    public CoreAsyncResponse<CoreMutationResult> upsertAsync(CoreCommonOptions var1, String var2, Supplier<CoreEncodedContent> var3, CoreDurability var4, long var5, boolean var7);

    default public CoreMutationResult upsertBlocking(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, long expiry, boolean preserveExpiry) {
        return this.upsertAsync(common, key, content, durability, expiry, preserveExpiry).toBlocking();
    }

    default public Mono<CoreMutationResult> upsertReactive(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, CoreDurability durability, long expiry, boolean preserveExpiry) {
        return Mono.defer(() -> this.upsertAsync(common, key, content, durability, expiry, preserveExpiry).toMono());
    }

    public CoreAsyncResponse<CoreMutationResult> replaceAsync(CoreCommonOptions var1, String var2, Supplier<CoreEncodedContent> var3, long var4, CoreDurability var6, long var7, boolean var9);

    default public CoreMutationResult replaceBlocking(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, long cas, CoreDurability durability, long expiry, boolean preserveExpiry) {
        return this.replaceAsync(common, key, content, cas, durability, expiry, preserveExpiry).toBlocking();
    }

    default public Mono<CoreMutationResult> replaceReactive(CoreCommonOptions common, String key, Supplier<CoreEncodedContent> content, long cas, CoreDurability durability, long expiry, boolean preserveExpiry) {
        return Mono.defer(() -> this.replaceAsync(common, key, content, cas, durability, expiry, preserveExpiry).toMono());
    }

    public CoreAsyncResponse<CoreMutationResult> removeAsync(CoreCommonOptions var1, String var2, long var3, CoreDurability var5);

    default public CoreMutationResult removeBlocking(CoreCommonOptions common, String key, long cas, CoreDurability durability) {
        return this.removeAsync(common, key, cas, durability).toBlocking();
    }

    default public Mono<CoreMutationResult> removeReactive(CoreCommonOptions common, String key, long cas, CoreDurability durability) {
        return Mono.defer(() -> this.removeAsync(common, key, cas, durability).toMono());
    }

    public CoreAsyncResponse<CoreExistsResult> existsAsync(CoreCommonOptions var1, String var2);

    default public CoreExistsResult existsBlocking(CoreCommonOptions common, String key) {
        return this.existsAsync(common, key).toBlocking();
    }

    default public Mono<CoreExistsResult> existsReactive(CoreCommonOptions common, String key) {
        return Mono.defer(() -> this.existsAsync(common, key).toMono());
    }

    public CoreAsyncResponse<CoreMutationResult> touchAsync(CoreCommonOptions var1, String var2, long var3);

    default public CoreMutationResult touchBlocking(CoreCommonOptions common, String key, long expiry) {
        return this.touchAsync(common, key, expiry).toBlocking();
    }

    default public Mono<CoreMutationResult> touchReactive(CoreCommonOptions common, String key, long expiry) {
        return Mono.defer(() -> this.touchAsync(common, key, expiry).toMono());
    }

    public CoreAsyncResponse<Void> unlockAsync(CoreCommonOptions var1, String var2, long var3);

    default public void unlockBlocking(CoreCommonOptions common, String key, long cas) {
        this.unlockAsync(common, key, cas).toBlocking();
    }

    default public Mono<Void> unlockReactive(CoreCommonOptions common, String key, long cas) {
        return Mono.defer(() -> this.unlockAsync(common, key, cas).toMono());
    }

    public Flux<CoreGetResult> getAllReplicasReactive(CoreCommonOptions var1, String var2);

    public Mono<CoreGetResult> getAnyReplicaReactive(CoreCommonOptions var1, String var2);

    public CoreAsyncResponse<CoreSubdocMutateResult> subdocMutateAsync(CoreCommonOptions var1, String var2, Supplier<List<CoreSubdocMutateCommand>> var3, CoreStoreSemantics var4, long var5, CoreDurability var7, long var8, boolean var10, boolean var11, boolean var12);

    default public CoreSubdocMutateResult subdocMutateBlocking(CoreCommonOptions common, String key, Supplier<List<CoreSubdocMutateCommand>> commands, CoreStoreSemantics storeSemantics, long cas, CoreDurability durability, long expiry, boolean preserveExpiry, boolean accessDeleted, boolean createAsDeleted) {
        return this.subdocMutateAsync(common, key, commands, storeSemantics, cas, durability, expiry, preserveExpiry, accessDeleted, createAsDeleted).toBlocking();
    }

    default public Mono<CoreSubdocMutateResult> subdocMutateReactive(CoreCommonOptions common, String key, Supplier<List<CoreSubdocMutateCommand>> commands, CoreStoreSemantics storeSemantics, long cas, CoreDurability durability, long expiry, boolean preserveExpiry, boolean accessDeleted, boolean createAsDeleted) {
        return Mono.defer(() -> this.subdocMutateAsync(common, key, commands, storeSemantics, cas, durability, expiry, preserveExpiry, accessDeleted, createAsDeleted).toMono());
    }

    public Flux<CoreRangeScanItem> scanRequestReactive(CoreScanType var1, CoreScanOptions var2);

    default public CompletableFuture<List<CoreRangeScanItem>> scanRequestAsync(CoreScanType coreScanType, CoreScanOptions coreScanOptions) {
        return this.scanRequestReactive(coreScanType, coreScanOptions).collectList().toFuture();
    }

    default public Stream<CoreRangeScanItem> scanRequestBlocking(CoreScanType coreScanType, CoreScanOptions coreScanOptions) {
        return this.scanRequestReactive(coreScanType, coreScanOptions).toStream();
    }
}

