/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.api.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreKeyspace;
import com.couchbase.client.core.api.kv.CoreDurability;
import com.couchbase.client.core.endpoint.http.CoreCommonOptions;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.util.Validators;
import java.util.Optional;
import java.util.function.Supplier;

public class CoreKvBinaryParamValidators {
    public static void validateAppendPrependArgs(Core core, String key, CoreKeyspace keyspace, CoreCommonOptions options, byte[] content, long cas, CoreDurability durability) {
        Supplier<Object> supplier = () -> ReducedKeyValueErrorContext.create(key, keyspace.toCollectionIdentifier());
        Validators.notNull(core, "core", supplier);
        Validators.notNullOrEmpty(key, "Id", supplier);
        Validators.notNull(keyspace, "Keyspace", supplier);
        Validators.notNull(options, "Options", supplier);
        Validators.notNull(content, "Content", supplier);
        Validators.notNull(durability, "Durability", supplier);
    }

    public static void validateIncrementDecrementArgs(Core core, String key, CoreKeyspace keyspace, CoreCommonOptions options, long expiry, long delta, Optional<Long> initial, CoreDurability durability) {
        Supplier<Object> supplier = () -> ReducedKeyValueErrorContext.create(key, keyspace.toCollectionIdentifier());
        Validators.notNull(core, "core", supplier);
        Validators.notNullOrEmpty(key, "Id", supplier);
        Validators.notNull(keyspace, "Keyspace", supplier);
        Validators.notNull(options, "Options", supplier);
        Validators.notNull(initial, "Initial", supplier);
        Validators.notNull(durability, "Durability", supplier);
    }

    public static void validateCore(Core core) {
        Validators.notNull(core, "Core");
    }

    public static void validateKeyspace(CoreKeyspace keyspace) {
        Validators.notNull(keyspace, "Keyspace");
    }
}

