/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.lang;

import com.apicatalog.jsonld.lang.LanguageTag;
import com.apicatalog.rdf.lang.RdfAlphabet;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import java.util.regex.Pattern;

final class LanguageTagParser {
    static final Pattern LANG_DEL_RE = Pattern.compile("-");
    final String languageTag;
    final String[] tags;
    int tagIndex;
    boolean verififierMode;

    LanguageTagParser(String languageTag, String[] tags, boolean verifierMode) {
        this.languageTag = languageTag;
        this.tags = tags;
        this.verififierMode = verifierMode;
        this.tagIndex = 0;
    }

    public static final LanguageTagParser create(String languageTag) {
        return LanguageTagParser.create(languageTag, false);
    }

    public static final boolean isWellFormed(String languageTag) {
        try {
            return LanguageTagParser.create(languageTag, true).parse() != null;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    private static final LanguageTagParser create(String languageTag, boolean verifierMode) {
        if (languageTag == null) {
            throw new IllegalArgumentException("The parameter 'laguageTag' must not be null");
        }
        String stripped = languageTag.trim();
        if (stripped.length() == 0 || RdfAlphabet.ASCII_ALPHA.negate().test(stripped.codePointAt(0)) || RdfAlphabet.ASCII_ALPHA_NUM.negate().test(stripped.codePointAt(stripped.length() - 1))) {
            return new LanguageTagParser(languageTag, null, verifierMode);
        }
        String[] tags = LANG_DEL_RE.split(stripped);
        if (tags == null || tags.length == 0) {
            return new LanguageTagParser(languageTag, null, verifierMode);
        }
        return new LanguageTagParser(languageTag, tags, verifierMode);
    }

    LanguageTag parse() throws IllegalArgumentException {
        if (this.tags == null || this.tags.length == 0) {
            return null;
        }
        LanguageTag tag = new LanguageTag();
        this.tagIndex = 0;
        if (this.acceptAlpha(2, 3, tag::setLanguage)) {
            if (this.acceptAlpha(3, tag::addLanguageExtension)) {
                this.acceptAlpha(3, tag::addLanguageExtension);
                this.acceptAlpha(3, tag::addLanguageExtension);
            }
        } else if (!this.acceptAlpha(4, 8, tag::setLanguage)) {
            if (this.acceptPrivateUse(tag)) {
                if (this.tagIndex != this.tags.length) {
                    throw new IllegalArgumentException("The language tag [" + this.languageTag + "] is not well-formed.");
                }
                return tag;
            }
            throw new IllegalArgumentException("The language tag [" + this.languageTag + "] is not well-formed.");
        }
        this.acceptAlpha(4, tag::setScript);
        if (!this.acceptAlpha(2, tag::setRegion)) {
            this.acceptDigit(3, tag::setRegion);
        }
        while (true) {
            if (this.acceptAlphaNun(5, 8, tag::addVariant)) {
                continue;
            }
            if (!this.digitRange(0, 1) || !this.alphaNumRange(1, 3)) break;
            if (!this.accept(4, tag::addVariant)) break;
        }
        while (this.acceptDigit(1) || this.alphaRange(0, 1) && !this.tags[this.tagIndex].equalsIgnoreCase("x") && this.accept(1)) {
            LanguageTag.Extension extension = new LanguageTag.Extension(this.tags[this.tagIndex - 1].charAt(0), new ArrayList<String>());
            if (!this.acceptAlphaNun(2, 8, extension::addTag)) {
                --this.tagIndex;
                break;
            }
            while (this.acceptAlphaNun(2, 8, extension::addTag)) {
            }
            tag.addExtension(extension);
        }
        this.acceptPrivateUse(tag);
        if (this.tagIndex != this.tags.length) {
            throw new IllegalArgumentException("The language tag [" + this.languageTag + "] is not well-formed.");
        }
        return tag;
    }

    boolean acceptPrivateUse(LanguageTag tag) {
        if (this.alphaRange(0, 1) && this.tags[this.tagIndex].equalsIgnoreCase("x") && this.accept(1)) {
            if (!this.acceptAlphaNun(1, 8, tag::addPrivateUse)) {
                --this.tagIndex;
            } else {
                while (this.acceptAlphaNun(1, 8, tag::addPrivateUse)) {
                }
                return true;
            }
        }
        return false;
    }

    boolean acceptAlpha(int length, Consumer<String> consumer) {
        return this.acceptAlpha(length, length, consumer);
    }

    boolean acceptAlpha(int min, int max, Consumer<String> consumer) {
        return this.accept(min, max, RdfAlphabet.ASCII_ALPHA, consumer);
    }

    boolean acceptDigit(int length) {
        return this.acceptDigit(length, length, null);
    }

    boolean acceptDigit(int length, Consumer<String> consumer) {
        return this.acceptDigit(length, length, consumer);
    }

    boolean acceptDigit(int min, int max, Consumer<String> consumer) {
        return this.accept(min, max, RdfAlphabet.ASCII_DIGIT, consumer);
    }

    boolean acceptAlphaNun(int min, int max, Consumer<String> consumer) {
        return this.accept(min, max, RdfAlphabet.ASCII_ALPHA_NUM, consumer);
    }

    boolean accept(int min, int max, IntPredicate predicate, Consumer<String> consumer) {
        if (this.tagIndex < this.tags.length && this.tags[this.tagIndex].length() >= min && this.tags[this.tagIndex].length() <= max && this.tags[this.tagIndex].chars().allMatch(predicate)) {
            if (!this.verififierMode && consumer != null) {
                consumer.accept(this.tags[this.tagIndex]);
            }
            ++this.tagIndex;
            return true;
        }
        return false;
    }

    boolean accept(int length) {
        return this.accept(length, null);
    }

    boolean accept(int length, Consumer<String> consumer) {
        if (this.tagIndex < this.tags.length && this.tags[this.tagIndex].length() == length) {
            if (!this.verififierMode && consumer != null) {
                consumer.accept(this.tags[this.tagIndex]);
            }
            ++this.tagIndex;
            return true;
        }
        return false;
    }

    boolean alphaRange(int index, int length) {
        return this.range(index, length, RdfAlphabet.ASCII_ALPHA);
    }

    boolean alphaNumRange(int index, int length) {
        return this.range(index, length, RdfAlphabet.ASCII_ALPHA_NUM);
    }

    boolean digitRange(int index, int length) {
        return this.range(index, length, RdfAlphabet.ASCII_DIGIT);
    }

    boolean range(int index, int length, IntPredicate predicate) {
        return this.tagIndex < this.tags.length && index < this.tags[this.tagIndex].length() && index + length <= this.tags[this.tagIndex].length() && this.tags[this.tagIndex].substring(index, index + length).chars().allMatch(predicate);
    }
}

