/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.autoscaling.model.AttachInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachInstancesRequestMarshaller
implements Marshaller<Request<AttachInstancesRequest>, AttachInstancesRequest> {
    @Override
    public Request<AttachInstancesRequest> marshall(AttachInstancesRequest attachInstancesRequest) {
        if (attachInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AttachInstancesRequest> request = new DefaultRequest<AttachInstancesRequest>(attachInstancesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "AttachInstances");
        request.addParameter("Version", "2011-01-01");
        List<String> instanceIdsList = attachInstancesRequest.getInstanceIds();
        int instanceIdsListIndex = 1;
        for (String instanceIdsListValue : instanceIdsList) {
            if (instanceIdsListValue != null) {
                request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringUtils.fromString(instanceIdsListValue));
            }
            ++instanceIdsListIndex;
        }
        if (attachInstancesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString(attachInstancesRequest.getAutoScalingGroupName()));
        }
        return request;
    }
}

