/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.lambda.model.CreateEventSourceMappingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateEventSourceMappingRequestMarshaller
implements Marshaller<Request<CreateEventSourceMappingRequest>, CreateEventSourceMappingRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<CreateEventSourceMappingRequest> marshall(CreateEventSourceMappingRequest createEventSourceMappingRequest) {
        if (createEventSourceMappingRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createEventSourceMappingRequest, "AWSLambda");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-03-31/event-source-mappings/";
        request.setResourcePath(uriResourcePath);
        try {
            SdkJsonGenerator jsonGenerator = new SdkJsonGenerator();
            jsonGenerator.writeStartObject();
            if (createEventSourceMappingRequest.getEventSourceArn() != null) {
                jsonGenerator.writeFieldName("EventSourceArn").writeValue(createEventSourceMappingRequest.getEventSourceArn());
            }
            if (createEventSourceMappingRequest.getFunctionName() != null) {
                jsonGenerator.writeFieldName("FunctionName").writeValue(createEventSourceMappingRequest.getFunctionName());
            }
            if (createEventSourceMappingRequest.getEnabled() != null) {
                jsonGenerator.writeFieldName("Enabled").writeValue(createEventSourceMappingRequest.getEnabled().booleanValue());
            }
            if (createEventSourceMappingRequest.getBatchSize() != null) {
                jsonGenerator.writeFieldName("BatchSize").writeValue(createEventSourceMappingRequest.getBatchSize().intValue());
            }
            if (createEventSourceMappingRequest.getStartingPosition() != null) {
                jsonGenerator.writeFieldName("StartingPosition").writeValue(createEventSourceMappingRequest.getStartingPosition());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

