/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.utils;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.Tag;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.utils.GsonObjectBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TagUtils {
    public static ObjectTagInfo getObjectTagInfo(String resource, PartitionSpec partitionSpec, RestClient client) throws OdpsException {
        Response resp;
        String body;
        JsonParser jsonParser;
        JsonElement jsonElement;
        Objects.requireNonNull(resource);
        Objects.requireNonNull(client);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tagging", null);
        if (partitionSpec != null) {
            params.put("partition", partitionSpec.toString());
        }
        if (!(jsonElement = (jsonParser = new JsonParser()).parse(body = new String((resp = client.request(resource, "GET", params, null, null)).getBody(), StandardCharsets.UTF_8))).isJsonObject()) {
            throw new ReloadException("Expect a JsonObject, but got: " + body);
        }
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        if (jsonObject.has("ObjectTagInfo")) {
            return (ObjectTagInfo)GsonObjectBuilder.get().fromJson(jsonObject.get("ObjectTagInfo"), ObjectTagInfo.class);
        }
        return null;
    }

    public static List<Tag> getTags(ObjectTagInfo tagInfo, String columnName, Odps odps) {
        LinkedList<Tag> tags = new LinkedList<Tag>();
        if (tagInfo.getTagInfo() != null && tagInfo.getTagInfo().getColumnTags() != null && tagInfo.getTagInfo().getColumnTags().get(columnName) != null) {
            for (Map.Entry<String, List<String>> entry : tagInfo.getTagInfo().getColumnTags().get(columnName).entrySet()) {
                String classificationName = entry.getKey();
                for (String tagName : entry.getValue()) {
                    tags.add(odps.classifications().get(classificationName).tags().get(tagName));
                }
            }
        }
        return tags;
    }

    public static List<Tag> getTags(ObjectTagInfo tagInfo, Odps odps) {
        LinkedList<Tag> tags = new LinkedList<Tag>();
        if (tagInfo.getTagInfo() != null && tagInfo.getTagInfo().getTags() != null) {
            for (Map.Entry<String, List<String>> entry : tagInfo.getTagInfo().getTags().entrySet()) {
                String classificationName = entry.getKey();
                for (String tagName : entry.getValue()) {
                    tags.add(odps.classifications().get(classificationName).tags().get(tagName));
                }
            }
        }
        return tags;
    }

    public static Map<String, Map<String, String>> getSimpleTags(ObjectTagInfo tagInfo) {
        HashMap<String, Map<String, String>> simpleTags = new HashMap<String, Map<String, String>>();
        if (tagInfo.getSimpleTagInfo() != null && tagInfo.getSimpleTagInfo().getTags() != null) {
            for (Map.Entry<String, List<SimpleTagInfoEntry>> entry : tagInfo.getSimpleTagInfo().getTags().entrySet()) {
                String category = entry.getKey();
                for (SimpleTagInfoEntry simpleTagInfoEntry : entry.getValue()) {
                    if (!simpleTags.containsKey(category)) {
                        simpleTags.put(category, new HashMap());
                    }
                    ((Map)simpleTags.get(category)).put(simpleTagInfoEntry.getTagName(), simpleTagInfoEntry.getTagValue());
                }
            }
        }
        return simpleTags;
    }

    public static Map<String, Map<String, String>> getSimpleTags(ObjectTagInfo tagInfo, String columnName) {
        HashMap<String, Map<String, String>> simpleTags = new HashMap<String, Map<String, String>>();
        if (tagInfo.getSimpleTagInfo() != null && tagInfo.getSimpleTagInfo().getColumnTags() != null && tagInfo.getSimpleTagInfo().getColumnTags().get(columnName) != null) {
            for (Map.Entry<String, List<SimpleTagInfoEntry>> entry : tagInfo.getSimpleTagInfo().getColumnTags().get(columnName).entrySet()) {
                String category = entry.getKey();
                for (SimpleTagInfoEntry simpleTagInfoEntry : entry.getValue()) {
                    if (!simpleTags.containsKey(category)) {
                        simpleTags.put(category, new HashMap());
                    }
                    ((Map)simpleTags.get(category)).put(simpleTagInfoEntry.getTagName(), simpleTagInfoEntry.getTagValue());
                }
            }
        }
        return simpleTags;
    }

    public static void updateTagInternal(SetObjectTagInput setObjectTagInput, PartitionSpec partitionSpec, RestClient client) throws OdpsException {
        String resource;
        Objects.requireNonNull(setObjectTagInput);
        Objects.requireNonNull(client);
        OBJECT_TYPE type = setObjectTagInput.objectRef.objectType;
        String projectName = setObjectTagInput.objectRef.projectName;
        String objectName = setObjectTagInput.objectRef.objectName;
        switch (type) {
            case TABLE: {
                resource = ResourceBuilder.buildTableResource(projectName, objectName);
                break;
            }
            case RESOURCE: {
                resource = ResourceBuilder.buildResourceResource(projectName, objectName);
                break;
            }
            case FUNCTION: {
                resource = ResourceBuilder.buildFunctionResource(projectName, objectName);
                break;
            }
            case VOLUME: {
                resource = ResourceBuilder.buildVolumeResource(projectName, objectName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported object type: " + (Object)((Object)type));
            }
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tagging", null);
        if (partitionSpec != null) {
            params.put("partition", partitionSpec.toString());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("SetObjectTagInput", GsonObjectBuilder.get().toJsonTree((Object)setObjectTagInput));
        String body = GsonObjectBuilder.get().toJson((JsonElement)jsonObject);
        client.request(resource, "PUT", params, headers, body.getBytes());
    }

    public static void validateTaggingColumn(TableSchema schema, List<String> columnNames) {
        Objects.requireNonNull(schema);
        if (columnNames != null) {
            List columns = schema.getColumns();
            List partitionColumns = schema.getPartitionColumns();
            for (String columnName : columnNames) {
                if (partitionColumns.stream().anyMatch(c -> columnName.equalsIgnoreCase(c.getName()))) {
                    throw new IllegalArgumentException("Partition column is unsupported yet.");
                }
                if (!columns.stream().noneMatch(c -> columnName.equalsIgnoreCase(c.getName()))) continue;
                throw new IllegalArgumentException("Column does not exist: " + columnName + ".");
            }
        }
    }

    public static class ObjectTagInfo {
        @Expose
        @SerializedName(value="SimpleTag")
        SimpleTagInfo simpleTagInfo;
        @Expose
        @SerializedName(value="Tag")
        TagInfo tagInfo;

        public SimpleTagInfo getSimpleTagInfo() {
            return this.simpleTagInfo;
        }

        public TagInfo getTagInfo() {
            return this.tagInfo;
        }
    }

    public static class TagInfo {
        @Expose
        @SerializedName(value="Tags")
        Map<String, List<String>> tags;
        @Expose
        @SerializedName(value="ColumnTags")
        Map<String, Map<String, List<String>>> columnTags;
        @Expose
        @SerializedName(value="UpdateTime")
        Long updateTime;

        public Map<String, List<String>> getTags() {
            return this.tags;
        }

        public Map<String, Map<String, List<String>>> getColumnTags() {
            return this.columnTags;
        }

        public Long getUpdateTime() {
            return this.updateTime;
        }
    }

    public static class SimpleTagInfo {
        @Expose
        @SerializedName(value="Tags")
        Map<String, List<SimpleTagInfoEntry>> tags;
        @Expose
        @SerializedName(value="ColumnTags")
        Map<String, Map<String, List<SimpleTagInfoEntry>>> columnTags;
        @Expose
        @SerializedName(value="UpdateTime")
        Long updateTime;

        public Map<String, List<SimpleTagInfoEntry>> getTags() {
            return this.tags;
        }

        public Map<String, Map<String, List<SimpleTagInfoEntry>>> getColumnTags() {
            return this.columnTags;
        }

        public Long getUpdateTime() {
            return this.updateTime;
        }
    }

    public static class SimpleTagInfoEntry {
        @Expose
        @SerializedName(value="TagCategory")
        String category;
        @Expose
        @SerializedName(value="TagName")
        String tagName;
        @Expose
        @SerializedName(value="TagValue")
        String tagValue;

        public String getCategory() {
            return this.category;
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getTagValue() {
            return this.tagValue;
        }
    }

    public static class SetObjectTagInput {
        @Expose
        @SerializedName(value="OpType")
        OPERATION_TYPE op;
        @Expose
        @SerializedName(value="ObjectRef")
        ObjectRef objectRef;
        @Expose
        @SerializedName(value="TagRef")
        TagRef tagRef;
        @Expose
        @SerializedName(value="SimpleTag")
        SimpleTag simpleTag;

        public SetObjectTagInput(OPERATION_TYPE op, ObjectRef objectRef, TagRef tagRef, SimpleTag simpleTag) {
            this.op = Objects.requireNonNull(op);
            this.objectRef = Objects.requireNonNull(objectRef);
            if (tagRef == null && simpleTag == null) {
                throw new IllegalArgumentException("TagRef and SimpleTag should not be null at the same time");
            }
            this.tagRef = tagRef;
            this.simpleTag = simpleTag;
        }
    }

    public static class TagRef {
        @Expose
        @SerializedName(value="Classification")
        String classificationName;
        @Expose
        @SerializedName(value="Name")
        String tagName;

        public TagRef(String classificationName, String tagName) {
            this.classificationName = Objects.requireNonNull(classificationName);
            this.tagName = Objects.requireNonNull(tagName);
        }
    }

    public static class SimpleTag {
        @Expose
        @SerializedName(value="Category")
        String category;
        @Expose
        @SerializedName(value="KeyValues")
        Map<String, String> kv;

        public SimpleTag(String category, Map<String, String> kv) {
            this.category = Objects.requireNonNull(category);
            this.kv = new HashMap<String, String>(Objects.requireNonNull(kv));
        }
    }

    public static class ObjectRef {
        @Expose
        @SerializedName(value="ColumnNames")
        List<String> columns;
        @Expose
        @SerializedName(value="DatabaseName")
        String projectName;
        @Expose
        @SerializedName(value="ObjectName")
        String objectName;
        @Expose
        @SerializedName(value="ObjectType")
        OBJECT_TYPE objectType;

        public ObjectRef(OBJECT_TYPE type, String projectName, String objectName, List<String> columns) {
            this.objectType = Objects.requireNonNull(type);
            this.projectName = Objects.requireNonNull(projectName);
            this.objectName = Objects.requireNonNull(objectName);
            this.columns = columns;
        }
    }

    public static enum OBJECT_TYPE {
        TABLE,
        FUNCTION,
        RESOURCE,
        VOLUME;

    }

    public static enum OPERATION_TYPE {
        SET,
        UNSET;

    }
}

