/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.impl;

import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.impl.SessionBase;
import com.aliyun.odps.tunnel.impl.Slot;
import com.aliyun.odps.tunnel.impl.Util;
import com.google.gson.JsonObject;
import java.util.List;

public class StreamSessionBase
extends SessionBase {
    protected List<Slot> loadFromJson(String requestId, JsonObject tree, boolean reload) throws TunnelException {
        try {
            if (!reload) {
                if (tree.has("session_name") && tree.has("schema")) {
                    this.id = tree.get("session_name").getAsString();
                    JsonObject tunnelTableSchema = tree.get("schema").getAsJsonObject();
                    this.schema = new TunnelTableSchema(tunnelTableSchema);
                } else {
                    throw new TunnelException(requestId, "Incomplete session info: '" + tree.toString() + "'");
                }
            }
            if (tree.has("quota_name")) {
                this.quotaName = tree.get("quota_name").getAsString();
            }
            if (tree.has("slots") && tree.has("status")) {
                String status = tree.get("status").getAsString();
                if (status.equals("init")) {
                    throw new TunnelException(requestId, "Session is initiating. Session name: " + this.id);
                }
                return Util.parseSlots(tree.getAsJsonArray("slots"));
            }
            throw new TunnelException(requestId, "Incomplete session info: '" + tree.toString() + "'");
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(requestId, "Invalid json content: '" + tree.toString() + "'", e);
        }
    }

    @Override
    protected String getResource() {
        return this.config.getResource(this.projectName, this.schemaName, this.tableName) + "/" + "streams";
    }
}

