/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.ml;

import com.aliyun.odps.Instance;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.ml.ModelResourceBuilder;
import com.aliyun.odps.ml.OfflineModel;
import com.aliyun.odps.ml.OfflineModelFilter;
import com.aliyun.odps.ml.OfflineModelInfo;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class OfflineModels
implements Iterable<OfflineModel> {
    private RestClient client;
    private Odps odps;

    public OfflineModels(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public OfflineModel get(String modelName) {
        return this.get(this.getDefaultProjectName(), modelName);
    }

    public OfflineModel get(String projectName, String modelName) {
        OfflineModel.OfflineModelDesc desc = new OfflineModel.OfflineModelDesc();
        desc.modelName = modelName;
        return new OfflineModel(desc, projectName, this.odps);
    }

    public boolean exists(String modelName) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), modelName);
    }

    public boolean exists(String projectName, String modelName) throws OdpsException {
        try {
            OfflineModel m = this.get(projectName, modelName);
            m.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    @Override
    public Iterator<OfflineModel> iterator() {
        return this.iterator(this.getDefaultProjectName(), null);
    }

    public Iterator<OfflineModel> iterator(String projectName) {
        return this.iterator(projectName, null);
    }

    public Iterator<OfflineModel> iterator(OfflineModelFilter filter) {
        return this.iterator(this.getDefaultProjectName(), filter);
    }

    public Iterator<OfflineModel> iterator(final String projectName, final OfflineModelFilter filter) {
        return new ListIterator<OfflineModel>(){
            Map<String, String> params = new HashMap<String, String>();

            @Override
            protected List<OfflineModel> list() {
                ArrayList<OfflineModel> models = new ArrayList<OfflineModel>();
                this.params.put("expectmarker", "true");
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                if (filter != null) {
                    if (filter.getName() != null) {
                        this.params.put("name", filter.getName());
                    }
                    if (filter.getOwner() != null) {
                        this.params.put("owner", filter.getOwner());
                    }
                }
                String resource = ResourceBuilder.buildOfflineModelResource(projectName);
                try {
                    ListOfflineModelsResponse resp = OfflineModels.this.client.request(ListOfflineModelsResponse.class, resource, "GET", this.params);
                    for (OfflineModel.OfflineModelDesc desc : resp.offlineModelDescs) {
                        OfflineModel m = new OfflineModel(desc, projectName, OfflineModels.this.odps);
                        models.add(m);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return models;
            }
        };
    }

    public Instance create(OfflineModelInfo modelInfo) throws OdpsException {
        return this.create(this.getDefaultProjectName(), modelInfo);
    }

    public Instance create(String project, OfflineModelInfo modelInfo) throws OdpsException {
        String xml = null;
        try {
            xml = SimpleXmlUtils.marshal(modelInfo);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String resource = ModelResourceBuilder.buildOfflineModelResource(project);
        Response resp = this.client.stringRequest(resource, "POST", null, headers, xml);
        String location = resp.getHeaders().get("Location");
        if (location == null || location.trim().length() == 0) {
            throw new OdpsException("Invalid response, Location header required.");
        }
        String instId = (location = location.trim()).substring(location.lastIndexOf(47) + 1);
        if (instId.trim().length() == 0) {
            throw new OdpsException("Create offlinemodel failed: Instance id not found, " + location);
        }
        if (this.odps.instances().exists(project, instId)) {
            return this.odps.instances().get(project, instId);
        }
        throw new OdpsException("Create offlinemodel failed: Instance not found, " + instId);
    }

    public Instance copy(String project, OfflineModelInfo modelInfo) throws OdpsException {
        String xml = null;
        try {
            xml = SimpleXmlUtils.marshal(modelInfo);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String resource = ModelResourceBuilder.buildOfflineModelResource(project);
        Response resp = this.client.stringRequest(resource, "POST", null, headers, xml);
        String location = resp.getHeaders().get("Location");
        if (location == null || location.trim().length() == 0) {
            throw new OdpsException("Invalid response, Location header required.");
        }
        String instId = (location = location.trim()).substring(location.lastIndexOf(47) + 1);
        if (instId.trim().length() == 0) {
            throw new OdpsException("Copy offlinemodel failed: Instance id not found, " + location);
        }
        if (this.odps.instances().exists(project, instId)) {
            return this.odps.instances().get(project, instId);
        }
        throw new OdpsException("Copy offlinemodel failed: Instance not found, " + instId);
    }

    public void delete(String modelName) throws OdpsException {
        this.delete(this.client.getDefaultProject(), modelName);
    }

    public void delete(String projectName, String modelName) throws OdpsException {
        String resource = ResourceBuilder.buildOfflineModelResource(projectName, modelName);
        this.client.request(resource, "DELETE", null, null, null);
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    @Root(name="OfflineModels", strict=false)
    private static class ListOfflineModelsResponse {
        @ElementList(entry="OfflineModel", inline=true, required=false)
        private List<OfflineModel.OfflineModelDesc> offlineModelDescs = new ArrayList<OfflineModel.OfflineModelDesc>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;

        private ListOfflineModelsResponse() {
        }
    }
}

