/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Partition;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Shard;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.Tag;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.data.DefaultRecordReader;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Attribute;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.Text;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.simpleframework.xml.convert.Converter;
import com.aliyun.odps.simpleframework.xml.stream.InputNode;
import com.aliyun.odps.simpleframework.xml.stream.OutputNode;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.utils.ColumnUtils;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import com.aliyun.odps.utils.StringUtils;
import com.aliyun.odps.utils.TagUtils;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Table
extends LazyLoad {
    private TableModel model;
    private TableSchema tableSchema;
    private TagUtils.ObjectTagInfo tableTagInfo;
    private RestClient client;
    private boolean isExtendInfoLoaded;
    private boolean isShardInfoLoaded;
    private Odps odps;

    Table(TableModel model, String project, String schemaName, Odps odps) {
        this.model = model;
        this.model.projectName = project;
        this.model.schemaName = schemaName;
        this.odps = odps;
        this.client = odps.getRestClient();
        this.isExtendInfoLoaded = false;
        this.isShardInfoLoaded = false;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildTableResource(this.model.projectName, this.model.name);
        HashMap<String, String> params = this.initParamsWithSchema();
        this.reload(this.client.request(TableModel.class, resource, "GET", params));
    }

    public void reload(TableModel model) throws OdpsException {
        this.model = model;
        if (model.schema != null) {
            this.tableSchema = this.loadSchemaFromJson(((TableModel)model).schema.content);
        }
        this.setLoaded(true);
    }

    private void reloadTagInfo() {
        String resource = ResourceBuilder.buildTableResource(this.model.projectName, this.model.name);
        try {
            this.tableTagInfo = TagUtils.getObjectTagInfo(resource, null, this.client);
        }
        catch (OdpsException e) {
            throw new ReloadException(e);
        }
    }

    private void lazyLoadExtendInfo() {
        if (!this.isExtendInfoLoaded) {
            TableModel response;
            try {
                HashMap<String, String> params = this.initParamsWithSchema();
                params.put("extended", null);
                String resource = ResourceBuilder.buildTableResource(this.model.projectName, this.model.name);
                response = this.client.request(TableModel.class, resource, "GET", params);
            }
            catch (OdpsException e) {
                throw new ReloadException(e.getMessage(), e);
            }
            this.loadSchemaFromJson(((TableModel)response).schema.content);
            this.isExtendInfoLoaded = true;
        }
    }

    public String getName() {
        return this.model.name;
    }

    public String getComment() {
        if (this.model.comment == null) {
            this.lazyLoad();
        }
        return this.model.comment;
    }

    public String getOwner() {
        if (this.model.owner == null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public TableType getType() {
        if (this.model.type == null) {
            this.lazyLoad();
        }
        return this.model.type;
    }

    public Date getCreatedTime() {
        if (this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    public String getTableLabel() {
        if (this.model.tableLabel == null) {
            this.lazyLoad();
        }
        return this.model.tableLabel;
    }

    public List<String> getTableExtendedLabels() {
        if (this.model.tableExtendedLabels == null) {
            this.lazyLoad();
        }
        return this.model.tableExtendedLabels;
    }

    public List<Tag> getTags() {
        this.reloadTagInfo();
        return TagUtils.getTags(this.tableTagInfo, this.odps);
    }

    public List<Tag> getTags(String columnName) {
        this.reloadTagInfo();
        Objects.requireNonNull(columnName);
        TagUtils.validateTaggingColumn(this.getSchema(), Collections.singletonList(columnName));
        return TagUtils.getTags(this.tableTagInfo, columnName, this.odps);
    }

    public Map<String, Map<String, String>> getSimpleTags() {
        this.reloadTagInfo();
        return TagUtils.getSimpleTags(this.tableTagInfo);
    }

    public Map<String, Map<String, String>> getSimpleTags(String columnName) {
        this.reloadTagInfo();
        Objects.requireNonNull(columnName);
        TagUtils.validateTaggingColumn(this.getSchema(), Collections.singletonList(columnName));
        return TagUtils.getSimpleTags(this.tableTagInfo, columnName);
    }

    public void addTag(Tag tag) throws OdpsException {
        this.addTag(tag, null);
    }

    public void addTag(Tag tag, List<String> columnNames) throws OdpsException {
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.TABLE, this.model.projectName, this.model.name, columnNames);
        TagUtils.TagRef tagRef = new TagUtils.TagRef(tag.getClassification(), tag.getName());
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.SET, objectRef, tagRef, null);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public void addSimpleTag(String category, String key, String value) throws OdpsException {
        this.addSimpleTag(category, key, value, null);
    }

    public void addSimpleTag(String category, String key, String value, List<String> columnNames) throws OdpsException {
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.TABLE, this.model.projectName, this.model.name, columnNames);
        TagUtils.SimpleTag simpleTag = new TagUtils.SimpleTag(category, Collections.singletonMap(key, value));
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.SET, objectRef, null, simpleTag);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public void removeTag(Tag tag) throws OdpsException {
        this.removeTag(tag, null);
    }

    public void removeTag(Tag tag, List<String> columnNames) throws OdpsException {
        Objects.requireNonNull(tag);
        TagUtils.validateTaggingColumn(this.getSchema(), columnNames);
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.TABLE, this.model.projectName, this.model.name, columnNames);
        TagUtils.TagRef tagRef = new TagUtils.TagRef(tag.getClassification(), tag.getName());
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.UNSET, objectRef, tagRef, null);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public void removeSimpleTag(String category, String key, String value) throws OdpsException {
        this.removeSimpleTag(category, key, value, null);
    }

    public void removeSimpleTag(String category, String key, String value, List<String> columnNames) throws OdpsException {
        Objects.requireNonNull(category);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        TagUtils.validateTaggingColumn(this.getSchema(), columnNames);
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.TABLE, this.model.projectName, this.model.name, columnNames);
        TagUtils.SimpleTag simpleTag = new TagUtils.SimpleTag(category, Collections.singletonMap(key, value));
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.UNSET, objectRef, null, simpleTag);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public String getTableID() {
        if (this.model.ID == null) {
            this.lazyLoad();
        }
        return this.model.ID;
    }

    public String getCryptoAlgoName() {
        if (this.model.cryptoAlgoName == null) {
            this.lazyLoad();
        }
        return this.model.cryptoAlgoName;
    }

    public String getMaxExtendedLabel() {
        ArrayList<String> extendedLabels = new ArrayList<String>();
        if (this.getTableExtendedLabels() != null) {
            extendedLabels.addAll(this.getTableExtendedLabels());
        }
        for (Column column : this.tableSchema.getColumns()) {
            if (column.getExtendedlabels() == null) continue;
            extendedLabels.addAll(column.getExtendedlabels());
        }
        return Table.calculateMaxLabel(extendedLabels);
    }

    public String getMaxLabel() {
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(this.getTableLabel());
        for (Column column : this.tableSchema.getColumns()) {
            labels.add(column.getCategoryLabel());
        }
        return Table.calculateMaxLabel(labels);
    }

    static String calculateMaxLabel(List<String> labels) {
        int maxLevel = 0;
        int category = 45;
        for (String label : labels) {
            char num;
            if (StringUtils.isNullOrEmpty((String)label) || !Character.isDigit(num = label.charAt(label.length() - 1)) || num - 48 < maxLevel) continue;
            if (num - 48 > maxLevel) {
                maxLevel = num - 48;
                category = 45;
            }
            if (label.length() == 1) {
                category = 76;
                continue;
            }
            for (int i = label.length() - 2; i >= 0; --i) {
                int c = label.charAt(i);
                if (!Character.isLetter((char)c)) continue;
                c = Character.toUpperCase((char)c);
                if (category == 45) {
                    category = c;
                    continue;
                }
                if (category == c) continue;
                category = 76;
            }
        }
        if (category == 45 && maxLevel == 0) {
            return "";
        }
        if (category == 45) {
            category = 76;
        }
        return (char)category + "" + maxLevel;
    }

    public Date getLastMetaModifiedTime() {
        if (this.model.lastMetaModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastMetaModifiedTime;
    }

    public String getProject() {
        return this.model.projectName;
    }

    public String getSchemaName() {
        return this.model.schemaName;
    }

    public boolean isVirtualView() {
        if (this.isLoaded()) {
            return this.model.isVirtualView;
        }
        if (this.model.type != null) {
            return TableType.VIRTUAL_VIEW.equals((Object)this.model.type);
        }
        this.lazyLoad();
        return this.model.isVirtualView;
    }

    public boolean isMaterializedView() {
        this.lazyLoad();
        return TableType.MATERIALIZED_VIEW.equals((Object)this.model.type);
    }

    public boolean isMaterializedViewRewriteEnabled() {
        this.lazyLoad();
        if (!this.isMaterializedView()) {
            throw new IllegalStateException("Not a materialized view");
        }
        return this.model.isMaterializedViewRewriteEnabled;
    }

    public boolean isMaterializedViewOutdated() {
        this.lazyLoadExtendInfo();
        if (!this.isMaterializedView()) {
            throw new IllegalStateException("Not a materialized view");
        }
        return this.model.isMaterializedViewOutdated;
    }

    public boolean isExternalTable() {
        if (this.isLoaded()) {
            return this.model.isExternalTable;
        }
        if (this.model.type != null) {
            return TableType.EXTERNAL_TABLE.equals((Object)this.model.type);
        }
        this.lazyLoad();
        return this.model.isExternalTable;
    }

    public String getViewText() {
        if (this.model.viewText == null) {
            this.lazyLoad();
        }
        return this.model.viewText;
    }

    public String getViewExpandedText() {
        if (this.model.viewExpandedText == null) {
            this.lazyLoad();
        }
        return this.model.viewExpandedText;
    }

    public Date getLastDataModifiedTime() {
        if (this.model.lastModifiedTime == null) {
            this.lazyLoad();
        }
        return this.model.lastModifiedTime;
    }

    public Date getLastDataAccessTime() {
        if (this.model.lastAccessTime == null) {
            this.lazyLoad();
        }
        return this.model.lastAccessTime;
    }

    public long getSize() {
        this.lazyLoad();
        return this.model.size;
    }

    public long getRecordNum() {
        this.lazyLoad();
        return this.model.recordNum;
    }

    public long getLife() {
        this.lazyLoad();
        return this.model.life;
    }

    public long getHubLifecycle() {
        this.lazyLoad();
        return this.model.hubLifecycle;
    }

    public TableSchema getSchema() {
        if (this.tableSchema == null) {
            this.lazyLoad();
        }
        return this.tableSchema;
    }

    public String getJsonSchema() {
        if (this.model.schema == null || ((TableModel)this.model).schema.content == null) {
            this.lazyLoad();
        }
        return this.model.schema == null ? null : ((TableModel)this.model).schema.content;
    }

    public boolean isArchived() {
        this.lazyLoadExtendInfo();
        return this.model.isArchived;
    }

    public boolean isTransactional() {
        this.lazyLoadExtendInfo();
        return this.model.isTransactional;
    }

    public long getPhysicalSize() {
        this.lazyLoadExtendInfo();
        return this.model.physicalSize;
    }

    public long getFileNum() {
        this.lazyLoadExtendInfo();
        return this.model.fileNum;
    }

    public String getLocation() {
        if (this.model.location == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.location;
    }

    public String getStorageHandler() {
        if (this.model.storageHandler == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.storageHandler;
    }

    public String getResources() {
        if (this.model.resources == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.resources;
    }

    public Map<String, String> getSerDeProperties() {
        if (this.model.serDeProperties == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.serDeProperties;
    }

    public String getReserved() {
        if (this.model.reserved == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.reserved;
    }

    public ClusterInfo getClusterInfo() {
        if (this.model.clusterInfo == null) {
            this.lazyLoadExtendInfo();
        }
        return this.model.clusterInfo;
    }

    public Shard getShard() {
        if (this.model.shard == null) {
            this.lazyLoad();
        }
        return this.model.shard;
    }

    public RecordReader read(int limit) throws OdpsException {
        return this.read(null, null, limit);
    }

    public RecordReader read(PartitionSpec partition, List<String> columns, int limit) throws OdpsException {
        return this.read(partition, columns, limit, null);
    }

    public RecordReader read(PartitionSpec partition, List<String> columns, int limit, String timezone) throws OdpsException {
        if (limit < 0) {
            throw new OdpsException("limit number should >= 0.");
        }
        HashMap<String, String> params = this.initParamsWithSchema();
        params.put("data", null);
        if (partition != null && partition.keys().size() > 0) {
            params.put("partition", partition.toString());
        }
        if (columns != null && columns.size() != 0) {
            String column = "";
            for (String temp : columns) {
                column = column + temp;
                column = column + ",";
            }
            column = column.substring(0, column.lastIndexOf(","));
            params.put("cols", column);
        }
        if (limit != -1) {
            params.put("linenum", String.valueOf(limit));
        }
        HashMap<String, String> header = null;
        if (timezone != null) {
            header = new HashMap<String, String>();
            header.put("x-odps-sql-timezone", timezone);
        }
        String resource = ResourceBuilder.buildTableResource(this.model.projectName, this.model.name);
        Response resp = this.client.request(resource, "GET", params, header, null);
        return new DefaultRecordReader(new ByteArrayInputStream(resp.getBody()), this.getSchema());
    }

    private TableSchema loadSchemaFromJson(String json) {
        TableSchema s;
        block42: {
            s = new TableSchema();
            try {
                JsonArray tableExtendedLabels;
                Iterator n;
                int i;
                JsonObject tree = new JsonParser().parse(json).getAsJsonObject();
                if (tree.has("comment")) {
                    this.model.comment = tree.get("comment").getAsString();
                }
                if (tree.has("owner")) {
                    this.model.owner = tree.get("owner").getAsString();
                }
                if (tree.has("createTime")) {
                    this.model.createdTime = new Date(tree.get("createTime").getAsLong() * 1000L);
                }
                if (tree.has("lastModifiedTime")) {
                    this.model.lastModifiedTime = new Date(tree.get("lastModifiedTime").getAsLong() * 1000L);
                }
                if (tree.has("lastDDLTime")) {
                    this.model.lastMetaModifiedTime = new Date(tree.get("lastDDLTime").getAsLong() * 1000L);
                }
                if (tree.has("lastAccessTime")) {
                    long timestamp = tree.get("lastAccessTime").getAsLong() * 1000L;
                    Date date = this.model.lastAccessTime = timestamp == 0L ? null : new Date(timestamp);
                }
                if (tree.has("isVirtualView")) {
                    this.model.isVirtualView = tree.get("isVirtualView").getAsBoolean();
                }
                if (tree.has("isMaterializedView") && tree.get("isMaterializedView").getAsBoolean()) {
                    this.model.type = TableType.MATERIALIZED_VIEW;
                }
                if (tree.has("isMaterializedViewRewriteEnabled")) {
                    this.model.isMaterializedViewRewriteEnabled = tree.get("isMaterializedViewRewriteEnabled").getAsBoolean();
                }
                if (tree.has("IsMaterializedViewOutdated")) {
                    this.model.isMaterializedViewOutdated = tree.get("IsMaterializedViewOutdated").getAsBoolean();
                }
                if (tree.has("isExternal")) {
                    this.model.isExternalTable = tree.get("isExternal").getAsBoolean();
                }
                if (tree.has("lifecycle")) {
                    this.model.life = tree.get("lifecycle").getAsLong();
                }
                if (tree.has("hubLifecycle")) {
                    this.model.hubLifecycle = tree.get("hubLifecycle").getAsLong();
                }
                if (tree.has("viewText")) {
                    this.model.viewText = tree.get("viewText").getAsString();
                }
                if (tree.has("viewExpandedText")) {
                    this.model.viewExpandedText = tree.get("viewExpandedText").getAsString();
                }
                if (tree.has("size")) {
                    this.model.size = tree.get("size").getAsLong();
                }
                if (tree.has("IsArchived")) {
                    this.model.isArchived = tree.get("IsArchived").getAsBoolean();
                }
                if (tree.has("PhysicalSize")) {
                    this.model.physicalSize = tree.get("PhysicalSize").getAsLong();
                }
                if (tree.has("FileNum")) {
                    this.model.fileNum = tree.get("FileNum").getAsLong();
                }
                if (tree.has("recordNum")) {
                    this.model.recordNum = tree.get("recordNum").getAsLong();
                }
                if (tree.has("storageHandler")) {
                    this.model.storageHandler = tree.get("storageHandler").getAsString();
                }
                if (tree.has("location")) {
                    this.model.location = tree.get("location").getAsString();
                }
                if (tree.has("resources")) {
                    this.model.resources = tree.get("resources").getAsString();
                }
                if (tree.has("serDeProperties")) {
                    this.model.serDeProperties = (Map)new GsonBuilder().disableHtmlEscaping().create().fromJson(tree.get("serDeProperties").getAsString(), new TypeToken<Map<String, String>>(){}.getType());
                }
                if (tree.has("shardExist")) {
                    boolean shardExist = tree.get("shardExist").getAsBoolean();
                    this.model.shard = shardExist && tree.has("shardInfo") ? Shard.parseShard(tree.get("shardInfo").getAsJsonObject()) : null;
                }
                if (tree.has("tableLabel")) {
                    this.model.tableLabel = tree.get("tableLabel").getAsString();
                    if (this.model.tableLabel.equals("0")) {
                        this.model.tableLabel = "";
                    }
                }
                if (tree.has("columns") && tree.get("columns") != null) {
                    JsonArray columnsNode = tree.get("columns").getAsJsonArray();
                    for (i = 0; i < columnsNode.size(); ++i) {
                        n = columnsNode.get(i).getAsJsonObject();
                        s.addColumn(ColumnUtils.fromJson(n.toString()));
                    }
                }
                if (tree.has("extendedLabel") && (tableExtendedLabels = tree.get("extendedLabel").getAsJsonArray()).size() != 0) {
                    LinkedList<String> labelList = new LinkedList<String>();
                    for (JsonElement label : tableExtendedLabels) {
                        labelList.add(label.getAsString());
                    }
                    this.model.tableExtendedLabels = labelList;
                }
                if (tree.has("partitionKeys") && tree.get("partitionKeys") != null) {
                    JsonArray columnsNode = tree.get("partitionKeys").getAsJsonArray();
                    for (i = 0; i < columnsNode.size(); ++i) {
                        n = columnsNode.get(i).getAsJsonObject();
                        s.addPartitionColumn(ColumnUtils.fromJson(n.toString()));
                    }
                }
                if (tree.has("Reserved")) {
                    this.model.reserved = tree.get("Reserved").getAsString();
                    this.loadReservedJson(this.model.reserved);
                }
                if (tree.has("props") && tree.get("props") != null) {
                    JsonObject props = tree.get("props").getAsJsonObject();
                    this.model.mvProperties = new HashMap<String, String>();
                    this.model.mvProperties.put("enable_auto_refresh", props.has("enable_auto_refresh") ? props.get("enable_auto_refresh").getAsString() : "false");
                    if (props.has("refresh_interval_minutes")) {
                        this.model.mvProperties.put("refresh_interval_minutes", props.get("refresh_interval_minutes").getAsString());
                    }
                    if (props.has("refresh_cron")) {
                        this.model.mvProperties.put("refresh_cron", props.get("refresh_cron").getAsString());
                    }
                    if (props.has("enable_auto_substitute")) {
                        this.model.mvProperties.put("enable_auto_substitute", props.get("enable_auto_substitute").getAsString());
                    }
                }
                if (!tree.has("RefreshHistory")) break block42;
                String refreshHistoryStr = tree.get("RefreshHistory").getAsString();
                JsonArray refreshHistoryList = new JsonParser().parse(refreshHistoryStr).getAsJsonArray();
                this.model.refreshHistory = new LinkedList<Map<String, String>>();
                for (int i2 = 0; i2 < refreshHistoryList.size(); ++i2) {
                    JsonObject info = refreshHistoryList.get(i2).getAsJsonObject();
                    HashMap<String, String> infoMap = new HashMap<String, String>();
                    infoMap.put("InstanceId", info.has("InstanceId") ? info.get("InstanceId").getAsString() : null);
                    infoMap.put("Status", info.has("Status") ? info.get("Status").getAsString() : null);
                    infoMap.put("StartTime", info.has("StartTime") ? info.get("StartTime").getAsString() : null);
                    infoMap.put("EndTime", info.has("EndTime") ? info.get("EndTime").getAsString() : null);
                    this.model.refreshHistory.add(infoMap);
                    if (this.model.refreshHistory.size() < 10) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        return s;
    }

    private void loadReservedJson(String reserved) {
        JsonObject reservedJson = new JsonParser().parse(reserved).getAsJsonObject();
        this.model.clusterInfo = Table.parseClusterInfo(reservedJson);
        this.model.isTransactional = Table.parseTransactionalInfo(reservedJson);
        boolean bl = this.model.hasRowAccessPolicy = reservedJson.has("HasRowAccessPolicy") ? reservedJson.get("HasRowAccessPolicy").getAsBoolean() : false;
        if (reservedJson.has("PrimaryKey")) {
            this.model.primaryKey = new ArrayList<String>();
            JsonArray element = reservedJson.get("PrimaryKey").getAsJsonArray();
            for (JsonElement e : element) {
                this.model.primaryKey.add(e.getAsString());
            }
        }
        this.model.acidDataRetainHours = reservedJson.has("acid.data.retain.hours") ? Integer.parseInt(reservedJson.get("acid.data.retain.hours").getAsString()) : -1;
    }

    private static boolean parseTransactionalInfo(JsonObject jsonObject) {
        if (!jsonObject.has("Transactional")) {
            return false;
        }
        return Boolean.parseBoolean(jsonObject.get("Transactional").getAsString());
    }

    public static ClusterInfo parseClusterInfo(JsonObject jsonObject) {
        int i;
        JsonArray array;
        if (!jsonObject.has("ClusterType")) {
            return null;
        }
        ClusterInfo clusterInfo = new ClusterInfo();
        clusterInfo.clusterType = jsonObject.has("ClusterType") ? jsonObject.get("ClusterType").getAsString() : null;
        clusterInfo.bucketNum = jsonObject.has("BucketNum") ? jsonObject.get("BucketNum").getAsLong() : 0L;
        JsonArray jsonArray = array = jsonObject.has("ClusterCols") ? jsonObject.get("ClusterCols").getAsJsonArray() : null;
        if (array != null) {
            clusterInfo.clusterCols = new ArrayList<String>();
            for (i = 0; i < array.size(); ++i) {
                clusterInfo.clusterCols.add(array.get(i).getAsString());
            }
        }
        if (jsonObject.has("SortCols")) {
            array = jsonObject.get("SortCols").getAsJsonArray();
            clusterInfo.sortCols = new ArrayList<SortColumn>();
            for (i = 0; i < array.size(); ++i) {
                JsonObject obj = array.get(i).getAsJsonObject();
                if (obj == null) continue;
                clusterInfo.sortCols.add(new SortColumn(obj.get("col").getAsString(), obj.get("order").getAsString()));
            }
        }
        return clusterInfo;
    }

    public void createPartition(PartitionSpec spec) throws OdpsException {
        this.createPartition(spec, false);
    }

    public void createPartition(PartitionSpec spec, boolean ifNotExists) throws OdpsException {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getCoordinate());
        sb.append(" ADD");
        if (ifNotExists) {
            sb.append(" IF NOT EXISTS");
        }
        sb.append(" PARTITION (");
        String[] keys = spec.keys().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            sb.append(keys[i]).append("='").append(spec.get(keys[i])).append("'");
            if (i + 1 >= keys.length) continue;
            sb.append(',');
        }
        sb.append(");");
        String taskName = "SQLAddPartitionTask";
        this.runSQL(taskName, sb.toString());
    }

    public void deletePartition(PartitionSpec spec) throws OdpsException {
        this.deletePartition(spec, false);
    }

    public void deletePartition(PartitionSpec spec, boolean ifExists) throws OdpsException {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getCoordinate());
        sb.append(" DROP");
        if (ifExists) {
            sb.append(" IF EXISTS");
        }
        sb.append(" PARTITION(");
        String[] keys = spec.keys().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            sb.append(keys[i]).append("='").append(spec.get(keys[i])).append("'");
            if (i + 1 >= keys.length) continue;
            sb.append(',');
        }
        sb.append(");");
        String taskName = "SQLDropPartitionTask";
        this.runSQL(taskName, sb.toString());
    }

    public void createShards(long shardCount) throws OdpsException {
        StringBuilder sb = new StringBuilder();
        sb.append("ALTER TABLE ").append(this.getCoordinate());
        sb.append(String.format(" INTO %d SHARDS;", shardCount));
        String taskName = "SQLCreateShardsTask";
        this.runSQL(taskName, sb.toString());
    }

    public Iterator<Partition> getPartitionIterator() {
        return this.getPartitionIterator(null);
    }

    public Iterator<Partition> getPartitionIterator(PartitionSpec spec) {
        return this.getPartitionIterator(spec, false, 1000L, Long.MAX_VALUE);
    }

    public Iterator<Partition> getPartitionIterator(final PartitionSpec spec, final boolean reverse, final Long batchSize, Long limit) {
        if (limit != null && limit <= 0L) {
            throw new IllegalArgumentException("Argument 'limit' should be greater than 0");
        }
        if (batchSize != null && batchSize <= 0L) {
            throw new IllegalArgumentException("Argument 'batchSize' should be greater than 0");
        }
        final long finalLimit = limit == null ? Long.MAX_VALUE : limit;
        return new ListIterator<Partition>(){
            long numPartitions = 0L;
            Map<String, String> params = new HashMap<String, String>();

            @Override
            public boolean hasNext() {
                return super.hasNext() && this.numPartitions < finalLimit;
            }

            @Override
            public Partition next() {
                Partition partition = (Partition)super.next();
                ++this.numPartitions;
                return partition;
            }

            @Override
            protected List<Partition> list() {
                ArrayList<Partition> partitions = new ArrayList<Partition>();
                this.params.put("partitions", null);
                this.params.put("expectmarker", "true");
                if (spec != null && !spec.isEmpty()) {
                    this.params.put("partition", spec.toString());
                }
                if (reverse) {
                    this.params.put("reverse", null);
                }
                if (batchSize != null) {
                    this.params.put("maxitems", batchSize.toString());
                }
                String lastMarker = this.params.get("marker");
                if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                    return null;
                }
                String resource = ResourceBuilder.buildTableResource(((Table)Table.this).model.projectName, ((Table)Table.this).model.name);
                try {
                    this.params.putAll(Table.this.initParamsWithSchema());
                    ListPartitionsResponse resp = Table.this.client.request(ListPartitionsResponse.class, resource, "GET", this.params);
                    for (Partition.PartitionModel partitionModel : resp.partitions) {
                        Partition t = new Partition(partitionModel, ((Table)Table.this).model.projectName, ((Table)Table.this).model.schemaName, ((Table)Table.this).model.name, Table.this.odps);
                        partitions.add(t);
                    }
                    this.params.put("marker", resp.marker);
                }
                catch (OdpsException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                return partitions;
            }
        };
    }

    public List<Partition> getPartitions() {
        ArrayList<Partition> parts = new ArrayList<Partition>();
        Iterator<Partition> it = this.getPartitionIterator();
        while (it.hasNext()) {
            parts.add(it.next());
        }
        return parts;
    }

    public Partition getPartition(PartitionSpec spec) {
        return new Partition(spec, this.model.projectName, this.model.schemaName, this.model.name, this.odps);
    }

    public boolean hasPartition(PartitionSpec spec) throws OdpsException {
        try {
            Partition part = this.getPartition(spec);
            part.reload();
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return true;
    }

    public void truncate() throws OdpsException {
        StringBuilder sb = new StringBuilder();
        sb.append("TRUNCATE TABLE ").append(this.getCoordinate()).append(";");
        String taskName = "SQLTruncateTask";
        this.runSQL(taskName, sb.toString());
    }

    public boolean isPartitioned() throws OdpsException {
        if (this.isVirtualView()) {
            return false;
        }
        return this.getSchema().getPartitionColumns().size() > 0;
    }

    private void runSQL(String taskName, String query) throws OdpsException {
        Map<String, String> hints = NameSpaceSchemaUtils.setSchemaFlagInHints(null, this.model.schemaName);
        Instance i = SQLTask.run(this.odps, this.odps.getDefaultProject(), query, taskName, hints, null);
        i.waitForSuccess();
    }

    private HashMap<String, String> initParamsWithSchema() throws OdpsException {
        return NameSpaceSchemaUtils.initParamsWithSchema(this.model.schemaName);
    }

    private String getCoordinate() throws OdpsException {
        return NameSpaceSchemaUtils.getFullName(this.model.projectName, this.model.schemaName, this.model.name);
    }

    private Map<String, String> getMvProperties() {
        this.lazyLoad();
        if (this.model.mvProperties == null) {
            this.model.mvProperties = new HashMap<String, String>();
        }
        return this.model.mvProperties;
    }

    public boolean isAutoRefreshEnabled() {
        return Boolean.parseBoolean(this.getMvProperties().getOrDefault("enable_auto_refresh", "false"));
    }

    public Boolean isAutoSubstituteEnabled() {
        String autoSubstituteEnabledStr = this.getMvProperties().getOrDefault("enable_auto_substitute", null);
        return autoSubstituteEnabledStr == null ? null : Boolean.valueOf(autoSubstituteEnabledStr);
    }

    public Integer getRefreshInterval() {
        String refreshIntervalStr = this.getMvProperties().getOrDefault("refresh_interval_minutes", null);
        return refreshIntervalStr == null ? null : Integer.valueOf(refreshIntervalStr);
    }

    public String getRefreshCron() {
        return this.getMvProperties().getOrDefault("refresh_cron", null);
    }

    public List<Map<String, String>> getRefreshHistory() {
        this.lazyLoadExtendInfo();
        return this.model.refreshHistory;
    }

    public boolean hasRowAccessPolicy() {
        this.lazyLoadExtendInfo();
        return this.model.hasRowAccessPolicy;
    }

    public List<String> getPrimaryKey() {
        this.lazyLoadExtendInfo();
        return this.model.primaryKey;
    }

    public int getAcidDataRetainHours() {
        this.lazyLoadExtendInfo();
        return this.model.acidDataRetainHours;
    }

    @Root(name="Partitions", strict=false)
    private static class ListPartitionsResponse {
        @ElementList(entry="Partition", inline=true, required=false)
        private List<Partition.PartitionModel> partitions = new LinkedList<Partition.PartitionModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;

        private ListPartitionsResponse() {
        }
    }

    public static class SortColumn {
        private String name;
        private String order;

        SortColumn(String name, String order) {
            this.name = name;
            this.order = order;
        }

        public String getName() {
            return this.name;
        }

        public String getOrder() {
            return this.order;
        }

        public String toString() {
            return String.format("%s %s", this.name, this.order);
        }
    }

    public static class ClusterInfo {
        long bucketNum = -1L;
        String clusterType;
        List<String> clusterCols;
        List<SortColumn> sortCols;

        public String getClusterType() {
            return this.clusterType;
        }

        public long getBucketNum() {
            return this.bucketNum;
        }

        public List<String> getClusterCols() {
            return this.clusterCols;
        }

        public List<SortColumn> getSortCols() {
            return this.sortCols;
        }
    }

    @Root(name="Table", strict=false)
    static class TableModel {
        @Element(name="Name", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="TableId", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String ID;
        @Attribute(name="format", required=false)
        private String format;
        @Element(name="Schema", required=false)
        private Schema schema;
        @Element(name="Comment", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String comment;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="Project", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String projectName;
        @Element(name="SchemaName", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String schemaName;
        @Element(name="TableLabel", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String tableLabel;
        @Element(name="CryptoAlgo", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String cryptoAlgoName;
        @Element(name="CreationTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date createdTime;
        @Element(name="LastModifiedTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastModifiedTime;
        @Element(name="LastAccessTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date lastAccessTime;
        @Element(name="Type", required=false)
        @Convert(value=TableTypeConverter.class)
        TableType type;
        Date lastMetaModifiedTime;
        boolean isVirtualView;
        boolean isMaterializedViewRewriteEnabled;
        boolean isMaterializedViewOutdated;
        boolean isExternalTable;
        long life = -1L;
        long hubLifecycle = -1L;
        String viewText;
        String viewExpandedText;
        long size;
        long recordNum = -1L;
        boolean isArchived;
        long physicalSize;
        long fileNum;
        boolean isTransactional;
        String reserved;
        Shard shard;
        String storageHandler;
        String location;
        String resources;
        Map<String, String> serDeProperties;
        ClusterInfo clusterInfo;
        List<String> tableExtendedLabels;
        Map<String, String> mvProperties;
        List<Map<String, String>> refreshHistory;
        boolean hasRowAccessPolicy;
        List<String> primaryKey;
        int acidDataRetainHours;

        TableModel() {
        }

        @Root(name="Schema", strict=false)
        static class Schema {
            @Text(required=false)
            String content;

            Schema() {
            }
        }
    }

    public static class TableTypeConverter
    implements Converter<TableType> {
        @Override
        public TableType read(InputNode node) throws Exception {
            String value = node.getValue();
            if (value == null) {
                return null;
            }
            try {
                return TableType.valueOf(value);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        @Override
        public void write(OutputNode node, TableType value) throws Exception {
            node.remove();
        }
    }

    public static enum TableType {
        MANAGED_TABLE,
        VIRTUAL_VIEW,
        EXTERNAL_TABLE,
        MATERIALIZED_VIEW;

    }
}

