/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.ReloadException;
import com.aliyun.odps.Resource;
import com.aliyun.odps.Tag;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.utils.NameSpaceSchemaUtils;
import com.aliyun.odps.utils.TagUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Function
extends LazyLoad {
    FunctionModel model;
    private TagUtils.ObjectTagInfo functionTagInfo;
    String project;
    RestClient client;
    Odps odps;

    public Function() {
        this.model = new FunctionModel();
    }

    Function(FunctionModel functionModel, String project, Odps odps) {
        this.model = functionModel;
        this.project = project;
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public String getName() {
        if (this.model.name == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.name;
    }

    public void setName(String name) {
        this.model.name = name;
    }

    public String getOwner() {
        if (this.model.owner == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Date getCreatedTime() {
        if (this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    @Deprecated
    public String getClassType() {
        if (this.model.classType == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.classType;
    }

    public String getClassPath() {
        if (this.model.classType == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.classType;
    }

    @Deprecated
    public void setClassType(String classType) {
        this.model.classType = classType;
    }

    public void setClassPath(String classPath) {
        this.model.classType = classPath;
    }

    public List<Resource> getResources() {
        if (this.model.resources == null && this.client != null) {
            this.lazyLoad();
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.model.resources != null) {
            for (String resourceFullName : this.model.resources) {
                resources.add(Resource.from(this.project, resourceFullName, this.odps));
            }
        }
        return resources;
    }

    @Deprecated
    private Map<String, String> parseResourcesName(List<String> resources) {
        HashMap<String, String> resourceMap = new HashMap<String, String>();
        for (String r : resources) {
            String[] splits = r.split("/resources/");
            String resourceProject = null;
            String resourceName = null;
            if (splits.length > 1) {
                resourceProject = splits[0];
                resourceName = splits[1];
            } else {
                resourceProject = this.project;
                resourceName = r;
            }
            resourceMap.put(resourceName, resourceProject);
        }
        return resourceMap;
    }

    @Deprecated
    public List<String> getResourceNames() {
        if (this.model.resources == null && this.client != null) {
            this.lazyLoad();
        }
        ArrayList<String> resourceNames = new ArrayList<String>();
        if (this.model.resources != null) {
            Map<String, String> resources = this.parseResourcesName(this.model.resources);
            for (Map.Entry<String, String> entry : resources.entrySet()) {
                if (entry.getValue().equals(this.project)) {
                    resourceNames.add(entry.getKey());
                    continue;
                }
                resourceNames.add(entry.getValue() + "/" + entry.getKey());
            }
        }
        return resourceNames;
    }

    public List<String> getResourceFullNames() {
        this.lazyLoad();
        return this.model.resources;
    }

    public void setResources(List<String> resources) {
        this.model.resources = new ArrayList();
        this.model.resources.addAll(resources);
    }

    public String getProject() {
        return this.project;
    }

    public String getSchemaName() {
        this.lazyLoad();
        return this.model.schemaName;
    }

    public boolean isSqlFunction() {
        this.lazyLoad();
        if (this.model.isSqlFunction == null) {
            this.model.isSqlFunction = false;
        }
        return this.model.isSqlFunction;
    }

    public String getSqlDefinitionText() {
        this.lazyLoad();
        if (this.isSqlFunction()) {
            return this.model.sqlDefinitionText;
        }
        return null;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildFunctionResource(this.project, this.model.name);
        HashMap<String, String> params = NameSpaceSchemaUtils.initParamsWithSchema(this.model.schemaName);
        this.model = this.client.request(FunctionModel.class, resource, "GET", params);
        this.setLoaded(true);
    }

    private void reloadTagInfo() {
        String resource = ResourceBuilder.buildFunctionResource(this.project, this.model.name);
        try {
            this.functionTagInfo = TagUtils.getObjectTagInfo(resource, null, this.client);
        }
        catch (OdpsException e) {
            throw new ReloadException(e);
        }
    }

    public void updateOwner(String newOwner) throws OdpsException {
        String method = "PUT";
        String resource = ResourceBuilder.buildFunctionResource(this.project, this.model.name);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("updateowner", null);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-odps-owner", newOwner);
        this.client.request(resource, method, params, headers, null);
        this.model.owner = newOwner;
    }

    public List<Tag> getTags() {
        this.reloadTagInfo();
        return TagUtils.getTags(this.functionTagInfo, this.odps);
    }

    public Map<String, Map<String, String>> getSimpleTags() {
        this.reloadTagInfo();
        return TagUtils.getSimpleTags(this.functionTagInfo);
    }

    public void addTag(Tag tag) throws OdpsException {
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.FUNCTION, this.project, this.model.name, null);
        TagUtils.TagRef tagRef = new TagUtils.TagRef(tag.getClassification(), tag.getName());
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.SET, objectRef, tagRef, null);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public void addSimpleTag(String category, String key, String value) throws OdpsException {
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.FUNCTION, this.project, this.model.name, null);
        TagUtils.SimpleTag simpleTag = new TagUtils.SimpleTag(category, Collections.singletonMap(key, value));
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.SET, objectRef, null, simpleTag);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public void removeTag(Tag tag) throws OdpsException {
        Objects.requireNonNull(tag);
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.FUNCTION, this.project, this.model.name, null);
        TagUtils.TagRef tagRef = new TagUtils.TagRef(tag.getClassification(), tag.getName());
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.UNSET, objectRef, tagRef, null);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    public void removeSimpleTag(String category, String key, String value) throws OdpsException {
        Objects.requireNonNull(category);
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        TagUtils.ObjectRef objectRef = new TagUtils.ObjectRef(TagUtils.OBJECT_TYPE.FUNCTION, this.project, this.model.name, null);
        TagUtils.SimpleTag simpleTag = new TagUtils.SimpleTag(category, Collections.singletonMap(key, value));
        TagUtils.SetObjectTagInput setObjectTagInput = new TagUtils.SetObjectTagInput(TagUtils.OPERATION_TYPE.UNSET, objectRef, null, simpleTag);
        TagUtils.updateTagInternal(setObjectTagInput, null, this.client);
    }

    @Root(name="Function", strict=false)
    static class FunctionModel {
        @Element(name="SchemaName", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String schemaName;
        @Element(name="Alias", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="CreationTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date createdTime;
        @Element(name="ClassType", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String classType;
        @ElementList(name="Resources", entry="ResourceName", required=false)
        ArrayList<String> resources;
        @Element(name="IsSqlFunction", required=false)
        Boolean isSqlFunction;
        @Element(name="SqlDefinitionText", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String sqlDefinitionText;

        FunctionModel() {
        }
    }
}

