/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.utils;

import com.aliyun.odps.io.DatetimeWritable;
import com.aliyun.odps.io.NullWritable;
import com.aliyun.odps.io.Writable;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class CommonUtils {
    private static final String[] ONE_STRING_ARRAY = new String[]{""};
    private static final String TIMESTAMP_FORMAT_S = "yyyyMMddHHmmss_SSS";
    @Deprecated
    public static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss_SSS");
    private static final NullWritable nullWritable = NullWritable.get();
    private static final String DATETIME_FORMAT_S = "yyyy-MM-dd HH:mm:ss";
    @Deprecated
    public static final SimpleDateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static SimpleDateFormat getTimestampFormat() {
        return new SimpleDateFormat(TIMESTAMP_FORMAT_S);
    }

    public static SimpleDateFormat getDatetimeFormat() {
        return new SimpleDateFormat(DATETIME_FORMAT_S);
    }

    public static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    public static String generateMrTaskName() {
        return "console_mr_" + CommonUtils.getTimestampFormat().format(new Date());
    }

    public static String generateLocalMrTaskName() {
        return "mr_" + CommonUtils.getTimestampFormat().format(new Date()) + "_" + CommonUtils.getPID();
    }

    public static String generateGraphTaskName() {
        return "console_graph_" + CommonUtils.getTimestampFormat().format(new Date());
    }

    public static String generateBigGraphTaskName() {
        return "console_biggraph_" + CommonUtils.getTimestampFormat().format(new Date());
    }

    public static String generateLocalGraphTaskName() {
        return "graph_" + CommonUtils.getTimestampFormat().format(new Date()) + "_" + CommonUtils.getPID();
    }

    public static String getCurrentTime() {
        return CommonUtils.getDatetimeFormat().format(new Date());
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String toDelimitedString(Writable[] fields, char delim, String nullIndicator) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < fields.length; ++i) {
            Writable field;
            if (i != 0) {
                buf.append(delim);
            }
            if ((field = fields[i]) == null || field == nullWritable) {
                buf.append(nullIndicator);
                continue;
            }
            buf.append(field.toString());
        }
        return buf.toString();
    }

    private static Writable parseDateTime(String val) throws IOException {
        try {
            return new DatetimeWritable(Long.parseLong(val));
        }
        catch (NumberFormatException e) {
            try {
                return new DatetimeWritable(CommonUtils.getDatetimeFormat().parse(val).getTime());
            }
            catch (ParseException ex) {
                throw new IOException("unsupported date time format:" + val);
            }
        }
    }

    public static LinkedHashMap<String, String> convertPartSpecToMap(String partSpec) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (partSpec != null && !partSpec.trim().isEmpty()) {
            String[] parts;
            for (String part : parts = partSpec.split("/")) {
                String[] ss = part.split("=");
                if (ss.length != 2) {
                    throw new RuntimeException("ODPS-0730001: error part spec format: " + partSpec);
                }
                map.put(ss[0], ss[1]);
            }
        }
        return map;
    }

    public static String convertPartSpecMapToString(LinkedHashMap<String, String> partSpecMap) {
        String partSpec = "";
        if (partSpecMap != null) {
            for (Map.Entry<String, String> entry : partSpecMap.entrySet()) {
                if (entry.getKey() == null || entry.getValue() == null) {
                    throw new RuntimeException("ODPS-0730001: partition name or value can't be null: " + entry.getKey() + "=" + entry.getValue());
                }
                String part = entry.getKey().trim() + "=" + entry.getValue().trim();
                partSpec = partSpec + (partSpec.isEmpty() ? part : "/" + part);
            }
        }
        return partSpec;
    }

    public static void checkArgument(String name, int value, int lower_bound, int upper_bound) {
        if (value < lower_bound || value > upper_bound) {
            throw new RuntimeException("Local Run: Value of " + name + " out of bound, must be in range [" + lower_bound + "," + upper_bound + "].");
        }
    }
}

