/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class OdpsDeprecatedLogger {
    private static ConcurrentHashMap<String, Long> deprecatedCalls = new ConcurrentHashMap();

    @Around(value="@annotation(Deprecated)")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        try {
            String methodSignature = point.getSignature().toString();
            Long calledTimes = OdpsDeprecatedLogger.getDeprecatedCalls().get(methodSignature);
            calledTimes = calledTimes == null ? Long.valueOf(1L) : Long.valueOf(calledTimes + 1L);
            OdpsDeprecatedLogger.getDeprecatedCalls().put(methodSignature, calledTimes);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return point.proceed();
    }

    @Around(value="@annotation(Survey)")
    public Object aroundOdpsImpl(ProceedingJoinPoint point) throws Throwable {
        try {
            String callerClass = Thread.currentThread().getStackTrace()[3].getClassName();
            if (!callerClass.startsWith("com.aliyun.odps.")) {
                String methodSignature = point.getSignature().toString();
                Long calledTimes = OdpsDeprecatedLogger.getDeprecatedCalls().get(methodSignature);
                calledTimes = calledTimes == null ? Long.valueOf(1L) : Long.valueOf(calledTimes + 1L);
                OdpsDeprecatedLogger.getDeprecatedCalls().put(methodSignature, calledTimes);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return point.proceed();
    }

    public static ConcurrentHashMap<String, Long> getDeprecatedCalls() {
        return deprecatedCalls;
    }

    public static void setDeprecatedCalls(ConcurrentHashMap<String, Long> deprecatedCalls) {
        OdpsDeprecatedLogger.deprecatedCalls = deprecatedCalls;
    }
}

