/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive.shims;

import com.aliyun.datalake.metastore.hive.shims.Hive2CDHShims;
import com.aliyun.datalake.metastore.hive.shims.Hive2Shims;
import com.aliyun.datalake.metastore.hive.shims.Hive3Shims;
import com.aliyun.datalake.metastore.hive.shims.IHiveShims;
import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.common.util.HiveVersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShimsLoader {
    private static final Logger logger = LoggerFactory.getLogger(ShimsLoader.class);
    private static IHiveShims hiveShims;

    public static synchronized IHiveShims getHiveShims() {
        if (hiveShims == null) {
            hiveShims = ShimsLoader.loadHiveShims();
        }
        return hiveShims;
    }

    private static IHiveShims loadHiveShims() {
        String hiveVersion = HiveVersionInfo.getShortVersion();
        if (Hive2Shims.supportsVersion((String)hiveVersion)) {
            try {
                if (!ShimsLoader.containsUpdateTableStatsFast()) {
                    logger.info("Current version is cdh hive2!");
                    return (IHiveShims)Hive2CDHShims.class.newInstance();
                }
                return (IHiveShims)Hive2Shims.class.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("unable to get instance of Hive 1.x shim class");
            }
        }
        if (Hive3Shims.supportsVersion((String)hiveVersion)) {
            try {
                return (IHiveShims)Hive3Shims.class.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException("unable to get instance of Hive 2.x shim class");
            }
        }
        throw new RuntimeException("Shim class for Hive version " + hiveVersion + " does not exist");
    }

    @VisibleForTesting
    static synchronized void clearShimClass() {
        hiveShims = null;
    }

    public static boolean containsUpdateTableStatsFast() {
        try {
            MetaStoreUtils.class.getMethod("updateTableStatsFast", Database.class, Table.class, Warehouse.class, Boolean.TYPE, Boolean.TYPE, EnvironmentContext.class);
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }
}

