/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive2;

import com.aliyun.datalake.metastore.hive2.DLFCacheableMetaStoreClient;
import com.aliyun.datalake.metastore.hive2.ProxyMetaStoreClient;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.RetryingMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreClientFactory;
import org.apache.hive.hcatalog.common.HiveClientCache;

public class DlfMetaStoreClientFactory
implements HiveMetaStoreClientFactory {
    public static HiveClientCache.ICacheableMetaStoreClient createHCatalogICacheableMetaStoreClient(HiveConf hiveConf, Integer timeout) throws MetaException, IOException {
        try {
            return (HiveClientCache.ICacheableMetaStoreClient)RetryingMetaStoreClient.getProxy((Configuration)hiveConf, (Class[])new Class[]{HiveConf.class, Integer.class, Boolean.class}, (Object[])new Object[]{hiveConf, timeout, true}, (String)DLFCacheableMetaStoreClient.class.getName());
        }
        catch (MetaException e) {
            throw new IOException("Couldn't create hiveMetaStoreClient, Error getting UGI for user", e);
        }
    }

    public IMetaStoreClient createMetaStoreClient(HiveConf hiveConf, HiveMetaHookLoader hiveMetaHookLoader, boolean allowEmbedded, ConcurrentHashMap<String, Long> metaCallTimeMap) throws MetaException {
        Preconditions.checkNotNull((Object)hiveConf, (Object)"conf cannot be null!");
        Preconditions.checkNotNull(metaCallTimeMap, (Object)"metaCallTimeMap cannot be null!");
        if (hiveConf.getBoolVar(HiveConf.ConfVars.METASTORE_FASTPATH)) {
            return new ProxyMetaStoreClient(hiveConf, hiveMetaHookLoader, null);
        }
        return RetryingMetaStoreClient.getProxy((Configuration)hiveConf, (Class[])new Class[]{HiveConf.class, HiveMetaHookLoader.class, Boolean.class}, (Object[])new Object[]{hiveConf, hiveMetaHookLoader, allowEmbedded}, metaCallTimeMap, (String)ProxyMetaStoreClient.class.getName());
    }
}

