/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive2;

import com.aliyun.datalake.metastore.common.Action;
import com.aliyun.datalake.metastore.common.DefaultExecutorServiceFactory;
import com.aliyun.datalake.metastore.common.ExecutorServiceFactory;
import com.aliyun.datalake.metastore.common.IDataLakeMetaStore;
import com.aliyun.datalake.metastore.common.ProxyMode;
import com.aliyun.datalake.metastore.common.api.DataLakeAPIException;
import com.aliyun.datalake.metastore.common.entity.ResultModel;
import com.aliyun.datalake.metastore.common.util.DataLakeUtil;
import com.aliyun.datalake.metastore.hive.common.CommonMetaStoreClientDelegate;
import com.aliyun.datalake.metastore.hive.common.MetastoreFactory;
import com.aliyun.datalake.metastore.hive.common.converters.CatalogToHiveConverter;
import com.aliyun.datalake.metastore.hive.common.converters.HiveToCatalogConverter;
import com.aliyun.datalake.metastore.hive.common.utils.ConfigUtils;
import com.aliyun.datalake.metastore.hive.common.utils.HiveMetaHookWrapper;
import com.aliyun.datalake.metastore.hive.common.utils.Utils;
import com.aliyun.datalake.metastore.hive.shims.IHiveShims;
import com.aliyun.datalake.metastore.hive.shims.ShimsLoader;
import com.aliyun.datalake20200710.models.Database;
import com.aliyun.datalake20200710.models.Function;
import com.aliyun.datalake20200710.models.LockStatus;
import com.aliyun.datalake20200710.models.Partition;
import com.aliyun.datalake20200710.models.PartitionInput;
import com.aliyun.tea.TeaException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ObjectPair;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.AggregateStatsCache;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.PartFilterExprUtil;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.ReplChangeManager;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpecWithSharedSD;
import org.apache.hadoop.hive.metastore.api.PartitionWithoutSD;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.parser.ExpressionTree;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.HdfsUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.SecurityUtils;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.common.util.BloomFilter;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlfMetaStoreClientDelegate {
    private static final String PUBLIC = "public";
    private static final String EMPTY_TOKEN = "";
    private static final List<Role> implicitRoles = Lists.newArrayList((Object[])new Role[]{new Role("public", 0, "public")});
    private static final Logger logger = LoggerFactory.getLogger(DlfMetaStoreClientDelegate.class);
    private final Configuration conf;
    private final Warehouse warehouse;
    private final ExecutorService executorService;
    private final PartitionExpressionProxy expressionProxy;
    private final Pattern partitionValidationPattern;
    private final int pageSize;
    private IDataLakeMetaStore dataLakeMetaStore;
    private final IHiveShims hiveShims = ShimsLoader.getHiveShims();
    private final boolean isAggregateStatsCacheEnabled;
    private final CommonMetaStoreClientDelegate commonMetaStoreClientDelegate;
    private final Boolean enableFsOperation;
    private final boolean isProxyModeDlfOnly;
    private final boolean enableRenameFileOperation;
    private HiveMetaHookLoader hookLoader;
    private AggregateStatsCache aggrStatsCache;

    public DlfMetaStoreClientDelegate(Configuration conf, Warehouse warehouse, HiveMetaHookLoader hookLoader) throws MetaException {
        this.conf = conf;
        this.warehouse = warehouse;
        this.hookLoader = hookLoader;
        this.pageSize = ConfigUtils.getPageSize((Configuration)this.conf);
        this.executorService = this.getExecutorService();
        this.dataLakeMetaStore = new MetastoreFactory().getMetaStore(this.conf, this.executorService);
        this.commonMetaStoreClientDelegate = new CommonMetaStoreClientDelegate(this.dataLakeMetaStore, this.hiveShims, this.conf);
        String partitionValidationRegex = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN);
        this.partitionValidationPattern = partitionValidationRegex != null && !partitionValidationRegex.isEmpty() ? Pattern.compile(partitionValidationRegex) : null;
        this.isAggregateStatsCacheEnabled = MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.AGGREGATE_STATS_CACHE_ENABLED);
        if (this.isAggregateStatsCacheEnabled) {
            this.aggrStatsCache = AggregateStatsCache.getInstance((Configuration)this.conf);
        }
        String className = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXPRESSION_PROXY_CLASS);
        try {
            Class clazz = JavaUtils.getClass((String)className, PartitionExpressionProxy.class);
            this.expressionProxy = (PartitionExpressionProxy)JavaUtils.newInstance((Class)clazz, (Class[])new Class[0], (Object[])new Object[0]);
        }
        catch (MetaException e) {
            logger.error("Error loading PartitionExpressionProxy", (Throwable)e);
            throw new RuntimeException("Error loading PartitionExpressionProxy: " + e.getMessage(), e);
        }
        this.isProxyModeDlfOnly = ConfigUtils.getProxyMode((Configuration)conf) == ProxyMode.DLF_ONLY;
        this.enableRenameFileOperation = this.isProxyModeDlfOnly || ConfigUtils.getProxyMode((Configuration)conf) == ProxyMode.DLF_METASTORE_FAILURE;
        this.enableFsOperation = this.isProxyModeDlfOnly || ConfigUtils.getEnableFileOperation((Configuration)conf) != false && DataLakeUtil.isEnableFileOperationGray((double)ConfigUtils.getEnableFileOperationGrayRate((Configuration)conf));
    }

    private static void throwExceptionIfIncompatibleColTypeChange(List<FieldSchema> oldCols, List<FieldSchema> newCols) throws InvalidOperationException {
        ArrayList<String> incompatibleCols = new ArrayList<String>();
        int maxCols = Math.min(oldCols.size(), newCols.size());
        for (int i = 0; i < maxCols; ++i) {
            if (DlfMetaStoreClientDelegate.areColTypesCompatible(oldCols.get(i).getType(), newCols.get(i).getType())) continue;
            incompatibleCols.add(newCols.get(i).getName());
        }
        if (!incompatibleCols.isEmpty()) {
            throw new InvalidOperationException("The following columns have types incompatible with the existing columns in their respective positions :\n" + StringUtils.join(incompatibleCols, (char)','));
        }
    }

    private static boolean areColTypesCompatible(String oldType, String newType) {
        return TypeInfoUtils.implicitConvertible((TypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)oldType), (TypeInfo)TypeInfoUtils.getTypeInfoFromTypeString((String)newType));
    }

    private static boolean isMustPurge(EnvironmentContext envContext, Table table) {
        return envContext != null && Boolean.parseBoolean((String)envContext.getProperties().get("ifPurge")) || table.isSetParameters() && "true".equalsIgnoreCase((String)table.getParameters().get("auto.purge"));
    }

    private static boolean isMustPurge(boolean purgeData, Table tbl) {
        boolean isAutoPurgeSet = tbl.isSetParameters() && "true".equalsIgnoreCase((String)tbl.getParameters().get("auto.purge"));
        return purgeData || isAutoPurgeSet;
    }

    private static String convertToFilter(byte[] expr, PartitionExpressionProxy expressionProxy) throws MetaException {
        return expressionProxy.convertExprToFilter(expr);
    }

    private static boolean is_partition_spec_grouping_enabled(Table table) {
        Map parameters = table.getParameters();
        return parameters.containsKey("hive.hcatalog.partition.spec.grouping.enabled") && ((String)parameters.get("hive.hcatalog.partition.spec.grouping.enabled")).equalsIgnoreCase("true");
    }

    public Boolean getEnableFsOperation() {
        return this.enableFsOperation;
    }

    public IDataLakeMetaStore getDataLakeMetaStore() {
        return this.dataLakeMetaStore;
    }

    @VisibleForTesting
    protected void setDataLakeMetaStore(IDataLakeMetaStore dataLakeMetaStore) {
        this.dataLakeMetaStore = dataLakeMetaStore;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public boolean makeDirs(Warehouse wh, Path path) throws MetaException {
        Preconditions.checkNotNull((Object)wh, (Object)"Warehouse cannot be null");
        Preconditions.checkNotNull((Object)path, (Object)"Path cannot be null");
        boolean madeDir = false;
        if (!wh.isDir(path)) {
            if (!this.hiveShims.mkdirs(wh, path, true, this.enableFsOperation)) {
                throw new MetaException("Unable to create path: " + path);
            }
            madeDir = true;
        }
        return madeDir;
    }

    public void createDatabase(String catalogId, org.apache.hadoop.hive.metastore.api.Database database) throws TException {
        Preconditions.checkNotNull((Object)database, (Object)"database cannot be null");
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)database.getLocationUri())) {
            database.setLocationUri(this.warehouse.getDefaultDatabasePath(database.getName()).toString());
        } else {
            database.setLocationUri(this.warehouse.getDnsPath(new Path(database.getLocationUri())).toString());
        }
        Path dbPath = new Path(database.getLocationUri());
        boolean madeDir = this.makeDirs(this.warehouse, dbPath);
        boolean isSuccess = false;
        try {
            this.dataLakeMetaStore.createDatabase(catalogId, database.getName(), database.getDescription(), database.getLocationUri(), database.getParameters(), database.getOwnerName(), HiveToCatalogConverter.toCatalogPrincipalTypeString((PrincipalType)database.getOwnerType()), HiveToCatalogConverter.toCatalogPrivilegeSet((PrincipalPrivilegeSet)database.getPrivileges()));
            isSuccess = true;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to create database: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
        finally {
            if (!isSuccess && madeDir) {
                this.hiveShims.deleteDir(this.warehouse, dbPath, true, database, this.enableFsOperation);
            }
        }
    }

    public org.apache.hadoop.hive.metastore.api.Database getDatabase(String catalogId, String dbName) throws TException {
        try {
            Database database = this.dataLakeMetaStore.getDatabase(catalogId, dbName);
            org.apache.hadoop.hive.metastore.api.Database hiveDatabase = CatalogToHiveConverter.toHiveDatabase((Database)database);
            this.hiveShims.addCatalogForDb(hiveDatabase, catalogId);
            return hiveDatabase;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to get database: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public List<String> getDatabases(String catalogId, String pattern) throws TException {
        Preconditions.checkNotNull((Object)pattern, (Object)"pattern cannot be null");
        try {
            return this.dataLakeMetaStore.getDatabases(catalogId, pattern, this.pageSize);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to get databases: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public void alterDatabase(String catalogId, String dbName, org.apache.hadoop.hive.metastore.api.Database database) throws TException {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        Preconditions.checkNotNull((Object)database, (Object)"database cannot be null");
        try {
            this.dataLakeMetaStore.alterDatabase(catalogId, dbName, HiveToCatalogConverter.toCatalogDatabase((org.apache.hadoop.hive.metastore.api.Database)database));
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to alter database: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public void dropDatabase(String catalogId, String dbName, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws TException {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dbName), (Object)"name cannot be null or empty");
        try {
            List<String> tables = this.getTables(catalogId, dbName, ".*", null);
            boolean isEmptyDatabase = tables.isEmpty();
            org.apache.hadoop.hive.metastore.api.Database db = this.getDatabase(catalogId, dbName);
            String dbLocation = db.getLocationUri();
            Path path = new Path(db.getLocationUri()).getParent();
            if (!this.warehouse.isWritable(path)) {
                throw new MetaException("Database not dropped since " + path + " is not writable by " + SecurityUtils.getUser());
            }
            if (isEmptyDatabase || cascade) {
                try {
                    if (deleteData) {
                        List<String> materializedViews = this.getTables(catalogId, dbName, ".*", TableType.MATERIALIZED_VIEW);
                        for (String table : materializedViews) {
                            this.dropTable(catalogId, dbName, table, deleteData, true, null);
                            tables.remove(table);
                        }
                        for (String tableName : tables) {
                            try {
                                this.dropTable(catalogId, dbName, tableName, true, true, null);
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {}
                        }
                    }
                    this.dataLakeMetaStore.dropDatabase(catalogId, dbName, deleteData, ignoreUnknownDb, cascade);
                }
                catch (DataLakeAPIException e) {
                    throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
                }
            } else {
                throw new InvalidOperationException("Database " + dbName + " is not empty.");
            }
            if (deleteData) {
                try {
                    this.hiveShims.deleteDir(this.warehouse, new Path(dbLocation), true, db, this.enableFsOperation);
                }
                catch (Exception e) {
                    logger.error("Unable to remove database directory " + dbLocation, (Throwable)e);
                }
            }
        }
        catch (NoSuchObjectException e) {
            if (ignoreUnknownDb) {
                return;
            }
            throw e;
        }
        catch (InvalidOperationException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Unable to drop database: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public void createTable(String catalogId, Table tbl, EnvironmentContext envContext) throws TException {
        HiveMetaHookWrapper hook = new HiveMetaHookWrapper(this.hookLoader, tbl);
        hook.preCreateTable(tbl);
        boolean dirCreated = this.validateNewTableAndCreateDirectory(catalogId, tbl);
        org.apache.hadoop.hive.metastore.api.Database db = this.getDatabase(catalogId, tbl.getDbName());
        boolean isSuccess = false;
        try {
            if (MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_AUTO_GATHER) && !this.isView(tbl)) {
                this.hiveShims.updateTableStatsFast(db, tbl, this.warehouse, dirCreated, false, envContext);
            }
            this.dataLakeMetaStore.createTable(catalogId, HiveToCatalogConverter.toCatalogTableInput((Table)tbl));
            hook.commitCreateTable(tbl);
            isSuccess = true;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to create table: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
        finally {
            if (!isSuccess && dirCreated) {
                Path tblPath = this.getTablePath(catalogId, tbl);
                this.hiveShims.deleteDir(this.warehouse, tblPath, true, db, this.enableFsOperation);
            }
            if (!isSuccess) {
                try {
                    hook.rollbackCreateTable(tbl);
                }
                catch (Exception e) {
                    logger.error("Create rollback failed with", (Throwable)e);
                }
            }
        }
    }

    public Table getTable(String catalogId, String dbName, String tableName) throws NoSuchObjectException, TException {
        try {
            com.aliyun.datalake20200710.models.Table result = this.dataLakeMetaStore.getTable(catalogId, dbName, tableName);
            return CatalogToHiveConverter.toHiveTable((com.aliyun.datalake20200710.models.Table)result);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to get table: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public List<ColumnStatisticsObj> getTableColumnStatisticsObjs(String catalogId, String dbName, String tableName, List<String> colNames) throws UnsupportedOperationException, TException {
        return this.commonMetaStoreClientDelegate.getTableColumnStatisticsObjs(catalogId, dbName, tableName, colNames);
    }

    public ColumnStatistics getTableColumnStatistics(String catalogId, String dbName, String tableName, List<String> colNames) throws UnsupportedOperationException, TException {
        return this.commonMetaStoreClientDelegate.getTableColumnStatistics(catalogId, dbName, tableName, colNames);
    }

    public List<String> getTables(String catalogId, String dbname, String tablePattern, TableType tableType) throws TException {
        try {
            try {
                List tables = new ArrayList();
                tables = tableType != null ? this.dataLakeMetaStore.getTables(catalogId, dbname, tablePattern, this.pageSize, tableType.name()) : this.dataLakeMetaStore.getTables(catalogId, dbname, tablePattern, this.pageSize, null);
                return tables;
            }
            catch (DataLakeAPIException e) {
                throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
            }
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Unable to get tables: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public List<Table> getTableObjects(String catalogId, String dbname, String tablePattern, TableType tableType) throws TException {
        try {
            try {
                List<Object> tables = new ArrayList();
                tables = tableType != null ? this.dataLakeMetaStore.getTableObjects(catalogId, dbname, tablePattern, this.pageSize, tableType.name()).stream().map(t -> CatalogToHiveConverter.toHiveTable((com.aliyun.datalake20200710.models.Table)t)).collect(Collectors.toList()) : this.dataLakeMetaStore.getTableObjects(catalogId, dbname, tablePattern, this.pageSize, null).stream().map(t -> CatalogToHiveConverter.toHiveTable((com.aliyun.datalake20200710.models.Table)t)).collect(Collectors.toList());
                return tables;
            }
            catch (DataLakeAPIException e) {
                throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
            }
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Unable to get tables: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public List<Table> getTableObjects(String catalogId, String dbname, List<String> tableNames) throws TException {
        try {
            try {
                List<Table> tables = this.dataLakeMetaStore.getTableObjects(catalogId, dbname, tableNames).stream().map(t -> CatalogToHiveConverter.toHiveTable((com.aliyun.datalake20200710.models.Table)t)).collect(Collectors.toList());
                return tables;
            }
            catch (DataLakeAPIException e) {
                throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
            }
        }
        catch (UnsupportedOperationException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Unable to get tables: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public List<TableMeta> getTableMeta(String catalogId, String dbPatterns, String tablePatterns, List<String> tableTypes) throws TException {
        ArrayList<TableMeta> tableMetaList = new ArrayList<TableMeta>();
        if (dbPatterns == null) {
            dbPatterns = "*";
        }
        if (tablePatterns == null) {
            tablePatterns = "*";
        }
        String dbPatternsLowercase = dbPatterns.trim().toLowerCase();
        String tablePatternsLowercase = tablePatterns.trim().toLowerCase();
        List<String> databases = this.getDatabases(catalogId, dbPatternsLowercase);
        ArrayList<Table> tbs = new ArrayList<Table>();
        for (String db : databases) {
            if (tableTypes != null && tableTypes.size() > 0) {
                for (String tableType : tableTypes) {
                    try {
                        TableType realTableType = TableType.valueOf((String)tableType);
                        tbs.addAll(this.getTableObjects(catalogId, db, tablePatternsLowercase, realTableType));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                continue;
            }
            tbs.addAll(this.getTableObjects(catalogId, db, tablePatternsLowercase, null));
        }
        for (Table table : tbs) {
            TableMeta tableMeta = new TableMeta(table.getDbName(), table.getTableName(), table.getTableType());
            tableMeta.setComments((String)table.getParameters().get("comment"));
            tableMetaList.add(tableMeta);
        }
        return tableMetaList;
    }

    public void alterTable(String catalogId, String dbName, String oldTableName, Table newTable, EnvironmentContext environmentContext) throws TException {
        Table oldTable;
        this.validateTableObject(newTable, this.getConf());
        this.updateTableType(newTable);
        try {
            oldTable = this.getTable(catalogId, dbName, oldTableName);
        }
        catch (NoSuchObjectException e) {
            throw (InvalidOperationException)DataLakeUtil.throwException((Throwable)new InvalidOperationException(String.format("table %s.%s doesn't exist", dbName, oldTableName)), (Exception)((Object)e));
        }
        this.populateMissingSd(newTable);
        org.apache.hadoop.hive.metastore.api.Database database = this.getDatabase(catalogId, dbName);
        if (this.isSupportedRenameAction(dbName, oldTableName, newTable)) {
            this.doRename(catalogId, dbName, oldTable, newTable, database);
            return;
        }
        this.validateTableChangeCompatibility(newTable, oldTable);
        if (this.hiveShims.requireCalStats(this.getConf(), null, null, newTable, environmentContext) && newTable.getPartitionKeys().isEmpty()) {
            this.hiveShims.updateTableStatsFast(database, newTable, this.warehouse, false, true, environmentContext);
        }
        try {
            boolean cascade = environmentContext != null && environmentContext.isSetProperties() && "true".equals(environmentContext.getProperties().get("CASCADE"));
            Boolean isAsync = cascade && oldTable.getPartitionKeys() != null && oldTable.getPartitionKeys().size() > 0;
            this.dataLakeMetaStore.alterTable(catalogId, dbName, oldTableName, HiveToCatalogConverter.toCatalogTableInput((Table)newTable), cascade, isAsync.booleanValue());
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to alter table: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    private void validateTableChangeCompatibility(Table newTable, Table oldTable) throws InvalidOperationException {
        this.checkNonViewColumnCompatibility(newTable, oldTable);
        this.validatePartitionKeyChange(newTable, oldTable);
    }

    private void doRename(String catalogId, String dbName, Table oldTable, Table newTable, org.apache.hadoop.hive.metastore.api.Database database) throws TException {
        String oldTableName;
        boolean tableInSpecifiedLoc;
        if (this.isView(oldTable) || this.isNewLocationSpecified(oldTable, newTable) || Utils.isExternalTable((Table)oldTable)) {
            this.doRenameTableInMs(catalogId, dbName, oldTable, newTable);
            return;
        }
        Path srcPath = new Path(oldTable.getSd().getLocation());
        String oldTableRelativePath = new Path(database.getLocationUri()).toUri().relativize(srcPath.toUri()).toString();
        boolean bl = tableInSpecifiedLoc = !oldTableRelativePath.equalsIgnoreCase(oldTableName = oldTable.getTableName()) && !oldTableRelativePath.equalsIgnoreCase(oldTableName + "/");
        if (tableInSpecifiedLoc) {
            this.doRenameTableInMs(catalogId, dbName, oldTable, newTable);
            return;
        }
        Boolean isSameDb = dbName.equalsIgnoreCase(newTable.getDbName());
        FileSystem srcFs = this.warehouse.getFs(srcPath);
        org.apache.hadoop.hive.metastore.api.Database db = database;
        if (!isSameDb.booleanValue()) {
            db = this.getDatabase(catalogId, newTable.getDbName());
        }
        if (!org.apache.hadoop.hive.common.FileUtils.equalsFileSystem((FileSystem)srcFs, (FileSystem)this.warehouse.getFs(this.warehouse.getDatabasePath(db)))) {
            throw new InvalidOperationException("table new location is on a different file system than the old location " + srcPath + ". This operation is not supported");
        }
        Path databasePath = Utils.constructRenamedPath((Path)this.warehouse.getDatabasePath(db), (Path)srcPath);
        Path destPath = new Path(databasePath, newTable.getTableName().toLowerCase());
        FileSystem destFs = this.warehouse.getFs(destPath);
        if (!org.apache.hadoop.hive.common.FileUtils.equalsFileSystem((FileSystem)srcFs, (FileSystem)destFs)) {
            throw new InvalidOperationException("table new location " + destPath + " is on a different file system than the old location " + srcPath + ". This operation is not supported");
        }
        boolean dataWasMoved = false;
        try {
            if (this.enableRenameFileOperation && destFs.exists(destPath)) {
                throw new InvalidOperationException("New location for this table " + newTable.getDbName() + "." + newTable.getTableName() + " already exists : " + destPath);
            }
            if (srcFs.exists(srcPath) && Utils.renameFs((FileSystem)srcFs, (Path)srcPath, (Path)destPath, (boolean)this.enableRenameFileOperation)) {
                dataWasMoved = true;
            }
        }
        catch (IOException e) {
            throw (InvalidOperationException)DataLakeUtil.throwException((Throwable)new InvalidOperationException(String.format("Alter Table operation for %s.%s failed to move data due to: '%s' See hive log file for details.", dbName, oldTableName, e.getMessage())), (Exception)e);
        }
        try {
            this.doRenameTableInMs(catalogId, dbName, oldTable, newTable);
        }
        catch (Exception e) {
            if (dataWasMoved) {
                try {
                    if (destFs.exists(destPath) && !Utils.renameFs((FileSystem)destFs, (Path)destPath, (Path)srcPath, (boolean)this.enableRenameFileOperation)) {
                        logger.error("Failed to restore data from {} to {} in alter table failure. Manual restore is needed.", (Object)destPath, (Object)srcPath);
                    }
                }
                catch (IOException e1) {
                    logger.error("Failed to restore data from {} to {} in alter table failure. Manual restore is needed.", new Object[]{destPath, srcPath, e1});
                }
            }
            String msg = String.format("Unable to rename table from %s to %s due to: ", oldTableName, newTable.getTableName());
            throw new MetaException(msg + e.getMessage());
        }
    }

    private boolean isNewLocationSpecified(Table oldTable, Table newTable) {
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)newTable.getSd().getLocation()) && !newTable.getSd().getLocation().equals(oldTable.getSd().getLocation());
    }

    private void doRenameTableInMs(String catalogId, String dbName, Table oldTable, Table newTable) throws TException {
        try {
            Boolean isAsync = false;
            if (!dbName.equalsIgnoreCase(newTable.getDbName()) || oldTable.getPartitionKeys() != null && oldTable.getPartitionKeys().size() > 0) {
                isAsync = true;
            }
            this.dataLakeMetaStore.doRenameTableInMs(catalogId, dbName, oldTable.getTableName(), HiveToCatalogConverter.toCatalogTableInput((Table)newTable), isAsync);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "unable to do rename table InMs:";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    private void updateTableType(Table newTable) {
        boolean isExternal = Utils.isExternalTableSetInParameters((Table)newTable);
        if (TableType.MANAGED_TABLE.toString().equals(newTable.getTableType()) && isExternal) {
            newTable.setTableType(TableType.EXTERNAL_TABLE.toString());
        }
    }

    private void validatePartitionKeyChange(Table newTable, Table oldTable) throws InvalidOperationException {
        boolean partKeysPartiallyEqual = this.checkPartialPartKeysEqual(oldTable.getPartitionKeys(), newTable.getPartitionKeys());
        if (!(this.isView(oldTable) || oldTable.getPartitionKeys().size() == newTable.getPartitionKeys().size() && partKeysPartiallyEqual)) {
            throw new InvalidOperationException("partition keys can not be changed.");
        }
    }

    private boolean isView(Table table) {
        return TableType.VIRTUAL_VIEW.toString().equals(table.getTableType());
    }

    private boolean checkPartialPartKeysEqual(List<FieldSchema> oldPartKeys, List<FieldSchema> newPartKeys) {
        if (newPartKeys == null || oldPartKeys == null) {
            return oldPartKeys == newPartKeys;
        }
        if (oldPartKeys.size() != newPartKeys.size()) {
            return false;
        }
        Iterator<FieldSchema> oldPartKeysIter = oldPartKeys.iterator();
        Iterator<FieldSchema> newPartKeysIter = newPartKeys.iterator();
        while (oldPartKeysIter.hasNext()) {
            FieldSchema oldFs = oldPartKeysIter.next();
            FieldSchema newFs = newPartKeysIter.next();
            if (oldFs.getName().equals(newFs.getName())) continue;
            return false;
        }
        return true;
    }

    private void checkNonViewColumnCompatibility(Table newTable, Table oldTable) throws InvalidOperationException {
        if (MetastoreConf.getBoolVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DISALLOW_INCOMPATIBLE_COL_TYPE_CHANGES) && !this.isView(oldTable)) {
            DlfMetaStoreClientDelegate.throwExceptionIfIncompatibleColTypeChange(oldTable.getSd().getCols(), newTable.getSd().getCols());
        }
    }

    private boolean isSupportedRenameAction(String dbName, String oldTableName, Table newTable) {
        return !oldTableName.equalsIgnoreCase(newTable.getTableName()) || !dbName.equalsIgnoreCase(newTable.getDbName());
    }

    private void populateMissingSd(Table newTable) throws MetaException {
        String newLocation;
        if (newTable.getSd() != null && StringUtils.isNotEmpty((String)(newLocation = newTable.getSd().getLocation()))) {
            Path tblPath = this.warehouse.getDnsPath(new Path(newLocation));
            newTable.getSd().setLocation(tblPath.toString());
        }
    }

    private boolean isCascade(EnvironmentContext environmentContext) {
        return environmentContext != null && environmentContext.isSetProperties() && "true".equals(environmentContext.getProperties().get("CASCADE"));
    }

    public boolean deletePartitionColumnStatistics(String catalogId, String dbName, String tableName, String partName, String colName) throws TException {
        return this.commonMetaStoreClientDelegate.deletePartitionColumnStatistics(catalogId, dbName, tableName, partName, colName);
    }

    public boolean deleteTableColumnStatistics(String catalogId, String dbName, String tableName, String colName) throws UnsupportedOperationException, TException {
        return this.commonMetaStoreClientDelegate.deleteTableColumnStatistics(catalogId, dbName, tableName, colName);
    }

    public boolean validateNewTableAndCreateDirectory(String catalogId, Table tbl) throws TException {
        if (this.tableExists(catalogId, tbl.getDbName(), tbl.getTableName())) {
            throw new AlreadyExistsException("Table " + tbl.getTableName() + " already exists.");
        }
        this.validateTableObject(tbl, this.getConf());
        if (TableType.VIRTUAL_VIEW.toString().equals(tbl.getTableType())) {
            return false;
        }
        Path tablePath = this.getTablePath(catalogId, tbl);
        tbl.getSd().setLocation(tablePath.toString());
        return this.makeDirs(this.warehouse, tablePath);
    }

    public Path getTablePath(String catalogId, Table table) throws TException {
        org.apache.hadoop.hive.metastore.api.Database db;
        Path tablePath = null;
        tablePath = org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)table.getSd().getLocation()) ? ((db = this.getDatabase(catalogId, table.getDbName())).getName().equalsIgnoreCase("default") && ConfigUtils.getDefaultDbCreateTableUseCurrentDbLocation((Configuration)this.conf) ? this.warehouse.getDnsPath(new Path(new Path(db.getLocationUri()), MetaStoreUtils.encodeTableName((String)table.getTableName().toLowerCase()))) : this.warehouse.getDefaultTablePath(db, table)) : this.warehouse.getDnsPath(new Path(table.getSd().getLocation()));
        return tablePath;
    }

    public boolean tableExists(String catalogId, String dbName, String tableName) throws TException {
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)catalogId);
        Preconditions.checkNotNull((Object)dbName);
        try {
            try {
                com.aliyun.datalake20200710.models.Table result = this.dataLakeMetaStore.getTable(catalogId, dbName, tableName);
                return result != null;
            }
            catch (DataLakeAPIException e) {
                throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
            }
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (Exception e) {
            String msg = "Unable to get table exists: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    private void validateTableObject(Table table, Configuration conf) throws InvalidObjectException {
        Preconditions.checkNotNull((Object)table, (Object)"table cannot be null");
        Preconditions.checkNotNull((Object)table.getSd(), (Object)"Table#StorageDescriptor cannot be null");
        this.validateTableName(table, conf);
        this.validateTableColumns(table);
        this.validatePartitionKeys(table);
        this.validateSkewedInfo(table);
    }

    private void validateSkewedInfo(Table table) throws InvalidObjectException {
        SkewedInfo skew = table.getSd().getSkewedInfo();
        if (skew != null) {
            String validate = this.hiveShims.validateSkewedColNames(skew.getSkewedColNames());
            if (validate != null) {
                throw new InvalidObjectException("Invalid skew column " + validate);
            }
            validate = this.hiveShims.validateSkewedColNamesSubsetCol(skew.getSkewedColNames(), table.getSd().getCols());
            if (validate != null) {
                throw new InvalidObjectException("Invalid skew column " + validate);
            }
        }
    }

    private void validatePartitionKeys(Table table) throws InvalidObjectException {
        String validate;
        if (table.getPartitionKeys() != null && (validate = this.hiveShims.validateTblColumns(table.getPartitionKeys())) != null) {
            throw new InvalidObjectException("Invalid partition column " + validate);
        }
    }

    private void validateTableColumns(Table table) throws InvalidObjectException {
        List cols = table.getSd().getCols();
        if (null == cols || cols.size() < 1) {
            throw new InvalidObjectException("Invalid table columns");
        }
        String validate = this.hiveShims.validateTblColumns(cols);
        if (validate != null) {
            throw new InvalidObjectException("Invalid column " + validate);
        }
    }

    private void validateTableName(Table table, Configuration conf) throws InvalidObjectException {
        if (!this.hiveShims.validateName(table.getTableName(), conf)) {
            throw new InvalidObjectException(table.getTableName() + " is not a valid object name");
        }
    }

    public void dropTable(String catalogId, String dbName, Table table, boolean deleteData, EnvironmentContext context) throws MetaException, NoSuchObjectException, TException {
        List<Path> partPaths;
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dbName), (Object)"database cannot be null or empty");
        Preconditions.checkNotNull((Object)table, (Object)"table cannot be null");
        Path tablePath = null;
        if (table.getSd().getLocation() != null) {
            tablePath = new Path(table.getSd().getLocation());
        }
        boolean isSourceOfReplication = ReplChangeManager.isSourceOfReplication((org.apache.hadoop.hive.metastore.api.Database)this.getDatabase(catalogId, dbName));
        boolean mustPurge = DlfMetaStoreClientDelegate.isMustPurge(context, table);
        boolean isExternal = Utils.isExternalTable((Table)table);
        boolean shouldDeleteData = deleteData && !isExternal;
        try {
            partPaths = this.getNonSubDirectoryPartitionLocations(catalogId, dbName, table.getTableName(), table.getPartitionKeys(), shouldDeleteData, tablePath);
        }
        catch (IOException ioException) {
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(ioException.getMessage()), (Exception)ioException);
        }
        try {
            this.dataLakeMetaStore.dropTable(catalogId, dbName, table.getTableName(), deleteData);
            if (shouldDeleteData) {
                this.deletePartitionData(partPaths, mustPurge, isSourceOfReplication);
                this.deleteTableData(tablePath, mustPurge, isSourceOfReplication);
            }
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to drop table: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public void truncateTable(String catName, String dbName, String tableName, List<String> partNames) throws MetaException, NoSuchObjectException, TException {
        Table tbl = this.getTable(catName, dbName, tableName);
        org.apache.hadoop.hive.metastore.api.Database db = this.getDatabase(catName, dbName);
        try {
            boolean isAutopurge = tbl.isSetParameters() && "true".equalsIgnoreCase((String)tbl.getParameters().get("auto.purge"));
            List<org.apache.hadoop.hive.metastore.api.Partition> partitions = this.getPatitionsForTruncate(catName, dbName, tableName, tbl, partNames);
            for (Path location : this.getLocationsForTruncate(tbl, partitions)) {
                FileSystem fs = location.getFileSystem(this.getConf());
                if (!HdfsUtils.isPathEncrypted((Configuration)this.getConf(), (URI)fs.getUri(), (Path)location) && !FileUtils.pathHasSnapshotSubDir((Path)location, (FileSystem)fs)) {
                    HdfsUtils.HadoopFileStatus status = new HdfsUtils.HadoopFileStatus(this.getConf(), fs, location);
                    FileStatus targetStatus = fs.getFileStatus(location);
                    String targetGroup = targetStatus == null ? null : targetStatus.getGroup();
                    this.hiveShims.deleteDir(this.warehouse, location, true, isAutopurge, db, this.enableFsOperation);
                    fs.mkdirs(location);
                    HdfsUtils.setFullFileStatus((Configuration)this.getConf(), (HdfsUtils.HadoopFileStatus)status, (String)targetGroup, (FileSystem)fs, (Path)location, (boolean)false);
                    continue;
                }
                FileStatus[] statuses = fs.listStatus(location, FileUtils.HIDDEN_FILES_PATH_FILTER);
                if (statuses == null || statuses.length == 0) continue;
                for (FileStatus status : statuses) {
                    this.hiveShims.deleteDir(this.warehouse, status.getPath(), true, isAutopurge, db, this.enableFsOperation);
                }
            }
            this.alterTableStatsForTruncate(catName, dbName, tableName, tbl, partitions);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to drop table: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    private void alterTableStatsForTruncate(String catName, String dbName, String tableName, Table table, List<org.apache.hadoop.hive.metastore.api.Partition> partitions) throws Exception {
        if (partitions == null) {
            EnvironmentContext environmentContext = new EnvironmentContext();
            this.updateStatsForTruncate(table.getParameters(), environmentContext);
            this.alterTable(catName, dbName, tableName, table, environmentContext);
        } else {
            for (org.apache.hadoop.hive.metastore.api.Partition partition : partitions) {
                this.alterPartitionForTruncate(catName, dbName, tableName, partition);
            }
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> getPatitionsForTruncate(String catName, String dbName, String tableName, Table table, List<String> partNames) throws TException {
        if (partNames == null) {
            if (0 != table.getPartitionKeysSize()) {
                return this.listPartitions(catName, dbName, tableName, Lists.newArrayList(), Integer.MAX_VALUE);
            }
            return null;
        }
        return this.getPartitionsByNames(catName, dbName, tableName, partNames);
    }

    private List<Path> getLocationsForTruncate(Table table, List<org.apache.hadoop.hive.metastore.api.Partition> partitions) throws Exception {
        ArrayList<Path> locations = new ArrayList<Path>();
        if (partitions != null) {
            partitions.stream().forEach(p -> locations.add(new Path(p.getSd().getLocation())));
        } else {
            locations.add(new Path(table.getSd().getLocation()));
        }
        return locations;
    }

    private void alterPartitionForTruncate(String catName, String dbName, String tableName, org.apache.hadoop.hive.metastore.api.Partition partition) throws Exception {
        EnvironmentContext environmentContext = new EnvironmentContext();
        this.updateStatsForTruncate(partition.getParameters(), environmentContext);
        this.alterPartitions(catName, dbName, tableName, Lists.newArrayList((Object[])new org.apache.hadoop.hive.metastore.api.Partition[]{partition}), environmentContext);
    }

    private void updateStatsForTruncate(Map<String, String> props, EnvironmentContext environmentContext) {
        if (null == props) {
            return;
        }
        for (String stat : StatsSetupConst.supportedStats) {
            String statVal = props.get(stat);
            if (statVal == null) continue;
            props.put(stat, "0");
        }
        StatsSetupConst.setBasicStatsState(props, (String)"true");
        environmentContext.putToProperties("STATS_GENERATED", "TASK");
        StatsSetupConst.clearColumnStatsState(props);
    }

    private List<Path> getNonSubDirectoryPartitionLocations(String catalogId, String dbName, String tableName, List<FieldSchema> partitionKeys, boolean checkLocation, Path tablePath) throws IOException, TException {
        if (!checkLocation) {
            return Collections.emptyList();
        }
        ArrayList<Path> partPaths = new ArrayList<Path>();
        String nextToken = EMPTY_TOKEN;
        try {
            List partitions;
            if (tablePath != null) {
                tablePath = this.warehouse.getDnsPath(tablePath);
            }
            if (!partitionKeys.isEmpty() && null != (partitions = this.dataLakeMetaStore.getNonSubDirectoryPartitionLocations(catalogId, dbName, tableName, this.pageSize))) {
                for (Partition partition : partitions) {
                    String absoluteLocation = partition.sd.location;
                    if (null == absoluteLocation) continue;
                    Path partPath = this.warehouse.getDnsPath(new Path(absoluteLocation));
                    if (tablePath != null && (partPath == null || Utils.isSubdirectory((Path)tablePath, (Path)partPath))) continue;
                    if (!this.warehouse.isWritable(partPath.getParent())) {
                        throw new MetaException("Table metadata not deleted since the partition " + Warehouse.makePartName(partitionKeys, (List)partition.values) + " has parent location " + partPath.getParent() + " which is not writable by " + SecurityUtils.getUser());
                    }
                    partPaths.add(partPath);
                }
            }
            return partPaths;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "unable to get NonSubDirectoryPartitionLocations:";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    private void validateTablePath(Path tablePath) throws MetaException {
        try {
            if (!this.warehouse.isWritable(tablePath.getParent())) {
                throw new MetaException("Table metadata not deleted since " + tablePath.getParent() + " is not writable by " + SecurityUtils.getUser());
            }
        }
        catch (IOException e) {
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(e.getMessage()), (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(String catalogId, String dbName, String tableName, boolean deleteData, boolean ignoreUnknownTab, EnvironmentContext context) throws TException {
        Table table;
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dbName), (Object)"dbName cannot be null or empty");
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)tableName), (Object)"tableName cannot be null or empty");
        try {
            table = this.getTable(catalogId, dbName, tableName);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw e;
            }
            return;
        }
        this.validateTableToDrop(table);
        HiveMetaHookWrapper hook = new HiveMetaHookWrapper(this.hookLoader, table);
        hook.preDropTable(table);
        boolean success = false;
        try {
            this.dropTable(catalogId, dbName, table, deleteData, context);
            hook.commitDropTable(table, deleteData || context != null && "TRUE".equals(context.getProperties().get("ifPurge")));
            success = true;
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownTab) {
                throw e;
            }
        }
        finally {
            if (!success) {
                hook.rollbackDropTable(table);
            }
        }
    }

    private void deletePartitionData(List<Path> partPaths, boolean ifPurge, boolean needCmRecycle) {
        if (partPaths != null && !partPaths.isEmpty()) {
            for (Path partPath : partPaths) {
                try {
                    this.hiveShims.deleteDir(this.warehouse, partPath, true, ifPurge, needCmRecycle, this.enableFsOperation);
                }
                catch (Exception e) {
                    logger.error("Failed to delete partition directory: {} {}", new Object[]{partPath, e.getMessage(), e});
                }
            }
        }
    }

    private void deleteTableData(Path tablePath, boolean ifPurge, boolean needCmRecycle) {
        if (tablePath != null) {
            try {
                this.hiveShims.deleteDir(this.warehouse, tablePath, true, ifPurge, needCmRecycle, this.enableFsOperation);
            }
            catch (Exception e) {
                logger.error("Failed to delete table directory: {} {}", new Object[]{tablePath, e.getMessage(), e});
            }
        }
    }

    private void validateTableToDrop(Table table) throws MetaException {
        if (this.hiveShims.isIndexTable(table)) {
            throw new UnsupportedOperationException("Cannot drop index tables");
        }
        if (null == table.getSd()) {
            throw new MetaException("Table metadata is corrupted");
        }
    }

    public boolean updatePartitionColumnStatistics(String catalogId, ColumnStatistics columnStatistics) throws TException {
        if (columnStatistics.getStatsDesc() == null) {
            throw new MetaException("columnStatistics desc is null");
        }
        Table tbl = this.getTable(catalogId, columnStatistics.getStatsDesc().getDbName(), columnStatistics.getStatsDesc().getTableName());
        return this.commonMetaStoreClientDelegate.updatePartitionColumnStatistics(catalogId, tbl, columnStatistics);
    }

    public boolean updateTableColumnStatistics(String catalogId, ColumnStatistics columnStatistics) throws TException {
        return this.commonMetaStoreClientDelegate.updateTableColumnStatistics(catalogId, columnStatistics);
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> addPartitions(String catalogId, List<org.apache.hadoop.hive.metastore.api.Partition> partitions, boolean ifNotExist, boolean needResult) throws TException, MetaException {
        if (CollectionUtils.isEmpty(partitions)) {
            return needResult ? Lists.newArrayList() : null;
        }
        org.apache.hadoop.hive.metastore.api.Partition firstPartition = partitions.get(0);
        String dbName = firstPartition.getDbName();
        String tableName = firstPartition.getTableName();
        org.apache.hadoop.hive.metastore.api.Database db = this.getDatabase(catalogId, dbName);
        this.validateDbTblAndPartitionNames(partitions, firstPartition.getDbName(), firstPartition.getTableName());
        this.validateNoDuplicatePartitions(partitions);
        Table table = this.getTable(catalogId, firstPartition.getDbName(), firstPartition.getTableName());
        boolean success = false;
        HashSet dirsCreated = new HashSet(partitions.size());
        ArrayList<PartitionInput> catalogPartitions = new ArrayList<PartitionInput>(partitions.size());
        try {
            Object partition2;
            for (Object partition2 : partitions) {
                Optional<String> dirCreated = this.createLocationForAddedPartition(table, (org.apache.hadoop.hive.metastore.api.Partition)partition2);
                dirCreated.ifPresent(dirsCreated::add);
                this.initAddedPartition(table, (org.apache.hadoop.hive.metastore.api.Partition)partition2, dirCreated.isPresent());
                catalogPartitions.add(HiveToCatalogConverter.toCatalogPartitionInput((org.apache.hadoop.hive.metastore.api.Partition)partition2));
            }
            List result = this.dataLakeMetaStore.addPartitions(catalogId, dbName, tableName, catalogPartitions, ifNotExist, needResult);
            success = true;
            if (needResult && result != null) {
                partition2 = result.stream().map(r -> CatalogToHiveConverter.toHivePartition((Partition)r)).collect(Collectors.toList());
                return partition2;
            }
            partition2 = null;
            return partition2;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to add partitions: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
        finally {
            if (!success) {
                for (String dir : dirsCreated) {
                    this.hiveShims.deleteDir(this.warehouse, new Path(dir), true, db, this.enableFsOperation);
                }
            }
        }
    }

    private void validateDbTblAndPartitionNames(List<org.apache.hadoop.hive.metastore.api.Partition> partitions, String dbName, String tblName) throws MetaException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)dbName)) {
            throw new MetaException("Database name is blank");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)tblName)) {
            throw new MetaException("Table name is blank");
        }
        for (org.apache.hadoop.hive.metastore.api.Partition part : partitions) {
            if (!dbName.trim().equalsIgnoreCase(part.getDbName().trim()) || !tblName.trim().equalsIgnoreCase(part.getTableName().trim())) {
                throw new MetaException("Partition does not belong to target table " + dbName + "." + tblName + ": " + part);
            }
            if (part.getValues() == null) {
                throw new MetaException("Partition values cannot be null");
            }
            this.hiveShims.validatePartitionNameCharacters(part.getValues(), this.partitionValidationPattern);
        }
    }

    private void validateNoDuplicatePartitions(List<org.apache.hadoop.hive.metastore.api.Partition> partitions) throws MetaException {
        HashSet<PartValueEqWrapper> partitionsToAdd = new HashSet<PartValueEqWrapper>(partitions.size());
        for (org.apache.hadoop.hive.metastore.api.Partition partition : partitions) {
            if (partitionsToAdd.add(new PartValueEqWrapper(partition.getValues()))) continue;
            throw new MetaException("Duplicate partitions in the list: " + partition);
        }
    }

    private Optional<String> createLocationForAddedPartition(Table table, org.apache.hadoop.hive.metastore.api.Partition partition) throws MetaException {
        Path absolutePath = null;
        String relativeLocation = null;
        if (partition.getSd() == null || partition.getSd().getLocation() == null) {
            if (table.getSd().getLocation() != null) {
                relativeLocation = Warehouse.makePartName((List)table.getPartitionKeys(), (List)partition.getValues());
                absolutePath = new Path(table.getSd().getLocation(), relativeLocation);
            }
        } else {
            if (table.getSd().getLocation() == null) {
                throw new MetaException("Cannot specify location for a view partition");
            }
            absolutePath = this.warehouse.getDnsPath(new Path(partition.getSd().getLocation()));
        }
        if (absolutePath != null) {
            partition.getSd().setLocation(absolutePath.toString());
            if (!this.warehouse.isDir(absolutePath)) {
                if (!this.hiveShims.mkdirs(this.warehouse, absolutePath, true, this.enableFsOperation)) {
                    throw new MetaException(absolutePath + " is not a directory or unable to create one");
                }
                return Optional.of(absolutePath.toString());
            }
        }
        return Optional.empty();
    }

    private void initAddedPartition(Table table, org.apache.hadoop.hive.metastore.api.Partition partition, boolean madeDir) throws MetaException {
        if (MetastoreConf.getBoolVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_AUTO_GATHER) && !this.hiveShims.isView(table)) {
            this.hiveShims.updatePartitionStatsFast(partition, table, this.warehouse, madeDir, false, null, true);
        }
        this.inheritTableParameters(table, partition);
    }

    private void inheritTableParameters(Table table, org.apache.hadoop.hive.metastore.api.Partition partition) {
        Map tblParams = table.getParameters();
        String inheritProps = MetastoreConf.getVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PART_INHERIT_TBL_PROPS).trim();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)inheritProps)) {
            return;
        }
        Set<String> inheritKeys = new HashSet<String>(Arrays.asList(inheritProps.split(",")));
        if (inheritKeys.contains("*")) {
            inheritKeys = tblParams.keySet();
        }
        for (String key : inheritKeys) {
            String paramVal = (String)tblParams.get(key);
            if (null == paramVal) continue;
            partition.putToParameters(key, paramVal);
        }
    }

    public int addPartitionsSpecProxy(String catalogId, PartitionSpecProxy pSpec) throws TException {
        List partSpecs = pSpec.toPartitionSpec();
        if (partSpecs.isEmpty()) {
            return 0;
        }
        if (!((PartitionSpec)partSpecs.get(0)).isSetCatName()) {
            partSpecs.forEach(ps -> ps.setCatName(catalogId));
        }
        String dbName = ((PartitionSpec)partSpecs.get(0)).getDbName();
        String tableName = ((PartitionSpec)partSpecs.get(0)).getTableName();
        boolean ifNotExist = false;
        boolean needResult = true;
        org.apache.hadoop.hive.metastore.api.Database db = this.getDatabase(catalogId, dbName);
        for (PartitionSpec spc : partSpecs) {
            if (spc.isSetPartitionList()) {
                this.validateDbTblAndPartitionNames(spc.getPartitionList().getPartitions(), dbName, tableName);
                this.validateNoDuplicatePartitions(spc.getPartitionList().getPartitions());
                continue;
            }
            if (spc.isSetSharedSDPartitionSpec()) {
                this.validateDbTblAndPartitionNames(this.getPspecWithSd(spc), dbName, tableName);
                this.validateNoDuplicatePartitions(this.getPspecWithSd(spc));
                continue;
            }
            throw new MetaException("failed to addPartitionsSpecProxy: PartitionSpec's type is unknown");
        }
        Table table = this.getTable(catalogId, dbName, tableName);
        boolean success = false;
        HashSet dirsCreated = new HashSet(pSpec.size());
        ArrayList<PartitionInput> catalogPartitions = new ArrayList<PartitionInput>(pSpec.size());
        try {
            PartitionSpecProxy.PartitionIterator iterator = pSpec.getPartitionIterator();
            while (iterator.hasNext()) {
                org.apache.hadoop.hive.metastore.api.Partition part = (org.apache.hadoop.hive.metastore.api.Partition)iterator.next();
                Optional<String> dirCreated = this.createLocationForAddedPartition(table, part);
                dirCreated.ifPresent(dirsCreated::add);
                this.initAddedPartition(table, part, dirCreated.isPresent());
                catalogPartitions.add(HiveToCatalogConverter.toCatalogPartitionInput((org.apache.hadoop.hive.metastore.api.Partition)part));
            }
            List result = this.dataLakeMetaStore.addPartitions(catalogId, dbName, tableName, catalogPartitions, ifNotExist, needResult);
            success = true;
            if (needResult && result != null) {
                int n = result.size();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to add partitions: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
        finally {
            if (!success) {
                for (String dir : dirsCreated) {
                    this.hiveShims.deleteDir(this.warehouse, new Path(dir), true, db, this.enableFsOperation);
                }
            }
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> getPspecWithSd(PartitionSpec spc) {
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> partitions = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        for (PartitionWithoutSD partWithoutSD : spc.getSharedSDPartitionSpec().getPartitions()) {
            StorageDescriptor partSD = new StorageDescriptor(spc.getSharedSDPartitionSpec().getSd());
            partSD.setLocation(partSD.getLocation() + partWithoutSD.getRelativePath());
            partitions.add(new org.apache.hadoop.hive.metastore.api.Partition(partWithoutSD.getValues(), spc.getDbName(), spc.getTableName(), partWithoutSD.getCreateTime(), partWithoutSD.getLastAccessTime(), partSD, partWithoutSD.getParameters()));
        }
        return partitions;
    }

    public void alterPartitions(String catalogId, String dbName, String tblName, List<org.apache.hadoop.hive.metastore.api.Partition> partitions, EnvironmentContext environmentContext) throws TException {
        if (CollectionUtils.isEmpty(partitions)) {
            return;
        }
        this.validateDbTblAndPartitionNames(partitions, dbName, tblName);
        this.validateNoDuplicatePartitions(partitions);
        ArrayList<PartitionInput> catalogPartitions = new ArrayList<PartitionInput>(partitions.size());
        Table table = this.getTable(catalogId, dbName, tblName);
        for (org.apache.hadoop.hive.metastore.api.Partition partition : partitions) {
            String newLocation;
            if (partition.getSd() != null && org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)(newLocation = partition.getSd().getLocation()))) {
                Path newPath = this.warehouse.getDnsPath(new Path(newLocation));
                partition.getSd().setLocation(newPath.toString());
            }
            this.updatePartitionStatsFast(catalogId, dbName, tblName, table, partition.getValues(), partition, environmentContext, false);
            catalogPartitions.add(HiveToCatalogConverter.toCatalogPartitionInput((org.apache.hadoop.hive.metastore.api.Partition)partition));
        }
        try {
            this.dataLakeMetaStore.alterPartitions(catalogId, dbName, tblName, catalogPartitions);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to alter partitions: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public org.apache.hadoop.hive.metastore.api.Partition appendPartition(String catalogId, String dbName, String tblName, List<String> values) throws TException {
        Table table = this.getTable(catalogId, dbName, tblName);
        if (table.getSd().getLocation() == null) {
            throw new MetaException("Cannot append a partition to a view");
        }
        org.apache.hadoop.hive.metastore.api.Partition partition = new org.apache.hadoop.hive.metastore.api.Partition();
        partition.setDbName(dbName);
        partition.setTableName(tblName);
        partition.setValues(values);
        partition.setSd(table.getSd().deepCopy());
        String partName = Warehouse.makePartName((List)table.getPartitionKeys(), values);
        Path partLocation = new Path(table.getSd().getLocation(), partName);
        partition.getSd().setLocation(partLocation.toString());
        List<org.apache.hadoop.hive.metastore.api.Partition> partitions = this.addPartitions(catalogId, Lists.newArrayList((Object[])new org.apache.hadoop.hive.metastore.api.Partition[]{partition}), false, true);
        if (partitions.size() != 1) {
            throw new MetaException("Unable to add partition: " + values);
        }
        return partitions.get(0);
    }

    public org.apache.hadoop.hive.metastore.api.Partition appendPartition(String catalogId, String dbName, String tblName, String partitionName) throws TException {
        Table table = this.getTable(catalogId, dbName, tblName);
        List<String> partValues = this.getPartValsFromName(table, partitionName);
        return this.appendPartition(catalogId, dbName, tblName, partValues);
    }

    private List<String> getPartValsFromName(Table table, String partName) throws MetaException, InvalidObjectException {
        LinkedHashMap hm = Warehouse.makeSpecFromName((String)partName);
        ArrayList<String> partVals = new ArrayList<String>(table.getPartitionKeys().size());
        for (FieldSchema field : table.getPartitionKeys()) {
            String key = field.getName();
            String val = (String)hm.get(key);
            if (val == null) {
                throw new InvalidObjectException("incomplete partition name - missing " + key);
            }
            partVals.add(val);
        }
        return partVals;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean listPartitionsByExpr(String catalogId, String dbName, String tblName, byte[] expr, String defaultPartName, int max, List<org.apache.hadoop.hive.metastore.api.Partition> result) throws TException {
        ExpressionTree exprTree = PartFilterExprUtil.makeExpressionTree((PartitionExpressionProxy)this.expressionProxy, (byte[])expr);
        boolean hasUnknownPartitions = false;
        if (exprTree != null) {
            String filter = DlfMetaStoreClientDelegate.convertToFilter(expr, this.expressionProxy);
            try {
                List partitions = (List)this.dataLakeMetaStore.listPartitionsByExpr(catalogId, dbName, tblName, expr, defaultPartName, max, filter, this.pageSize, (IDataLakeMetaStore.PartitionVisitor)new PartitionToHiveVisitor());
                if (partitions == null) return hasUnknownPartitions;
                result.addAll(partitions);
                return hasUnknownPartitions;
            }
            catch (DataLakeAPIException e) {
                throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
            }
            catch (Exception e) {
                String msg = "Unable to list partitions: ";
                logger.error(msg, (Throwable)e);
                throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
            }
        } else {
            List<String> partitionNames = this.listPartitionNames(catalogId, dbName, tblName, Lists.newArrayList(), max);
            Table table = this.getTable(catalogId, dbName, tblName);
            hasUnknownPartitions = this.getPartitionNamesPrunedByExpr(table, expr, defaultPartName, partitionNames);
            if (!CollectionUtils.isNotEmpty(partitionNames)) return hasUnknownPartitions;
            result.addAll(this.getPartitionsByNames(catalogId, dbName, tblName, partitionNames));
        }
        return hasUnknownPartitions;
    }

    private boolean getPartitionNamesPrunedByExpr(Table table, byte[] expr, String defaultPartName, List<String> result) throws MetaException {
        if (defaultPartName == null || defaultPartName.isEmpty()) {
            defaultPartName = MetastoreConf.getVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DEFAULTPARTITIONNAME);
        }
        return this.hiveShims.filterPartitionsByExpr(this.expressionProxy, table.getPartitionKeys(), expr, defaultPartName, result);
    }

    private List<org.apache.hadoop.hive.metastore.api.Partition> dropPartitions(String catalogId, List<org.apache.hadoop.hive.metastore.api.Partition> partitionsToDelete, boolean ifExist, boolean deleteData, boolean purgeData) throws TException {
        if (CollectionUtils.isEmpty(partitionsToDelete)) {
            return Lists.newArrayList();
        }
        org.apache.hadoop.hive.metastore.api.Partition firstPartition = partitionsToDelete.get(0);
        String dbName = firstPartition.getDbName();
        String tableName = firstPartition.getTableName();
        boolean isSourceOfReplication = ReplChangeManager.isSourceOfReplication((org.apache.hadoop.hive.metastore.api.Database)this.getDatabase(catalogId, dbName));
        this.validateDbTblAndPartitionNames(partitionsToDelete, dbName, tableName);
        this.validateNoDuplicatePartitions(partitionsToDelete);
        Table table = this.getTable(catalogId, dbName, tableName);
        boolean isExternalTbl = this.hiveShims.isExternalTable(table);
        boolean mustPurge = DlfMetaStoreClientDelegate.isMustPurge(purgeData, table);
        boolean shouldDelete = deleteData && !isExternalTbl;
        ArrayList dirsToDelete = new ArrayList();
        ArrayList archToDelete = new ArrayList();
        try {
            ArrayList<List<String>> partValuesList = new ArrayList<List<String>>(partitionsToDelete.size());
            for (org.apache.hadoop.hive.metastore.api.Partition part : partitionsToDelete) {
                partValuesList.add(part.getValues());
                Optional<Path> archiveToDelete = this.getArchiveToDelete(mustPurge, shouldDelete, part, this.getObjectName(dbName, tableName, part));
                archiveToDelete.ifPresent(archToDelete::add);
                Optional<PathAndPartValSize> dirToDelete = this.getDirToDelete(mustPurge, shouldDelete, part, this.getObjectName(dbName, tableName, part));
                dirToDelete.ifPresent(dirsToDelete::add);
            }
            List<org.apache.hadoop.hive.metastore.api.Partition> deleted = this.doDropPartitions(catalogId, dbName, tableName, partValuesList, ifExist, partitionsToDelete);
            if (shouldDelete) {
                logger.info(mustPurge ? "dropPartition() will purge partition-directories directly, skipping trash." : "dropPartition() will move partition-directories to trash-directory.");
                for (Path path : archToDelete) {
                    this.hiveShims.deleteDir(this.warehouse, path, true, mustPurge, isSourceOfReplication, this.enableFsOperation);
                }
                for (PathAndPartValSize p : dirsToDelete) {
                    this.hiveShims.deleteDir(this.warehouse, p.getPath(), true, mustPurge, isSourceOfReplication, this.enableFsOperation);
                    try {
                        this.deleteParentRecursive(p.getPath().getParent(), p.getPartValSize() - 1, mustPurge, isSourceOfReplication);
                    }
                    catch (IOException ex) {
                        logger.warn("Error from deleteParentRecursive", (Throwable)ex);
                        throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException("Failed to delete parent: " + ex.getMessage()), (Exception)ex);
                    }
                }
            }
            return deleted;
        }
        catch (Exception e) {
            String message = "Unable to drop partitions: ";
            logger.error(message, (Throwable)e);
            if (e instanceof MetaException) {
                throw e;
            }
            throw new MetaException(message + e);
        }
    }

    private Optional<Path> getArchiveToDelete(boolean mustPurge, boolean shouldDelete, org.apache.hadoop.hive.metastore.api.Partition part, String objectName) throws MetaException {
        if (part.getParameters() != null && this.hiveShims.isArchived(part)) {
            Path archiveParentDir = this.hiveShims.getOriginalLocation(part);
            this.verifyPathRemovable(mustPurge, shouldDelete, objectName, archiveParentDir);
            return Optional.of(archiveParentDir);
        }
        return Optional.empty();
    }

    private void verifyPathRemovable(boolean mustPurge, boolean shouldDelete, String objectName, Path path) throws MetaException {
        this.verifyIsWritablePath(path);
    }

    private String getObjectName(String dbName, String tableName, org.apache.hadoop.hive.metastore.api.Partition part) {
        return dbName + "." + tableName + "." + part.getValues();
    }

    private void deleteParentRecursive(Path parent, int depth, boolean mustPurge, boolean isSourceOfReplication) throws IOException, MetaException {
        if (depth > 0 && parent != null && this.warehouse.isWritable(parent)) {
            if (this.warehouse.isDir(parent) && Utils.isEmptyDir((Warehouse)this.warehouse, (Path)parent)) {
                this.hiveShims.deleteDir(this.warehouse, parent, true, mustPurge, isSourceOfReplication, this.enableFsOperation);
            }
            this.deleteParentRecursive(parent.getParent(), depth - 1, mustPurge, isSourceOfReplication);
        }
    }

    private void verifyIsWritablePath(Path dir) throws MetaException {
        try {
            if (!this.warehouse.isWritable(dir.getParent())) {
                throw new MetaException("Table partition not deleted since " + dir.getParent() + " is not writable by " + SecurityUtils.getUser());
            }
        }
        catch (IOException ex) {
            logger.warn("Error from isWritable", (Throwable)ex);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException("Table partition not deleted since " + dir.getParent() + " access cannot be checked: " + ex.getMessage()), (Exception)ex);
        }
    }

    private Optional<PathAndPartValSize> getDirToDelete(boolean mustPurge, boolean shouldDelete, org.apache.hadoop.hive.metastore.api.Partition part, String objectName) throws MetaException {
        if (part.getSd() != null && part.getSd().getLocation() != null) {
            Path partPath = new Path(part.getSd().getLocation());
            this.verifyPathRemovable(mustPurge, shouldDelete, objectName, partPath);
            return Optional.of(new PathAndPartValSize(partPath, part.getValues().size()));
        }
        return Optional.empty();
    }

    private List<org.apache.hadoop.hive.metastore.api.Partition> doDropPartitions(String catalogId, String dbName, String tableName, List<List<String>> partValuesList, boolean ifExist, List<org.apache.hadoop.hive.metastore.api.Partition> partitionsToDelete) throws TException {
        try {
            this.dataLakeMetaStore.doDropPartitions(catalogId, dbName, tableName, partValuesList, ifExist);
            return partitionsToDelete;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to do drop partitions: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public boolean dropPartition(String catalogId, String dbName, String tblName, List<String> values, boolean ifExists, boolean deleteData, boolean purgeData) throws TException {
        try {
            org.apache.hadoop.hive.metastore.api.Partition partition = this.getPartition(catalogId, dbName, tblName, values);
            List<org.apache.hadoop.hive.metastore.api.Partition> result = this.dropPartitions(catalogId, Lists.newArrayList((Object[])new org.apache.hadoop.hive.metastore.api.Partition[]{partition}), ifExists, deleteData, purgeData);
            return result.size() > 0;
        }
        catch (NoSuchObjectException e) {
            if (!ifExists) {
                throw e;
            }
            return true;
        }
    }

    public org.apache.hadoop.hive.metastore.api.Partition getPartition(String catalogId, String dbName, String tblName, List<String> partitionValues) throws TException {
        return this.getPartition(catalogId, dbName, tblName, partitionValues, null);
    }

    public org.apache.hadoop.hive.metastore.api.Partition getPartition(String catalogId, String dbName, String tblName, String partitionName) throws TException {
        List<String> partitionValues;
        Table table = this.getTable(catalogId, dbName, tblName);
        try {
            partitionValues = this.partitionNameToValues(partitionName, table.getPartitionKeys());
        }
        catch (InvalidObjectException exception) {
            throw (NoSuchObjectException)DataLakeUtil.throwException((Throwable)new NoSuchObjectException(), (Exception)((Object)exception));
        }
        return this.getPartition(catalogId, dbName, tblName, partitionValues, table);
    }

    private org.apache.hadoop.hive.metastore.api.Partition getPartition(String catalogId, String databaseName, String tableName, List<String> parValues, Table table) throws TException {
        try {
            Partition partition = this.dataLakeMetaStore.getPartition(catalogId, databaseName, tableName, parValues);
            return CatalogToHiveConverter.toHivePartition((Partition)partition);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to get partition: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    private List<String> partitionNameToValues(String partName, List<FieldSchema> partitionKeys) throws MetaException, InvalidObjectException {
        LinkedHashMap hm = Warehouse.makeSpecFromName((String)partName);
        ArrayList<String> partVals = new ArrayList<String>();
        for (FieldSchema field : partitionKeys) {
            String key = field.getName();
            String val = (String)hm.get(key);
            if (val == null) {
                throw new InvalidObjectException("incomplete partition name - missing " + key);
            }
            partVals.add(val);
        }
        return partVals;
    }

    private List<String> partitionNameToValues(String name) throws TException {
        if (name.length() == 0) {
            return new ArrayList<String>();
        }
        LinkedHashMap map = Warehouse.makeSpecFromName((String)name);
        return new ArrayList<String>(map.values());
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatisticsObj(String catalogId, String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws TException {
        return this.commonMetaStoreClientDelegate.getPartitionColumnStatisticsObj(catalogId, dbName, tableName, partitionNames, columnNames);
    }

    public Map<String, ColumnStatistics> getPartitionColumnStatistics(String catalogId, String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws TException {
        return this.commonMetaStoreClientDelegate.getPartitionColumnStatistics(catalogId, dbName, tableName, partitionNames, columnNames);
    }

    public boolean setPartitionColumnStatistics(String catalogId, SetPartitionsStatsRequest request) throws TException {
        boolean ret = true;
        List csNews = request.getColStats();
        if (csNews == null || csNews.isEmpty()) {
            return ret;
        }
        ColumnStatistics firstColStats = (ColumnStatistics)csNews.get(0);
        ColumnStatisticsDesc statsDesc = firstColStats.getStatsDesc();
        String dbName = statsDesc.getDbName();
        String tableName = statsDesc.getTableName();
        Table t = this.getTable(catalogId, dbName, tableName);
        ArrayList<String> partitionNames = new ArrayList<String>();
        List<Object> partitions = new ArrayList();
        if (!statsDesc.isIsTblLevel()) {
            for (ColumnStatistics csNew : csNews) {
                String partName = csNew.getStatsDesc().getPartName();
                partitionNames.add(partName);
            }
            partitions = this.getPartitionsByNames(catalogId, dbName, tableName, partitionNames);
        }
        return this.commonMetaStoreClientDelegate.setPartitionColumnStatistics(catalogId, request, t, partitions);
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> getPartitionsByNames(String catalogId, String dbName, String tblName, List<String> partitionNames) throws TException {
        ArrayList<List<String>> partValuesList = new ArrayList<List<String>>(partitionNames.size());
        for (String partitionName : partitionNames) {
            partValuesList.add(this.partitionNameToValues(partitionName));
        }
        return this.getPartitionsByValues(catalogId, dbName, tblName, partValuesList);
    }

    private List<org.apache.hadoop.hive.metastore.api.Partition> getPartitionsByValues(String catalogId, String databaseName, String tableName, List<List<String>> partValuesList) throws TException {
        try {
            List result = this.dataLakeMetaStore.getPartitionsByValues(catalogId, databaseName, tableName, partValuesList);
            return result.stream().map(CatalogToHiveConverter::toHivePartition).collect(Collectors.toList());
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "unable to get partition by values:";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public void renamePartition(String catalogId, String dbName, String tblName, List<String> partValues, org.apache.hadoop.hive.metastore.api.Partition newPartition) throws TException {
        org.apache.hadoop.hive.metastore.api.Partition oldPartition;
        Table table = this.getTable(catalogId, dbName, tblName);
        try {
            oldPartition = this.getPartition(catalogId, dbName, tblName, partValues);
        }
        catch (NoSuchObjectException e) {
            throw (InvalidObjectException)DataLakeUtil.throwException((Throwable)new InvalidObjectException(e.getMessage()), (Exception)((Object)e));
        }
        if (newPartition.getSd() == null || oldPartition.getSd() == null) {
            throw new InvalidObjectException("Storage descriptor cannot be null");
        }
        if (!Strings.isNullOrEmpty((String)table.getTableType()) && table.getTableType().equalsIgnoreCase(TableType.EXTERNAL_TABLE.toString())) {
            newPartition.getSd().setLocation(oldPartition.getSd().getLocation());
            this.renamePartitionInCatalog(catalogId, table, partValues, newPartition);
        } else {
            Path destPath = this.getDestinationPathForRename(table, newPartition, oldPartition);
            Path srcPath = new Path(oldPartition.getSd().getLocation());
            FileSystem srcFs = this.warehouse.getFs(srcPath);
            FileSystem destFs = this.warehouse.getFs(destPath);
            this.verifyDestinationLocation(srcFs, destFs, srcPath, destPath, table, newPartition);
            newPartition.getSd().setLocation(destPath.toString());
            boolean dataWasMoved = false;
            try {
                if (srcFs.exists(srcPath)) {
                    Path destParentPath = destPath.getParent();
                    if (!this.hiveShims.mkdirs(this.warehouse, destParentPath, true, Boolean.valueOf(this.enableRenameFileOperation))) {
                        throw new IOException("Unable to create path " + destParentPath);
                    }
                    if (Utils.renameDir((Warehouse)this.warehouse, (Path)srcPath, (Path)destPath, (boolean)true, (boolean)this.enableRenameFileOperation)) {
                        dataWasMoved = true;
                    }
                }
            }
            catch (IOException e) {
                throw (InvalidOperationException)DataLakeUtil.throwException((Throwable)new InvalidOperationException(String.format("Unable to access old location %s for partition %s.%s %s", srcPath, table.getDbName(), table.getTableName(), partValues)), (Exception)e);
            }
            try {
                this.updatePartitionStatsFast(catalogId, dbName, tblName, table, partValues, newPartition, null, true);
                this.renamePartitionInCatalog(catalogId, table, partValues, newPartition);
            }
            catch (Exception e) {
                if (dataWasMoved && !Utils.tryRename((FileSystem)destFs, (Path)destPath, (Path)srcPath, (boolean)this.enableRenameFileOperation)) {
                    logger.error("Failed to restore data from {} to {} in alter table failure. Manual restore is needed.", new Object[]{destPath, srcPath, e});
                }
                throw e;
            }
        }
    }

    public void updatePartitionStatsFast(String catalogId, String dbName, String tblName, Table table, List<String> partVals, org.apache.hadoop.hive.metastore.api.Partition partition, EnvironmentContext environmentContext, boolean isRename) throws TException {
        org.apache.hadoop.hive.metastore.api.Partition oldPart = this.getPartition(catalogId, dbName, tblName, partVals);
        if (this.hiveShims.requireCalStats(this.conf, oldPart, partition, table, environmentContext)) {
            if (this.hiveShims.isFastStatsSame(oldPart, partition) && !isRename) {
                this.hiveShims.updateBasicState(environmentContext, partition.getParameters());
            } else {
                this.hiveShims.updatePartitionStatsFast(partition, table, this.warehouse, false, true, environmentContext, false);
            }
        }
    }

    private void verifyDestinationLocation(FileSystem srcFs, FileSystem destFs, Path srcPath, Path destPath, Table tbl, org.apache.hadoop.hive.metastore.api.Partition newPartition) throws InvalidOperationException {
        String oldPartLoc = srcPath.toString();
        String newPartLoc = destPath.toString();
        if (!org.apache.hadoop.hive.common.FileUtils.equalsFileSystem((FileSystem)srcFs, (FileSystem)destFs)) {
            throw new InvalidOperationException(String.format("table new location %s is on a different file system than the old location %s. This operation is not supported", destPath, srcPath));
        }
        try {
            srcFs.exists(srcPath);
            if (this.enableRenameFileOperation && newPartLoc.compareTo(oldPartLoc) != 0 && destFs.exists(destPath)) {
                throw new InvalidOperationException(String.format("New location for this partition %s.%s.%s already exists : %s", tbl.getDbName(), tbl.getTableName(), newPartition.getValues(), destPath));
            }
        }
        catch (IOException e) {
            throw (InvalidOperationException)DataLakeUtil.throwException((Throwable)new InvalidOperationException(String.format("Unable to access new location %s for partition %s.%s %s", destPath, tbl.getDbName(), tbl.getTableName(), newPartition.getValues())), (Exception)e);
        }
    }

    private void renamePartitionInCatalog(String catalogId, Table table, List<String> partitionValues, org.apache.hadoop.hive.metastore.api.Partition newPartition) throws TException {
        try {
            this.dataLakeMetaStore.renamePartitionInCatalog(catalogId, table.getDbName(), table.getTableName(), partitionValues, HiveToCatalogConverter.toCatalogPartitionInput((org.apache.hadoop.hive.metastore.api.Partition)newPartition));
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "unable to rename partition";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    private Path getDestinationPathForRename(Table table, org.apache.hadoop.hive.metastore.api.Partition newPartition, org.apache.hadoop.hive.metastore.api.Partition oldPartition) throws TException {
        if (table.getSd().getLocation() == null) {
            throw new MetaException("The table location is null");
        }
        List partKeys = table.getPartitionKeys();
        if (partKeys == null || partKeys.size() != newPartition.getValues().size()) {
            throw new MetaException("Invalid number of partition keys found for " + table.getTableName());
        }
        Map partSpec = Warehouse.makeSpecFromValues((List)table.getPartitionKeys(), (List)newPartition.getValues());
        Path tablePath = this.warehouse.getDnsPath(new Path(table.getSd().getLocation()));
        Path destPath = this.warehouse.getPartitionPath(tablePath, partSpec);
        return Utils.constructRenamedPath((Path)destPath, (Path)new Path(oldPartition.getSd().getLocation()));
    }

    private boolean tryRename(FileSystem fileSystem, Path src, Path dest) {
        try {
            return fileSystem.exists(src) && fileSystem.rename(src, dest);
        }
        catch (IOException ignored) {
            return false;
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> dropPartitions(String catalogId, String dbName, String tableName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean purgeData, boolean needResult) throws TException {
        ArrayList toBeDeleted = Lists.newArrayList();
        for (ObjectPair<Integer, byte[]> expr : partExprs) {
            this.listPartitionsByExpr(catalogId, dbName, tableName, (byte[])expr.getSecond(), null, -1, toBeDeleted);
        }
        List<org.apache.hadoop.hive.metastore.api.Partition> deleted = this.dropPartitions(catalogId, toBeDeleted, false, deleteData, purgeData);
        return needResult ? deleted : null;
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> dropPartitions(String catalogId, String dbName, String tableName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean purgeData, boolean ifExist, boolean needResult) throws TException {
        ArrayList toBeDeleted = Lists.newArrayList();
        for (ObjectPair<Integer, byte[]> expr : partExprs) {
            this.listPartitionsByExpr(catalogId, dbName, tableName, (byte[])expr.getSecond(), null, -1, toBeDeleted);
        }
        List<org.apache.hadoop.hive.metastore.api.Partition> deleted = this.dropPartitions(catalogId, toBeDeleted, ifExist, deleteData, purgeData);
        return needResult ? deleted : null;
    }

    public List<String> listPartitionNames(String catalogId, String dbName, String tblName, List<String> partialPartValues, int max) throws TException {
        try {
            Table table = this.getTable(catalogId, dbName, tblName);
            if (table.getPartitionKeys() == null || table.getPartitionKeys().size() == 0) {
                return new ArrayList<String>();
            }
            return this.dataLakeMetaStore.listPartitionNames(catalogId, dbName, tblName, partialPartValues, max, this.pageSize);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to list partitions names: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public int getNumPartitionsByFilter(String catalogId, String dbName, String tblName, String filter) throws TException {
        try {
            return this.dataLakeMetaStore.getNumPartitionsByFilter(catalogId, dbName, tblName, filter, this.pageSize);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to list NumPartitionsByFilter: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public List<PartitionSpec> listPartitionSpecs(String catalogId, String databaseName, String tableName, int max) throws TException {
        String cateName = catalogId.toLowerCase();
        String dbName = databaseName.toLowerCase();
        String tblName = tableName.toLowerCase();
        List<PartitionSpec> partitionSpecs = null;
        try {
            Table table = this.getTable(cateName, dbName, tableName);
            List partitions = (List)this.dataLakeMetaStore.listPartitions(cateName, dbName, tblName, max, this.pageSize, (IDataLakeMetaStore.PartitionVisitor)new PartitionToHiveVisitor());
            if (DlfMetaStoreClientDelegate.is_partition_spec_grouping_enabled(table)) {
                partitionSpecs = this.get_partitionspecs_grouped_by_storage_descriptor(table, partitions);
            } else {
                PartitionSpec pSpec = new PartitionSpec();
                pSpec.setPartitionList(new PartitionListComposingSpec(partitions));
                pSpec.setCatName(cateName);
                pSpec.setDbName(dbName);
                pSpec.setTableName(tblName);
                pSpec.setRootPath(table.getSd().getLocation());
                partitionSpecs = Arrays.asList(pSpec);
            }
            return partitionSpecs;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to list listPartitionSpecs: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    private List<PartitionSpec> get_partitionspecs_grouped_by_storage_descriptor(Table table, List<org.apache.hadoop.hive.metastore.api.Partition> partitions) throws NoSuchObjectException, MetaException {
        ImmutableList partitionsOutsideTableDir;
        assert (DlfMetaStoreClientDelegate.is_partition_spec_grouping_enabled(table));
        final String tablePath = table.getSd().getLocation();
        ImmutableListMultimap partitionsWithinTableDirectory = Multimaps.index(partitions, (com.google.common.base.Function)new com.google.common.base.Function<org.apache.hadoop.hive.metastore.api.Partition, Boolean>(){

            public Boolean apply(org.apache.hadoop.hive.metastore.api.Partition input) {
                return input.getSd().getLocation().startsWith(tablePath);
            }
        });
        ArrayList<PartitionSpec> partSpecs = new ArrayList<PartitionSpec>();
        HashMap sdToPartList = new HashMap();
        if (partitionsWithinTableDirectory.containsKey((Object)true)) {
            ImmutableList partsWithinTableDir = partitionsWithinTableDirectory.get((Object)true);
            for (org.apache.hadoop.hive.metastore.api.Partition partition : partsWithinTableDir) {
                PartitionWithoutSD partitionWithoutSD = new PartitionWithoutSD(partition.getValues(), partition.getCreateTime(), partition.getLastAccessTime(), partition.getSd().getLocation().substring(tablePath.length()), partition.getParameters());
                StorageDescriptorKey sdKey = new StorageDescriptorKey(partition.getSd());
                if (!sdToPartList.containsKey(sdKey)) {
                    sdToPartList.put(sdKey, new ArrayList());
                }
                ((List)sdToPartList.get(sdKey)).add(partitionWithoutSD);
            }
            for (Map.Entry entry : sdToPartList.entrySet()) {
                partSpecs.add(this.getSharedSDPartSpec(table, (StorageDescriptorKey)entry.getKey(), (List)entry.getValue()));
            }
        }
        if (partitionsWithinTableDirectory.containsKey((Object)false) && !(partitionsOutsideTableDir = partitionsWithinTableDirectory.get((Object)false)).isEmpty()) {
            PartitionSpec partListSpec = new PartitionSpec();
            partListSpec.setDbName(table.getDbName());
            partListSpec.setTableName(table.getTableName());
            partListSpec.setPartitionList(new PartitionListComposingSpec((List)partitionsOutsideTableDir));
            partSpecs.add(partListSpec);
        }
        return partSpecs;
    }

    private PartitionSpec getSharedSDPartSpec(Table table, StorageDescriptorKey sdKey, List<PartitionWithoutSD> partitions) {
        StorageDescriptor sd = new StorageDescriptor(sdKey.getSd());
        sd.setLocation(table.getSd().getLocation());
        PartitionSpecWithSharedSD sharedSDPartSpec = new PartitionSpecWithSharedSD(partitions, sd);
        PartitionSpec ret = new PartitionSpec();
        ret.setRootPath(sd.getLocation());
        ret.setSharedSDPartitionSpec(sharedSDPartSpec);
        ret.setDbName(table.getDbName());
        ret.setTableName(table.getTableName());
        return ret;
    }

    public List<PartitionSpec> listPartitionSpecsByFilter(String catalogId, String dbName, String tblName, String filter, int max) throws TException {
        List<PartitionSpec> partitionSpecs = null;
        try {
            Table table = this.getTable(catalogId, dbName, tblName);
            List<org.apache.hadoop.hive.metastore.api.Partition> partitions = this.listPartitionsByFilter(catalogId, dbName, tblName, filter, max);
            if (DlfMetaStoreClientDelegate.is_partition_spec_grouping_enabled(table)) {
                partitionSpecs = this.get_partitionspecs_grouped_by_storage_descriptor(table, partitions);
            } else {
                PartitionSpec pSpec = new PartitionSpec();
                pSpec.setPartitionList(new PartitionListComposingSpec(partitions));
                pSpec.setRootPath(table.getSd().getLocation());
                pSpec.setCatName(catalogId);
                pSpec.setDbName(dbName);
                pSpec.setTableName(tblName);
                partitionSpecs = Arrays.asList(pSpec);
            }
            return partitionSpecs;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to list listPartitionSpecsByFilter: " + catalogId + "." + dbName + "." + tblName + ":" + filter;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> listPartitions(String catalogId, String dbName, String tblName, List<String> values, int max) throws TException {
        return this.listPartitionsInternal(catalogId, dbName, tblName, values, null, max);
    }

    private List<org.apache.hadoop.hive.metastore.api.Partition> listPartitionsInternal(String catalogId, String databaseName, String tableName, List<String> values, String filter, int max) throws TException {
        ArrayList<org.apache.hadoop.hive.metastore.api.Partition> partitions = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();
        if (0 == max) {
            return partitions;
        }
        Preconditions.checkArgument((org.apache.commons.lang3.StringUtils.isBlank((CharSequence)filter) || CollectionUtils.isEmpty(values) ? 1 : 0) != 0, (Object)"Filter and partial part values can not be supplied both");
        try {
            return (List)this.dataLakeMetaStore.listPartitionsInternal(catalogId, databaseName, tableName, values, filter, max, this.pageSize, (IDataLakeMetaStore.PartitionVisitor)new PartitionToHiveVisitor());
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to list partitions internal: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> listPartitionsByFilter(String catalogId, String dbName, String tblName, String partFilter, int max) throws TException {
        return this.listPartitionsInternal(catalogId, dbName, tblName, null, partFilter, max);
    }

    public List<String> partitionNameToVals(String name) throws TException {
        if (name.length() == 0) {
            return new ArrayList<String>();
        }
        LinkedHashMap map = Warehouse.makeSpecFromName((String)name);
        return new ArrayList<String>(map.values());
    }

    public void addDynamicPartitions(long txnId, String dbName, String tblName, List<String> partNames, DataOperationType operationType) {
        throw new UnsupportedOperationException("addDynamicPartitions is not supported");
    }

    public boolean createRole(Role role) {
        throw new UnsupportedOperationException("createRole is not supported");
    }

    public boolean dropRole(String roleName) {
        throw new UnsupportedOperationException("dropRole is not supported");
    }

    public List<Role> listRoles(String principalName, PrincipalType principalType) {
        if (PrincipalType.USER == principalType) {
            return implicitRoles;
        }
        throw new UnsupportedOperationException("listRoles is only supported for " + PrincipalType.USER + " Principal type");
    }

    public List<String> listRoleNames() {
        return Lists.newArrayList((Object[])new String[]{PUBLIC});
    }

    public GetPrincipalsInRoleResponse getPrincipalsInRole(GetPrincipalsInRoleRequest request) throws TException {
        throw new UnsupportedOperationException("getPrincipalsInRole is not supported");
    }

    public GetRoleGrantsForPrincipalResponse getRoleGrantsForPrincipal(GetRoleGrantsForPrincipalRequest request) throws TException {
        throw new UnsupportedOperationException("getRoleGrantsForPrincipal is not supported");
    }

    public boolean grantRole(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws TException {
        throw new UnsupportedOperationException("grantRole is not supported");
    }

    public boolean revokeRole(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws TException {
        throw new UnsupportedOperationException("revokeRole is not supported");
    }

    public PrincipalPrivilegeSet getPrivilegeSet(HiveObjectRef obj, String user, List<String> groups) {
        return null;
    }

    public boolean grantPrivileges(PrivilegeBag privileges) {
        throw new UnsupportedOperationException("grantPrivileges is not supported");
    }

    public boolean revokePrivileges(PrivilegeBag privileges, boolean grantOption) {
        throw new UnsupportedOperationException("revokePrivileges is not supported");
    }

    public List<HiveObjectPrivilege> listPrivileges(String principal, PrincipalType principalType, HiveObjectRef objectRef) throws TException {
        throw new UnsupportedOperationException("listPrivileges is not supported");
    }

    public void cancelDelegationToken(String tokenStrForm) {
    }

    public String getTokenStrForm() {
        logger.warn("getTokenStrForm is not supported by dlf client, return null result by default");
        return null;
    }

    public boolean addToken(String tokenIdentifier, String delegationToken) {
        throw new UnsupportedOperationException("addToken is not supported");
    }

    public boolean removeToken(String tokenIdentifier) {
        throw new UnsupportedOperationException("removeToken is not supported");
    }

    public String getToken(String tokenIdentifier) {
        throw new UnsupportedOperationException("getToken is not supported");
    }

    public List<String> getAllTokenIdentifiers() {
        throw new UnsupportedOperationException("getAllTokenIdentifiers is not supported");
    }

    public int addMasterKey(String key) {
        throw new UnsupportedOperationException("addMasterKey is not supported");
    }

    public void updateMasterKey(Integer seqNo, String key) {
        throw new UnsupportedOperationException("updateMasterKey is not supported");
    }

    public boolean removeMasterKey(Integer keySeq) {
        throw new UnsupportedOperationException("removeMasterKey is not supported");
    }

    public String[] getMasterKeys() {
        throw new UnsupportedOperationException("getMasterKeys is not supported");
    }

    public LockResponse checkLock(long lockId) throws TException {
        try {
            LockStatus lockStatus = this.dataLakeMetaStore.getLock(Long.valueOf(lockId));
            return CatalogToHiveConverter.toHiveLockResponse((LockStatus)lockStatus);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to checklock: " + lockId;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public void commitTxn(long txnId) {
        throw new UnsupportedOperationException("commitTxn is not supported");
    }

    public void abortTxns(List<Long> txnIds) {
        throw new UnsupportedOperationException("abortTxns is not supported");
    }

    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType) {
        throw new UnsupportedOperationException("compact is not supported");
    }

    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType, Map<String, String> tblProperties) {
        throw new UnsupportedOperationException("compact is not supported");
    }

    public CompactionResponse compact2(String dbName, String tblName, String partitionName, CompactionType compactionType, Map<String, String> tblProperties) {
        throw new UnsupportedOperationException("compact2 is not supported");
    }

    public org.apache.hadoop.hive.metastore.api.Partition exchangePartition(Map<String, String> partitionSpecs, String srcCatalogId, String srcDb, String srcTbl, String dstCatalogId, String dstDb, String dstTbl) {
        throw new UnsupportedOperationException("exchangePartition is not supported");
    }

    public List<org.apache.hadoop.hive.metastore.api.Partition> exchangePartitions(Map<String, String> partitionSpecs, String srcCatalogId, String sourceDb, String sourceTbl, String desCatalogId, String destDb, String destTbl) {
        throw new UnsupportedOperationException("exchangePartitions is not supported");
    }

    private BloomFilter createPartsBloomFilter(int maxPartsPerCacheNode, double fpp, List<String> partNames) {
        BloomFilter bloomFilter = new BloomFilter((long)maxPartsPerCacheNode, fpp);
        for (String partName : partNames) {
            bloomFilter.add(partName.getBytes());
        }
        return bloomFilter;
    }

    public AggrStats getAggrColStatsFor(String catalogId, String dbName, String tblName, List<String> colNames, List<String> partNames) throws TException {
        if (colNames.isEmpty() || partNames.isEmpty()) {
            logger.debug("Columns is empty or partNames is empty : Short-circuiting stats eval on client side.");
            return new AggrStats(new ArrayList(), 0L);
        }
        String catalogLowercase = catalogId.toLowerCase();
        String dbNameLowercase = dbName.toLowerCase();
        String tblNameLowercase = tblName.toLowerCase();
        ArrayList<String> lowerCaseColNames = new ArrayList<String>(colNames.size());
        for (String string : colNames) {
            lowerCaseColNames.add(string.toLowerCase());
        }
        ArrayList<String> lowerCasePartNames = new ArrayList<String>(partNames.size());
        for (String partName : partNames) {
            lowerCasePartNames.add(Utils.lowerCaseConvertPartName((String)partName));
        }
        PartitionsStatsRequest partitionsStatsRequest = new PartitionsStatsRequest(dbNameLowercase, tblNameLowercase, lowerCaseColNames, lowerCasePartNames);
        long partsFound = 0L;
        if (this.isAggregateStatsCacheEnabled && partNames.size() < this.aggrStatsCache.getMaxPartsPerCacheNode()) {
            int maxPartsPerCacheNode = this.aggrStatsCache.getMaxPartsPerCacheNode();
            double fpp = this.aggrStatsCache.getFalsePositiveProbability();
            ArrayList<ColumnStatisticsObj> colStatsList = new ArrayList<ColumnStatisticsObj>();
            BloomFilter bloomFilter = this.createPartsBloomFilter(maxPartsPerCacheNode, fpp, lowerCasePartNames);
            boolean computePartsFound = true;
            for (String colName : lowerCaseColNames) {
                AggregateStatsCache.AggrColStats colStatsAggrCached = this.aggrStatsCache.get(catalogLowercase, dbNameLowercase, tblNameLowercase, colName, lowerCasePartNames);
                if (colStatsAggrCached != null) {
                    colStatsList.add(colStatsAggrCached.getColStats());
                    partsFound = colStatsAggrCached.getNumPartsCached();
                    continue;
                }
                if (computePartsFound) {
                    partsFound = this.commonMetaStoreClientDelegate.partsFoundForPartitions(catalogLowercase, dbNameLowercase, tblNameLowercase, lowerCasePartNames, lowerCaseColNames);
                    computePartsFound = false;
                }
                ArrayList<String> colNamesForDB = new ArrayList<String>();
                colNamesForDB.add(colName);
                List colStatsAggrFromDB = this.commonMetaStoreClientDelegate.columnStatisticsObjForPartitions(catalogLowercase, dbNameLowercase, tblNameLowercase, lowerCasePartNames, colNamesForDB, partsFound, this.hiveShims.getDensityFunctionForNDVEstimation(this.conf), this.hiveShims.getNdvTuner(this.conf));
                if (colStatsAggrFromDB.isEmpty()) continue;
                ColumnStatisticsObj colStatsAggr = (ColumnStatisticsObj)colStatsAggrFromDB.get(0);
                colStatsList.add(colStatsAggr);
                this.aggrStatsCache.add(catalogLowercase, dbNameLowercase, tblNameLowercase, colName, partsFound, colStatsAggr, bloomFilter);
            }
            return new AggrStats(colStatsList, partsFound);
        }
        return this.commonMetaStoreClientDelegate.getAggrStatsFor(catalogId, partitionsStatsRequest);
    }

    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) {
        return null;
    }

    public List<FieldSchema> getFields(String catalogId, String db, String tableName) throws TException {
        return this.getFieldsWithEnvironmentContext(catalogId, db, tableName, null);
    }

    public List<FieldSchema> getFieldsWithEnvironmentContext(String catalogId, String db, String tableName, EnvironmentContext envContext) throws TException {
        Table tbl = this.getAndCheckTable(catalogId, db, tableName);
        return this.getFieldsWithEnvironmentContext(tableName, tbl, envContext);
    }

    private List<FieldSchema> getFieldsWithEnvironmentContext(String tableName, Table tbl, EnvironmentContext envContext) throws TException {
        List list;
        block7: {
            if (this.useInternalSerde(tbl)) {
                return tbl.getSd().getCols();
            }
            ClassLoader orgHiveLoader = null;
            Configuration curConf = this.getConf();
            try {
                String addedJars;
                if (envContext != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(addedJars = (String)envContext.getProperties().get(HiveConf.ConfVars.HIVEADDEDJARS.varname)))) {
                    orgHiveLoader = curConf.getClassLoader();
                    ClassLoader loader = this.hiveShims.addToClassPath(orgHiveLoader, org.apache.commons.lang3.StringUtils.split((String)addedJars, (String)","));
                    curConf.setClassLoader(loader);
                }
                Deserializer s = this.hiveShims.getDeserializer(curConf, tbl, false);
                list = this.hiveShims.getFieldsFromDeserializer(tableName, s);
                if (orgHiveLoader == null) break block7;
            }
            catch (Exception e) {
                try {
                    throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(e.getMessage()), (Exception)e);
                }
                catch (Throwable throwable) {
                    if (orgHiveLoader != null) {
                        curConf.setClassLoader(orgHiveLoader);
                    }
                    throw throwable;
                }
            }
            curConf.setClassLoader(orgHiveLoader);
        }
        return list;
    }

    private boolean useInternalSerde(Table tbl) {
        String serializationLib = tbl.getSd().getSerdeInfo().getSerializationLib();
        if (null == serializationLib) {
            return true;
        }
        Collection internalSerdes = MetastoreConf.getStringCollection((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.SERDES_USING_METASTORE_FOR_SCHEMA);
        return internalSerdes.contains(serializationLib);
    }

    public List<FieldSchema> getSchema(String catalogId, String db, String tableName) throws TException {
        return this.getSchemaWithEnvironmentContext(catalogId, db, tableName, null);
    }

    public List<FieldSchema> getSchemaWithEnvironmentContext(String catalogId, String db, String tableName, EnvironmentContext envContext) throws TException {
        Table tbl = this.getAndCheckTable(catalogId, db, tableName);
        List<FieldSchema> fieldSchemas = this.getFieldsWithEnvironmentContext(tableName, tbl, envContext);
        if (tbl.getPartitionKeys() != null) {
            fieldSchemas.addAll(tbl.getPartitionKeys());
        }
        return fieldSchemas;
    }

    private Table getAndCheckTable(String catalogId, String db, String tableName) throws TException {
        String[] names = tableName.split("\\.");
        String baseTableName = names[0];
        Table tbl = this.getTable(catalogId, db, baseTableName);
        if (tbl == null) {
            throw new UnknownTableException(tableName + " doesn't exist");
        }
        return tbl;
    }

    public ValidTxnList getValidTxns() {
        throw new UnsupportedOperationException("getValidTxns is not supported");
    }

    public ValidTxnList getValidTxns(long currentTxn) {
        throw new UnsupportedOperationException("getValidTxns is not supported");
    }

    public void heartbeat(long txnId, long lockId) throws TException {
        try {
            boolean bl = this.dataLakeMetaStore.refreshLock(Long.valueOf(lockId));
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to heart beat lock: " + txnId + " " + lockId;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public HeartbeatTxnRangeResponse heartbeatTxnRange(long min, long max) {
        throw new UnsupportedOperationException("heartbeatTxnRange is not supported");
    }

    public boolean isPartitionMarkedForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) {
        return false;
    }

    public List<String> listTableNamesByFilter(String catalogId, String dbName, String filter, int maxTables) {
        throw new UnsupportedOperationException();
    }

    public LockResponse lock(String catalogId, LockRequest lockRequest) throws TException {
        Preconditions.checkArgument((!lockRequest.getComponent().isEmpty() ? 1 : 0) != 0, (Object)"unable to lock with empty components");
        try {
            LockStatus lockStatus = this.dataLakeMetaStore.lock(lockRequest.getComponent().stream().map(component -> HiveToCatalogConverter.toCatalogLockObj((String)catalogId, (LockComponent)component)).collect(Collectors.toList()));
            return CatalogToHiveConverter.toHiveLockResponse((LockStatus)lockStatus);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to lock: " + lockRequest.getHostname() + " " + lockRequest.getUser();
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public void markPartitionForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) {
        throw new UnsupportedOperationException("markPartitionForEvent is not supported");
    }

    public long openTxn(String user) {
        throw new UnsupportedOperationException("openTxn is not supported");
    }

    public OpenTxnsResponse openTxns(String user, int numTxns) {
        throw new UnsupportedOperationException("openTxns is not supported");
    }

    public long renewDelegationToken(String tokenStrForm) {
        return 0L;
    }

    public void rollbackTxn(long txnId) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) {
        throw new UnsupportedOperationException();
    }

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) {
        throw new UnsupportedOperationException();
    }

    public void clearFileMetadata(List<Long> fileIds) {
        throw new UnsupportedOperationException();
    }

    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) {
        throw new UnsupportedOperationException();
    }

    public boolean cacheFileMetadata(String dbName, String tblName, String partName, boolean allParts) {
        throw new UnsupportedOperationException();
    }

    public void createTableWithConstraints(Table table, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys) {
        throw new UnsupportedOperationException("createTableWithConstraints is not supported");
    }

    public void dropConstraint(String dbName, String tblName, String constraintName) {
        throw new UnsupportedOperationException("dropConstraint is not supported");
    }

    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) {
        throw new UnsupportedOperationException("addPrimaryKey is not supported");
    }

    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) {
        throw new UnsupportedOperationException("addForeignKey is not supported");
    }

    public ShowCompactResponse showCompactions() {
        throw new UnsupportedOperationException("showCompactions is not supported");
    }

    public void insertTable(Table table, boolean overwrite) {
        throw new UnsupportedOperationException("insertTable is not supported");
    }

    public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter notificationFilter) {
        throw new UnsupportedOperationException("getNextNotification is not supported");
    }

    public CurrentNotificationEventId getCurrentNotificationEventId() {
        throw new UnsupportedOperationException("getCurrentNotificationEventId is not supported");
    }

    public FireEventResponse fireListenerEvent(FireEventRequest fireEventRequest) {
        throw new UnsupportedOperationException("fireListenerEvent is not supported");
    }

    public ShowLocksResponse showLocks() {
        throw new UnsupportedOperationException("showLocks is not supported");
    }

    public ShowLocksResponse showLocks(ShowLocksRequest showLocksRequest) {
        throw new UnsupportedOperationException("showLocks is not supported");
    }

    public GetOpenTxnsInfoResponse showTxns() {
        throw new UnsupportedOperationException("showTxns is not supported");
    }

    public void unlock(long lockId) throws TException {
        try {
            boolean bl = this.dataLakeMetaStore.unLock(Long.valueOf(lockId));
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to unlock: " + lockId;
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public void createFunction(String catalogId, org.apache.hadoop.hive.metastore.api.Function function) throws TException {
        try {
            this.dataLakeMetaStore.createFunction(catalogId, HiveToCatalogConverter.toCatalogFunctionInput((String)catalogId, (org.apache.hadoop.hive.metastore.api.Function)function), function.getDbName());
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "Unable to create function";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public org.apache.hadoop.hive.metastore.api.Function getFunction(String catalogId, String dbName, String functionName) throws TException {
        try {
            Function result = this.dataLakeMetaStore.getFunction(catalogId, dbName, functionName);
            return CatalogToHiveConverter.toHiveFunction((Function)result);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "unable to get funcition: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public List<String> getFunctions(String catalogId, String dbName, String pattern) throws TException {
        try {
            return this.dataLakeMetaStore.getFunctions(catalogId, dbName, pattern, this.pageSize);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "unable to get funcitions: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public List<org.apache.hadoop.hive.metastore.api.Function> getFunctionObjects(String catalogId, String dbName, String pattern) throws TException {
        ArrayList<org.apache.hadoop.hive.metastore.api.Function> functions = new ArrayList<org.apache.hadoop.hive.metastore.api.Function>();
        try {
            List result = this.dataLakeMetaStore.getFunctionObjects(catalogId, dbName, pattern, this.pageSize);
            result.stream().forEach(r -> functions.add(CatalogToHiveConverter.toHiveFunction((Function)r)));
            return functions;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "unable to get function objects";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public void alterFunction(String catalogId, String dbName, String functionName, org.apache.hadoop.hive.metastore.api.Function function) throws TException {
        try {
            this.dataLakeMetaStore.alterFunction(catalogId, dbName, functionName, HiveToCatalogConverter.toCatalogFunctionInput((String)catalogId, (org.apache.hadoop.hive.metastore.api.Function)function));
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "unable to alter funcition: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public void dropFunction(String catalogId, String dbName, String functionName) throws TException {
        try {
            this.dataLakeMetaStore.dropFunction(catalogId, dbName, functionName);
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "unable to drop funcition: ";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    public GetAllFunctionsResponse getAllFunctions(String catalogId) throws TException {
        String nextToken = EMPTY_TOKEN;
        try {
            List databases = this.dataLakeMetaStore.getDatabases(catalogId, ".*", this.pageSize);
            ArrayList listFunctionsFutures = Lists.newArrayList();
            for (Object dbName : databases) {
                listFunctionsFutures.add(this.executorService.submit(() -> this.lambda$getAllFunctions$8(catalogId, (String)dbName)));
            }
            ArrayList functions = new ArrayList();
            for (Future listFunctionsFuture : listFunctionsFutures) {
                try {
                    functions.addAll((Collection)listFunctionsFuture.get());
                }
                catch (Exception e) {
                    if (e instanceof TeaException) {
                        throw (TeaException)e;
                    }
                    throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException("get functions failed, message: " + e.getMessage()), (Exception)e);
                }
            }
            GetAllFunctionsResponse getAllFunctionsResponse = new GetAllFunctionsResponse();
            getAllFunctionsResponse.setFunctions(functions);
            return getAllFunctionsResponse;
        }
        catch (DataLakeAPIException e) {
            throw CatalogToHiveConverter.toHiveException((ResultModel)e.getResult(), (Action)e.getAction(), (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = "unable to get all functions";
            logger.error(msg, (Throwable)e);
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(msg + e), (Exception)e);
        }
    }

    protected ExecutorService getExecutorService() {
        Class<ExecutorServiceFactory> executorFactoryClass = this.getConf().getClass("hive.metastore.executorservice.factory.class", DefaultExecutorServiceFactory.class).asSubclass(ExecutorServiceFactory.class);
        ExecutorServiceFactory factory = (ExecutorServiceFactory)ReflectionUtils.newInstance(executorFactoryClass, (Configuration)this.getConf());
        return factory.getExecutorService(ConfigUtils.getMetaStoreNumThreads((Configuration)this.conf));
    }

    private /* synthetic */ List lambda$getAllFunctions$8(String catalogId, String dbName) throws Exception {
        return this.getFunctionObjects(catalogId, dbName, ".*");
    }

    private static class StorageDescriptorKey {
        private final StorageDescriptor sd;

        StorageDescriptorKey(StorageDescriptor sd) {
            this.sd = sd;
        }

        StorageDescriptor getSd() {
            return this.sd;
        }

        private String hashCodeKey() {
            return this.sd.getInputFormat() + "\t" + this.sd.getOutputFormat() + "\t" + this.sd.getSerdeInfo().getSerializationLib() + "\t" + this.sd.getCols();
        }

        public int hashCode() {
            return this.hashCodeKey().hashCode();
        }

        public boolean equals(Object rhs) {
            if (rhs == this) {
                return true;
            }
            if (!(rhs instanceof StorageDescriptorKey)) {
                return false;
            }
            return this.hashCodeKey().equals(((StorageDescriptorKey)rhs).hashCodeKey());
        }
    }

    private static class PartValueEqWrapper {
        private final ImmutableList<String> partValues;

        PartValueEqWrapper(List<String> partVals) {
            this.partValues = partVals == null ? null : ImmutableList.copyOf(partVals);
        }

        public int hashCode() {
            if (this.partValues == null) {
                return 0;
            }
            return this.partValues.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof PartValueEqWrapper) {
                return Objects.equals(this.partValues, ((PartValueEqWrapper)obj).partValues);
            }
            return false;
        }
    }

    private static class PathAndPartValSize {
        private Path path;
        private int partValSize;

        PathAndPartValSize(Path path, int partValSize) {
            this.path = path;
            this.partValSize = partValSize;
        }

        public Path getPath() {
            return this.path;
        }

        public int getPartValSize() {
            return this.partValSize;
        }
    }

    private static class PartitionToHiveVisitor
    implements IDataLakeMetaStore.PartitionVisitor<List<org.apache.hadoop.hive.metastore.api.Partition>, Partition> {
        private List<org.apache.hadoop.hive.metastore.api.Partition> result = new ArrayList<org.apache.hadoop.hive.metastore.api.Partition>();

        PartitionToHiveVisitor() {
        }

        public void accept(List<Partition> partitions) {
            partitions.stream().forEach(p -> this.result.add(CatalogToHiveConverter.toHivePartition((Partition)p)));
        }

        public List<org.apache.hadoop.hive.metastore.api.Partition> getResult() {
            return this.result;
        }
    }
}

