/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive2;

import com.aliyun.datalake.metastore.common.util.DataLakeUtil;
import com.aliyun.datalake.metastore.hive.common.utils.ConfigUtils;
import com.aliyun.datalake.metastore.hive.shims.IHiveShims;
import com.aliyun.datalake.metastore.hive.shims.ShimsLoader;
import com.aliyun.datalake.metastore.hive2.DlfMetaStoreClientDelegate;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreFilterHook;
import org.apache.hadoop.hive.metastore.PartitionDropOptions;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Catalog;
import org.apache.hadoop.hive.metastore.api.CheckConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleRequest;
import org.apache.hadoop.hive.metastore.api.CmRecycleResponse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.CompactionType;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.CreationMetadata;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.DataOperationType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DefaultConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsResp;
import org.apache.hadoop.hive.metastore.api.FindSchemasByColsRqst;
import org.apache.hadoop.hive.metastore.api.FireEventRequest;
import org.apache.hadoop.hive.metastore.api.FireEventResponse;
import org.apache.hadoop.hive.metastore.api.ForeignKeysRequest;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.GetAllFunctionsResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleRequest;
import org.apache.hadoop.hive.metastore.api.GetPrincipalsInRoleResponse;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalRequest;
import org.apache.hadoop.hive.metastore.api.GetRoleGrantsForPrincipalResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.ISchema;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetadataPpdResult;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.NotNullConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventsCountResponse;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PartitionValuesRequest;
import org.apache.hadoop.hive.metastore.api.PartitionValuesResponse;
import org.apache.hadoop.hive.metastore.api.PrimaryKeysRequest;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.RuntimeStat;
import org.apache.hadoop.hive.metastore.api.SQLCheckConstraint;
import org.apache.hadoop.hive.metastore.api.SQLDefaultConstraint;
import org.apache.hadoop.hive.metastore.api.SQLForeignKey;
import org.apache.hadoop.hive.metastore.api.SQLNotNullConstraint;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.metastore.api.SQLUniqueConstraint;
import org.apache.hadoop.hive.metastore.api.SchemaVersion;
import org.apache.hadoop.hive.metastore.api.SchemaVersionState;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.metastore.api.TableValidWriteIds;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.TxnToWriteId;
import org.apache.hadoop.hive.metastore.api.UniqueConstraintsRequest;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.api.WMFullResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMMapping;
import org.apache.hadoop.hive.metastore.api.WMNullablePool;
import org.apache.hadoop.hive.metastore.api.WMNullableResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMPool;
import org.apache.hadoop.hive.metastore.api.WMResourcePlan;
import org.apache.hadoop.hive.metastore.api.WMTrigger;
import org.apache.hadoop.hive.metastore.api.WMValidateResourcePlanResponse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.utils.ObjectPair;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DlfMetaStoreClient
implements IMetaStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(DlfMetaStoreClient.class);
    private static volatile Boolean isCreatedDefaultDatabase;
    protected final Configuration conf;
    private final Warehouse warehouse;
    private final DlfMetaStoreClientDelegate clientDelegate;
    private final String catalogId;
    private final IHiveShims hiveShims = ShimsLoader.getHiveShims();
    private final Pattern partitionValidationPattern;
    private final Boolean enableFsOperation;
    private Map<String, String> currentMetaVars;
    private final MetaStoreFilterHook filterHook;

    public DlfMetaStoreClient(Configuration conf) throws MetaException {
        this(conf, null);
    }

    public DlfMetaStoreClient(Configuration conf, HiveMetaHookLoader hookLoader) throws MetaException {
        this.conf = conf == null ? (conf = MetastoreConf.newMetastoreConf()) : new Configuration(conf);
        this.catalogId = ConfigUtils.getCatalogId((Configuration)this.conf);
        this.warehouse = new Warehouse(this.conf);
        String partitionValidationRegex = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN);
        this.partitionValidationPattern = partitionValidationRegex != null && !partitionValidationRegex.isEmpty() ? Pattern.compile(partitionValidationRegex) : null;
        this.snapshotActiveConf();
        this.filterHook = this.loadFilterHooks();
        this.clientDelegate = new DlfMetaStoreClientDelegate(this.conf, this.warehouse, hookLoader);
        boolean createDefaultDatabase = this.getConf().getBoolean("dlf.catalog.createDefaultDBIfNotExist", true);
        this.createDefaultCatalogAndDatabase(createDefaultDatabase);
        this.enableFsOperation = this.clientDelegate.getEnableFsOperation();
    }

    public DlfMetaStoreClient(Configuration conf, HiveMetaHookLoader hookLoader, boolean allowEmbedded) throws MetaException {
        long startTime = System.currentTimeMillis();
        logger.info("DlfMetaStoreClient start");
        this.conf = conf == null ? (conf = MetastoreConf.newMetastoreConf()) : new Configuration(conf);
        this.catalogId = ConfigUtils.getCatalogId((Configuration)this.conf);
        this.warehouse = new Warehouse(this.conf);
        String partitionValidationRegex = MetastoreConf.getVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN);
        this.partitionValidationPattern = partitionValidationRegex != null && !partitionValidationRegex.isEmpty() ? Pattern.compile(partitionValidationRegex) : null;
        this.snapshotActiveConf();
        this.filterHook = this.loadFilterHooks();
        this.clientDelegate = new DlfMetaStoreClientDelegate(this.conf, this.warehouse, hookLoader);
        boolean createDefaultDatabase = this.getConf().getBoolean("dlf.catalog.createDefaultDBIfNotExist", true);
        this.createDefaultCatalogAndDatabase(createDefaultDatabase);
        this.enableFsOperation = this.clientDelegate.getEnableFsOperation();
        logger.info("DlfMetaStoreClient end, cost:{}ms", (Object)(System.currentTimeMillis() - startTime));
    }

    private MetaStoreFilterHook loadFilterHooks() throws IllegalStateException {
        Class authProviderClass = MetastoreConf.getClass((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.FILTER_HOOK, DefaultMetaStoreFilterHookImpl.class, MetaStoreFilterHook.class);
        String msg = "Unable to create instance of " + authProviderClass.getName() + ": ";
        try {
            Constructor constructor = authProviderClass.getConstructor(Configuration.class);
            return (MetaStoreFilterHook)constructor.newInstance(this.conf);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(msg + e.getMessage(), e);
        }
    }

    public Boolean getEnableFsOperation() {
        return this.enableFsOperation;
    }

    public Configuration getConf() {
        return this.conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createDefaultCatalogAndDatabase(boolean ifCreateDefaultDatabase) throws MetaException {
        if (!ifCreateDefaultDatabase) return;
        Class<DlfMetaStoreClient> clazz = DlfMetaStoreClient.class;
        synchronized (DlfMetaStoreClient.class) {
            if (isCreatedDefaultDatabase != null && isCreatedDefaultDatabase.booleanValue()) return;
            logger.info("dlf metastoreclient create default database ");
            this.createDefaultDatabaseIfNotExists();
            isCreatedDefaultDatabase = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public DlfMetaStoreClientDelegate getClientDelegate() {
        return this.clientDelegate;
    }

    private void createDefaultDatabaseIfNotExists() throws MetaException {
        try {
            this.clientDelegate.getDatabase(this.catalogId, "default");
        }
        catch (NoSuchObjectException noObjectEx) {
            Database defaultDB = this.getDefaultDatabaseObj();
            try {
                this.createDatabase(defaultDB);
            }
            catch (AlreadyExistsException ignoreException) {
                logger.warn("database - default already exists. Ignoring..");
            }
            catch (Exception e) {
                logger.error("Unable to create default database", (Throwable)e);
            }
        }
        catch (Exception ex) {
            logger.error("getDefaultDb exception");
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(ex.getMessage()), (Exception)ex);
        }
    }

    private Database getDefaultDatabaseObj() throws MetaException {
        Database defaultDB = new Database();
        defaultDB.setName("default");
        defaultDB.setDescription("Default Hive database");
        defaultDB.setParameters(Collections.EMPTY_MAP);
        defaultDB.setLocationUri(this.warehouse.getDefaultDatabasePath("default").toString());
        defaultDB.setOwnerType(PrincipalType.USER);
        try {
            defaultDB.setOwnerName(UserGroupInformation.getCurrentUser().getUserName());
        }
        catch (IOException e) {
            defaultDB.setOwnerName("root");
        }
        PrincipalPrivilegeSet principalPrivilegeSet = new PrincipalPrivilegeSet();
        principalPrivilegeSet.setRolePrivileges((Map)Maps.newHashMap());
        principalPrivilegeSet.setGroupPrivileges((Map)Maps.newHashMap());
        principalPrivilegeSet.setUserPrivileges((Map)Maps.newHashMap());
        defaultDB.setPrivileges(principalPrivilegeSet);
        return defaultDB;
    }

    public void createDatabase(Database database) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        this.clientDelegate.createDatabase(this.catalogId, database);
    }

    public Database getDatabase(String name) throws NoSuchObjectException, MetaException, TException {
        return this.getDatabase(this.catalogId, name);
    }

    public Database getDatabase(String catalogId, String databaseName) throws NoSuchObjectException, MetaException, TException {
        return this.filterHook.filterDatabase(this.clientDelegate.getDatabase(catalogId, databaseName));
    }

    public List<String> getDatabases(String pattern) throws MetaException, TException {
        return this.getDatabases(this.catalogId, pattern);
    }

    public List<String> getDatabases(String catalogId, String databasePattern) throws MetaException, TException {
        return this.filterHook.filterDatabases(this.clientDelegate.getDatabases(catalogId, databasePattern));
    }

    public List<String> getAllDatabases() throws MetaException, TException {
        return this.getDatabases(".*");
    }

    public List<String> getAllDatabases(String catalogId) throws MetaException, TException {
        return this.getDatabases(catalogId, ".*");
    }

    public void alterDatabase(String databaseName, Database database) throws NoSuchObjectException, MetaException, TException {
        this.clientDelegate.alterDatabase(this.catalogId, databaseName, database);
    }

    public void alterDatabase(String catalogId, String databaseName, Database database) throws NoSuchObjectException, MetaException, TException {
        this.clientDelegate.alterDatabase(catalogId, databaseName, database);
    }

    public void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, true, false, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, deleteData, ignoreUnknownDb, false);
    }

    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.clientDelegate.dropDatabase(this.catalogId, name, deleteData, ignoreUnknownDb, cascade);
    }

    public void dropDatabase(String catalogId, String name, boolean deleteData, boolean ignoreUnknownDb, boolean cascade) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.clientDelegate.dropDatabase(catalogId, name, deleteData, ignoreUnknownDb, cascade);
    }

    public Partition add_partition(Partition partition) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        List<Partition> partitions = this.clientDelegate.addPartitions(this.catalogId, Lists.newArrayList((Object[])new Partition[]{partition}), false, true);
        return partitions != null ? partitions.get(0) : null;
    }

    public int add_partitions(List<Partition> partitions) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.add_partitions(partitions, false, true).size();
    }

    public List<Partition> add_partitions(List<Partition> partitions, boolean ifNotExists, boolean needResult) throws TException {
        return this.filterHook.filterPartitions(this.clientDelegate.addPartitions(this.catalogId, partitions, ifNotExists, needResult));
    }

    public int add_partitions_pspec(PartitionSpecProxy pSpec) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.clientDelegate.addPartitionsSpecProxy(this.catalogId, pSpec);
    }

    public void alterFunction(String dbName, String functionName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        this.clientDelegate.alterFunction(this.catalogId, dbName, functionName, newFunction);
    }

    public void alterFunction(String catalogId, String dbName, String functionName, Function newFunction) throws InvalidObjectException, MetaException, TException {
        this.clientDelegate.alterFunction(catalogId, dbName, functionName, newFunction);
    }

    public void alter_partition(String dbName, String tblName, Partition partition) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterPartitions(this.catalogId, dbName, tblName, Lists.newArrayList((Object[])new Partition[]{partition}), null);
    }

    public void alter_partition(String dbName, String tblName, Partition partition, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterPartitions(this.catalogId, dbName, tblName, Lists.newArrayList((Object[])new Partition[]{partition}), environmentContext);
    }

    public void alter_partition(String catalogId, String dbName, String tblName, Partition partition, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterPartitions(catalogId, dbName, tblName, Lists.newArrayList((Object[])new Partition[]{partition}), environmentContext);
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> partitions) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterPartitions(this.catalogId, dbName, tblName, partitions, null);
    }

    public void alter_partitions(String dbName, String tblName, List<Partition> partitions, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterPartitions(this.catalogId, dbName, tblName, partitions, environmentContext);
    }

    public void alter_partitions(String catalogId, String dbName, String tblName, List<Partition> partitions, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterPartitions(catalogId, dbName, tblName, partitions, environmentContext);
    }

    public void alter_table(String dbName, String tblName, Table table) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterTable(this.catalogId, dbName, tblName, table, null);
    }

    public void alter_table(String catalogId, String dbName, String tblName, Table table, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterTable(catalogId, dbName, tblName, table, environmentContext);
    }

    @Deprecated
    public void alter_table(String dbName, String tblName, Table table, boolean cascade) throws InvalidOperationException, MetaException, TException {
        EnvironmentContext environmentContext = new EnvironmentContext();
        if (cascade) {
            environmentContext.putToProperties("CASCADE", "true");
        }
        this.clientDelegate.alterTable(this.catalogId, dbName, tblName, table, environmentContext);
    }

    public void alter_table_with_environmentContext(String dbName, String tblName, Table table, EnvironmentContext environmentContext) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.alterTable(this.catalogId, dbName, tblName, table, environmentContext);
    }

    public Partition appendPartition(String dbName, String tblName, List<String> values) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.clientDelegate.appendPartition(this.catalogId, dbName, tblName, values);
    }

    public Partition appendPartition(String catalogId, String dbName, String tblName, List<String> values) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.clientDelegate.appendPartition(catalogId, dbName, tblName, values);
    }

    public Partition appendPartition(String dbName, String tblName, String partitionName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.clientDelegate.appendPartition(this.catalogId, dbName, tblName, partitionName);
    }

    public Partition appendPartition(String catalogId, String dbName, String tblName, String partitionName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.clientDelegate.appendPartition(catalogId, dbName, tblName, partitionName);
    }

    public boolean create_role(Role role) throws MetaException, TException {
        return this.clientDelegate.createRole(role);
    }

    public boolean drop_role(String roleName) throws MetaException, TException {
        return this.clientDelegate.dropRole(roleName);
    }

    public List<Role> list_roles(String principalName, PrincipalType principalType) throws MetaException, TException {
        return this.clientDelegate.listRoles(principalName, principalType);
    }

    public List<String> listRoleNames() throws MetaException, TException {
        return this.clientDelegate.listRoleNames();
    }

    public GetPrincipalsInRoleResponse get_principals_in_role(GetPrincipalsInRoleRequest request) throws MetaException, TException {
        return this.clientDelegate.getPrincipalsInRole(request);
    }

    public GetRoleGrantsForPrincipalResponse get_role_grants_for_principal(GetRoleGrantsForPrincipalRequest request) throws MetaException, TException {
        return this.clientDelegate.getRoleGrantsForPrincipal(request);
    }

    public boolean grant_role(String roleName, String userName, PrincipalType principalType, String grantor, PrincipalType grantorType, boolean grantOption) throws MetaException, TException {
        return this.clientDelegate.grantRole(roleName, userName, principalType, grantor, grantorType, grantOption);
    }

    public boolean revoke_role(String roleName, String userName, PrincipalType principalType, boolean grantOption) throws MetaException, TException {
        return this.clientDelegate.revokeRole(roleName, userName, principalType, grantOption);
    }

    public void cancelDelegationToken(String tokenStrForm) throws MetaException, TException {
        this.clientDelegate.cancelDelegationToken(tokenStrForm);
    }

    public String getTokenStrForm() throws IOException {
        return this.clientDelegate.getTokenStrForm();
    }

    public boolean addToken(String tokenIdentifier, String delegationToken) throws TException {
        return this.clientDelegate.addToken(tokenIdentifier, delegationToken);
    }

    public boolean removeToken(String tokenIdentifier) throws TException {
        return this.clientDelegate.removeToken(tokenIdentifier);
    }

    public String getToken(String tokenIdentifier) throws TException {
        return this.clientDelegate.getToken(tokenIdentifier);
    }

    public List<String> getAllTokenIdentifiers() throws TException {
        return this.clientDelegate.getAllTokenIdentifiers();
    }

    public int addMasterKey(String key) throws MetaException, TException {
        return this.clientDelegate.addMasterKey(key);
    }

    public void updateMasterKey(Integer seqNo, String key) throws NoSuchObjectException, MetaException, TException {
        this.clientDelegate.updateMasterKey(seqNo, key);
    }

    public boolean removeMasterKey(Integer keySeq) throws TException {
        return this.clientDelegate.removeMasterKey(keySeq);
    }

    public String[] getMasterKeys() throws TException {
        return this.clientDelegate.getMasterKeys();
    }

    public LockResponse checkLock(long lockId) throws NoSuchTxnException, TxnAbortedException, NoSuchLockException, TException {
        return this.clientDelegate.checkLock(lockId);
    }

    public void close() {
        this.currentMetaVars = null;
    }

    public void commitTxn(long txnId) throws NoSuchTxnException, TxnAbortedException, TException {
        this.clientDelegate.commitTxn(txnId);
    }

    public void replCommitTxn(long srcTxnId, String replPolicy) throws NoSuchTxnException, TxnAbortedException, TException {
        throw new UnsupportedOperationException();
    }

    public void abortTxns(List<Long> txnIds) throws TException {
        this.clientDelegate.abortTxns(txnIds);
    }

    public long allocateTableWriteId(long txnId, String dbName, String tableName) throws TException {
        throw new UnsupportedOperationException();
    }

    public void replTableWriteIdState(String validWriteIdList, String dbName, String tableName, List<String> partNames) throws TException {
        throw new UnsupportedOperationException();
    }

    public List<TxnToWriteId> allocateTableWriteIdsBatch(List<Long> txnIds, String dbName, String tableName) throws TException {
        throw new UnsupportedOperationException();
    }

    public List<TxnToWriteId> replAllocateTableWriteIdsBatch(String dbName, String tableName, String replPolicy, List<TxnToWriteId> srcTxnToWriteIdList) throws TException {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType) throws TException {
        this.clientDelegate.compact(dbName, tblName, partitionName, compactionType);
    }

    @Deprecated
    public void compact(String dbName, String tblName, String partitionName, CompactionType compactionType, Map<String, String> tblProperties) throws TException {
        this.clientDelegate.compact(dbName, tblName, partitionName, compactionType, tblProperties);
    }

    public CompactionResponse compact2(String dbName, String tblName, String partitionName, CompactionType compactionType, Map<String, String> tblProperties) throws TException {
        return this.clientDelegate.compact2(dbName, tblName, partitionName, compactionType, tblProperties);
    }

    public void createFunction(Function function) throws InvalidObjectException, MetaException, TException {
        this.clientDelegate.createFunction(this.catalogId, function);
    }

    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.createTable(tbl, null);
    }

    public void createTable(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.create_table_with_environment_context(tbl, envContext);
    }

    protected void create_table_with_environment_context(Table tbl, EnvironmentContext envContext) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        this.clientDelegate.createTable(this.catalogId, tbl, envContext);
    }

    public boolean deletePartitionColumnStatistics(String dbName, String tableName, String partName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        return this.clientDelegate.deletePartitionColumnStatistics(this.catalogId, dbName, tableName, partName, colName);
    }

    public boolean deletePartitionColumnStatistics(String catalogId, String dbName, String tableName, String partName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        return this.clientDelegate.deletePartitionColumnStatistics(catalogId, dbName, tableName, partName, colName);
    }

    public boolean deleteTableColumnStatistics(String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        return this.clientDelegate.deleteTableColumnStatistics(this.catalogId, dbName, tableName, colName);
    }

    public boolean deleteTableColumnStatistics(String catalogId, String dbName, String tableName, String colName) throws NoSuchObjectException, MetaException, InvalidObjectException, TException, InvalidInputException {
        return this.clientDelegate.deleteTableColumnStatistics(catalogId, dbName, tableName, colName);
    }

    public void dropFunction(String dbName, String functionName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        this.clientDelegate.dropFunction(this.catalogId, dbName, functionName);
    }

    public void dropFunction(String catalogId, String dbName, String functionName) throws MetaException, NoSuchObjectException, InvalidObjectException, InvalidInputException, TException {
        this.clientDelegate.dropFunction(catalogId, dbName, functionName);
    }

    private void deleteParentRecursive(Path parent, int depth, boolean mustPurge) throws IOException, MetaException {
        if (depth > 0 && parent != null && this.warehouse.isWritable(parent) && this.warehouse.isEmpty(parent)) {
            this.warehouse.deleteDir(parent, true, mustPurge, false);
            this.deleteParentRecursive(parent.getParent(), depth - 1, mustPurge);
        }
    }

    private boolean isMustPurge(Table table, boolean ifPurge) {
        return ifPurge || "true".equalsIgnoreCase((String)table.getParameters().get("auto.purge"));
    }

    public boolean dropPartition(String dbName, String tblName, List<String> values, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.dropPartition(this.catalogId, dbName, tblName, values, false, deleteData, false);
    }

    public boolean dropPartition(String catalogId, String dbName, String tblName, List<String> values, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.dropPartition(catalogId, dbName, tblName, values, false, deleteData, false);
    }

    public boolean dropPartition(String dbName, String tblName, List<String> values, PartitionDropOptions options) throws TException {
        return this.clientDelegate.dropPartition(this.catalogId, dbName, tblName, values, options.ifExists, options.deleteData, options.purgeData);
    }

    public boolean dropPartition(String catalogId, String dbName, String tblName, List<String> values, PartitionDropOptions options) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.dropPartition(catalogId, dbName, tblName, values, options.ifExists, options.deleteData, options.purgeData);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.dropPartitions(this.catalogId, dbName, tblName, this.hiveShims.objectPairConvert(partExprs), deleteData, false, ifExists, true);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, boolean deleteData, boolean ifExists, boolean needResult) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.dropPartitions(this.catalogId, dbName, tblName, this.hiveShims.objectPairConvert(partExprs), deleteData, false, ifExists, needResult);
    }

    public List<Partition> dropPartitions(String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, PartitionDropOptions partitionDropOptions) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.dropPartitions(this.catalogId, dbName, tblName, this.hiveShims.objectPairConvert(partExprs), partitionDropOptions.deleteData, partitionDropOptions.purgeData, partitionDropOptions.returnResults);
    }

    public List<Partition> dropPartitions(String catalogId, String dbName, String tblName, List<ObjectPair<Integer, byte[]>> partExprs, PartitionDropOptions partitionDropOptions) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.dropPartitions(catalogId, dbName, tblName, this.hiveShims.objectPairConvert(partExprs), partitionDropOptions.deleteData, partitionDropOptions.purgeData, partitionDropOptions.returnResults);
    }

    public boolean dropPartition(String dbName, String tblName, String partitionName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        List<String> values = this.partitionNameToVals(partitionName);
        return this.clientDelegate.dropPartition(this.catalogId, dbName, tblName, values, false, deleteData, false);
    }

    public boolean dropPartition(String catName, String dbName, String tblName, String partitionName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        List<String> values = this.partitionNameToVals(partitionName);
        return this.clientDelegate.dropPartition(this.catalogId, dbName, tblName, values, false, deleteData, false);
    }

    public void dropTable(String dbname, String tableName) throws MetaException, TException, NoSuchObjectException {
        this.clientDelegate.dropTable(this.catalogId, dbname, tableName, true, true, null);
    }

    public void dropTable(String catalogId, String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTab, boolean ifPurge) throws MetaException, NoSuchObjectException, TException {
        EnvironmentContext envContext = null;
        if (ifPurge) {
            HashMap<String, String> warehouseOptions = new HashMap<String, String>();
            warehouseOptions.put("ifPurge", "TRUE");
            envContext = new EnvironmentContext(warehouseOptions);
        }
        this.clientDelegate.dropTable(catalogId, dbname, tableName, deleteData, ignoreUnknownTab, envContext);
    }

    public void truncateTable(String dbName, String tableName, List<String> partNames) throws MetaException, TException {
        this.clientDelegate.truncateTable(this.catalogId, dbName, tableName, partNames);
    }

    public void truncateTable(String catName, String dbName, String tableName, List<String> partNames) throws MetaException, TException {
        this.clientDelegate.truncateTable(catName, dbName, tableName, partNames);
    }

    public CmRecycleResponse recycleDirToCmPath(CmRecycleRequest cmRecycleRequest) throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTab) throws MetaException, TException, NoSuchObjectException {
        this.clientDelegate.dropTable(this.catalogId, dbname, tableName, deleteData, ignoreUnknownTab, null);
    }

    public void dropTable(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTable, boolean ifPurge) throws MetaException, TException, NoSuchObjectException {
        EnvironmentContext envContext = null;
        if (ifPurge) {
            HashMap<String, String> warehouseOptions = null;
            warehouseOptions = new HashMap<String, String>();
            warehouseOptions.put("ifPurge", "TRUE");
            envContext = new EnvironmentContext(warehouseOptions);
        }
        this.clientDelegate.dropTable(this.catalogId, dbname, tableName, deleteData, ignoreUnknownTable, envContext);
    }

    protected void drop_table_with_environment_context(String dbname, String tableName, boolean deleteData, boolean ignoreUnknownTable, EnvironmentContext envContext) throws MetaException, TException, NoSuchObjectException, UnsupportedOperationException {
        this.clientDelegate.dropTable(this.catalogId, dbname, tableName, deleteData, ignoreUnknownTable, envContext);
    }

    public Partition exchange_partition(Map<String, String> partitionSpecs, String srcDb, String srcTbl, String dstDb, String dstTbl) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return this.clientDelegate.exchangePartition(partitionSpecs, this.catalogId, srcDb, srcTbl, this.catalogId, dstDb, dstTbl);
    }

    public Partition exchange_partition(Map<String, String> partitionSpecs, String srcCatalogId, String srcDb, String srcTbl, String descCatalogId, String dstDb, String dstTbl) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return this.clientDelegate.exchangePartition(partitionSpecs, srcCatalogId, srcDb, srcTbl, descCatalogId, dstDb, dstTbl);
    }

    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String sourceDb, String sourceTbl, String destDb, String destTbl) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return this.clientDelegate.exchangePartitions(partitionSpecs, this.catalogId, sourceDb, sourceTbl, this.catalogId, destDb, destTbl);
    }

    public List<Partition> exchange_partitions(Map<String, String> partitionSpecs, String srcCatalogId, String sourceDb, String sourceTbl, String dstCatalogId, String destDb, String destTbl) throws MetaException, NoSuchObjectException, InvalidObjectException, TException {
        return this.clientDelegate.exchangePartitions(partitionSpecs, srcCatalogId, sourceDb, sourceTbl, dstCatalogId, destDb, destTbl);
    }

    public AggrStats getAggrColStatsFor(String dbName, String tblName, List<String> colNames, List<String> partName) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.getAggrColStatsFor(this.catalogId, dbName, tblName, colNames, partName);
    }

    public AggrStats getAggrColStatsFor(String catalogId, String dbName, String tblName, List<String> colNames, List<String> partName) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.getAggrColStatsFor(catalogId, dbName, tblName, colNames, partName);
    }

    public List<String> getAllTables(String dbname) throws MetaException, TException, UnknownDBException {
        return this.getTables(dbname, ".*");
    }

    public List<String> getAllTables(String catalogId, String dbName) throws MetaException, TException, UnknownDBException {
        return this.getTables(catalogId, dbName, ".*");
    }

    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        if (name == null) {
            return defaultValue;
        }
        if (!Pattern.matches("(hive|hdfs|mapred).*", name)) {
            throw new ConfigValSecurityException("For security reasons, the config key " + name + " cannot be accessed");
        }
        return this.getConf().get(name, defaultValue);
    }

    public String getDelegationToken(String owner, String renewerKerberosPrincipalName) throws MetaException, TException {
        return this.clientDelegate.getDelegationToken(owner, renewerKerberosPrincipalName);
    }

    public List<FieldSchema> getFields(String db, String tableName) throws TException {
        return this.clientDelegate.getFields(this.catalogId, db, tableName);
    }

    public List<FieldSchema> getFields(String catalogId, String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.clientDelegate.getFields(catalogId, db, tableName);
    }

    public Function getFunction(String dbName, String functionName) throws MetaException, TException {
        try {
            return this.clientDelegate.getFunction(this.catalogId, dbName, functionName);
        }
        catch (NoSuchObjectException e) {
            if (e.getMessage().contains("Function not found")) {
                e.setMessage(String.format("Function %s.%s does not exist", dbName, functionName));
            }
            throw e;
        }
    }

    public Function getFunction(String catalogId, String dbName, String funcName) throws MetaException, TException {
        try {
            return this.clientDelegate.getFunction(catalogId, dbName, funcName);
        }
        catch (NoSuchObjectException e) {
            if (e.getMessage().contains("Function not found")) {
                e.setMessage(String.format("Function %s.%s.%s does not exist", catalogId, dbName, funcName));
            }
            throw e;
        }
    }

    public List<String> getFunctions(String dbName, String pattern) throws MetaException, TException {
        return this.clientDelegate.getFunctions(this.catalogId, dbName, pattern);
    }

    public List<String> getFunctions(String catalogId, String dbName, String pattern) throws MetaException, TException {
        return this.clientDelegate.getFunctions(catalogId, dbName, pattern);
    }

    public GetAllFunctionsResponse getAllFunctions() throws MetaException, TException {
        return this.clientDelegate.getAllFunctions(this.catalogId);
    }

    public String getMetaConf(String key) throws MetaException, TException {
        MetastoreConf.ConfVars metaConfVar = MetastoreConf.getMetaConf((String)key);
        if (metaConfVar == null) {
            throw new MetaException("Invalid configuration key " + key);
        }
        return this.getConf().get(key, metaConfVar.getDefaultVal().toString());
    }

    public void createCatalog(Catalog catalog) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void alterCatalog(String catalogName, Catalog newCatalog) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public Catalog getCatalog(String catalogId) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public List<String> getCatalogs() throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void dropCatalog(String catalogId) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public Partition getPartition(String dbName, String tblName, List<String> values) throws NoSuchObjectException, MetaException, TException {
        return this.getPartition(this.catalogId, dbName, tblName, values);
    }

    public Partition getPartition(String catalogId, String dbName, String tblName, List<String> values) throws NoSuchObjectException, MetaException, TException {
        return this.filterHook.filterPartition(this.clientDelegate.getPartition(catalogId, dbName, tblName, values));
    }

    public Partition getPartition(String dbName, String tblName, String partitionName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return this.getPartition(this.catalogId, dbName, tblName, partitionName);
    }

    public Partition getPartition(String catalogId, String dbName, String tblName, String partitionName) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        return this.filterHook.filterPartition(this.clientDelegate.getPartition(catalogId, dbName, tblName, partitionName));
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.getPartitionColumnStatisticsObj(this.catalogId, dbName, tableName, partitionNames, columnNames);
    }

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String catalogId, String dbName, String tableName, List<String> partitionNames, List<String> columnNames) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.getPartitionColumnStatisticsObj(catalogId, dbName, tableName, partitionNames, columnNames);
    }

    public Partition getPartitionWithAuthInfo(String databaseName, String tableName, List<String> values, String userName, List<String> groupNames) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        Partition partition = this.getPartition(databaseName, tableName, values);
        Table table = this.getTable(databaseName, tableName);
        if ("TRUE".equalsIgnoreCase((String)table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setDbName(databaseName);
            obj.setObjectName(tableName);
            obj.setPartValues(values);
            PrincipalPrivilegeSet privilegeSet = this.get_privilege_set(obj, userName, groupNames);
            partition.setPrivileges(privilegeSet);
        }
        return this.filterHook.filterPartition(partition);
    }

    public Partition getPartitionWithAuthInfo(String catalogId, String databaseName, String tableName, List<String> values, String userName, List<String> groupNames) throws MetaException, UnknownTableException, NoSuchObjectException, TException {
        Partition partition = this.getPartition(catalogId, databaseName, tableName, values);
        Table table = this.getTable(catalogId, databaseName, tableName);
        if ("TRUE".equalsIgnoreCase((String)table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setCatName(catalogId);
            obj.setDbName(databaseName);
            obj.setObjectName(tableName);
            obj.setPartValues(values);
            PrincipalPrivilegeSet privilegeSet = this.get_privilege_set(obj, userName, groupNames);
            partition.setPrivileges(privilegeSet);
        }
        return this.filterHook.filterPartition(partition);
    }

    public List<Partition> getPartitionsByNames(String databaseName, String tableName, List<String> partitionNames) throws NoSuchObjectException, MetaException, TException {
        return this.getPartitionsByNames(this.catalogId, databaseName, tableName, partitionNames);
    }

    public List<Partition> getPartitionsByNames(String catalogId, String databaseName, String tableName, List<String> partitionNames) throws NoSuchObjectException, MetaException, TException {
        return this.filterHook.filterPartitions(this.clientDelegate.getPartitionsByNames(catalogId, databaseName, tableName, partitionNames));
    }

    public List<FieldSchema> getSchema(String db, String tableName) throws TException {
        EnvironmentContext envCxt = null;
        String addedJars = MetastoreConf.getVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ADDED_JARS);
        if (StringUtils.isNotBlank((CharSequence)addedJars)) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HiveConf.ConfVars.HIVEADDEDJARS.varname, addedJars);
            envCxt = new EnvironmentContext(props);
        }
        return this.clientDelegate.getSchemaWithEnvironmentContext(this.catalogId, db, tableName, envCxt);
    }

    public List<FieldSchema> getSchema(String catalogId, String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        EnvironmentContext envCxt = null;
        String addedJars = MetastoreConf.getVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ADDED_JARS);
        if (StringUtils.isNotBlank((CharSequence)addedJars)) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HiveConf.ConfVars.HIVEADDEDJARS.varname, addedJars);
            envCxt = new EnvironmentContext(props);
        }
        return this.clientDelegate.getSchemaWithEnvironmentContext(catalogId, db, tableName, envCxt);
    }

    public Table getTable(String dbName, String tableName) throws MetaException, TException, NoSuchObjectException {
        return this.getTable(this.catalogId, dbName, tableName);
    }

    public Table getTable(String catalogId, String dbName, String tableName) throws MetaException, TException {
        try {
            return this.filterHook.filterTable(this.clientDelegate.getTable(this.catalogId, dbName, tableName));
        }
        catch (Exception e) {
            if (e.getMessage() != null && e.getMessage().contains("Invalid resource: acs:dlf")) {
                throw new NoSuchObjectException(e.getMessage());
            }
            throw e;
        }
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String dbName, String tableName, List<String> colNames) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.getTableColumnStatisticsObjs(this.catalogId, dbName, tableName, colNames);
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String catalogId, String dbName, String tableName, List<String> colNames) throws NoSuchObjectException, MetaException, TException {
        return this.clientDelegate.getTableColumnStatisticsObjs(catalogId, dbName, tableName, colNames);
    }

    public List<Table> getTableObjectsByName(String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        ArrayList hiveTables = Lists.newArrayList();
        if (dbName == null || dbName.isEmpty()) {
            throw new UnknownDBException("DB name is null or empty");
        }
        if (tableNames == null) {
            throw new InvalidOperationException(dbName + " cannot find null tables");
        }
        try {
            this.getDatabase(dbName);
        }
        catch (NoSuchObjectException e) {
            throw new UnknownDBException("Could not find database " + dbName);
        }
        HashSet<String> tables = new HashSet<String>(tableNames);
        try {
            return this.clientDelegate.getTableObjects(this.catalogId, dbName, new ArrayList<String>(tables));
        }
        catch (NoSuchObjectException e) {
            logger.warn("Try to get a non exist table: " + e.getMessage());
            return this.filterHook.filterTables((List)hiveTables);
        }
    }

    public List<Table> getTableObjectsByName(String catalogId, String dbName, List<String> tableNames) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        ArrayList hiveTables = Lists.newArrayList();
        if (dbName == null || dbName.isEmpty()) {
            throw new UnknownDBException("DB name is null or empty");
        }
        if (tableNames == null) {
            throw new InvalidOperationException(dbName + " cannot find null tables");
        }
        try {
            this.getDatabase(dbName);
        }
        catch (NoSuchObjectException e) {
            throw new UnknownDBException("Could not find database " + dbName);
        }
        HashSet<String> tables = new HashSet<String>(tableNames);
        try {
            return this.clientDelegate.getTableObjects(this.catalogId, dbName, new ArrayList<String>(tables));
        }
        catch (NoSuchObjectException e) {
            logger.warn("Try to get a non exist table: " + e.getMessage());
            return this.filterHook.filterTables((List)hiveTables);
        }
    }

    public Materialization getMaterializationInvalidationInfo(CreationMetadata cm, String validTxnList) throws MetaException, InvalidOperationException, UnknownDBException, TException {
        throw new UnsupportedOperationException();
    }

    public void updateCreationMetadata(String dbName, String tableName, CreationMetadata cm) throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void updateCreationMetadata(String catalogId, String dbName, String tableName, CreationMetadata cm) throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public List<String> getTables(String dbname, String tablePattern) throws MetaException, TException, UnknownDBException {
        return this.getTables(this.catalogId, dbname, tablePattern, null);
    }

    public List<String> getTables(String catalogId, String dbname, String tablePattern) throws MetaException, TException, UnknownDBException {
        return this.getTables(catalogId, dbname, tablePattern, null);
    }

    public List<String> getTables(String dbname, String tablePattern, TableType tableType) throws MetaException, TException, UnknownDBException {
        return this.getTables(this.catalogId, dbname, tablePattern, tableType);
    }

    public List<String> getTables(String catalogId, String dbname, String tablePattern, TableType tableType) throws MetaException, TException, UnknownDBException {
        return this.filterHook.filterTableNames(catalogId, dbname, this.clientDelegate.getTables(catalogId, dbname, tablePattern, tableType));
    }

    public List<String> getMaterializedViewsForRewriting(String dbName) throws MetaException, TException, UnknownDBException {
        return this.getTables(dbName, "*", TableType.MATERIALIZED_VIEW);
    }

    public List<String> getMaterializedViewsForRewriting(String catalogId, String dbName) throws MetaException, TException, UnknownDBException {
        return this.getTables(catalogId, dbName, "*", TableType.MATERIALIZED_VIEW);
    }

    public List<TableMeta> getTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException, TException, UnknownDBException, UnsupportedOperationException {
        return this.getTableMeta(this.catalogId, dbPatterns, tablePatterns, tableTypes);
    }

    public List<TableMeta> getTableMeta(String catalogId, String dbPatterns, String tablePatterns, List<String> tableTypes) throws MetaException, TException, UnknownDBException {
        return this.filterHook.filterTableMetas(this.clientDelegate.getTableMeta(catalogId, dbPatterns, tablePatterns, tableTypes));
    }

    public ValidTxnList getValidTxns() throws TException {
        return this.clientDelegate.getValidTxns();
    }

    public ValidTxnList getValidTxns(long currentTxn) throws TException {
        return this.clientDelegate.getValidTxns(currentTxn);
    }

    public ValidWriteIdList getValidWriteIds(String fullTableName) throws TException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public List<TableValidWriteIds> getValidWriteIds(List<String> tablesList, String validTxnList) throws TException {
        throw new UnsupportedOperationException();
    }

    public PrincipalPrivilegeSet get_privilege_set(HiveObjectRef hiveObject, String userName, List<String> groupNames) throws MetaException, TException {
        return this.clientDelegate.getPrivilegeSet(hiveObject, userName, groupNames);
    }

    public boolean grant_privileges(PrivilegeBag privileges) throws MetaException, TException {
        return this.clientDelegate.grantPrivileges(privileges);
    }

    public boolean revoke_privileges(PrivilegeBag privileges, boolean grantOption) throws MetaException, TException {
        return this.clientDelegate.revokePrivileges(privileges, grantOption);
    }

    public boolean refresh_privileges(HiveObjectRef objToRefresh, String authorizer, PrivilegeBag grantPrivileges) throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void heartbeat(long txnId, long lockId) throws NoSuchLockException, NoSuchTxnException, TxnAbortedException, TException {
        this.clientDelegate.heartbeat(txnId, lockId);
    }

    public HeartbeatTxnRangeResponse heartbeatTxnRange(long min, long max) throws TException {
        return this.clientDelegate.heartbeatTxnRange(min, max);
    }

    public boolean isCompatibleWith(Configuration configuration) {
        Map<String, String> currentMetaVarsCopy = this.currentMetaVars;
        if (currentMetaVarsCopy == null) {
            return false;
        }
        boolean compatible = true;
        for (MetastoreConf.ConfVars oneVar : MetastoreConf.metaVars) {
            String oldVar = currentMetaVarsCopy.get(oneVar.getVarname());
            String newVar = MetastoreConf.getAsString((Configuration)configuration, (MetastoreConf.ConfVars)oneVar);
            if (oldVar != null && !(oneVar.isCaseSensitive() ? !oldVar.equals(newVar) : !oldVar.equalsIgnoreCase(newVar))) continue;
            logger.info("Mestastore configuration " + oneVar.toString() + " changed from " + oldVar + " to " + newVar);
            compatible = false;
        }
        return compatible;
    }

    public void setHiveAddedJars(String addedJars) {
        MetastoreConf.setVar((Configuration)this.getConf(), (MetastoreConf.ConfVars)MetastoreConf.ConfVars.ADDED_JARS, (String)addedJars);
    }

    public boolean isLocalMetaStore() {
        return false;
    }

    private void snapshotActiveConf() {
        this.currentMetaVars = new HashMap<String, String>(MetastoreConf.metaVars.length);
        for (MetastoreConf.ConfVars oneVar : MetastoreConf.metaVars) {
            this.currentMetaVars.put(oneVar.getVarname(), MetastoreConf.getAsString((Configuration)this.conf, (MetastoreConf.ConfVars)oneVar));
        }
    }

    public boolean isPartitionMarkedForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        return this.clientDelegate.isPartitionMarkedForEvent(dbName, tblName, partKVs, eventType);
    }

    public boolean isPartitionMarkedForEvent(String catalogId, String db_name, String tbl_name, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        throw new UnsupportedOperationException();
    }

    public List<String> listPartitionNames(String dbName, String tblName, short max) throws MetaException, TException {
        try {
            return this.listPartitionNames(dbName, tblName, Lists.newArrayList(), max);
        }
        catch (NoSuchObjectException e) {
            return Collections.emptyList();
        }
    }

    public List<String> listPartitionNames(String catalogId, String dbName, String tblName, int max) throws NoSuchObjectException, MetaException, TException {
        try {
            return this.listPartitionNames(catalogId, dbName, tblName, Lists.newArrayList(), max);
        }
        catch (NoSuchObjectException e) {
            return Collections.emptyList();
        }
    }

    public List<String> listPartitionNames(String databaseName, String tableName, List<String> values, short max) throws MetaException, TException, NoSuchObjectException {
        return this.listPartitionNames(this.catalogId, databaseName, tableName, values, max);
    }

    public List<String> listPartitionNames(String catalogId, String databaseName, String tableName, List<String> values, int max) throws MetaException, TException, NoSuchObjectException {
        return this.filterHook.filterPartitionNames(catalogId, databaseName, tableName, this.clientDelegate.listPartitionNames(catalogId, databaseName, tableName, values, max));
    }

    public PartitionValuesResponse listPartitionValues(PartitionValuesRequest partitionValuesRequest) throws MetaException, TException, NoSuchObjectException {
        throw new UnsupportedOperationException();
    }

    public int getNumPartitionsByFilter(String dbName, String tableName, String filter) throws MetaException, NoSuchObjectException, TException {
        return this.clientDelegate.getNumPartitionsByFilter(this.catalogId, dbName, tableName, filter);
    }

    public int getNumPartitionsByFilter(String catalogId, String dbName, String tableName, String filter) throws MetaException, NoSuchObjectException, TException {
        return this.clientDelegate.getNumPartitionsByFilter(catalogId, dbName, tableName, filter);
    }

    public PartitionSpecProxy listPartitionSpecs(String dbName, String tblName, int max) throws TException {
        return this.listPartitionSpecs(this.catalogId, dbName, tblName, max);
    }

    public PartitionSpecProxy listPartitionSpecs(String catalogId, String dbName, String tblName, int max) throws TException {
        return PartitionSpecProxy.Factory.get((List)this.filterHook.filterPartitionSpecs(this.clientDelegate.listPartitionSpecs(catalogId, dbName, tblName, max)));
    }

    public PartitionSpecProxy listPartitionSpecsByFilter(String dbName, String tblName, String filter, int max) throws MetaException, NoSuchObjectException, TException {
        return this.listPartitionSpecsByFilter(this.catalogId, dbName, tblName, filter, max);
    }

    public PartitionSpecProxy listPartitionSpecsByFilter(String catalogId, String dbName, String tblName, String filter, int max) throws MetaException, NoSuchObjectException, TException {
        return PartitionSpecProxy.Factory.get((List)this.filterHook.filterPartitionSpecs(this.clientDelegate.listPartitionSpecsByFilter(catalogId, dbName, tblName, filter, max)));
    }

    public List<Partition> listPartitions(String dbName, String tblName, short max) throws NoSuchObjectException, MetaException, TException {
        return this.listPartitions(dbName, tblName, Lists.newArrayList(), max);
    }

    public List<Partition> listPartitions(String catalogId, String dbName, String tblName, int max) throws NoSuchObjectException, MetaException, TException {
        return this.listPartitions(catalogId, dbName, tblName, Lists.newArrayList(), max);
    }

    public List<Partition> listPartitions(String databaseName, String tableName, List<String> values, short max) throws NoSuchObjectException, MetaException, TException {
        return this.listPartitions(this.catalogId, databaseName, tableName, values, max);
    }

    public List<Partition> listPartitions(String catalogId, String databaseName, String tableName, List<String> values, int max) throws NoSuchObjectException, MetaException, TException {
        return this.filterHook.filterPartitions(this.clientDelegate.listPartitions(catalogId, databaseName, tableName, values, max));
    }

    public boolean listPartitionsByExpr(String databaseName, String tableName, byte[] expr, String defaultPartitionName, short max, List<Partition> result) throws TException {
        Preconditions.checkNotNull(result, (Object)"The result argument cannot be null.");
        return this.listPartitionsByExpr(this.catalogId, databaseName, tableName, expr, defaultPartitionName, max, result);
    }

    public boolean listPartitionsByExpr(String catalogId, String databaseName, String tableName, byte[] expr, String defaultPartitionName, int max, List<Partition> result) throws TException {
        Preconditions.checkNotNull(result, (Object)"The result argument cannot be null.");
        ArrayList tmpResult = Lists.newArrayListWithExpectedSize((int)result.size());
        boolean hasUnknownPartitions = this.clientDelegate.listPartitionsByExpr(catalogId, databaseName, tableName, expr, defaultPartitionName, max, tmpResult);
        result.addAll(this.filterHook.filterPartitions((List)tmpResult));
        return hasUnknownPartitions;
    }

    public List<Partition> listPartitionsByFilter(String databaseName, String tableName, String filter, short max) throws MetaException, NoSuchObjectException, TException {
        return this.listPartitionsByFilter(this.catalogId, databaseName, tableName, filter, max);
    }

    public List<Partition> listPartitionsByFilter(String catalogId, String databaseName, String tableName, String filter, int max) throws MetaException, NoSuchObjectException, TException {
        return this.filterHook.filterPartitions(this.clientDelegate.listPartitionsByFilter(catalogId, databaseName, tableName, filter, max));
    }

    public List<Partition> listPartitionsWithAuthInfo(String database, String table, short maxParts, String user, List<String> groups) throws MetaException, TException, NoSuchObjectException {
        List<Partition> partitions = this.listPartitions(database, table, maxParts);
        for (Partition p : partitions) {
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setDbName(database);
            obj.setObjectName(table);
            obj.setPartValues(p.getValues());
            PrincipalPrivilegeSet set = this.get_privilege_set(obj, user, groups);
            p.setPrivileges(set);
        }
        return this.filterHook.filterPartitions(partitions);
    }

    public List<Partition> listPartitionsWithAuthInfo(String catalogId, String database, String table, int maxParts, String user, List<String> groups) throws MetaException, TException, NoSuchObjectException {
        List<Partition> partitions = this.listPartitions(catalogId, database, table, maxParts);
        for (Partition p : partitions) {
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setCatName(catalogId);
            obj.setDbName(database);
            obj.setObjectName(table);
            obj.setPartValues(p.getValues());
            PrincipalPrivilegeSet set = this.get_privilege_set(obj, user, groups);
            p.setPrivileges(set);
        }
        return this.filterHook.filterPartitions(partitions);
    }

    public List<Partition> listPartitionsWithAuthInfo(String database, String table, List<String> partVals, short maxParts, String user, List<String> groups) throws MetaException, TException, NoSuchObjectException {
        List<Partition> partitions = this.listPartitions(database, table, partVals, maxParts);
        for (Partition p : partitions) {
            PrincipalPrivilegeSet set;
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setDbName(database);
            obj.setObjectName(table);
            obj.setPartValues(p.getValues());
            try {
                set = this.get_privilege_set(obj, user, groups);
            }
            catch (MetaException e) {
                String msg = String.format("No privileges found for user: %s, groups: %s", user, String.join((CharSequence)",", groups));
                logger.error(msg, (Throwable)e);
                set = new PrincipalPrivilegeSet();
            }
            p.setPrivileges(set);
        }
        return this.filterHook.filterPartitions(partitions);
    }

    public List<Partition> listPartitionsWithAuthInfo(String catalogId, String database, String table, List<String> partVals, int maxParts, String user, List<String> groups) throws MetaException, TException, NoSuchObjectException {
        List<Partition> partitions = this.listPartitions(catalogId, database, table, partVals, maxParts);
        for (Partition p : partitions) {
            PrincipalPrivilegeSet set;
            HiveObjectRef obj = new HiveObjectRef();
            obj.setObjectType(HiveObjectType.PARTITION);
            obj.setCatName(catalogId);
            obj.setDbName(database);
            obj.setObjectName(table);
            obj.setPartValues(p.getValues());
            try {
                set = this.get_privilege_set(obj, user, groups);
            }
            catch (MetaException e) {
                String msg = String.format("No privileges found for user: %s, groups: %s", user, String.join((CharSequence)",", groups));
                logger.error(msg, (Throwable)e);
                set = new PrincipalPrivilegeSet();
            }
            p.setPrivileges(set);
        }
        return this.filterHook.filterPartitions(partitions);
    }

    public List<String> listTableNamesByFilter(String dbName, String filter, short maxTables) throws MetaException, TException, InvalidOperationException, UnknownDBException, UnsupportedOperationException {
        return this.listTableNamesByFilter(this.catalogId, dbName, filter, maxTables);
    }

    public List<String> listTableNamesByFilter(String catalogId, String dbName, String filter, int maxTables) throws TException, InvalidOperationException, UnknownDBException {
        return this.filterHook.filterTableNames(catalogId, dbName, this.clientDelegate.listTableNamesByFilter(catalogId, dbName, filter, maxTables));
    }

    public List<HiveObjectPrivilege> list_privileges(String principal, PrincipalType principalType, HiveObjectRef objectRef) throws MetaException, TException {
        return this.clientDelegate.listPrivileges(principal, principalType, objectRef);
    }

    public LockResponse lock(LockRequest lockRequest) throws NoSuchTxnException, TxnAbortedException, TException {
        return this.clientDelegate.lock(this.catalogId, lockRequest);
    }

    public void markPartitionForEvent(String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        this.clientDelegate.markPartitionForEvent(dbName, tblName, partKVs, eventType);
    }

    public void markPartitionForEvent(String catalogId, String dbName, String tblName, Map<String, String> partKVs, PartitionEventType eventType) throws MetaException, NoSuchObjectException, TException, UnknownTableException, UnknownDBException, UnknownPartitionException, InvalidPartitionException {
        throw new UnsupportedOperationException();
    }

    public long openTxn(String user) throws TException {
        return this.clientDelegate.openTxn(user);
    }

    public List<Long> replOpenTxn(String replPolicy, List<Long> srcTxnIds, String user) throws TException {
        throw new UnsupportedOperationException();
    }

    public OpenTxnsResponse openTxns(String user, int numTxns) throws TException {
        return this.clientDelegate.openTxns(user, numTxns);
    }

    public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        if (name.length() == 0) {
            return new HashMap<String, String>();
        }
        return Warehouse.makeSpecFromName((String)name);
    }

    public List<String> partitionNameToVals(String name) throws MetaException, TException {
        return this.clientDelegate.partitionNameToVals(name);
    }

    public void reconnect() throws MetaException {
        this.snapshotActiveConf();
    }

    public void renamePartition(String dbName, String tblName, List<String> partitionValues, Partition newPartition) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.renamePartition(this.catalogId, dbName, tblName, partitionValues, newPartition);
    }

    public void renamePartition(String catalogId, String dbName, String tblName, List<String> partitionValues, Partition newPartition) throws InvalidOperationException, MetaException, TException {
        this.clientDelegate.renamePartition(catalogId, dbName, tblName, partitionValues, newPartition);
    }

    public long renewDelegationToken(String tokenStrForm) throws MetaException, TException {
        return this.clientDelegate.renewDelegationToken(tokenStrForm);
    }

    public void rollbackTxn(long txnId) throws NoSuchTxnException, TException {
        this.clientDelegate.rollbackTxn(txnId);
    }

    public void replRollbackTxn(long srcTxnId, String replPolicy) throws NoSuchTxnException, TException {
        throw new UnsupportedOperationException();
    }

    public void setMetaConf(String key, String value) throws MetaException, TException {
        MetastoreConf.ConfVars confVar = MetastoreConf.getMetaConf((String)key);
        if (confVar == null) {
            throw new MetaException("Invalid configuration key " + key);
        }
        try {
            confVar.validate(value);
        }
        catch (IllegalArgumentException e) {
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException("Invalid configuration value " + value + " for key " + key + " by " + e.getMessage()), (Exception)e);
        }
        this.getConf().set(key, value);
    }

    public boolean setPartitionColumnStatistics(SetPartitionsStatsRequest request) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.clientDelegate.setPartitionColumnStatistics(this.catalogId, request);
    }

    public void flushCache() {
    }

    public Iterable<Map.Entry<Long, ByteBuffer>> getFileMetadata(List<Long> fileIds) throws TException {
        return this.clientDelegate.getFileMetadata(fileIds);
    }

    public Iterable<Map.Entry<Long, MetadataPpdResult>> getFileMetadataBySarg(List<Long> fileIds, ByteBuffer sarg, boolean doGetFooters) throws TException {
        return this.clientDelegate.getFileMetadataBySarg(fileIds, sarg, doGetFooters);
    }

    public void clearFileMetadata(List<Long> fileIds) throws TException {
        this.clientDelegate.clearFileMetadata(fileIds);
    }

    public void putFileMetadata(List<Long> fileIds, List<ByteBuffer> metadata) throws TException {
        this.clientDelegate.putFileMetadata(fileIds, metadata);
    }

    public boolean isSameConfObj(Configuration configuration) {
        return this.getConf() == configuration;
    }

    public boolean cacheFileMetadata(String dbName, String tblName, String partName, boolean allParts) throws TException {
        return this.clientDelegate.cacheFileMetadata(dbName, tblName, partName, allParts);
    }

    public List<SQLPrimaryKey> getPrimaryKeys(PrimaryKeysRequest primaryKeysRequest) throws MetaException, NoSuchObjectException, TException {
        return new ArrayList<SQLPrimaryKey>();
    }

    public List<SQLForeignKey> getForeignKeys(ForeignKeysRequest foreignKeysRequest) throws MetaException, NoSuchObjectException, TException {
        return new ArrayList<SQLForeignKey>();
    }

    public List<SQLUniqueConstraint> getUniqueConstraints(UniqueConstraintsRequest uniqueConstraintsRequest) throws MetaException, NoSuchObjectException, TException {
        return new ArrayList<SQLUniqueConstraint>();
    }

    public List<SQLNotNullConstraint> getNotNullConstraints(NotNullConstraintsRequest notNullConstraintsRequest) throws MetaException, NoSuchObjectException, TException {
        return new ArrayList<SQLNotNullConstraint>();
    }

    public List<SQLDefaultConstraint> getDefaultConstraints(DefaultConstraintsRequest defaultConstraintsRequest) throws MetaException, NoSuchObjectException, TException {
        return new ArrayList<SQLDefaultConstraint>();
    }

    public List<SQLCheckConstraint> getCheckConstraints(CheckConstraintsRequest checkConstraintsRequest) throws MetaException, NoSuchObjectException, TException {
        return new ArrayList<SQLCheckConstraint>();
    }

    public void createTableWithConstraints(Table tbl, List<SQLPrimaryKey> primaryKeys, List<SQLForeignKey> foreignKeys, List<SQLUniqueConstraint> uniqueConstraints, List<SQLNotNullConstraint> notNullConstraints, List<SQLDefaultConstraint> defaultConstraints, List<SQLCheckConstraint> checkConstraints) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public void dropConstraint(String dbName, String tblName, String constraintName) throws MetaException, NoSuchObjectException, TException {
        this.clientDelegate.dropConstraint(dbName, tblName, constraintName);
    }

    public void dropConstraint(String catalogId, String dbName, String tableName, String constraintName) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public void addPrimaryKey(List<SQLPrimaryKey> primaryKeyCols) throws MetaException, NoSuchObjectException, TException {
        this.clientDelegate.addPrimaryKey(primaryKeyCols);
    }

    public void addForeignKey(List<SQLForeignKey> foreignKeyCols) throws MetaException, NoSuchObjectException, TException {
        this.clientDelegate.addForeignKey(foreignKeyCols);
    }

    public void addUniqueConstraint(List<SQLUniqueConstraint> uniqueConstraintCols) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public void addNotNullConstraint(List<SQLNotNullConstraint> notNullConstraintCols) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public void addDefaultConstraint(List<SQLDefaultConstraint> defaultConstraints) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public void addCheckConstraint(List<SQLCheckConstraint> checkConstraints) throws MetaException, NoSuchObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public String getMetastoreDbUuid() throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void createResourcePlan(WMResourcePlan wmResourcePlan, String copyFromName) throws InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public WMFullResourcePlan getResourcePlan(String resourcePlanName) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public List<WMResourcePlan> getAllResourcePlans() throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void dropResourcePlan(String resourcePlanName) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public WMFullResourcePlan alterResourcePlan(String resourcePlanName, WMNullableResourcePlan wmNullableResourcePlan, boolean canActivateDisabled, boolean isForceDeactivate, boolean isReplace) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public WMFullResourcePlan getActiveResourcePlan() throws MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public WMValidateResourcePlanResponse validateResourcePlan(String resourcePlanName) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void createWMTrigger(WMTrigger wmTrigger) throws InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void alterWMTrigger(WMTrigger wmTrigger) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void dropWMTrigger(String resourcePlanName, String triggerName) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public List<WMTrigger> getTriggersForResourcePlan(String resourcePlan) throws NoSuchObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void createWMPool(WMPool wmPool) throws NoSuchObjectException, InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void alterWMPool(WMNullablePool wmNullablePool, String poolPath) throws NoSuchObjectException, InvalidObjectException, TException {
        throw new UnsupportedOperationException();
    }

    public void dropWMPool(String resourcePlanName, String poolPath) throws TException {
        throw new UnsupportedOperationException();
    }

    public void createOrUpdateWMMapping(WMMapping wmMapping, boolean isUpdate) throws TException {
        throw new UnsupportedOperationException();
    }

    public void dropWMMapping(WMMapping wmMapping) throws TException {
        throw new UnsupportedOperationException();
    }

    public void createOrDropTriggerToPoolMapping(String resourcePlanName, String triggerName, String poolPath, boolean shouldDrop) throws AlreadyExistsException, NoSuchObjectException, InvalidObjectException, MetaException, TException {
        throw new UnsupportedOperationException();
    }

    public void createISchema(ISchema iSchema) throws TException {
        throw new UnsupportedOperationException();
    }

    public void alterISchema(String catName, String dbName, String schemaName, ISchema newSchema) throws TException {
        throw new UnsupportedOperationException();
    }

    public ISchema getISchema(String catalogId, String dbName, String name) throws TException {
        throw new UnsupportedOperationException();
    }

    public void dropISchema(String catalogId, String dbName, String name) throws TException {
        throw new UnsupportedOperationException();
    }

    public void addSchemaVersion(SchemaVersion schemaVersion) throws TException {
        throw new UnsupportedOperationException();
    }

    public SchemaVersion getSchemaVersion(String catalogId, String dbName, String schemaName, int version) throws TException {
        throw new UnsupportedOperationException();
    }

    public SchemaVersion getSchemaLatestVersion(String catalogId, String dbName, String schemaName) throws TException {
        throw new UnsupportedOperationException();
    }

    public List<SchemaVersion> getSchemaAllVersions(String catalogId, String dbName, String schemaName) throws TException {
        throw new UnsupportedOperationException();
    }

    public void dropSchemaVersion(String catalogId, String dbName, String schemaName, int version) throws TException {
        throw new UnsupportedOperationException();
    }

    public FindSchemasByColsResp getSchemaByCols(FindSchemasByColsRqst findSchemasByColsRqst) throws TException {
        throw new UnsupportedOperationException();
    }

    public void mapSchemaVersionToSerde(String catalogId, String dbName, String schemaName, int version, String serdeName) throws TException {
        throw new UnsupportedOperationException();
    }

    public void setSchemaVersionState(String catalogId, String dbName, String schemaName, int version, SchemaVersionState state) throws TException {
        throw new UnsupportedOperationException();
    }

    public void addSerDe(SerDeInfo serDeInfo) throws TException {
        throw new UnsupportedOperationException();
    }

    public SerDeInfo getSerDe(String serDeName) throws TException {
        throw new UnsupportedOperationException();
    }

    public LockResponse lockMaterializationRebuild(String dbName, String tableName, long txnId) throws TException {
        throw new UnsupportedOperationException();
    }

    public boolean heartbeatLockMaterializationRebuild(String dbName, String tableName, long txnId) throws TException {
        throw new UnsupportedOperationException();
    }

    public void addRuntimeStat(RuntimeStat runtimeStat) throws TException {
        throw new UnsupportedOperationException();
    }

    public List<RuntimeStat> getRuntimeStats(int maxWeight, int maxCreateTime) throws TException {
        throw new UnsupportedOperationException();
    }

    public ShowCompactResponse showCompactions() throws TException {
        return this.clientDelegate.showCompactions();
    }

    public void addDynamicPartitions(long txnId, long writeId, String dbName, String tableName, List<String> partNames) throws TException {
        throw new UnsupportedOperationException();
    }

    public void addDynamicPartitions(long txnId, long writeId, String dbName, String tableName, List<String> partNames, DataOperationType operationType) throws TException {
        throw new UnsupportedOperationException();
    }

    public void insertTable(Table table, boolean overwrite) throws MetaException {
        this.clientDelegate.insertTable(table, overwrite);
    }

    public NotificationEventResponse getNextNotification(long lastEventId, int maxEvents, IMetaStoreClient.NotificationFilter notificationFilter) throws TException {
        return this.clientDelegate.getNextNotification(lastEventId, maxEvents, notificationFilter);
    }

    public CurrentNotificationEventId getCurrentNotificationEventId() throws TException {
        return this.clientDelegate.getCurrentNotificationEventId();
    }

    public NotificationEventsCountResponse getNotificationEventsCount(NotificationEventsCountRequest notificationEventsCountRequest) throws TException {
        throw new UnsupportedOperationException();
    }

    public FireEventResponse fireListenerEvent(FireEventRequest fireEventRequest) throws TException {
        return this.clientDelegate.fireListenerEvent(fireEventRequest);
    }

    @Deprecated
    public ShowLocksResponse showLocks() throws TException {
        return this.clientDelegate.showLocks();
    }

    public ShowLocksResponse showLocks(ShowLocksRequest showLocksRequest) throws TException {
        return this.clientDelegate.showLocks(showLocksRequest);
    }

    public GetOpenTxnsInfoResponse showTxns() throws TException {
        return this.clientDelegate.showTxns();
    }

    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        return this.tableExists(this.catalogId, databaseName, tableName);
    }

    public boolean tableExists(String catalogId, String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)catalogId);
        Preconditions.checkNotNull((Object)databaseName);
        try {
            Table result = this.getTable(databaseName, tableName);
            return result != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public void unlock(long lockId) throws NoSuchLockException, TxnOpenException, TException {
        this.clientDelegate.unlock(lockId);
    }

    public boolean updatePartitionColumnStatistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.clientDelegate.updatePartitionColumnStatistics(this.catalogId, columnStatistics);
    }

    public boolean updateTableColumnStatistics(ColumnStatistics columnStatistics) throws NoSuchObjectException, InvalidObjectException, MetaException, TException, InvalidInputException {
        return this.clientDelegate.updateTableColumnStatistics(this.catalogId, columnStatistics);
    }

    public void validatePartitionNameCharacters(List<String> part_vals) throws TException, MetaException {
        try {
            MetaStoreUtils.validatePartitionNameCharacters(part_vals, (Pattern)this.partitionValidationPattern);
        }
        catch (Exception e) {
            if (e instanceof MetaException) {
                throw (MetaException)((Object)e);
            }
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException(e.getMessage()), (Exception)e);
        }
    }
}

