/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive2;

import com.aliyun.datalake.metastore.hive2.ProxyMetaStoreClient;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hive.hcatalog.common.HiveClientCache;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DLFCacheableMetaStoreClient
extends ProxyMetaStoreClient
implements HiveClientCache.ICacheableMetaStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(DLFCacheableMetaStoreClient.class);
    private final AtomicInteger users = new AtomicInteger(0);
    private volatile boolean expiredFromCache = false;
    private boolean isClosed = false;

    DLFCacheableMetaStoreClient(HiveConf conf, Integer timeout, Boolean allowEmbedded) throws MetaException {
        super(conf, null, allowEmbedded);
    }

    public synchronized void acquire() {
        this.users.incrementAndGet();
        if (this.users.get() > 1) {
            logger.warn("Unexpected increment of user count beyond one: " + this.users.get() + " " + this);
        }
    }

    private void release() {
        if (this.users.get() > 0) {
            this.users.decrementAndGet();
        } else {
            logger.warn("Unexpected attempt to decrement user count of zero: " + this.users.get() + " " + this);
        }
    }

    public synchronized void setExpiredFromCache() {
        if (this.users.get() != 0) {
            logger.warn("Evicted client has non-zero user count: " + this.users.get());
        }
        this.expiredFromCache = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public AtomicInteger getUsers() {
        return this.users;
    }

    @Deprecated
    public boolean isOpen() {
        try {
            super.getDatabases("NonExistentDatabaseUsedForHealthCheck");
        }
        catch (TException e) {
            return false;
        }
        return true;
    }

    @Override
    public synchronized void close() {
        this.release();
        this.tearDownIfUnused();
    }

    public synchronized void tearDownIfUnused() {
        if (this.users.get() != 0) {
            logger.warn("Non-zero user count preventing client tear down: users=" + this.users.get() + " expired=" + this.expiredFromCache);
        }
        if (this.users.get() == 0 && this.expiredFromCache) {
            this.tearDown();
        }
    }

    public void tearDown() {
        try {
            if (!this.isClosed) {
                super.close();
            }
            this.isClosed = true;
        }
        catch (Exception e) {
            logger.warn("Error closing hive metastore client. Ignored.", (Throwable)e);
        }
    }

    public String toString() {
        return "HCatClient: thread: " + Thread.currentThread().getId() + " users=" + this.users.get() + " expired=" + this.expiredFromCache + " closed=" + this.isClosed;
    }

    protected void finalize() throws Throwable {
        if (this.users.get() != 0) {
            logger.warn("Closing client with non-zero user count: users=" + this.users.get() + " expired=" + this.expiredFromCache);
        }
        try {
            this.tearDown();
        }
        finally {
            super.finalize();
        }
    }
}

