/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive.common.utils;

import com.aliyun.datalake.metastore.common.util.ProxyLogUtils;
import com.aliyun.datalake.metastore.hive.shims.IHiveShims;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hive.common.util.HiveVersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    public static boolean isExternalTable(Table table) {
        return TableType.EXTERNAL_TABLE.name().equals(table.getTableType()) || Utils.isExternalTableSetInParameters(table);
    }

    public static boolean isExternalTableSetInParameters(Table table) {
        if (table.getParameters() == null) {
            return false;
        }
        return Boolean.parseBoolean((String)table.getParameters().get("EXTERNAL"));
    }

    public static Path constructRenamedPath(Path newPath, Path currentPath) {
        URI currentUri = currentPath.toUri();
        return new Path(currentUri.getScheme(), currentUri.getAuthority(), newPath.toUri().getPath());
    }

    public static String lowerCaseConvertPartName(String partName) throws MetaException {
        boolean isFirst = true;
        Map partSpec = Warehouse.makeEscSpecFromName((String)partName);
        String convertedPartName = new String();
        for (Map.Entry entry : partSpec.entrySet()) {
            String partColName = (String)entry.getKey();
            String partColVal = (String)entry.getValue();
            if (!isFirst) {
                convertedPartName = convertedPartName + "/";
            } else {
                isFirst = false;
            }
            convertedPartName = convertedPartName + partColName.toLowerCase() + "=" + partColVal;
        }
        return convertedPartName;
    }

    public static boolean supportRewrite() {
        return HiveVersionInfo.getShortVersion().startsWith("2.3") || HiveVersionInfo.getShortVersion().startsWith("3.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryRename(FileSystem fileSystem, Path src, Path dest, boolean enableFsOperation) {
        long startTime = System.currentTimeMillis();
        boolean exists = false;
        boolean rename = false;
        try {
            if (enableFsOperation) {
                exists = fileSystem.exists(src);
                rename = fileSystem.rename(src, dest);
                boolean bl = exists && rename;
                return bl;
            }
            exists = true;
            rename = true;
            boolean bl = exists && rename;
            return bl;
        }
        catch (IOException ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            boolean existsFinal = exists;
            boolean renameFinal = rename;
            ProxyLogUtils.printLog(() -> logger.info("dlf.fs.{}.tryRename, exists:{}, rename:{}, cost:{}ms, src:{}, dest:{}", new Object[]{IHiveShims.realMessage((boolean)enableFsOperation), existsFinal, renameFinal, System.currentTimeMillis() - startTime, src, dest}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renameDir(Warehouse warehouse, Path src, Path dest, boolean inheritPerms, boolean enableFsOperation) throws MetaException {
        long startTime = System.currentTimeMillis();
        boolean rename = false;
        try {
            rename = enableFsOperation ? warehouse.renameDir(src, dest, inheritPerms) : true;
            boolean bl = rename;
            return bl;
        }
        finally {
            boolean renameFinal = rename;
            ProxyLogUtils.printLog(() -> logger.info("dlf.fs.{}.renameDir, result:{}, cost:{}ms, src:{}, dest:{}", new Object[]{IHiveShims.realMessage((boolean)enableFsOperation), renameFinal, System.currentTimeMillis() - startTime, src, dest}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renameFs(FileSystem fs, Path src, Path dest, boolean enableFsOperation) throws IOException {
        long startTime = System.currentTimeMillis();
        boolean rename = false;
        try {
            rename = enableFsOperation ? fs.rename(src, dest) : true;
            boolean bl = rename;
            return bl;
        }
        finally {
            boolean renameFinal = rename;
            ProxyLogUtils.printLog(() -> logger.info("dlf.fs.{}.renameFs, result:{}, cost:{}ms, src:{}, dest:{}", new Object[]{IHiveShims.realMessage((boolean)enableFsOperation), renameFinal, System.currentTimeMillis() - startTime, src, dest}));
        }
    }

    public static boolean isSubdirectory(Path parent, Path other) {
        return other.toString().startsWith(parent.toString());
    }

    public static boolean isEmptyDir(Warehouse warehouse, Path path) throws IOException, MetaException {
        int listCount = warehouse.getFs(path).listStatus(path).length;
        return listCount == 0;
    }
}

