/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive.common.utils;

import com.aliyun.datalake.metastore.hive.shims.IHiveShims;
import com.aliyun.datalake.metastore.hive.shims.ShimsLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.TableMeta;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionClientUtils {
    public static final IHiveShims HIVE_SHIMS = ShimsLoader.getHiveShims();
    public static final Logger LOG = LoggerFactory.getLogger(SessionClientUtils.class);

    public static org.apache.hadoop.hive.metastore.api.Table deepCopy(org.apache.hadoop.hive.metastore.api.Table table) {
        org.apache.hadoop.hive.metastore.api.Table copy = null;
        if (table != null) {
            copy = new org.apache.hadoop.hive.metastore.api.Table(table);
        }
        return copy;
    }

    public static FieldSchema deepCopy(FieldSchema schema) {
        FieldSchema copy = null;
        if (schema != null) {
            copy = new FieldSchema(schema);
        }
        return copy;
    }

    public static List<FieldSchema> deepCopyFieldSchemas(List<FieldSchema> schemas) {
        ArrayList<FieldSchema> copy = null;
        if (schemas != null) {
            copy = new ArrayList<FieldSchema>();
            for (FieldSchema schema : schemas) {
                copy.add(SessionClientUtils.deepCopy(schema));
            }
        }
        return copy;
    }

    public static PrincipalPrivilegeSet deepCopy(PrincipalPrivilegeSet pps) {
        PrincipalPrivilegeSet copy = null;
        if (pps != null) {
            copy = new PrincipalPrivilegeSet(pps);
        }
        return copy;
    }

    public static List<String> mergeSortList(List<String> tableNames, Set<String> tempTableNames) {
        HashSet<String> allTableNames = new HashSet<String>(tableNames.size() + tempTableNames.size());
        allTableNames.addAll(tableNames);
        allTableNames.addAll(tempTableNames);
        tableNames = new ArrayList<String>(allTableNames);
        Collections.sort(tableNames);
        return tableNames;
    }

    public static List<String> mergeSortListWithPattern(List<String> tableNames, Set<String> tempTableNames, String tablePattern) {
        tablePattern = tablePattern.replaceAll("\\*", ".*");
        Pattern pattern = Pattern.compile(tablePattern);
        Matcher matcher = pattern.matcher("");
        HashSet<String> combinedTableNames = new HashSet<String>();
        for (String tableName : tempTableNames) {
            matcher.reset(tableName);
            if (!matcher.matches()) continue;
            combinedTableNames.add(tableName);
        }
        combinedTableNames.addAll(tableNames);
        tableNames = new ArrayList<String>(combinedTableNames);
        Collections.sort(tableNames);
        return tableNames;
    }

    /*
     * WARNING - void declaration
     */
    public static void mergeTableMeta(String dbPatterns, String tablePatterns, List<String> tableTypes, List<TableMeta> tableMetas, Map<String, Map<String, Table>> tmpTables) {
        void var8_10;
        ArrayList<Matcher> dbPatternList = new ArrayList<Matcher>();
        String[] stringArray = dbPatterns.split("\\|");
        int n = stringArray.length;
        boolean bl = false;
        while (var8_10 < n) {
            String element = stringArray[var8_10];
            dbPatternList.add(Pattern.compile(element.replaceAll("\\*", ".*")).matcher(""));
            ++var8_10;
        }
        ArrayList<Matcher> tblPatternList = new ArrayList<Matcher>();
        for (String element : tablePatterns.split("\\|")) {
            tblPatternList.add(Pattern.compile(element.replaceAll("\\*", ".*")).matcher(""));
        }
        for (Map.Entry entry : tmpTables.entrySet()) {
            if (!SessionClientUtils.matchesAny((String)entry.getKey(), dbPatternList)) continue;
            for (Map.Entry inner : ((Map)entry.getValue()).entrySet()) {
                Table table = (Table)inner.getValue();
                String tableName = table.getTableName();
                String typeString = table.getTableType().name();
                if (tableTypes != null && !tableTypes.contains(typeString) || !SessionClientUtils.matchesAny((String)inner.getKey(), tblPatternList)) continue;
                TableMeta tableMeta = new TableMeta(table.getDbName(), tableName, typeString);
                tableMeta.setComments(table.getProperty("comment"));
                tableMetas.add(tableMeta);
            }
        }
    }

    private static boolean matchesAny(String string, List<Matcher> matchers) {
        for (Matcher matcher : matchers) {
            if (!matcher.reset(string).matches()) continue;
            return true;
        }
        return matchers.isEmpty();
    }

    public static void createTempTableDir(SessionState ss, Warehouse wh, org.apache.hadoop.hive.metastore.api.Table tbl, String dbName, String tblName, Map<String, Table> tables, Boolean enableFsOperation) throws MetaException {
        Path tblPath = wh.getDnsPath(new Path(tbl.getSd().getLocation()));
        if (tblPath == null) {
            throw new MetaException("Temp table path not set for " + tbl.getTableName());
        }
        if (!wh.isDir(tblPath) && !HIVE_SHIMS.mkdirs(wh, tblPath, true, enableFsOperation)) {
            throw new MetaException(tblPath + " is not a directory or unable to create one");
        }
        tbl.getSd().setLocation(tblPath.toString());
        Table tTable = new Table(tbl);
        if (tables == null) {
            tables = new HashMap<String, Table>();
            ss.getTempTables().put(dbName, tables);
        }
        tables.put(tblName, tTable);
    }

    public static Path isExistsTempLocation(org.apache.hadoop.hive.metastore.api.Table table, Warehouse wh, HiveConf conf) throws MetaException {
        Path tablePath = null;
        String pathStr = table.getSd().getLocation();
        if (pathStr != null) {
            try {
                tablePath = new Path(table.getSd().getLocation());
                if (!wh.isWritable(tablePath.getParent())) {
                    throw new MetaException("Table metadata not deleted since " + tablePath.getParent() + " is not writable by " + conf.getUser());
                }
            }
            catch (IOException err) {
                MetaException metaException = new MetaException("Error checking temp table path for " + table.getTableName());
                metaException.initCause((Throwable)err);
                throw metaException;
            }
        }
        return tablePath;
    }

    public static void dropTempDir(org.apache.hadoop.hive.metastore.api.Table table, Path tablePath, Warehouse wh, boolean deleteData, EnvironmentContext envContext, Boolean enableFsOperation) {
        if (deleteData && !MetaStoreUtils.isExternalTable((org.apache.hadoop.hive.metastore.api.Table)table)) {
            try {
                boolean ifPurge = false;
                if (envContext != null) {
                    ifPurge = Boolean.parseBoolean((String)envContext.getProperties().get("ifPurge"));
                }
                HIVE_SHIMS.deleteDir(wh, tablePath, true, ifPurge, false, enableFsOperation);
            }
            catch (Exception err) {
                LOG.error("Failed to delete temp table directory: " + tablePath, (Throwable)err);
            }
        }
    }
}

