/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive.common.utils;

import com.aliyun.datalake.metastore.common.DataLakeConfig;
import com.aliyun.datalake.metastore.common.ProxyMode;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;

public class ConfigUtils {
    public static ProxyMode getProxyMode(Configuration conf) {
        String proxyModeString = conf.get("dlf.catalog.proxyMode", ProxyMode.DLF_ONLY.name());
        return ProxyMode.valueOf((String)proxyModeString);
    }

    public static Optional<String> getAccessKeyId(Configuration conf) {
        String keyId = conf.get("dlf.catalog.accessKeyId");
        if (keyId == null || keyId.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(keyId);
    }

    public static Optional<String> getAccessKeySecret(Configuration conf) {
        String keySecret = conf.get("dlf.catalog.accessKeySecret");
        if (keySecret == null || keySecret.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(keySecret);
    }

    public static Optional<String> getRegionId(Configuration conf) {
        String regionId = conf.get("dlf.catalog.region");
        if (regionId == null || regionId.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(regionId);
    }

    public static Optional<String> getSecurityToken(Configuration conf) {
        String securityToken = conf.get("dlf.catalog.securityToken");
        if (securityToken == null || securityToken.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(securityToken);
    }

    public static Optional<String> getEndPoint(Configuration conf) {
        String endpoint = conf.get("dlf.catalog.endpoint");
        if (endpoint == null || endpoint.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(endpoint);
    }

    public static String getCatalogId(Configuration conf) {
        String catalog = conf.get("dlf.catalog.id");
        if (catalog == null || catalog.isEmpty()) {
            return "";
        }
        return catalog;
    }

    public static short getPageSize(Configuration conf) {
        try {
            int size = conf.getInt("dlf.catalog.pageSize", 500);
            if (size > Short.MAX_VALUE || size < 0) {
                return 500;
            }
            return (short)size;
        }
        catch (Exception e) {
            return 500;
        }
    }

    public static int getAccurateListBatchSize(Configuration conf) {
        int size;
        try {
            size = conf.getInt("dlf.catalog.accurate.batchSize", 60);
            if (size > Short.MAX_VALUE || size < 0) {
                size = 60;
            }
        }
        catch (Exception e) {
            size = 60;
        }
        return size;
    }

    public static short getColStatsPageSize(Configuration conf) {
        try {
            int size = conf.getInt("dlf.catalog.client.col.stats.pageSize", 1000);
            if (size > Short.MAX_VALUE || size < 0 && size != -1) {
                return 1000;
            }
            return (short)size;
        }
        catch (Exception e) {
            return 1000;
        }
    }

    public static short getTableColStatsPageSize(Configuration conf) {
        try {
            int size = conf.getInt("dlf.catalog.client.table.col.stats.pageSize", 50);
            if (size > Short.MAX_VALUE || size < 0 && size != -1) {
                return 50;
            }
            return (short)size;
        }
        catch (Exception e) {
            return 50;
        }
    }

    public static DataLakeConfig.AKMode akMode(Configuration conf) {
        if (conf.get("dlf.catalog.akMode") != null) {
            return DataLakeConfig.AKMode.valueOf((String)conf.get("dlf.catalog.akMode"));
        }
        return DataLakeConfig.DEFAULT_AK_MODE;
    }

    public static boolean isNewSTSMode(Configuration conf) {
        return conf.getBoolean("dlf.catalog.sts.isNewMode", true);
    }

    public static String getUserId(Configuration conf) {
        return conf.get("dlf.catalog.uid");
    }

    public static int getReadTimeout(Configuration conf) {
        try {
            int timeout = conf.getInt("dlf.catalog.server.read.timeout.mills", 30000);
            if (timeout > 60000 || timeout < 0) {
                return 30000;
            }
            return timeout;
        }
        catch (Exception e) {
            return 30000;
        }
    }

    public static int getConnTimeout(Configuration conf) {
        try {
            int timeout = conf.getInt("dlf.catalog.server.conn.timeout.mills", 30000);
            if (timeout > 60000 || timeout < 0) {
                return 30000;
            }
            return timeout;
        }
        catch (Exception e) {
            return 30000;
        }
    }

    public static int getMetaStoreNumThreads(Configuration conf) {
        return conf.getInt("dlf.catalog.client.threads", 5);
    }

    public static String getRole(Configuration conf) {
        return conf.get("dlf.catalog.role");
    }

    public static Boolean getEnableFileOperation(Configuration conf) {
        return conf.getBoolean("dlf.catalog.enable.file.operation", false);
    }

    public static double getEnableFileOperationGrayRate(Configuration conf) {
        double gray = conf.getDouble("dlf.catalog.enable.file.operation.gray.rate", 0.0);
        return gray;
    }

    public static boolean getDefaultDbCreateTableUseCurrentDbLocation(Configuration conf) {
        boolean enableModify = conf.getBoolean("dlf.catalog.defaultdb.createtable.use.current.db.location", false);
        return enableModify;
    }
}

