/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive.common.converters;

import com.aliyun.datalake.metastore.hive.common.utils.Utils;
import com.aliyun.datalake.metastore.hive.shims.IHiveShims;
import com.aliyun.datalake20200710.models.ColumnStatisticsDesc;
import com.aliyun.datalake20200710.models.ColumnStatisticsObj;
import com.aliyun.datalake20200710.models.Function;
import com.aliyun.datalake20200710.models.FunctionInput;
import com.aliyun.datalake20200710.models.LockObj;
import com.aliyun.datalake20200710.models.Partition;
import com.aliyun.datalake20200710.models.PartitionInput;
import com.aliyun.datalake20200710.models.PrincipalPrivilegeSet;
import com.aliyun.datalake20200710.models.PrivilegeGrantInfo;
import com.aliyun.datalake20200710.models.ResourceUri;
import com.aliyun.datalake20200710.models.SerDeInfo;
import com.aliyun.datalake20200710.models.StorageDescriptor;
import com.aliyun.datalake20200710.models.TableInput;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveToCatalogConverter {
    public static com.aliyun.datalake20200710.models.Database toCatalogDatabase(Database hiveDatabase) {
        com.aliyun.datalake20200710.models.Database catalogDb = new com.aliyun.datalake20200710.models.Database();
        catalogDb.description = hiveDatabase.getDescription();
        catalogDb.locationUri = hiveDatabase.getLocationUri();
        catalogDb.name = hiveDatabase.getName();
        catalogDb.ownerName = hiveDatabase.getOwnerName();
        catalogDb.ownerType = HiveToCatalogConverter.toCatalogPrincipalTypeString(hiveDatabase.getOwnerType());
        catalogDb.parameters = (Map)ObjectUtils.firstNonNull((Object[])new Map[]{hiveDatabase.getParameters(), Maps.newHashMap()});
        catalogDb.privileges = HiveToCatalogConverter.toCatalogPrivilegeSet(hiveDatabase.getPrivileges());
        return catalogDb;
    }

    public static TableInput toCatalogTableInput(Table table) {
        TableInput tableInput = new TableInput();
        tableInput.tableName = table.getTableName();
        tableInput.databaseName = table.getDbName();
        tableInput.owner = table.getOwner();
        tableInput.sd = HiveToCatalogConverter.toCatalogStorageDescriptor(table.getSd());
        tableInput.partitionKeys = HiveToCatalogConverter.toCatalogCols(table.getPartitionKeys());
        tableInput.parameters = table.getParameters();
        tableInput.viewOriginalText = table.getViewOriginalText();
        tableInput.viewExpandedText = table.getViewExpandedText();
        tableInput.tableType = table.getTableType();
        tableInput.privileges = HiveToCatalogConverter.toCatalogPrivilegeSet(table.getPrivileges());
        if (table.isSetLastAccessTime()) {
            tableInput.lastAccessTime = table.getLastAccessTime();
        }
        if (table.isSetRetention()) {
            tableInput.retention = table.getRetention();
        }
        if (table.isSetTemporary()) {
            tableInput.temporary = table.isTemporary();
        }
        if (Utils.supportRewrite() && table.isSetRewriteEnabled()) {
            tableInput.rewriteEnabled = table.isRewriteEnabled();
        }
        return tableInput;
    }

    public static com.aliyun.datalake20200710.models.Table toCatalogTable(Table table) {
        if (table == null) {
            return null;
        }
        com.aliyun.datalake20200710.models.Table catalogTable = new com.aliyun.datalake20200710.models.Table();
        catalogTable.tableName = table.getTableName();
        catalogTable.databaseName = table.getDbName();
        catalogTable.owner = table.getOwner();
        catalogTable.sd = HiveToCatalogConverter.toCatalogStorageDescriptor(table.getSd());
        catalogTable.partitionKeys = HiveToCatalogConverter.toCatalogCols(table.getPartitionKeys());
        catalogTable.parameters = table.getParameters();
        catalogTable.viewOriginalText = table.getViewOriginalText();
        catalogTable.viewExpandedText = table.getViewExpandedText();
        catalogTable.tableType = table.getTableType();
        catalogTable.privileges = HiveToCatalogConverter.toCatalogPrivilegeSet(table.getPrivileges());
        if (table.isSetCreateTime()) {
            catalogTable.createTime = table.getCreateTime();
        }
        if (table.isSetLastAccessTime()) {
            catalogTable.lastAccessTime = table.getLastAccessTime();
        }
        if (table.isSetRetention()) {
            catalogTable.retention = table.getRetention();
        }
        if (table.isSetTemporary()) {
            catalogTable.temporary = table.isTemporary();
        }
        if (Utils.supportRewrite() && table.isSetRewriteEnabled()) {
            catalogTable.rewriteEnabled = table.isRewriteEnabled();
        }
        return catalogTable;
    }

    public static StorageDescriptor toCatalogStorageDescriptor(org.apache.hadoop.hive.metastore.api.StorageDescriptor sd) {
        if (null == sd) {
            return null;
        }
        StorageDescriptor storageDescriptor = new StorageDescriptor();
        storageDescriptor.location = sd.getLocation();
        storageDescriptor.bucketCols = sd.getBucketCols();
        storageDescriptor.cols = HiveToCatalogConverter.toCatalogCols(sd.getCols());
        storageDescriptor.inputFormat = sd.getInputFormat();
        storageDescriptor.outputFormat = sd.getOutputFormat();
        storageDescriptor.compressed = sd.isCompressed();
        storageDescriptor.numBuckets = sd.getNumBuckets();
        storageDescriptor.serDeInfo = HiveToCatalogConverter.toCatalogSerdeInfo(sd.getSerdeInfo());
        storageDescriptor.sortCols = HiveToCatalogConverter.toCatalogSortCols(sd.getSortCols());
        storageDescriptor.skewedInfo = HiveToCatalogConverter.toCatalogSkewedInfo(sd.getSkewedInfo());
        storageDescriptor.parameters = sd.getParameters();
        storageDescriptor.storedAsSubDirectories = sd.isStoredAsSubDirectories();
        return storageDescriptor;
    }

    public static List<com.aliyun.datalake20200710.models.FieldSchema> toCatalogCols(List<FieldSchema> cols) {
        if (cols == null) {
            return null;
        }
        ArrayList<com.aliyun.datalake20200710.models.FieldSchema> fieldSchemas = new ArrayList<com.aliyun.datalake20200710.models.FieldSchema>();
        cols.forEach(c -> fieldSchemas.add(HiveToCatalogConverter.toCatalogColSchema(c)));
        return fieldSchemas;
    }

    public static com.aliyun.datalake20200710.models.FieldSchema toCatalogColSchema(FieldSchema schema) {
        com.aliyun.datalake20200710.models.FieldSchema fieldSchema = new com.aliyun.datalake20200710.models.FieldSchema();
        fieldSchema.comment = schema.getComment();
        fieldSchema.name = schema.getName();
        fieldSchema.type = schema.getType();
        return fieldSchema;
    }

    public static SerDeInfo toCatalogSerdeInfo(org.apache.hadoop.hive.metastore.api.SerDeInfo serdeInfo) {
        if (serdeInfo == null) {
            return null;
        }
        SerDeInfo catalogSerdeInfo = new SerDeInfo();
        catalogSerdeInfo.name = serdeInfo.getName();
        catalogSerdeInfo.parameters = serdeInfo.getParameters();
        catalogSerdeInfo.serializationLib = serdeInfo.getSerializationLib();
        return catalogSerdeInfo;
    }

    public static com.aliyun.datalake20200710.models.SkewedInfo toCatalogSkewedInfo(SkewedInfo skewedInfo) {
        if (skewedInfo == null) {
            return null;
        }
        com.aliyun.datalake20200710.models.SkewedInfo catalogSkewedInfo = new com.aliyun.datalake20200710.models.SkewedInfo();
        catalogSkewedInfo.skewedColNames = skewedInfo.getSkewedColNames();
        catalogSkewedInfo.skewedColValues = skewedInfo.getSkewedColValues();
        catalogSkewedInfo.setSkewedColValueLocationMaps(HiveToCatalogConverter.toCatalogSkewedColValueLocationMaps(skewedInfo.getSkewedColValueLocationMaps()));
        return catalogSkewedInfo;
    }

    public static Map<String, String> toCatalogSkewedColValueLocationMaps(Map<List<String>, String> skewedColValueLocationMaps) {
        if (skewedColValueLocationMaps == null) {
            return null;
        }
        HashMap<String, String> transformedMap = new HashMap<String, String>(skewedColValueLocationMaps.size());
        skewedColValueLocationMaps.forEach((k, v) -> transformedMap.put(new Gson().toJson(k), (String)v));
        return transformedMap;
    }

    public static List<com.aliyun.datalake20200710.models.Order> toCatalogSortCols(List<Order> sortCols) {
        if (sortCols == null) {
            return null;
        }
        ArrayList<com.aliyun.datalake20200710.models.Order> catalogOrders = new ArrayList<com.aliyun.datalake20200710.models.Order>();
        sortCols.forEach(order -> catalogOrders.add(HiveToCatalogConverter.toCatalogOrder(order)));
        return catalogOrders;
    }

    public static com.aliyun.datalake20200710.models.Order toCatalogOrder(Order order) {
        if (order == null) {
            return null;
        }
        com.aliyun.datalake20200710.models.Order catalogOrder = new com.aliyun.datalake20200710.models.Order();
        catalogOrder.col = order.getCol();
        catalogOrder.order = order.getOrder();
        return catalogOrder;
    }

    public static Partition toCatalogPartition(org.apache.hadoop.hive.metastore.api.Partition hivePartition) {
        if (hivePartition == null) {
            return null;
        }
        Partition catalogPartition = new Partition();
        catalogPartition.databaseName = hivePartition.getDbName();
        catalogPartition.tableName = hivePartition.getTableName();
        catalogPartition.createTime = hivePartition.getCreateTime();
        catalogPartition.lastAccessTime = hivePartition.getLastAccessTime();
        catalogPartition.sd = HiveToCatalogConverter.toCatalogStorageDescriptor(hivePartition.getSd());
        catalogPartition.privileges = HiveToCatalogConverter.toCatalogPrivilegeSet(hivePartition.getPrivileges());
        if (hivePartition.getParameters() != null) {
            catalogPartition.parameters = new HashMap(hivePartition.getParameters());
        }
        if (hivePartition.getValues() != null) {
            catalogPartition.values = new ArrayList(hivePartition.getValues());
        }
        return catalogPartition;
    }

    public static PartitionInput toCatalogPartitionInput(org.apache.hadoop.hive.metastore.api.Partition hivePartition) {
        if (hivePartition == null) {
            return null;
        }
        PartitionInput partitionInput = new PartitionInput();
        partitionInput.databaseName = hivePartition.getDbName();
        partitionInput.tableName = hivePartition.getTableName();
        partitionInput.lastAccessTime = hivePartition.getLastAccessTime();
        partitionInput.sd = HiveToCatalogConverter.toCatalogStorageDescriptor(hivePartition.getSd());
        partitionInput.privileges = HiveToCatalogConverter.toCatalogPrivilegeSet(hivePartition.getPrivileges());
        if (hivePartition.getParameters() != null) {
            partitionInput.parameters = new HashMap(hivePartition.getParameters());
        }
        if (hivePartition.getValues() != null) {
            partitionInput.values = new ArrayList(hivePartition.getValues());
        }
        return partitionInput;
    }

    public static PrincipalPrivilegeSet toCatalogPrivilegeSet(org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet privileges) {
        if (privileges == null) {
            return null;
        }
        PrincipalPrivilegeSet catalogPrivilegeSet = new PrincipalPrivilegeSet();
        catalogPrivilegeSet.groupPrivileges = HiveToCatalogConverter.toCatalogPrivilegeMap(privileges.getGroupPrivileges());
        catalogPrivilegeSet.rolePrivileges = HiveToCatalogConverter.toCatalogPrivilegeMap(privileges.getRolePrivileges());
        catalogPrivilegeSet.userPrivileges = HiveToCatalogConverter.toCatalogPrivilegeMap(privileges.getUserPrivileges());
        return catalogPrivilegeSet;
    }

    private static Map<String, List<PrivilegeGrantInfo>> toCatalogPrivilegeMap(Map<String, List<org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo>> groupPrivileges) {
        if (groupPrivileges == null) {
            return null;
        }
        HashMap<String, List<PrivilegeGrantInfo>> catalogPrivileges = new HashMap<String, List<PrivilegeGrantInfo>>(groupPrivileges.size());
        groupPrivileges.forEach((k, v) -> catalogPrivileges.put((String)k, HiveToCatalogConverter.toCatalogGrantInfoList(v)));
        return catalogPrivileges;
    }

    private static List<PrivilegeGrantInfo> toCatalogGrantInfoList(List<org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo> privilegeGrantInfos) {
        if (privilegeGrantInfos == null) {
            return null;
        }
        ArrayList<PrivilegeGrantInfo> infoList = new ArrayList<PrivilegeGrantInfo>(privilegeGrantInfos.size());
        privilegeGrantInfos.forEach(t -> infoList.add(HiveToCatalogConverter.toCatalogGrantInfo(t)));
        return infoList;
    }

    private static PrivilegeGrantInfo toCatalogGrantInfo(org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo hiveInfo) {
        if (hiveInfo == null) {
            return null;
        }
        PrivilegeGrantInfo privilegeGrantInfo = new PrivilegeGrantInfo();
        privilegeGrantInfo.privilege = hiveInfo.getPrivilege();
        privilegeGrantInfo.grantor = hiveInfo.getGrantor();
        privilegeGrantInfo.grantOption = hiveInfo.isGrantOption();
        privilegeGrantInfo.grantorType = HiveToCatalogConverter.toCatalogPrincipalTypeString(hiveInfo.getGrantorType());
        privilegeGrantInfo.createTime = hiveInfo.getCreateTime();
        return privilegeGrantInfo;
    }

    public static String toCatalogPrincipalTypeString(PrincipalType ownerType) {
        if (ownerType == null) {
            return null;
        }
        return ownerType.name();
    }

    public static Function toCatalogFunction(String catalogName, org.apache.hadoop.hive.metastore.api.Function function) {
        if (null == function) {
            return null;
        }
        Function catalogFunction = new Function();
        catalogFunction.catalogId = catalogName;
        catalogFunction.databaseName = function.getDbName();
        catalogFunction.className = function.getClassName();
        catalogFunction.functionName = function.getFunctionName();
        catalogFunction.functionType = HiveToCatalogConverter.toCatalogFunctionTypeString(function.getFunctionType());
        catalogFunction.ownerName = function.getOwnerName();
        catalogFunction.ownerType = HiveToCatalogConverter.toCatalogPrincipalTypeString(function.getOwnerType());
        catalogFunction.createTime = function.getCreateTime();
        catalogFunction.resourceUri = HiveToCatalogConverter.toCatalogResourceUriList(function.getResourceUris());
        return catalogFunction;
    }

    public static FunctionInput toCatalogFunctionInput(String catalogId, org.apache.hadoop.hive.metastore.api.Function function) {
        if (null == function) {
            return null;
        }
        FunctionInput catalogFunction = new FunctionInput();
        catalogFunction.className = function.getClassName();
        catalogFunction.functionName = function.getFunctionName();
        catalogFunction.functionType = HiveToCatalogConverter.toCatalogFunctionTypeString(function.getFunctionType());
        catalogFunction.ownerName = function.getOwnerName();
        catalogFunction.ownerType = HiveToCatalogConverter.toCatalogPrincipalTypeString(function.getOwnerType());
        catalogFunction.resourceUri = HiveToCatalogConverter.toCatalogResourceUriList(function.getResourceUris());
        return catalogFunction;
    }

    public static String toCatalogFunctionTypeString(FunctionType functionType) {
        if (functionType == null) {
            return null;
        }
        return functionType.name();
    }

    public static String toCatalogResourceTypeString(ResourceType resourceType) {
        if (resourceType == null) {
            return null;
        }
        return resourceType.name();
    }

    public static List<ResourceUri> toCatalogResourceUriList(List<org.apache.hadoop.hive.metastore.api.ResourceUri> resourceUris) {
        if (resourceUris == null) {
            return null;
        }
        ArrayList<ResourceUri> uris = new ArrayList<ResourceUri>();
        resourceUris.forEach(t -> uris.add(HiveToCatalogConverter.toCatalogResourceUri(t)));
        return uris;
    }

    public static ResourceUri toCatalogResourceUri(org.apache.hadoop.hive.metastore.api.ResourceUri resourceUri) {
        if (resourceUri == null) {
            return null;
        }
        ResourceUri catalogUri = new ResourceUri();
        catalogUri.uri = resourceUri.getUri();
        catalogUri.resourceType = HiveToCatalogConverter.toCatalogResourceTypeString(resourceUri.getResourceType());
        return catalogUri;
    }

    public static com.aliyun.datalake20200710.models.Table convertIndexToCatalogTableObject(Index hiveIndex) {
        com.aliyun.datalake20200710.models.Table catalogIndexTableObject = new com.aliyun.datalake20200710.models.Table();
        catalogIndexTableObject.tableName = hiveIndex.getIndexName();
        catalogIndexTableObject.createTime = hiveIndex.getCreateTime();
        catalogIndexTableObject.lastAccessTime = hiveIndex.getLastAccessTime();
        catalogIndexTableObject.sd = HiveToCatalogConverter.toCatalogStorageDescriptor(hiveIndex.getSd());
        catalogIndexTableObject.parameters = hiveIndex.getParameters() == null ? new HashMap() : hiveIndex.getParameters();
        catalogIndexTableObject.parameters.put("DeferredRebuild", hiveIndex.isDeferredRebuild() ? "TRUE" : "FALSE");
        catalogIndexTableObject.parameters.put("IndexTableName", hiveIndex.getIndexTableName());
        catalogIndexTableObject.parameters.put("IndexHandlerClass", hiveIndex.getIndexHandlerClass());
        catalogIndexTableObject.parameters.put("DbName", hiveIndex.getDbName());
        catalogIndexTableObject.parameters.put("OriginTableName", hiveIndex.getOrigTableName());
        return catalogIndexTableObject;
    }

    public static com.aliyun.datalake20200710.models.ColumnStatistics toCatalogColumnStats(IHiveShims hiveShims, ColumnStatistics columnStatistics) throws IOException {
        com.aliyun.datalake20200710.models.ColumnStatistics catalogStats = new com.aliyun.datalake20200710.models.ColumnStatistics();
        catalogStats.setColumnStatisticsDesc(HiveToCatalogConverter.toCatalogColumnStatsDesc(columnStatistics.getStatsDesc()));
        catalogStats.setColumnStatisticsObjList(HiveToCatalogConverter.toCatalogColumnStatsObjs(hiveShims, columnStatistics.getStatsObj()));
        return catalogStats;
    }

    public static com.aliyun.datalake20200710.models.ColumnStatisticsObj toCatalogColumnStatsObj(IHiveShims hiveShims, ColumnStatisticsObj columnStatisticsObj) throws IOException {
        com.aliyun.datalake20200710.models.ColumnStatisticsObj catalogStatsObj = new com.aliyun.datalake20200710.models.ColumnStatisticsObj();
        if (columnStatisticsObj.getColName() != null) {
            catalogStatsObj.setColumnName(columnStatisticsObj.getColName());
        }
        if (columnStatisticsObj.getColType() != null) {
            catalogStatsObj.setColumnType(columnStatisticsObj.getColType());
        }
        catalogStatsObj.setColumnStatisticsData(HiveToCatalogConverter.toCatalogColumnStatsData(hiveShims, columnStatisticsObj.getStatsData()));
        return catalogStatsObj;
    }

    public static ColumnStatisticsObj.ColumnStatisticsObjColumnStatisticsData toCatalogColumnStatsData(IHiveShims hiveShims, ColumnStatisticsData columnStatisticsData) throws IOException {
        ColumnStatisticsObj.ColumnStatisticsObjColumnStatisticsData catalogColumnStatisticsData = new ColumnStatisticsObj.ColumnStatisticsObjColumnStatisticsData();
        catalogColumnStatisticsData.setStatisticsData(HiveToCatalogConverter.toCatalogColumnStatsDataCore(hiveShims, columnStatisticsData));
        catalogColumnStatisticsData.setStatisticsType(String.valueOf(((ColumnStatisticsData._Fields)columnStatisticsData.getSetField()).getThriftFieldId()));
        return catalogColumnStatisticsData;
    }

    public static String toCatalogColumnStatsDataCore(IHiveShims hiveShims, ColumnStatisticsData columnStatisticsData) throws IOException {
        String statsDataCore = "";
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode root = mapper.createObjectNode();
        switch ((ColumnStatisticsData._Fields)columnStatisticsData.getSetField()) {
            case BOOLEAN_STATS: {
                BooleanColumnStatsData boolStats = columnStatisticsData.getBooleanStats();
                root.put("numNulls", boolStats.isSetNumNulls() ? Long.valueOf(boolStats.getNumNulls()) : null);
                root.put("numTrues", boolStats.isSetNumTrues() ? Long.valueOf(boolStats.getNumTrues()) : null);
                root.put("numFalses", boolStats.isSetNumFalses() ? Long.valueOf(boolStats.getNumFalses()) : null);
                statsDataCore = mapper.writeValueAsString((Object)root);
                break;
            }
            case LONG_STATS: {
                LongColumnStatsData longStats = columnStatisticsData.getLongStats();
                root.put("numNulls", longStats.isSetNumNulls() ? Long.valueOf(longStats.getNumNulls()) : null);
                root.put("numDVs", longStats.isSetNumDVs() ? Long.valueOf(longStats.getNumDVs()) : null);
                root.put("lowValue", longStats.isSetLowValue() ? Long.valueOf(longStats.getLowValue()) : null);
                root.put("highValue", longStats.isSetHighValue() ? Long.valueOf(longStats.getHighValue()) : null);
                root.put("bitVectors", hiveShims.getLongBitVector(longStats));
                statsDataCore = mapper.writeValueAsString((Object)root);
                break;
            }
            case DOUBLE_STATS: {
                DoubleColumnStatsData doubleStats = columnStatisticsData.getDoubleStats();
                root.put("numNulls", doubleStats.isSetNumNulls() ? Long.valueOf(doubleStats.getNumNulls()) : null);
                root.put("numDVs", doubleStats.isSetNumDVs() ? Long.valueOf(doubleStats.getNumDVs()) : null);
                root.put("lowValue", doubleStats.isSetLowValue() ? Double.valueOf(doubleStats.getLowValue()) : null);
                root.put("highValue", doubleStats.isSetHighValue() ? Double.valueOf(doubleStats.getHighValue()) : null);
                root.put("bitVectors", hiveShims.getDoubleBitVector(doubleStats));
                statsDataCore = mapper.writeValueAsString((Object)root);
                break;
            }
            case STRING_STATS: {
                StringColumnStatsData stringStats = columnStatisticsData.getStringStats();
                root.put("numNulls", stringStats.isSetNumNulls() ? Long.valueOf(stringStats.getNumNulls()) : null);
                root.put("numDVs", stringStats.isSetNumDVs() ? Long.valueOf(stringStats.getNumDVs()) : null);
                root.put("maxColLen", stringStats.isSetMaxColLen() ? Long.valueOf(stringStats.getMaxColLen()) : null);
                root.put("avgColLen", stringStats.isSetAvgColLen() ? Double.valueOf(stringStats.getAvgColLen()) : null);
                root.put("bitVectors", hiveShims.getStringBitVector(stringStats));
                statsDataCore = mapper.writeValueAsString((Object)root);
                break;
            }
            case BINARY_STATS: {
                BinaryColumnStatsData binaryStats = columnStatisticsData.getBinaryStats();
                root.put("numNulls", binaryStats.isSetNumNulls() ? Long.valueOf(binaryStats.getNumNulls()) : null);
                root.put("maxColLen", binaryStats.isSetMaxColLen() ? Long.valueOf(binaryStats.getMaxColLen()) : null);
                root.put("avgColLen", binaryStats.isSetAvgColLen() ? Double.valueOf(binaryStats.getAvgColLen()) : null);
                statsDataCore = mapper.writeValueAsString((Object)root);
                break;
            }
            case DECIMAL_STATS: {
                DecimalColumnStatsData decimalStats = columnStatisticsData.getDecimalStats();
                root.put("numNulls", decimalStats.isSetNumNulls() ? Long.valueOf(decimalStats.getNumNulls()) : null);
                root.put("numDVs", decimalStats.isSetNumDVs() ? Long.valueOf(decimalStats.getNumDVs()) : null);
                root.put("lowValue", decimalStats.isSetLowValue() ? hiveShims.createJdoDecimalString(decimalStats.getLowValue()) : null);
                root.put("highValue", decimalStats.isSetHighValue() ? hiveShims.createJdoDecimalString(decimalStats.getHighValue()) : null);
                root.put("bitVectors", hiveShims.getDecimalBitVector(decimalStats));
                statsDataCore = mapper.writeValueAsString((Object)root);
                break;
            }
            case DATE_STATS: {
                DateColumnStatsData dateStats = columnStatisticsData.getDateStats();
                root.put("numNulls", dateStats.isSetNumNulls() ? Long.valueOf(dateStats.getNumNulls()) : null);
                root.put("numDVs", dateStats.isSetNumDVs() ? Long.valueOf(dateStats.getNumDVs()) : null);
                root.put("lowValue", dateStats.isSetLowValue() ? Long.valueOf(dateStats.getLowValue().getDaysSinceEpoch()) : null);
                root.put("highValue", dateStats.isSetHighValue() ? Long.valueOf(dateStats.getHighValue().getDaysSinceEpoch()) : null);
                root.put("bitVectors", hiveShims.getDateBitVector(dateStats));
                statsDataCore = mapper.writeValueAsString((Object)root);
                break;
            }
        }
        return statsDataCore;
    }

    public static List<com.aliyun.datalake20200710.models.ColumnStatisticsObj> toCatalogColumnStatsObjs(IHiveShims hiveShims, List<ColumnStatisticsObj> columnStatisticsObjs) throws IOException {
        ArrayList<com.aliyun.datalake20200710.models.ColumnStatisticsObj> catalogObjs = new ArrayList<com.aliyun.datalake20200710.models.ColumnStatisticsObj>();
        for (ColumnStatisticsObj obj : columnStatisticsObjs) {
            catalogObjs.add(HiveToCatalogConverter.toCatalogColumnStatsObj(hiveShims, obj));
        }
        return catalogObjs;
    }

    public static ColumnStatisticsDesc toCatalogColumnStatsDesc(org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc columnStatisticsDesc) {
        ColumnStatisticsDesc catalogStatsDesc = new ColumnStatisticsDesc();
        if (columnStatisticsDesc.getLastAnalyzed() == 0L) {
            long time = System.currentTimeMillis() / 1000L;
            catalogStatsDesc.setLastAnalyzedTime(Long.valueOf(time));
        } else {
            catalogStatsDesc.setLastAnalyzedTime(Long.valueOf(columnStatisticsDesc.getLastAnalyzed()));
        }
        if (columnStatisticsDesc.getPartName() != null) {
            catalogStatsDesc.setPartitionName(columnStatisticsDesc.getPartName());
        }
        return catalogStatsDesc;
    }

    public static LockObj toCatalogLockObj(String catalogId, LockComponent lockComponent) {
        LockObj lockObj = new LockObj();
        lockObj.setCatalogId(catalogId);
        lockObj.setDatabaseName(lockComponent.getDbname());
        lockObj.setTableName(lockComponent.getTablename());
        return lockObj;
    }
}

