/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive.common.converters;

import com.aliyun.datalake.metastore.common.Action;
import com.aliyun.datalake.metastore.common.entity.ResultModel;
import com.aliyun.datalake.metastore.common.util.DataLakeUtil;
import com.aliyun.datalake.metastore.hive.common.utils.Utils;
import com.aliyun.datalake.metastore.hive.shims.IHiveShims;
import com.aliyun.datalake20200710.models.ColumnStatisticsDesc;
import com.aliyun.datalake20200710.models.Function;
import com.aliyun.datalake20200710.models.LockStatus;
import com.aliyun.datalake20200710.models.Partition;
import com.aliyun.datalake20200710.models.PrincipalPrivilegeSet;
import com.aliyun.datalake20200710.models.PrivilegeGrantInfo;
import com.aliyun.datalake20200710.models.ResourceUri;
import com.aliyun.datalake20200710.models.SerDeInfo;
import com.aliyun.datalake20200710.models.StorageDescriptor;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FunctionType;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.ResourceType;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.thrift.TException;

public class CatalogToHiveConverter {
    private static final ImmutableMap<String, MetaStoreException> EXCEPTION_MAP = ImmutableMap.builder().put((Object)"UnknownTable", UnknownTableException::new).put((Object)"UnknownDB", UnknownDBException::new).put((Object)"AlreadyExists", AlreadyExistsException::new).put((Object)"InvalidPartition", InvalidPartitionException::new).put((Object)"UnknownPartition", UnknownPartitionException::new).put((Object)"InvalidObject", InvalidObjectException::new).put((Object)"NoSuchObject", NoSuchObjectException::new).put((Object)"InvalidOperation", InvalidOperationException::new).put((Object)"ConfigValSecurityError", ConfigValSecurityException::new).put((Object)"InvalidInput", InvalidInputException::new).put((Object)"NoSuchTxn", NoSuchTxnException::new).put((Object)"TxnAbortedError", TxnAbortedException::new).put((Object)"TxnOpenError", TxnOpenException::new).put((Object)"NoSuchLock", NoSuchLockException::new).build();

    public static TException toHiveException(ResultModel<?> result, Action action, Exception e) {
        if (result == null) {
            return (TException)DataLakeUtil.throwException((Throwable)new MetaException("Empty result returned from catalog."), (Exception)e);
        }
        String code = result.code;
        String msg = result.message;
        String requestId = result.requestId;
        String message = String.join((CharSequence)" ", "Action:", action.name(), "ErrorCode:", code, "Message:", msg, "RequestId:", requestId);
        if (EXCEPTION_MAP.containsKey((Object)code)) {
            return (TException)DataLakeUtil.throwException((Throwable)((MetaStoreException)EXCEPTION_MAP.get((Object)code)).get(message), (Exception)e);
        }
        return (TException)DataLakeUtil.throwException((Throwable)new MetaException(message), (Exception)e);
    }

    public static Database toHiveDatabase(com.aliyun.datalake20200710.models.Database catalogDatabase) {
        Database hiveDatabase = new Database();
        hiveDatabase.setName(catalogDatabase.name);
        hiveDatabase.setDescription(catalogDatabase.description);
        String location = catalogDatabase.locationUri;
        hiveDatabase.setLocationUri(location == null ? "" : location);
        hiveDatabase.setParameters((Map)ObjectUtils.firstNonNull((Object[])new Map[]{catalogDatabase.parameters, Maps.newHashMap()}));
        hiveDatabase.setOwnerName(catalogDatabase.ownerName);
        hiveDatabase.setOwnerType(CatalogToHiveConverter.toHivePrincipalTypeString(catalogDatabase.ownerType));
        hiveDatabase.setParameters(catalogDatabase.parameters);
        hiveDatabase.setPrivileges(CatalogToHiveConverter.toHivePrivilegeSet(catalogDatabase.privileges));
        return hiveDatabase;
    }

    public static Table toHiveTable(com.aliyun.datalake20200710.models.Table catalogTable) {
        if (catalogTable == null) {
            return null;
        }
        Table table = new Table();
        table.setTableName(catalogTable.tableName);
        table.setDbName(catalogTable.databaseName);
        table.setOwner(catalogTable.owner);
        table.setSd(CatalogToHiveConverter.toHiveStorageDescriptor(catalogTable.sd));
        table.setPartitionKeys(CatalogToHiveConverter.toHiveCols(catalogTable.partitionKeys));
        table.setParameters(catalogTable.parameters);
        table.setViewOriginalText(catalogTable.viewOriginalText);
        table.setViewExpandedText(catalogTable.viewExpandedText);
        table.setTableType(catalogTable.tableType);
        table.setPrivileges(CatalogToHiveConverter.toHivePrivilegeSet(catalogTable.privileges));
        if (null != catalogTable.createTime) {
            table.setCreateTime(catalogTable.createTime.intValue());
        }
        if (null != catalogTable.lastAccessTime) {
            table.setLastAccessTime(catalogTable.lastAccessTime.intValue());
        }
        if (null != catalogTable.retention) {
            table.setRetention(catalogTable.retention.intValue());
        }
        if (null != catalogTable.temporary) {
            table.setTemporary(catalogTable.temporary.booleanValue());
        }
        if (Utils.supportRewrite() && null != catalogTable.rewriteEnabled) {
            table.setRewriteEnabled(catalogTable.rewriteEnabled.booleanValue());
        }
        return table;
    }

    public static org.apache.hadoop.hive.metastore.api.StorageDescriptor toHiveStorageDescriptor(StorageDescriptor sd) {
        if (sd == null) {
            return null;
        }
        org.apache.hadoop.hive.metastore.api.StorageDescriptor storageDescriptor = new org.apache.hadoop.hive.metastore.api.StorageDescriptor();
        storageDescriptor.setCols(CatalogToHiveConverter.toHiveCols(sd.cols));
        storageDescriptor.setLocation(sd.location);
        storageDescriptor.setInputFormat(sd.inputFormat);
        storageDescriptor.setOutputFormat(sd.outputFormat);
        storageDescriptor.setSerdeInfo(CatalogToHiveConverter.toHiveSerDeInfo(sd.serDeInfo));
        storageDescriptor.setBucketCols(sd.bucketCols);
        storageDescriptor.setSortCols(CatalogToHiveConverter.toHiveSortCols(sd.sortCols));
        storageDescriptor.setParameters(sd.parameters);
        storageDescriptor.setSkewedInfo(CatalogToHiveConverter.toHiveSkewedInfo(sd.skewedInfo));
        if (null != sd.compressed) {
            storageDescriptor.setCompressed(sd.compressed.booleanValue());
        }
        if (null != sd.numBuckets) {
            storageDescriptor.setNumBuckets(sd.numBuckets.intValue());
        }
        if (null != sd.storedAsSubDirectories) {
            storageDescriptor.setStoredAsSubDirectories(sd.storedAsSubDirectories.booleanValue());
        }
        return storageDescriptor;
    }

    public static List<FieldSchema> toHiveCols(List<com.aliyun.datalake20200710.models.FieldSchema> catalogCols) {
        if (null == catalogCols) {
            return null;
        }
        ArrayList<FieldSchema> fieldSchemas = new ArrayList<FieldSchema>();
        catalogCols.forEach(c -> fieldSchemas.add(CatalogToHiveConverter.toHiveColSchema(c)));
        return fieldSchemas;
    }

    public static FieldSchema toHiveColSchema(com.aliyun.datalake20200710.models.FieldSchema catalogColSchema) {
        if (null == catalogColSchema) {
            return null;
        }
        FieldSchema fieldSchema = new FieldSchema();
        fieldSchema.setName(catalogColSchema.name);
        fieldSchema.setType(catalogColSchema.type);
        fieldSchema.setComment(catalogColSchema.comment);
        return fieldSchema;
    }

    public static org.apache.hadoop.hive.metastore.api.SerDeInfo toHiveSerDeInfo(SerDeInfo catalogSerDeInfo) {
        if (null == catalogSerDeInfo) {
            return null;
        }
        org.apache.hadoop.hive.metastore.api.SerDeInfo serDeInfo = new org.apache.hadoop.hive.metastore.api.SerDeInfo();
        serDeInfo.setName(catalogSerDeInfo.name);
        serDeInfo.setSerializationLib(catalogSerDeInfo.serializationLib);
        serDeInfo.setParameters(catalogSerDeInfo.parameters);
        return serDeInfo;
    }

    public static SkewedInfo toHiveSkewedInfo(com.aliyun.datalake20200710.models.SkewedInfo catalogSkewedInfo) {
        if (null == catalogSkewedInfo) {
            return null;
        }
        SkewedInfo skewedInfo = new SkewedInfo();
        skewedInfo.setSkewedColNames(catalogSkewedInfo.skewedColNames);
        skewedInfo.setSkewedColValues(catalogSkewedInfo.skewedColValues);
        if (catalogSkewedInfo.skewedColValueLocationMaps != null) {
            skewedInfo.setSkewedColValueLocationMaps(CatalogToHiveConverter.toHiveSkewedColValueLocationMaps(catalogSkewedInfo.getSkewedColValueLocationMaps()));
        }
        return skewedInfo;
    }

    public static Map<List<String>, String> toHiveSkewedColValueLocationMaps(Map<String, String> skewedColValueLocationMaps) {
        Gson gson = new Gson();
        HashMap<List<String>, String> hashMap = new HashMap<List<String>, String>();
        for (Map.Entry<String, String> entry : skewedColValueLocationMaps.entrySet()) {
            ArrayList arrayList = (ArrayList)gson.fromJson(entry.getKey(), ArrayList.class);
            hashMap.put(arrayList, entry.getValue());
        }
        return hashMap;
    }

    public static List<Order> toHiveSortCols(List<com.aliyun.datalake20200710.models.Order> sortCols) {
        if (null == sortCols) {
            return null;
        }
        ArrayList<Order> catalogOrders = new ArrayList<Order>();
        sortCols.forEach(order -> catalogOrders.add(CatalogToHiveConverter.toHiveOrder(order)));
        return catalogOrders;
    }

    public static Order toHiveOrder(com.aliyun.datalake20200710.models.Order catalogOrder) {
        if (null == catalogOrder) {
            return null;
        }
        Order order = new Order();
        order.setOrder(catalogOrder.order.intValue());
        order.setCol(catalogOrder.col);
        return order;
    }

    public static org.apache.hadoop.hive.metastore.api.Partition toHivePartition(Partition catalogPartition) {
        org.apache.hadoop.hive.metastore.api.Partition hivePartition = new org.apache.hadoop.hive.metastore.api.Partition();
        hivePartition.setDbName(catalogPartition.databaseName);
        hivePartition.setTableName(catalogPartition.tableName);
        hivePartition.setCreateTime(CatalogToHiveConverter.nullOrZero(catalogPartition.createTime));
        hivePartition.setLastAccessTime(CatalogToHiveConverter.nullOrZero(catalogPartition.lastAccessTime));
        hivePartition.setSd(CatalogToHiveConverter.toHiveStorageDescriptor(catalogPartition.sd));
        hivePartition.setPrivileges(CatalogToHiveConverter.toHivePrivilegeSet(catalogPartition.privileges));
        hivePartition.setParameters(new HashMap(catalogPartition.parameters));
        hivePartition.setValues(new ArrayList(catalogPartition.values));
        return hivePartition;
    }

    private static int nullOrZero(Integer input) {
        return Objects.isNull(input) ? 0 : input;
    }

    public static org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet toHivePrivilegeSet(PrincipalPrivilegeSet privilegeSet) {
        if (privilegeSet == null) {
            return null;
        }
        org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet set = new org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet();
        set.setRolePrivileges(CatalogToHiveConverter.toHivePrivilegeMap(privilegeSet.rolePrivileges));
        set.setGroupPrivileges(CatalogToHiveConverter.toHivePrivilegeMap(privilegeSet.groupPrivileges));
        set.setUserPrivileges(CatalogToHiveConverter.toHivePrivilegeMap(privilegeSet.userPrivileges));
        return set;
    }

    private static Map<String, List<org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo>> toHivePrivilegeMap(Map<String, List<PrivilegeGrantInfo>> rolePrivileges) {
        if (rolePrivileges == null) {
            return null;
        }
        HashMap<String, List<org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo>> map = new HashMap<String, List<org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo>>(rolePrivileges.size());
        rolePrivileges.forEach((k, v) -> map.put((String)k, CatalogToHiveConverter.toHiveGrantInfoList(v)));
        return map;
    }

    private static List<org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo> toHiveGrantInfoList(List<PrivilegeGrantInfo> catalogGrantInfos) {
        if (catalogGrantInfos == null) {
            return null;
        }
        ArrayList<org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo> infoList = new ArrayList<org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo>(catalogGrantInfos.size());
        catalogGrantInfos.forEach(t -> infoList.add(CatalogToHiveConverter.toHiveGrantInfo(t)));
        return infoList;
    }

    private static org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo toHiveGrantInfo(PrivilegeGrantInfo catalogGrantInfo) {
        if (catalogGrantInfo == null) {
            return null;
        }
        org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo hiveInfo = new org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo();
        hiveInfo.setGrantOption(catalogGrantInfo.grantOption.booleanValue());
        hiveInfo.setGrantor(catalogGrantInfo.grantor);
        hiveInfo.setGrantorType(CatalogToHiveConverter.toHivePrincipalType(catalogGrantInfo.grantorType));
        hiveInfo.setPrivilege(catalogGrantInfo.privilege);
        hiveInfo.setCreateTime(catalogGrantInfo.createTime.intValue());
        return hiveInfo;
    }

    public static PrincipalType toHivePrincipalType(String ownerType) {
        if (ownerType == null) {
            return null;
        }
        return PrincipalType.valueOf((String)ownerType);
    }

    public static PrincipalType toHivePrincipalTypeString(String ownerType) {
        if (ownerType == null) {
            return null;
        }
        return PrincipalType.valueOf((String)ownerType);
    }

    public static org.apache.hadoop.hive.metastore.api.Function toHiveFunction(Function function) {
        if (function == null) {
            return null;
        }
        org.apache.hadoop.hive.metastore.api.Function hiveFunction = new org.apache.hadoop.hive.metastore.api.Function();
        hiveFunction.setCreateTime(function.createTime.intValue());
        hiveFunction.setDbName(function.databaseName);
        hiveFunction.setClassName(function.className);
        hiveFunction.setFunctionName(function.functionName);
        FunctionType functionType = CatalogToHiveConverter.toHiveFunctionType(function.functionType);
        hiveFunction.setFunctionType(functionType);
        hiveFunction.setOwnerName(function.ownerName);
        PrincipalType ownerType = CatalogToHiveConverter.toHivePrincipalType(function.ownerType);
        hiveFunction.setOwnerType(ownerType);
        hiveFunction.setResourceUris(CatalogToHiveConverter.toHiveResourceUriList(function.resourceUri));
        return hiveFunction;
    }

    public static FunctionType toHiveFunctionType(String functionType) {
        if (functionType == null) {
            return null;
        }
        return FunctionType.valueOf((String)functionType);
    }

    public static ResourceType toHiveResourceType(String resourceType) {
        if (resourceType == null) {
            return null;
        }
        return ResourceType.valueOf((String)resourceType);
    }

    public static List<org.apache.hadoop.hive.metastore.api.ResourceUri> toHiveResourceUriList(List<ResourceUri> resourceUris) {
        if (resourceUris == null) {
            return null;
        }
        ArrayList<org.apache.hadoop.hive.metastore.api.ResourceUri> uris = new ArrayList<org.apache.hadoop.hive.metastore.api.ResourceUri>(resourceUris.size());
        resourceUris.forEach(t -> uris.add(CatalogToHiveConverter.toHiveResourceUri(t)));
        return uris;
    }

    public static org.apache.hadoop.hive.metastore.api.ResourceUri toHiveResourceUri(ResourceUri catalogResourceUri) {
        if (catalogResourceUri == null) {
            return null;
        }
        ResourceType type = CatalogToHiveConverter.toHiveResourceType(catalogResourceUri.resourceType);
        org.apache.hadoop.hive.metastore.api.ResourceUri hiveUri = new org.apache.hadoop.hive.metastore.api.ResourceUri(type, catalogResourceUri.uri);
        return hiveUri;
    }

    public static Index ToHiveIndex(com.aliyun.datalake20200710.models.Table catalogTable) {
        Index hiveIndex = new Index();
        Map parameters = catalogTable.parameters;
        hiveIndex.setIndexName(catalogTable.tableName);
        hiveIndex.setCreateTime(catalogTable.createTime.intValue());
        hiveIndex.setLastAccessTime(catalogTable.lastAccessTime.intValue());
        hiveIndex.setSd(CatalogToHiveConverter.toHiveStorageDescriptor(catalogTable.sd));
        hiveIndex.setParameters(catalogTable.parameters);
        hiveIndex.setDeferredRebuild(((String)parameters.get("DeferredRebuild")).equals("TRUE"));
        hiveIndex.setIndexHandlerClass((String)parameters.get("IndexHandlerClass"));
        hiveIndex.setDbName((String)parameters.get("DbName"));
        hiveIndex.setOrigTableName((String)parameters.get("OriginTableName"));
        hiveIndex.setIndexTableName((String)parameters.get("IndexTableName"));
        return hiveIndex;
    }

    public static ColumnStatistics toHiveColumnStats(String catalogId, String dbName, String tblName, com.aliyun.datalake20200710.models.ColumnStatistics columnStatistics, boolean isTableLevel, boolean enableBitVector, IHiveShims hiveShims) throws IOException {
        ColumnStatistics hiveColumnStats = new ColumnStatistics();
        hiveColumnStats.setStatsDesc(CatalogToHiveConverter.toHiveColumnStatsDesc(catalogId, dbName, tblName, isTableLevel, columnStatistics.getColumnStatisticsDesc(), hiveShims));
        hiveColumnStats.setStatsObj(CatalogToHiveConverter.toHiveColumnStatsObjs(columnStatistics.getColumnStatisticsObjList(), enableBitVector, hiveShims));
        return hiveColumnStats;
    }

    public static ColumnStatisticsObj toHiveColumnStatsObj(com.aliyun.datalake20200710.models.ColumnStatisticsObj columnStatisticsObj, boolean enableBitVector, IHiveShims hiveShims) throws IOException {
        ColumnStatisticsObj hiveColumnStats = new ColumnStatisticsObj();
        hiveColumnStats.setColName(columnStatisticsObj.getColumnName());
        hiveColumnStats.setColType(columnStatisticsObj.getColumnType());
        String type = columnStatisticsObj.getColumnStatisticsData().getStatisticsType();
        ColumnStatisticsData hiveColumnStatsData = new ColumnStatisticsData();
        ColumnStatisticsData._Fields field = hiveColumnStatsData.fieldForId(Integer.parseInt(type));
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree(columnStatisticsObj.getColumnStatisticsData().getStatisticsData());
        switch (field) {
            case BOOLEAN_STATS: {
                hiveColumnStatsData.setBooleanStats(hiveShims.getBooleanColumnStatsData(Long.valueOf(root.get("numFalses").asLong()), Long.valueOf(root.get("numTrues").asLong()), Long.valueOf(root.get("numNulls").asLong())));
                break;
            }
            case LONG_STATS: {
                hiveColumnStatsData.setLongStats(hiveShims.getLongColumnStatsData(Long.valueOf(root.get("numNulls").asLong()), Long.valueOf(root.get("numDVs").asLong()), Long.valueOf(root.get("lowValue").asLong()), Long.valueOf(root.get("highValue").asLong()), root.get("bitVectors").binaryValue(), enableBitVector));
                break;
            }
            case DOUBLE_STATS: {
                hiveColumnStatsData.setDoubleStats(hiveShims.getDoubleColumnStatsData(Long.valueOf(root.get("numNulls").asLong()), Long.valueOf(root.get("numDVs").asLong()), Double.valueOf(root.get("lowValue").asDouble()), Double.valueOf(root.get("highValue").asDouble()), root.get("bitVectors").binaryValue(), enableBitVector));
                break;
            }
            case STRING_STATS: {
                hiveColumnStatsData.setStringStats(hiveShims.getStringColumnStatsData(Long.valueOf(root.get("numNulls").asLong()), Long.valueOf(root.get("numDVs").asLong()), root.get("avgColLen").asDouble(), Long.valueOf(root.get("maxColLen").asLong()), root.get("bitVectors").binaryValue(), enableBitVector));
                break;
            }
            case BINARY_STATS: {
                hiveColumnStatsData.setBinaryStats(hiveShims.getBinaryColumnStatsData(Long.valueOf(root.get("numNulls").asLong()), root.get("avgColLen").asDouble(), Long.valueOf(root.get("maxColLen").asLong())));
                break;
            }
            case DECIMAL_STATS: {
                hiveColumnStatsData.setDecimalStats(hiveShims.getDecimalColumnStatsData(Long.valueOf(root.get("numNulls").asLong()), Long.valueOf(root.get("numDVs").asLong()), hiveShims.createThriftDecimal(root.get("lowValue").textValue()), hiveShims.createThriftDecimal(root.get("highValue").textValue()), root.get("bitVectors").binaryValue(), enableBitVector));
                break;
            }
            case DATE_STATS: {
                hiveColumnStatsData.setDateStats(hiveShims.getDateColumnStatsData(Long.valueOf(root.get("numNulls").asLong()), Long.valueOf(root.get("numDVs").asLong()), new Date(root.get("lowValue").asLong()), new Date(root.get("highValue").asLong()), root.get("bitVectors").binaryValue(), enableBitVector));
                break;
            }
        }
        hiveColumnStats.setStatsData(hiveColumnStatsData);
        return hiveColumnStats;
    }

    public static List<ColumnStatisticsObj> toHiveColumnStatsObjs(List<com.aliyun.datalake20200710.models.ColumnStatisticsObj> columnStatisticsObj, boolean enableBitVector, IHiveShims hiveShims) throws IOException {
        ArrayList<ColumnStatisticsObj> hiveColumnStatsObjs = new ArrayList<ColumnStatisticsObj>();
        for (com.aliyun.datalake20200710.models.ColumnStatisticsObj obj : columnStatisticsObj) {
            hiveColumnStatsObjs.add(CatalogToHiveConverter.toHiveColumnStatsObj(obj, enableBitVector, hiveShims));
        }
        return hiveColumnStatsObjs;
    }

    public static Map<String, List<ColumnStatisticsObj>> toHiveColumnStatsObjMaps(Map<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> columnStatisticsObjMap, boolean enableBitVector, IHiveShims hiveShims) throws IOException {
        HashMap<String, List<ColumnStatisticsObj>> hiveStatsMap = new HashMap<String, List<ColumnStatisticsObj>>();
        for (Map.Entry<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> iter : columnStatisticsObjMap.entrySet()) {
            hiveStatsMap.put(iter.getKey(), CatalogToHiveConverter.toHiveColumnStatsObjs(iter.getValue(), enableBitVector, hiveShims));
        }
        return hiveStatsMap;
    }

    public static Map<String, ColumnStatistics> toHiveColumnStatsMaps(String catalogId, String dbName, String tblName, Map<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> columnStatisticsObjMap, boolean isTableLevel, boolean enableBitVector, IHiveShims hiveShims) throws IOException {
        HashMap<String, ColumnStatistics> hiveStatsMap = new HashMap<String, ColumnStatistics>();
        for (Map.Entry<String, List<com.aliyun.datalake20200710.models.ColumnStatisticsObj>> iter : columnStatisticsObjMap.entrySet()) {
            List<ColumnStatisticsObj> objs = CatalogToHiveConverter.toHiveColumnStatsObjs(iter.getValue(), enableBitVector, hiveShims);
            ColumnStatistics stats = new ColumnStatistics();
            org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc desc = new org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc();
            desc.setTableName(tblName);
            desc.setDbName(dbName);
            desc.setPartName(iter.getKey());
            desc.setIsTblLevel(isTableLevel);
            hiveShims.setColumnStatisticsDescCatalog(catalogId, desc);
            stats.setStatsDesc(desc);
            stats.setStatsObj(objs);
            hiveStatsMap.put(iter.getKey(), stats);
        }
        return hiveStatsMap;
    }

    public static org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc toHiveColumnStatsDesc(String catalogId, String dbName, String tblName, boolean isTableLevel, ColumnStatisticsDesc columnStatistics, IHiveShims hiveShims) {
        org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc hiveColumnStatsDesc = new org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc();
        hiveColumnStatsDesc.setPartName(columnStatistics.getPartitionName());
        hiveColumnStatsDesc.setLastAnalyzed(columnStatistics.getLastAnalyzedTime().longValue());
        hiveColumnStatsDesc.setTableName(dbName);
        hiveColumnStatsDesc.setDbName(tblName);
        hiveShims.setColumnStatisticsDescCatalog(catalogId, hiveColumnStatsDesc);
        hiveColumnStatsDesc.setIsTblLevel(isTableLevel);
        return hiveColumnStatsDesc;
    }

    public static LockResponse toHiveLockResponse(LockStatus lockStatus) {
        LockResponse lockResponse = new LockResponse();
        if (lockStatus != null) {
            lockResponse.setLockid(lockStatus.getLockId().longValue());
            lockResponse.setState(CatalogToHiveConverter.toLockState(lockStatus.getLockState()));
        }
        return lockResponse;
    }

    public static LockState toLockState(String state) {
        if ("NOT_ACQUIRED".equals(state)) {
            return LockState.NOT_ACQUIRED;
        }
        if ("ACQUIRED".equals(state)) {
            return LockState.ACQUIRED;
        }
        return LockState.NOT_ACQUIRED;
    }

    static interface MetaStoreException {
        public TException get(String var1);
    }
}

