/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.hive.common;

import com.aliyun.datalake.metastore.common.CacheDataLakeMetaStore;
import com.aliyun.datalake.metastore.common.CacheDataLakeMetaStoreConfig;
import com.aliyun.datalake.metastore.common.DataLakeConfig;
import com.aliyun.datalake.metastore.common.DefaultDataLakeMetaStore;
import com.aliyun.datalake.metastore.common.IDataLakeMetaStore;
import com.aliyun.datalake.metastore.common.util.DataLakeUtil;
import com.aliyun.datalake.metastore.hive.common.utils.ConfigUtils;
import com.aliyun.teaopenapi.models.Config;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetastoreFactory {
    private static final Logger logger = LoggerFactory.getLogger(MetastoreFactory.class);

    public IDataLakeMetaStore getMetaStore(Configuration conf, ExecutorService service) throws MetaException {
        String accessKeyId = ConfigUtils.getAccessKeyId(conf).orElse(null);
        String accessKeySecret = ConfigUtils.getAccessKeySecret(conf).orElse(null);
        String regionId = ConfigUtils.getRegionId(conf).orElse(null);
        String securityToken = ConfigUtils.getSecurityToken(conf).orElse(null);
        DataLakeConfig.AKMode akMode = ConfigUtils.akMode(conf);
        String uid = ConfigUtils.getUserId(conf);
        String role = ConfigUtils.getRole(conf);
        Properties extendedConfig = new Properties();
        if (akMode != null) {
            extendedConfig.setProperty("dlf.catalog.akMode", akMode.name());
        }
        if (uid != null) {
            extendedConfig.setProperty("dlf.catalog.uid", uid);
        }
        if (role != null) {
            extendedConfig.setProperty("dlf.catalog.role", role);
        }
        extendedConfig.setProperty("dlf.catalog.sts.isNewMode", String.valueOf(ConfigUtils.isNewSTSMode(conf)));
        extendedConfig.setProperty("dlf.catalog.accurate.batchSize", String.valueOf(ConfigUtils.getAccurateListBatchSize(conf)));
        extendedConfig.setProperty("dlf.catalog.client.table.col.stats.pageSize", String.valueOf(ConfigUtils.getTableColStatsPageSize(conf)));
        String endpoint = ConfigUtils.getEndPoint(conf).orElse(null);
        try {
            Config config = new Config();
            config.accessKeyId = accessKeyId;
            config.accessKeySecret = accessKeySecret;
            config.endpoint = endpoint;
            config.regionId = regionId;
            config.securityToken = securityToken;
            config.readTimeout = ConfigUtils.getReadTimeout(conf);
            config.connectTimeout = ConfigUtils.getConnTimeout(conf);
            DefaultDataLakeMetaStore dataLakeMetaStore = new DefaultDataLakeMetaStore(config, extendedConfig, service);
            if (this.isCacheEnabled(conf)) {
                boolean databaseCacheEnabled = conf.getBoolean("data.lake.cache.db.enable", false);
                int dbCacheSize = conf.getInt("data.lake.cache.db.size", 0);
                int dbCacheTtlMins = conf.getInt("data.lake.cache.db.ttl.mins", 0);
                boolean tableCacheEnabled = conf.getBoolean("data.lake.cache.tb.enable", false);
                int tbCacheSize = conf.getInt("data.lake.cache.tb.size", 0);
                int tbCacheTtlMins = conf.getInt("data.lake.cache.tb.ttl.mins", 0);
                CacheDataLakeMetaStoreConfig cacheConfig = new CacheDataLakeMetaStoreConfig(databaseCacheEnabled, dbCacheSize, dbCacheTtlMins, tableCacheEnabled, tbCacheSize, tbCacheTtlMins);
                return new CacheDataLakeMetaStore(cacheConfig, (IDataLakeMetaStore)dataLakeMetaStore);
            }
            return dataLakeMetaStore;
        }
        catch (Exception e) {
            throw (MetaException)DataLakeUtil.throwException((Throwable)new MetaException("Initialize DlfMetaStoreClient failed: " + e.getMessage()), (Exception)e);
        }
    }

    private boolean isCacheEnabled(Configuration conf) {
        boolean databaseCacheEnabled = conf.getBoolean("data.lake.cache.db.enable", false);
        boolean tableCacheEnabled = conf.getBoolean("data.lake.cache.tb.enable", false);
        return databaseCacheEnabled || tableCacheEnabled;
    }
}

