/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common.api;

import com.aliyun.datalake.metastore.common.api.AbstractBaseApi;
import com.aliyun.datalake.metastore.common.entity.PaginatedResult;
import com.aliyun.datalake.metastore.common.entity.ResultModel;
import com.aliyun.datalake.metastore.common.functional.ThrowingBiFunction;
import com.aliyun.datalake.metastore.common.util.DataLakeUtil;
import com.aliyun.datalake20200710.Client;
import com.aliyun.datalake20200710.models.CreateFunctionRequest;
import com.aliyun.datalake20200710.models.CreateFunctionResponse;
import com.aliyun.datalake20200710.models.CreateFunctionResponseBody;
import com.aliyun.datalake20200710.models.DeleteFunctionRequest;
import com.aliyun.datalake20200710.models.DeleteFunctionResponse;
import com.aliyun.datalake20200710.models.DeleteFunctionResponseBody;
import com.aliyun.datalake20200710.models.Function;
import com.aliyun.datalake20200710.models.FunctionInput;
import com.aliyun.datalake20200710.models.GetFunctionRequest;
import com.aliyun.datalake20200710.models.GetFunctionResponse;
import com.aliyun.datalake20200710.models.GetFunctionResponseBody;
import com.aliyun.datalake20200710.models.ListFunctionNamesRequest;
import com.aliyun.datalake20200710.models.ListFunctionNamesResponse;
import com.aliyun.datalake20200710.models.ListFunctionNamesResponseBody;
import com.aliyun.datalake20200710.models.ListFunctionsRequest;
import com.aliyun.datalake20200710.models.ListFunctionsResponse;
import com.aliyun.datalake20200710.models.ListFunctionsResponseBody;
import com.aliyun.datalake20200710.models.UpdateFunctionRequest;
import com.aliyun.datalake20200710.models.UpdateFunctionResponse;
import com.aliyun.datalake20200710.models.UpdateFunctionResponseBody;
import com.aliyun.teautil.models.RuntimeOptions;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;

public class FunctionApi
extends AbstractBaseApi {
    public FunctionApi(Client client) {
        super(client);
    }

    public ResultModel<Function> getFunction(String catalogId, String databaseName, String functionName) throws Exception {
        return this.call(() -> {
            GetFunctionRequest request = new GetFunctionRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.functionName = functionName;
            GetFunctionResponseBody response = ((GetFunctionResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, GetFunctionResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$getFunction$0(com.aliyun.datalake20200710.models.GetFunctionRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/GetFunctionResponse;)((FunctionApi)this, (GetFunctionRequest)request))).body;
            return new ResultModel<Function>(response.success, response.code, response.message, response.requestId, response.function);
        });
    }

    public ResultModel<Void> createFunction(String catalogId, String databaseName, FunctionInput functionInput) throws Exception {
        return this.call(() -> {
            CreateFunctionRequest request = new CreateFunctionRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.functionInput = functionInput;
            CreateFunctionResponseBody response = ((CreateFunctionResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, CreateFunctionResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$createFunction$2(com.aliyun.datalake20200710.models.CreateFunctionRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/CreateFunctionResponse;)((FunctionApi)this, (CreateFunctionRequest)request))).body;
            return new ResultModel(response.success, response.code, response.message, response.requestId);
        });
    }

    public ResultModel<Void> updateFunction(String catalogId, String databaseName, String functionName, FunctionInput functionInput) throws Exception {
        return this.call(() -> {
            UpdateFunctionRequest request = new UpdateFunctionRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.functionName = functionName;
            request.functionInput = functionInput;
            UpdateFunctionResponseBody response = ((UpdateFunctionResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, UpdateFunctionResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$updateFunction$4(com.aliyun.datalake20200710.models.UpdateFunctionRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/UpdateFunctionResponse;)((FunctionApi)this, (UpdateFunctionRequest)request))).body;
            return new ResultModel(response.success, response.code, response.message, response.requestId);
        });
    }

    public ResultModel<Void> deleteFunction(String catalogId, String databaseName, String functionName) throws Exception {
        return this.call(() -> {
            DeleteFunctionRequest request = new DeleteFunctionRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.functionName = functionName;
            DeleteFunctionResponseBody response = ((DeleteFunctionResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, DeleteFunctionResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$deleteFunction$6(com.aliyun.datalake20200710.models.DeleteFunctionRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/DeleteFunctionResponse;)((FunctionApi)this, (DeleteFunctionRequest)request))).body;
            return new ResultModel(response.success, response.code, response.message, response.requestId);
        });
    }

    public ResultModel<PaginatedResult<String>> listFunctionNames(String catalogId, String databaseName, String functionNamePattern, int pageSize, String nextPageToken) throws Exception {
        return this.call(() -> {
            ListFunctionNamesRequest request = new ListFunctionNamesRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.functionNamePattern = DataLakeUtil.wrapperPatternString(functionNamePattern);
            request.pageSize = pageSize;
            request.nextPageToken = DataLakeUtil.wrapperNullString(nextPageToken);
            ListFunctionNamesResponseBody response = ((ListFunctionNamesResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, ListFunctionNamesResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$listFunctionNames$8(com.aliyun.datalake20200710.models.ListFunctionNamesRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/ListFunctionNamesResponse;)((FunctionApi)this, (ListFunctionNamesRequest)request))).body;
            PaginatedResult result = new PaginatedResult(response.functionNames, DataLakeUtil.wrapperNullString(response.nextPageToken));
            return new ResultModel(response.success, response.code, response.message, response.requestId, result);
        });
    }

    public ResultModel<PaginatedResult<Function>> listFunctions(String catalogId, String databaseName, String functionNamePattern, int pageSize, String nextPageToken) throws Exception {
        return this.call(() -> {
            ListFunctionsRequest request = new ListFunctionsRequest();
            request.catalogId = catalogId;
            request.databaseName = databaseName;
            request.functionNamePattern = DataLakeUtil.wrapperPatternString(functionNamePattern);
            request.pageSize = pageSize;
            request.nextPageToken = DataLakeUtil.wrapperNullString(nextPageToken);
            ListFunctionsResponseBody response = ((ListFunctionsResponse)this.callWithOptions((ThrowingBiFunction<Map, RuntimeOptions, ListFunctionsResponse, E>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$listFunctions$10(com.aliyun.datalake20200710.models.ListFunctionsRequest java.util.Map com.aliyun.teautil.models.RuntimeOptions ), (Ljava/util/Map;Lcom/aliyun/teautil/models/RuntimeOptions;)Lcom/aliyun/datalake20200710/models/ListFunctionsResponse;)((FunctionApi)this, (ListFunctionsRequest)request))).body;
            PaginatedResult result = new PaginatedResult(response.functions, DataLakeUtil.wrapperNullString(response.nextPageToken));
            return new ResultModel(response.success, response.code, response.message, response.requestId, result);
        });
    }

    private /* synthetic */ ListFunctionsResponse lambda$listFunctions$10(ListFunctionsRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.listFunctionsWithOptions(request, h, r);
    }

    private /* synthetic */ ListFunctionNamesResponse lambda$listFunctionNames$8(ListFunctionNamesRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.listFunctionNamesWithOptions(request, h, r);
    }

    private /* synthetic */ DeleteFunctionResponse lambda$deleteFunction$6(DeleteFunctionRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.deleteFunctionWithOptions(request, h, r);
    }

    private /* synthetic */ UpdateFunctionResponse lambda$updateFunction$4(UpdateFunctionRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.updateFunctionWithOptions(request, h, r);
    }

    private /* synthetic */ CreateFunctionResponse lambda$createFunction$2(CreateFunctionRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.createFunctionWithOptions(request, h, r);
    }

    private /* synthetic */ GetFunctionResponse lambda$getFunction$0(GetFunctionRequest request, Map h, RuntimeOptions r) throws Exception {
        return this.client.getFunctionWithOptions(request, h, r);
    }
}

