/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.datalake.metastore.common;

import com.aliyun.datalake.metastore.common.entity.PaginatedResult;
import com.aliyun.datalake20200710.models.ColumnStatisticsObj;
import com.aliyun.datalake20200710.models.Database;
import com.aliyun.datalake20200710.models.Function;
import com.aliyun.datalake20200710.models.FunctionInput;
import com.aliyun.datalake20200710.models.LockObj;
import com.aliyun.datalake20200710.models.LockStatus;
import com.aliyun.datalake20200710.models.Partition;
import com.aliyun.datalake20200710.models.PartitionInput;
import com.aliyun.datalake20200710.models.PrincipalPrivilegeSet;
import com.aliyun.datalake20200710.models.Table;
import com.aliyun.datalake20200710.models.TableInput;
import com.aliyun.datalake20200710.models.UpdateTablePartitionColumnStatisticsRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface IDataLakeMetaStore {
    public void createDatabase(String var1, Database var2) throws Exception;

    public void createDatabase(String var1, String var2, String var3, String var4, Map<String, String> var5, String var6, String var7, PrincipalPrivilegeSet var8) throws Exception;

    public Database getDatabase(String var1, String var2) throws Exception;

    public List<String> getDatabases(String var1, String var2, int var3) throws Exception;

    public void alterDatabase(String var1, String var2, Database var3) throws Exception;

    public void dropDatabase(String var1, String var2, boolean var3, boolean var4, boolean var5) throws Exception;

    public void createTable(String var1, TableInput var2) throws Exception;

    public Table getTable(String var1, String var2, String var3) throws Exception;

    public List<String> getTables(String var1, String var2, String var3, int var4, String var5) throws Exception;

    public List<Table> getTableObjects(String var1, String var2, String var3, int var4, String var5) throws Exception;

    public List<Table> getTableObjects(String var1, String var2, List<String> var3) throws Exception;

    public void alterTable(String var1, String var2, String var3, TableInput var4) throws Exception;

    public void alterTable(String var1, String var2, String var3, TableInput var4, boolean var5, boolean var6) throws Exception;

    public void dropTable(String var1, String var2, String var3, boolean var4) throws Exception;

    public void doRenameTableInMs(String var1, String var2, String var3, TableInput var4, Boolean var5) throws Exception;

    public List<ColumnStatisticsObj> getTableColumnStatistics(String var1, String var2, String var3, List<String> var4) throws Exception;

    public boolean updateTableColumnStatistics(UpdateTablePartitionColumnStatisticsRequest var1) throws Exception;

    public boolean deleteTableColumnStatistics(String var1, String var2, String var3, List<String> var4) throws Exception;

    public Partition addPartition(String var1, String var2, String var3, PartitionInput var4, boolean var5, boolean var6) throws Exception;

    public List<Partition> addPartitions(String var1, String var2, String var3, List<PartitionInput> var4, boolean var5, boolean var6) throws Exception;

    public void alterPartitions(String var1, String var2, String var3, List<PartitionInput> var4) throws Exception;

    public <T> T listPartitionsByExpr(String var1, String var2, String var3, byte[] var4, String var5, int var6, String var7, int var8, PartitionVisitor<T, Partition> var9) throws Exception;

    public void doDropPartitions(String var1, String var2, String var3, List<List<String>> var4, boolean var5) throws Exception;

    public Partition getPartition(String var1, String var2, String var3, List<String> var4) throws Exception;

    public List<Partition> getPartitionsByValues(String var1, String var2, String var3, List<List<String>> var4) throws Exception;

    public void renamePartitionInCatalog(String var1, String var2, String var3, List<String> var4, PartitionInput var5) throws Exception;

    public List<String> listPartitionNames(String var1, String var2, String var3, List<String> var4, int var5, int var6) throws Exception;

    public int getNumPartitionsByFilter(String var1, String var2, String var3, String var4, int var5) throws Exception;

    public <T> T listPartitionsInternal(String var1, String var2, String var3, List<String> var4, String var5, int var6, int var7, PartitionVisitor<T, Partition> var8) throws Exception;

    public <T> T listPartitions(String var1, String var2, String var3, int var4, int var5, PartitionVisitor<T, Partition> var6) throws Exception;

    public List<Partition> listPartitionsByFilter(String var1, String var2, String var3, String var4, int var5) throws Exception;

    public void doDropPartition(String var1, String var2, String var3, List<String> var4, boolean var5) throws Exception;

    public Map<String, List<ColumnStatisticsObj>> getPartitionColumnStatistics(String var1, String var2, String var3, List<String> var4, List<String> var5) throws Exception;

    public Map<String, List<ColumnStatisticsObj>> batchGetPartitionColumnStatistics(String var1, String var2, String var3, List<String> var4, List<String> var5) throws Exception;

    public boolean updatePartitionColumnStatistics(UpdateTablePartitionColumnStatisticsRequest var1) throws Exception;

    public boolean deletePartitionColumnStatistics(String var1, String var2, String var3, List<String> var4, List<String> var5) throws Exception;

    public void createFunction(String var1, FunctionInput var2, String var3) throws Exception;

    public Function getFunction(String var1, String var2, String var3) throws Exception;

    public List<String> getFunctions(String var1, String var2, String var3, int var4) throws Exception;

    public List<Function> getFunctionObjects(String var1, String var2, String var3, int var4) throws Exception;

    public void alterFunction(String var1, String var2, String var3, FunctionInput var4) throws Exception;

    public void dropFunction(String var1, String var2, String var3) throws Exception;

    public List<Partition> getNonSubDirectoryPartitionLocations(String var1, String var2, String var3, int var4) throws Exception;

    public LockStatus lock(List<LockObj> var1) throws Exception;

    public Boolean unLock(Long var1) throws Exception;

    public LockStatus getLock(Long var1) throws Exception;

    public Boolean refreshLock(Long var1) throws Exception;

    public static class PartitionNameVisitor
    implements PartitionVisitor<List<String>, String> {
        private final List<String> result = new ArrayList<String>();

        PartitionNameVisitor() {
        }

        @Override
        public void accept(List<String> partitions) {
            this.result.addAll(partitions);
        }

        @Override
        public List<String> getResult() {
            return this.result;
        }
    }

    public static class PartitionCountVisitor
    implements PartitionVisitor<Integer, Partition> {
        private int count = 0;

        @Override
        public void accept(List<Partition> partition) {
            this.count += partition.size();
        }

        @Override
        public Integer getResult() {
            return this.count;
        }
    }

    public static interface PartitionVisitor<T, U> {
        public void accept(List<U> var1);

        public T getResult();
    }

    @FunctionalInterface
    public static interface PartitionsFetcher<T> {
        public PaginatedResult<T> apply(int var1, String var2) throws Exception;
    }
}

