/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ChiSquareHeuristic
implements JsonpSerializable {
    private final boolean backgroundIsSuperset;
    private final boolean includeNegatives;
    public static final JsonpDeserializer<ChiSquareHeuristic> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChiSquareHeuristic::setupChiSquareHeuristicDeserializer);

    private ChiSquareHeuristic(Builder builder) {
        this.backgroundIsSuperset = ApiTypeHelper.requireNonNull(builder.backgroundIsSuperset, this, "backgroundIsSuperset");
        this.includeNegatives = ApiTypeHelper.requireNonNull(builder.includeNegatives, this, "includeNegatives");
    }

    public static ChiSquareHeuristic of(Function<Builder, ObjectBuilder<ChiSquareHeuristic>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final boolean backgroundIsSuperset() {
        return this.backgroundIsSuperset;
    }

    public final boolean includeNegatives() {
        return this.includeNegatives;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("background_is_superset");
        generator.write(this.backgroundIsSuperset);
        generator.writeKey("include_negatives");
        generator.write(this.includeNegatives);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupChiSquareHeuristicDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::backgroundIsSuperset, JsonpDeserializer.booleanDeserializer(), "background_is_superset");
        op.add(Builder::includeNegatives, JsonpDeserializer.booleanDeserializer(), "include_negatives");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ChiSquareHeuristic> {
        private Boolean backgroundIsSuperset;
        private Boolean includeNegatives;

        public final Builder backgroundIsSuperset(boolean value) {
            this.backgroundIsSuperset = value;
            return this;
        }

        public final Builder includeNegatives(boolean value) {
            this.includeNegatives = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ChiSquareHeuristic build() {
            this._checkSingleUse();
            return new ChiSquareHeuristic(this);
        }
    }
}

