/*
 * Decompiled with CFR 0.152.
 */
package ch.vorburger.mariadb4j;

import ch.vorburger.exec.ManagedProcessListener;
import java.util.List;
import java.util.function.Function;

public interface DBConfiguration {
    public int getPort();

    public String getSocket();

    public String getBinariesClassPathLocation();

    public String getBaseDir();

    public String getLibDir();

    public String getDataDir();

    public boolean isDeletingTemporaryBaseAndDataDirsOnShutdown();

    public boolean isWindows();

    public List<String> getArgs();

    public String getOSLibraryEnvironmentVarName();

    public ManagedProcessListener getProcessListener();

    public boolean isSecurityDisabled();

    public String getURL(String var1);

    public static class Impl
    implements DBConfiguration {
        private final int port;
        private final String socket;
        private final String binariesClassPathLocation;
        private final String baseDir;
        private final String libDir;
        private final String dataDir;
        private final boolean isDeletingTemporaryBaseAndDataDirsOnShutdown;
        private final boolean isWindows;
        private final List<String> args;
        private final String osLibraryEnvironmentVarName;
        private final ManagedProcessListener listener;
        private final boolean isSecurityDisabled;
        private final Function<String, String> getURL;

        Impl(int port, String socket, String binariesClassPathLocation, String baseDir, String libDir, String dataDir, boolean isWindows, List<String> args, String osLibraryEnvironmentVarName, boolean isSecurityDisabled, boolean isDeletingTemporaryBaseAndDataDirsOnShutdown, Function<String, String> getURL, ManagedProcessListener listener) {
            this.port = port;
            this.socket = socket;
            this.binariesClassPathLocation = binariesClassPathLocation;
            this.baseDir = baseDir;
            this.libDir = libDir;
            this.dataDir = dataDir;
            this.isDeletingTemporaryBaseAndDataDirsOnShutdown = isDeletingTemporaryBaseAndDataDirsOnShutdown;
            this.isWindows = isWindows;
            this.args = args;
            this.osLibraryEnvironmentVarName = osLibraryEnvironmentVarName;
            this.isSecurityDisabled = isSecurityDisabled;
            this.getURL = getURL;
            this.listener = listener;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public String getSocket() {
            return this.socket;
        }

        @Override
        public String getBinariesClassPathLocation() {
            return this.binariesClassPathLocation;
        }

        @Override
        public String getBaseDir() {
            return this.baseDir;
        }

        @Override
        public String getLibDir() {
            return this.libDir;
        }

        @Override
        public String getDataDir() {
            return this.dataDir;
        }

        @Override
        public boolean isDeletingTemporaryBaseAndDataDirsOnShutdown() {
            return this.isDeletingTemporaryBaseAndDataDirsOnShutdown;
        }

        @Override
        public boolean isWindows() {
            return this.isWindows;
        }

        @Override
        public List<String> getArgs() {
            return this.args;
        }

        @Override
        public String getOSLibraryEnvironmentVarName() {
            return this.osLibraryEnvironmentVarName;
        }

        @Override
        public boolean isSecurityDisabled() {
            return this.isSecurityDisabled;
        }

        @Override
        public String getURL(String dbName) {
            return this.getURL.apply(dbName);
        }

        @Override
        public ManagedProcessListener getProcessListener() {
            return this.listener;
        }
    }
}

